/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.PlayerEnterTownEvent;
import com.palmergames.bukkit.towny.event.PlayerLeaveTownEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.eventwar.WarUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.ChatTools;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Lectern;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class TownyPlayerListener
implements Listener {
    private final Towny plugin;

    public TownyPlayerListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isError()) {
            player.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
            return;
        }
        TownyUniverse.getInstance().onLogin(player);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        townyUniverse.onLogout(event.getPlayer());
        try {
            if (TownyTimerHandler.isTeleportWarmupRunning()) {
                TownyAPI.getInstance().abortTeleportRequest(townyUniverse.getDataSource().getResident(event.getPlayer().getName().toLowerCase()));
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.plugin.deleteCache(event.getPlayer());
        TownyPerms.removeAttachment(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Player player = event.getPlayer();
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        Location respawn = TownyAPI.getInstance().getTownSpawnLocation(player);
        if (respawn == null) {
            return;
        }
        if (TownySettings.isTownRespawningInOtherWorlds() && !player.getWorld().equals(respawn.getWorld())) {
            return;
        }
        if (TownySettings.getBedUse() && player.getBedSpawnLocation() != null) {
            event.setRespawnLocation(player.getBedSpawnLocation());
        } else {
            event.setRespawnLocation(respawn);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJailRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        try {
            Location respawn = null;
            Resident resident = townyUniverse.getDataSource().getResident(event.getPlayer().getName());
            if (resident.isJailed()) {
                Town respawnTown = townyUniverse.getDataSource().getTown(resident.getJailTown());
                respawn = respawnTown.getJailSpawn(resident.getJailSpawn());
                event.setRespawnLocation(respawn);
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(this.onPlayerInteract(event.getPlayer(), event.getBlockClicked().getRelative(event.getBlockFace()), event.getPlayer().getInventory().getItemInMainHand()));
        if (!event.isCancelled()) {
            event.setCancelled(this.onPlayerInteract(event.getPlayer(), event.getBlockClicked(), event.getItemStack()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(this.onPlayerInteract(event.getPlayer(), event.getBlockClicked(), event.getItemStack()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        TownyWorld World2 = null;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            World2 = townyUniverse.getDataSource().getWorld(block.getLocation().getWorld().getName());
            if (!World2.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return;
        }
        if (event.getAction() == Action.PHYSICAL && block.getType() == Material.FARMLAND && (World2.isDisablePlayerTrample() || !PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getType(), TownyPermission.ActionType.DESTROY))) {
            event.setCancelled(true);
            return;
        }
        if (event.hasItem()) {
            if (event.getPlayer().getInventory().getItemInMainHand().getType() == Material.getMaterial((String)TownySettings.getTool()) && townyUniverse.getPermissionSource().isTownyAdmin(player) && event.getClickedBlock() != null) {
                block = event.getClickedBlock();
                if (Tag.SIGNS.isTagged((Keyed)block.getType())) {
                    Sign sign;
                    BlockFace facing = null;
                    if (block.getBlockData() instanceof Sign) {
                        sign = (Sign)block.getBlockData();
                        facing = sign.getRotation();
                    }
                    if (block.getBlockData() instanceof WallSign) {
                        sign = (WallSign)block.getBlockData();
                        facing = sign.getFacing();
                    }
                    TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Sign Info"), ChatTools.formatCommand("", "Sign Type", "", block.getType().name()), ChatTools.formatCommand("", "Facing", "", facing.toString())));
                } else if (Tag.DOORS.isTagged((Keyed)block.getType())) {
                    Door door = (Door)block.getBlockData();
                    TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Door Info"), ChatTools.formatCommand("", "Door Type", "", block.getType().name()), ChatTools.formatCommand("", "hinged on ", "", String.valueOf(door.getHinge())), ChatTools.formatCommand("", "isOpen", "", String.valueOf(door.isOpen())), ChatTools.formatCommand("", "getFacing", "", door.getFacing().name())));
                } else {
                    TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Block Info"), ChatTools.formatCommand("", "Material", "", block.getType().name()), ChatTools.formatCommand("", "MaterialData", "", block.getBlockData().getAsString())));
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setCancelled(true);
            }
            if (TownySettings.isItemUseMaterial(event.getItem().getType().name())) {
                TownyMessaging.sendDebugMsg("ItemUse Material found: " + event.getItem().getType().name());
                event.setCancelled(this.onPlayerInteract(player, event.getClickedBlock(), event.getItem()));
            }
        }
        if (!event.useItemInHand().equals((Object)Event.Result.DENY) && event.getClickedBlock() != null && (TownySettings.isSwitchMaterial(event.getClickedBlock().getType().name()) || event.getAction() == Action.PHYSICAL)) {
            this.onPlayerSwitchEvent(event, null, World2);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractAtEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getRightClicked() != null) {
            if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
                return;
            }
            Player player = event.getPlayer();
            boolean bBuild = true;
            Material block = null;
            switch (event.getRightClicked().getType()) {
                case ARMOR_STAND: {
                    TownyMessaging.sendDebugMsg("ArmorStand Right Clicked");
                    block = Material.ARMOR_STAND;
                    bBuild = PlayerCacheUtil.getCachePermission(player, event.getRightClicked().getLocation(), block, TownyPermission.ActionType.DESTROY);
                    break;
                }
                case ITEM_FRAME: {
                    TownyMessaging.sendDebugMsg("Item_Frame Right Clicked");
                    block = Material.ITEM_FRAME;
                    bBuild = PlayerCacheUtil.getCachePermission(player, event.getRightClicked().getLocation(), block, TownyPermission.ActionType.SWITCH);
                    break;
                }
            }
            if (block != null) {
                if (bBuild) {
                    return;
                }
                event.setCancelled(true);
                PlayerCache cache = this.plugin.getCache(player);
                if (cache.hasBlockErrMsg()) {
                    TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
                }
                return;
            }
            if (event.getPlayer().getInventory().getItemInMainHand() != null && TownySettings.isItemUseMaterial(event.getPlayer().getInventory().getItemInMainHand().getType().name())) {
                event.setCancelled(this.onPlayerInteract(event.getPlayer(), null, event.getPlayer().getInventory().getItemInMainHand()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getRightClicked() != null) {
            TownyWorld World2 = null;
            try {
                World2 = TownyUniverse.getInstance().getDataSource().getWorld(event.getPlayer().getWorld().getName());
                if (!World2.isUsingTowny()) {
                    return;
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
                return;
            }
            Player player = event.getPlayer();
            Material block = null;
            TownyPermission.ActionType actionType = TownyPermission.ActionType.SWITCH;
            switch (event.getRightClicked().getType()) {
                case ITEM_FRAME: {
                    block = Material.ITEM_FRAME;
                    actionType = TownyPermission.ActionType.DESTROY;
                    break;
                }
                case PAINTING: {
                    block = Material.PAINTING;
                    actionType = TownyPermission.ActionType.DESTROY;
                    break;
                }
                case MINECART: 
                case MINECART_MOB_SPAWNER: {
                    block = Material.MINECART;
                    break;
                }
                case MINECART_CHEST: {
                    block = Material.CHEST_MINECART;
                    break;
                }
                case MINECART_FURNACE: {
                    block = Material.FURNACE_MINECART;
                    break;
                }
                case MINECART_COMMAND: {
                    block = Material.COMMAND_BLOCK_MINECART;
                    break;
                }
                case MINECART_HOPPER: {
                    block = Material.HOPPER_MINECART;
                    break;
                }
                case MINECART_TNT: {
                    block = Material.TNT_MINECART;
                }
            }
            if (block != null && TownySettings.isSwitchMaterial(block.name())) {
                if (!PlayerCacheUtil.getCachePermission(player, event.getRightClicked().getLocation(), block, actionType)) {
                    event.setCancelled(true);
                    PlayerCache cache = this.plugin.getCache(player);
                    if (cache.hasBlockErrMsg()) {
                        TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
                    }
                }
                return;
            }
            if (event.getPlayer().getInventory().getItemInMainHand() != null) {
                if (event.getPlayer().getInventory().getItemInMainHand().getType() == Material.getMaterial((String)TownySettings.getTool())) {
                    if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
                        return;
                    }
                    Entity entity = event.getRightClicked();
                    TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Entity Info"), ChatTools.formatCommand("", "Entity Class", "", entity.getType().getEntityClass().getSimpleName())));
                    event.setCancelled(true);
                }
                if (TownySettings.isItemUseMaterial(event.getPlayer().getInventory().getItemInMainHand().getType().name())) {
                    event.setCancelled(this.onPlayerInteract(event.getPlayer(), null, event.getPlayer().getInventory().getItemInMainHand()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        Player player = event.getPlayer();
        Location to = event.getTo();
        PlayerCache cache = this.plugin.getCache(player);
        try {
            from = cache.getLastLocation();
        }
        catch (NullPointerException e) {
            from = event.getFrom();
        }
        try {
            TownyWorld fromWorld = townyUniverse.getDataSource().getWorld(from.getWorld().getName());
            WorldCoord fromCoord = new WorldCoord(fromWorld.getName(), Coord.parseCoord(from));
            TownyWorld toWorld = townyUniverse.getDataSource().getWorld(to.getWorld().getName());
            WorldCoord toCoord = new WorldCoord(toWorld.getName(), Coord.parseCoord(to));
            if (!fromCoord.equals(toCoord)) {
                this.onPlayerMoveChunk(player, fromCoord, toCoord, from, to, event);
            }
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
        cache.setLastLocation(to);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        try {
            if (TownyUniverse.getInstance().getDataSource().getResident(player.getName()).isJailed()) {
                if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                    TownyMessaging.sendErrorMsg((Object)event.getPlayer(), String.format(TownySettings.getLangString("msg_err_jailed_players_no_teleport"), new Object[0]));
                    event.setCancelled(true);
                    return;
                }
                if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
                    return;
                }
                if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL || !TownySettings.JailAllowsEnderPearls()) {
                    TownyMessaging.sendErrorMsg((Object)event.getPlayer(), String.format(TownySettings.getLangString("msg_err_jailed_players_no_teleport"), new Object[0]));
                    event.setCancelled(true);
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && TownySettings.isItemUseMaterial(Material.CHORUS_FRUIT.name()) && this.onPlayerInteract(event.getPlayer(), event.getTo().getBlock(), new ItemStack(Material.CHORUS_FRUIT))) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && TownySettings.isItemUseMaterial(Material.ENDER_PEARL.name()) && this.onPlayerInteract(event.getPlayer(), event.getTo().getBlock(), new ItemStack(Material.ENDER_PEARL))) {
            event.setCancelled(true);
            TownyMessaging.sendErrorMsg((Object)event.getPlayer(), String.format(TownySettings.getLangString("msg_err_ender_pearls_disabled"), new Object[0]));
            return;
        }
        this.onPlayerMove((PlayerMoveEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        if (event.getPlayer().isOnline()) {
            TownyPerms.assignPermissions(null, event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getBed().getWorld())) {
            return;
        }
        if (!TownySettings.getBedUse()) {
            return;
        }
        boolean isOwner = false;
        boolean isInnPlot = false;
        try {
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(event.getPlayer().getName());
            WorldCoord worldCoord = new WorldCoord(event.getPlayer().getWorld().getName(), Coord.parseCoord(event.getBed().getLocation()));
            TownBlock townblock = worldCoord.getTownBlock();
            isOwner = townblock.isOwner(resident);
            boolean bl = isInnPlot = townblock.getType() == TownBlockType.INN;
            if (resident.hasNation() && townblock.getTown().hasNation()) {
                Nation residentNation = resident.getTown().getNation();
                Nation townblockNation = townblock.getTown().getNation();
                if (townblockNation.hasEnemy(residentNation)) {
                    event.setCancelled(true);
                    TownyMessaging.sendErrorMsg((Object)event.getPlayer(), String.format(TownySettings.getLangString("msg_err_no_sleep_in_enemy_inn"), new Object[0]));
                    return;
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (!isOwner && !isInnPlot) {
            event.setCancelled(true);
            TownyMessaging.sendErrorMsg((Object)event.getPlayer(), String.format(TownySettings.getLangString("msg_err_cant_use_bed"), new Object[0]));
        }
    }

    public boolean onPlayerInteract(Player player, Block block, ItemStack item) {
        boolean cancelState = false;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            String worldName = player.getWorld().getName();
            WorldCoord worldCoord = block != null ? new WorldCoord(worldName, Coord.parseCoord(block)) : new WorldCoord(worldName, Coord.parseCoord((Entity)player));
            boolean bItemUse = block != null ? PlayerCacheUtil.getCachePermission(player, block.getLocation(), item.getType(), TownyPermission.ActionType.ITEM_USE) : PlayerCacheUtil.getCachePermission(player, player.getLocation(), item.getType(), TownyPermission.ActionType.ITEM_USE);
            boolean wildOverride = townyUniverse.getPermissionSource().hasWildOverride(worldCoord.getTownyWorld(), player, item.getType(), TownyPermission.ActionType.ITEM_USE);
            PlayerCache cache = this.plugin.getCache(player);
            try {
                PlayerCache.TownBlockStatus status = cache.getStatus();
                if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE && wildOverride) {
                    return cancelState;
                }
                if (status == PlayerCache.TownBlockStatus.TOWN_RESIDENT && townyUniverse.getPermissionSource().hasOwnTownOverride(player, item.getType(), TownyPermission.ActionType.ITEM_USE) || (status == PlayerCache.TownBlockStatus.OUTSIDER || status == PlayerCache.TownBlockStatus.TOWN_ALLY || status == PlayerCache.TownBlockStatus.ENEMY) && townyUniverse.getPermissionSource().hasAllTownOverride(player, item.getType(), TownyPermission.ActionType.ITEM_USE)) {
                    return cancelState;
                }
                if (status == PlayerCache.TownBlockStatus.WARZONE && TownyWarConfig.isAllowingAttacks() || TownyAPI.getInstance().isWarTime() && status == PlayerCache.TownBlockStatus.WARZONE && !WarUtil.isPlayerNeutral(player)) {
                    if (!TownyWarConfig.isAllowingItemUseInWarZone()) {
                        cancelState = true;
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_warzone_cannot_use_item"));
                    }
                    return cancelState;
                }
                if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE && !wildOverride || !bItemUse && status != PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                    cancelState = true;
                }
                if (cache.hasBlockErrMsg()) {
                    TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
                }
            }
            catch (NullPointerException e) {
                System.out.print("NPE generated!");
                System.out.print("Player: " + player.getName());
                System.out.print("Item: " + item.getType().name());
            }
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            cancelState = true;
            return cancelState;
        }
        return cancelState;
    }

    public void onPlayerSwitchEvent(PlayerInteractEvent event, String errMsg, TownyWorld world) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        event.setCancelled(this.onPlayerSwitchEvent(player, block, errMsg, world));
    }

    public boolean onPlayerSwitchEvent(Player player, Block block, String errMsg, TownyWorld world) {
        if (!TownySettings.isSwitchMaterial(block.getType().name())) {
            return false;
        }
        boolean bSwitch = PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getType(), TownyPermission.ActionType.SWITCH);
        if (bSwitch) {
            return false;
        }
        PlayerCache cache = this.plugin.getCache(player);
        PlayerCache.TownBlockStatus status = cache.getStatus();
        if (status == PlayerCache.TownBlockStatus.WARZONE && TownyWarConfig.isAllowingAttacks() || TownyAPI.getInstance().isWarTime() && status == PlayerCache.TownBlockStatus.WARZONE && !WarUtil.isPlayerNeutral(player)) {
            if (!TownyWarConfig.isAllowingSwitchesInWarZone()) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_warzone_cannot_use_switches"));
                return true;
            }
            return false;
        }
        if (cache.hasBlockErrMsg()) {
            TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_ENTITY)) {
            Player player = event.getPlayer();
            Entity caught = event.getCaught();
            if (caught.getType().equals((Object)EntityType.PLAYER)) {
                return;
            }
            boolean bDestroy = PlayerCacheUtil.getCachePermission(player, caught.getLocation(), Material.GRASS, TownyPermission.ActionType.DESTROY);
            if (!bDestroy) {
                event.setCancelled(true);
                event.getHook().remove();
            }
        }
    }

    public void onPlayerMoveChunk(Player player, WorldCoord from, WorldCoord to, Location fromLoc, Location toLoc, PlayerMoveEvent moveEvent) {
        this.plugin.getCache(player).setLastLocation(toLoc);
        this.plugin.getCache(player).updateCoord(to);
        PlayerChangePlotEvent event = new PlayerChangePlotEvent(player, from, to, moveEvent);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        block9: {
            PlayerMoveEvent pme = event.getMoveEvent();
            Player player = event.getPlayer();
            WorldCoord from = event.getFrom();
            WorldCoord to = event.getTo();
            try {
                Resident resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName());
                try {
                    to.getTownBlock();
                    if (to.getTownBlock().hasTown()) {
                        try {
                            Town fromTown = from.getTownBlock().getTown();
                            if (!to.getTownBlock().getTown().equals(fromTown)) {
                                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEnterTownEvent(player, to, from, to.getTownBlock().getTown(), pme));
                                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveTownEvent(player, to, from, from.getTownBlock().getTown(), pme));
                            }
                            break block9;
                        }
                        catch (NotRegisteredException e) {
                            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEnterTownEvent(player, to, from, to.getTownBlock().getTown(), pme));
                        }
                        break block9;
                    }
                    if (from.getTownBlock().hasTown() && !to.getTownBlock().hasTown()) {
                        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveTownEvent(player, to, from, from.getTownBlock().getTown(), pme));
                    }
                }
                catch (NotRegisteredException e) {
                    Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveTownEvent(player, to, from, from.getTownBlock().getTown(), pme));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onOutlawEnterTown(PlayerEnterTownEvent event) throws NotRegisteredException {
        Player player = event.getPlayer();
        WorldCoord to = event.getTo();
        Resident resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName());
        if (to.getTownBlock().getTown().hasOutlaw(resident)) {
            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_are_an_outlaw_in_this_town"), to.getTownBlock().getTown()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDieInTown(PlayerDeathEvent event) {
        TownBlock tb;
        boolean keepInventory = event.getKeepInventory();
        boolean keepLevel = event.getKeepLevel();
        Player player = event.getEntity();
        Location deathloc = player.getLocation();
        if (TownySettings.getKeepInventoryInTowns() && !keepInventory && (tb = TownyAPI.getInstance().getTownBlock(deathloc)) != null && tb.hasTown()) {
            event.setKeepInventory(true);
        }
        if (TownySettings.getKeepExperienceInTowns() && !keepLevel && (tb = TownyAPI.getInstance().getTownBlock(deathloc)) != null && tb.hasTown()) {
            event.setKeepLevel(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerEnterTown(PlayerEnterTownEvent event) throws TownyException {
        Resident resident = TownyUniverse.getInstance().getDataSource().getResident(event.getPlayer().getName());
        WorldCoord to = event.getTo();
        if (TownySettings.isNotificationUsingTitles()) {
            String replacement;
            String title = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesTownTitle());
            String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesTownSubtitle());
            if (title.contains("{townname}")) {
                title = replacement = title.replace("{townname}", to.getTownBlock().getTown().getName());
            }
            if (subtitle.contains("{townname}")) {
                subtitle = replacement = subtitle.replace("{townname}", to.getTownBlock().getTown().getName());
            }
            TownyMessaging.sendTitleMessageToResident(resident, title, subtitle);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLeaveTown(PlayerLeaveTownEvent event) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident resident = townyUniverse.getDataSource().getResident(event.getPlayer().getName());
        WorldCoord to = event.getTo();
        if (TownySettings.isNotificationUsingTitles()) {
            try {
                Town town = to.getTownBlock().getTown();
            }
            catch (NotRegisteredException e) {
                String title = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesWildTitle());
                String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesWildSubtitle());
                if (title.contains("{wilderness}")) {
                    title = title.replace("{wilderness}", townyUniverse.getDataSource().getWorld(event.getPlayer().getLocation().getWorld().getName()).getUnclaimedZoneName());
                }
                if (subtitle.contains("{wilderness}")) {
                    subtitle = subtitle.replace("{wilderness}", townyUniverse.getDataSource().getWorld(event.getPlayer().getLocation().getWorld().getName()).getUnclaimedZoneName());
                }
                TownyMessaging.sendTitleMessageToResident(resident, title, subtitle);
            }
        }
        Player player = event.getPlayer();
        if (townyUniverse.getDataSource().getResident(player.getName()).isJailed()) {
            resident.freeFromJail(player, resident.getJailSpawn(), true);
            townyUniverse.getDataSource().saveResident(resident);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTakeLecternBookEvent(PlayerTakeLecternBookEvent event) {
        Lectern lectern;
        Location location;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getLectern().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        boolean bDestroy = PlayerCacheUtil.getCachePermission(player, location = (lectern = event.getLectern()).getLocation(), Material.LECTERN, TownyPermission.ActionType.DESTROY);
        event.setCancelled(!bDestroy);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJailedPlayerUsesCommand(PlayerCommandPreprocessEvent event) throws NotRegisteredException {
        if (!TownyAPI.getInstance().getDataSource().getResident(event.getPlayer().getName()).isJailed()) {
            return;
        }
        String[] split = event.getMessage().substring(1).split(" ");
        if (TownySettings.getJailBlacklistedCommands().contains(split[0])) {
            TownyMessaging.sendErrorMsg((Object)event.getPlayer(), TownySettings.getLangString("msg_you_cannot_use_that_command_while_jailed"));
            event.setCancelled(true);
        }
    }
}

