/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownyWorld;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class TownyWorldListener
implements Listener {
    public static List<String> playersMap = new ArrayList<String>();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldLoadEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldInit(WorldInitEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    private void newWorld(String worldName) {
        boolean dungeonWorld = false;
        if (Bukkit.getServer().getPluginManager().getPlugin("DungeonsXL") != null && worldName.startsWith("DXL_")) {
            dungeonWorld = true;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            townyUniverse.getDataSource().newWorld(worldName);
            TownyWorld world = townyUniverse.getDataSource().getWorld(worldName);
            if (dungeonWorld) {
                world.setUsingTowny(false);
            }
            if (world == null) {
                TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            } else if (!dungeonWorld && !townyUniverse.getDataSource().loadWorld(world)) {
                townyUniverse.getDataSource().saveWorld(world);
            }
        }
        catch (AlreadyRegisteredException world) {
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            e.printStackTrace();
        }
    }
}

