/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.NationAddTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.event.NationTagChangeEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.TownyAllySender;
import com.palmergames.bukkit.towny.invites.TownyInviteReceiver;
import com.palmergames.bukkit.towny.invites.TownyInviteSender;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class Nation
extends TownyEconomyObject
implements ResidentList,
TownyInviteSender,
TownyInviteReceiver,
TownyAllySender {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getNationAccountPrefix();
    private List<Town> towns = new ArrayList<Town>();
    private List<Nation> allies = new ArrayList<Nation>();
    private List<Nation> enemies = new ArrayList<Nation>();
    private Town capital;
    private double taxes;
    private double spawnCost;
    private boolean neutral = false;
    private String nationBoard = "/nation set board [msg]";
    private String tag = "";
    public UUID uuid;
    private long registered;
    private Location nationSpawn;
    private boolean isPublic = TownySettings.getNationDefaultPublic();
    private boolean isOpen = TownySettings.getNationDefaultOpen();
    private transient List<Invite> receivedinvites = new ArrayList<Invite>();
    private transient List<Invite> sentinvites = new ArrayList<Invite>();
    private transient List<Invite> sentallyinvites = new ArrayList<Invite>();

    public Nation(String name) {
        super(name);
    }

    public void setTag(String text) throws TownyException {
        if (text.length() > 4) {
            throw new TownyException(TownySettings.getLangString("msg_err_tag_too_long"));
        }
        this.tag = text.toUpperCase().trim();
        Bukkit.getPluginManager().callEvent((Event)new NationTagChangeEvent(this.tag));
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public void addAlly(Nation nation) throws AlreadyRegisteredException {
        if (this.hasAlly(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeEnemy(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getAllies().add(nation);
    }

    public boolean removeAlly(Nation nation) throws NotRegisteredException {
        if (!this.hasAlly(nation)) {
            throw new NotRegisteredException();
        }
        return this.getAllies().remove(nation);
    }

    public boolean removeAllAllies() {
        for (Nation ally : new ArrayList<Nation>(this.getAllies())) {
            try {
                this.removeAlly(ally);
                ally.removeAlly(this);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasAlly(Nation nation) {
        return this.getAllies().contains(nation);
    }

    public boolean IsAlliedWith(Nation nation) {
        return this.getAllies().contains(nation);
    }

    public void addEnemy(Nation nation) throws AlreadyRegisteredException {
        if (this.hasEnemy(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeAlly(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getEnemies().add(nation);
    }

    public boolean removeEnemy(Nation nation) throws NotRegisteredException {
        if (!this.hasEnemy(nation)) {
            throw new NotRegisteredException();
        }
        return this.getEnemies().remove(nation);
    }

    public boolean removeAllEnemies() {
        for (Nation enemy : new ArrayList<Nation>(this.getEnemies())) {
            try {
                this.removeEnemy(enemy);
                enemy.removeEnemy(this);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasEnemy(Nation nation) {
        return this.getEnemies().contains(nation);
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public boolean isKing(Resident resident) {
        return this.hasCapital() && this.getCapital().isMayor(resident);
    }

    public boolean hasCapital() {
        return this.getCapital() != null;
    }

    public boolean hasAssistant(Resident resident) {
        return this.getAssistants().contains(resident);
    }

    public boolean isCapital(Town town) {
        return town == this.getCapital();
    }

    public boolean hasTown(String name) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTown(Town town) {
        return this.towns.contains(town);
    }

    public void addTown(Town town) throws AlreadyRegisteredException {
        if (this.hasTown(town)) {
            throw new AlreadyRegisteredException();
        }
        if (town.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.towns.add(town);
        town.setNation(this);
        BukkitTools.getPluginManager().callEvent((Event)new NationAddTownEvent(town, this));
    }

    public void setCapital(Town capital) {
        this.capital = capital;
        try {
            this.recheckTownDistance();
            TownyPerms.assignPermissions(capital.getMayor(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Town getCapital() {
        return this.capital;
    }

    public Location getNationSpawn() throws TownyException {
        if (this.nationSpawn == null) {
            throw new TownyException(TownySettings.getLangString("msg_err_nation_has_not_set_a_spawn_location"));
        }
        return this.nationSpawn;
    }

    public boolean hasNationSpawn() {
        return this.nationSpawn != null;
    }

    public void setNationSpawn(Location spawn) throws TownyException {
        Coord spawnBlock = Coord.parseCoord(spawn);
        TownBlock townBlock = TownyUniverse.getInstance().getDataSource().getWorld(spawn.getWorld().getName()).getTownBlock(spawnBlock);
        if (TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_CAPITAL_SPAWN)) {
            if (this.capital == null) {
                throw new TownyException(TownySettings.getLangString("msg_err_spawn_not_within_capital"));
            }
            if (!townBlock.hasTown()) {
                throw new TownyException(TownySettings.getLangString("msg_err_spawn_not_within_capital"));
            }
            if (townBlock.getTown() != this.getCapital()) {
                throw new TownyException(TownySettings.getLangString("msg_err_spawn_not_within_capital"));
            }
        } else {
            if (!townBlock.hasTown()) {
                throw new TownyException(TownySettings.getLangString("msg_err_spawn_not_within_nationtowns"));
            }
            if (!this.towns.contains(townBlock.getTown())) {
                throw new TownyException(TownySettings.getLangString("msg_err_spawn_not_within_nationtowns"));
            }
        }
        this.nationSpawn = spawn;
    }

    public void forceSetNationSpawn(Location nationSpawn) {
        this.nationSpawn = nationSpawn;
    }

    public boolean setAllegiance(String type, Nation nation) {
        try {
            if (type.equalsIgnoreCase("ally")) {
                this.removeEnemy(nation);
                this.addAlly(nation);
                if (!this.hasEnemy(nation) && this.hasAlly(nation)) {
                    return true;
                }
            } else if (type.equalsIgnoreCase("peaceful") || type.equalsIgnoreCase("neutral")) {
                this.removeEnemy(nation);
                this.removeAlly(nation);
                if (!this.hasEnemy(nation) && !this.hasAlly(nation)) {
                    return true;
                }
            } else if (type.equalsIgnoreCase("enemy")) {
                this.removeAlly(nation);
                this.addEnemy(nation);
                if (this.hasEnemy(nation) && !this.hasAlly(nation)) {
                    return true;
                }
            }
        }
        catch (AlreadyRegisteredException | NotRegisteredException x) {
            return false;
        }
        return false;
    }

    public List<Resident> getAssistants() {
        ArrayList<Resident> assistants = new ArrayList<Resident>();
        for (Town town : this.towns) {
            for (Resident assistant : town.getResidents()) {
                if (!assistant.hasNationRank("assistant")) continue;
                assistants.add(assistant);
            }
        }
        return assistants;
    }

    public void setEnemies(List<Nation> enemies) {
        this.enemies = enemies;
    }

    public List<Nation> getEnemies() {
        return this.enemies;
    }

    public void setAllies(List<Nation> allies) {
        this.allies = allies;
    }

    public List<Nation> getAllies() {
        return this.allies;
    }

    public int getNumTowns() {
        return this.towns.size();
    }

    public int getNumResidents() {
        int numResidents = 0;
        for (Town town : this.getTowns()) {
            numResidents += town.getNumResidents();
        }
        return numResidents;
    }

    public void removeTown(Town town) throws EmptyNationException, NotRegisteredException {
        if (!this.hasTown(town)) {
            throw new NotRegisteredException();
        }
        boolean isCapital = town.isCapital();
        this.remove(town);
        if (this.getNumTowns() == 0) {
            throw new EmptyNationException(this);
        }
        if (isCapital) {
            int numResidents = 0;
            Town tempCapital = null;
            for (Town newCapital : this.getTowns()) {
                if (newCapital.getNumResidents() <= numResidents) continue;
                tempCapital = newCapital;
                numResidents = newCapital.getNumResidents();
            }
            if (tempCapital != null) {
                this.setCapital(tempCapital);
            }
        }
    }

    private void remove(Town town) {
        try {
            town.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.towns.remove(town);
        BukkitTools.getPluginManager().callEvent((Event)new NationRemoveTownEvent(town, this));
    }

    private void removeAllTowns() {
        for (Town town : new ArrayList<Town>(this.towns)) {
            this.remove(town);
        }
    }

    public void setTaxes(double taxes) {
        this.taxes = taxes > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : taxes;
    }

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public void clear() {
        this.removeAllAllies();
        this.removeAllEnemies();
        this.removeAllTowns();
        this.capital = null;
    }

    public void recheckTownDistance() throws TownyException {
        if (this.capital != null && TownySettings.getNationRequiresProximity() > 0.0) {
            Coord capitalCoord = this.capital.getHomeBlock().getCoord();
            Iterator<Town> it = this.towns.iterator();
            while (it.hasNext()) {
                Town town = it.next();
                Coord townCoord = town.getHomeBlock().getCoord();
                if (!this.capital.getHomeBlock().getWorld().getName().equals(town.getHomeBlock().getWorld().getName())) {
                    it.remove();
                    continue;
                }
                double distance = Math.sqrt(Math.pow(capitalCoord.getX() - townCoord.getX(), 2.0) + Math.pow(capitalCoord.getZ() - townCoord.getZ(), 2.0));
                if (!(distance > TownySettings.getNationRequiresProximity())) continue;
                town.setNation(null);
                it.remove();
            }
        }
    }

    public void setNeutral(boolean neutral) throws TownyException {
        if (!TownySettings.isDeclaringNeutral() && neutral) {
            throw new TownyException(TownySettings.getLangString("msg_err_fight_like_king"));
        }
        if (neutral) {
            for (Resident resident : this.getResidents()) {
                TownyWar.removeAttackerFlags(resident.getName());
            }
        }
        this.neutral = neutral;
    }

    public boolean isNeutral() {
        return this.neutral;
    }

    public void setKing(Resident king) throws TownyException {
        if (!this.hasResident(king)) {
            throw new TownyException(TownySettings.getLangString("msg_err_king_not_in_nation"));
        }
        if (!king.isMayor()) {
            throw new TownyException(TownySettings.getLangString("msg_err_new_king_notmayor"));
        }
        this.setCapital(king.getTown());
    }

    public boolean hasResident(Resident resident) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(resident)) continue;
            return true;
        }
        return false;
    }

    public void collect(double amount) throws EconomyException {
        if (TownySettings.isUsingEconomy()) {
            double bankcap = TownySettings.getNationBankCap();
            if (bankcap > 0.0 && amount + this.getHoldingBalance() > bankcap) {
                TownyMessaging.sendNationMessage(this, String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
                return;
            }
            this.collect(amount, null);
        }
    }

    public void withdrawFromBank(Resident resident, int amount) throws EconomyException, TownyException {
        if (TownySettings.isUsingEconomy()) {
            if (!this.payTo(amount, resident, "Nation Withdraw")) {
                throw new TownyException(TownySettings.getLangString("msg_err_no_money"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_no_economy"));
        }
    }

    @Override
    public List<Resident> getResidents() {
        ArrayList<Resident> out = new ArrayList<Resident>();
        for (Town town : this.getTowns()) {
            out.addAll(town.getResidents());
        }
        return out;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Nation (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Capital: " + this.getCapital().getName());
        List<Resident> assistants = this.getAssistants();
        if (assistants.size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        if (this.getAllies().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Allies (" + this.getAllies().size() + "): " + Arrays.toString(this.getAllies().toArray(new Nation[0])));
        }
        if (this.getEnemies().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Enemies (" + this.getEnemies().size() + "): " + Arrays.toString(this.getEnemies().toArray(new Nation[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Towns (" + this.getTowns().size() + "):");
        for (Town town : this.getTowns()) {
            out.addAll(town.getTreeString(depth + 2));
        }
        return out;
    }

    @Override
    public boolean hasResident(String name) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected World getBukkitWorld() {
        if (this.hasCapital() && this.getCapital().hasWorld()) {
            return BukkitTools.getWorld(this.getCapital().getWorld().getName());
        }
        return super.getBukkitWorld();
    }

    @Override
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }

    @Override
    public List<Resident> getOutlaws() {
        ArrayList<Resident> out = new ArrayList<Resident>();
        for (Town town : this.getTowns()) {
            out.addAll(town.getOutlaws());
        }
        return out;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public long getRegistered() {
        return this.registered;
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    @Override
    public List<Invite> getReceivedInvites() {
        return this.receivedinvites;
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedinvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(String.format(TownySettings.getLangString("msg_err_nation_has_too_many_requests"), this.getName()));
        }
        this.receivedinvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedinvites.remove(invite);
    }

    @Override
    public List<Invite> getSentInvites() {
        return this.sentinvites;
    }

    @Override
    public void newSentInvite(Invite invite) throws TooManyInvitesException {
        if (this.sentinvites.size() > InviteHandler.getSentInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(TownySettings.getLangString("msg_err_nation_sent_too_many_invites"));
        }
        this.sentinvites.add(invite);
    }

    @Override
    public void deleteSentInvite(Invite invite) {
        this.sentinvites.remove(invite);
    }

    @Override
    public void newSentAllyInvite(Invite invite) throws TooManyInvitesException {
        if (this.sentallyinvites.size() > InviteHandler.getSentAllyRequestsMaxAmount(this) - 1) {
            throw new TooManyInvitesException(TownySettings.getLangString("msg_err_nation_sent_too_many_requests"));
        }
        this.sentallyinvites.add(invite);
    }

    @Override
    public void deleteSentAllyInvite(Invite invite) {
        this.sentallyinvites.remove(invite);
    }

    @Override
    public List<Invite> getSentAllyInvites() {
        return this.sentallyinvites;
    }

    public void setNationBoard(String nationBoard) {
        this.nationBoard = nationBoard;
    }

    public String getNationBoard() {
        return this.nationBoard;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setSpawnCost(double spawnCost) {
        this.spawnCost = spawnCost;
    }

    public double getSpawnCost() {
        return this.spawnCost;
    }

    public int getNumTownblocks() {
        int townBlocksClaimed = 0;
        for (Town towns : this.getTowns()) {
            townBlocksClaimed += towns.getTownBlocks().size();
        }
        return townBlocksClaimed;
    }

    public Resident getKing() {
        return this.capital.getMayor();
    }
}

