/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.ConfirmationType;
import com.palmergames.bukkit.towny.event.TownAddResidentRankEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentRankEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.TownyInviteReceiver;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.ResidentModes;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Resident
extends TownBlockOwner
implements ResidentModes,
TownyInviteReceiver {
    private List<Resident> friends = new ArrayList<Resident>();
    private Town town = null;
    private long lastOnline;
    private long registered;
    private boolean isNPC = false;
    private boolean isJailed = false;
    private int jailSpawn;
    private int jailDays;
    private String jailTown = "";
    private String title = "";
    private String surname = "";
    private long teleportRequestTime = -1L;
    private Location teleportDestination;
    private double teleportCost = 0.0;
    private List<String> modes = new ArrayList<String>();
    private transient ConfirmationType confirmationType;
    private transient List<Invite> receivedinvites = new ArrayList<Invite>();
    private List<String> townRanks = new ArrayList<String>();
    private List<String> nationRanks = new ArrayList<String>();

    public Resident(String name) {
        super(name);
        this.permissions.loadDefault(this);
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean isNPC) {
        this.isNPC = isNPC;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    public void setJailed(boolean isJailed) {
        this.isJailed = isJailed;
        if (isJailed) {
            TownyUniverse.getInstance().getJailedResidentMap().add(this);
        } else {
            TownyUniverse.getInstance().getJailedResidentMap().remove(this);
        }
    }

    public void sendToJail(Player player, Integer index, Town town) {
        this.setJailed(true);
        this.setJailSpawn(index);
        this.setJailTown(town.getName());
        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_you_have_been_sent_to_jail"));
        TownyMessaging.sendTownMessagePrefixed(town, String.format(TownySettings.getLangString("msg_player_has_been_sent_to_jail_number"), player.getName(), index));
    }

    public void freeFromJail(Player player, Integer index, boolean escaped) {
        this.setJailed(false);
        this.removeJailSpawn();
        this.setJailTown(" ");
        if (!escaped) {
            TownyMessaging.sendMsg(this, TownySettings.getLangString("msg_you_have_been_freed_from_jail"));
            TownyMessaging.sendTownMessagePrefixed(this.town, String.format(TownySettings.getLangString("msg_player_has_been_freed_from_jail_number"), this.getName(), index));
        } else {
            try {
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_player_escaped_jail_into_wilderness"), player.getName(), TownyUniverse.getInstance().getDataSource().getWorld(player.getLocation().getWorld().getName()).getUnclaimedZoneName()));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void setJailedByMayor(Player player, Integer index, Town town, Integer days) {
        if (this.isJailed) {
            try {
                Location loc = this.getTown().getSpawn();
                if (BukkitTools.isOnline(player.getName())) {
                    player.sendMessage(String.format(TownySettings.getLangString("msg_town_spawn_warmup"), TownySettings.getTeleportWarmupTime()));
                    TownyAPI.getInstance().jailTeleport(player, loc);
                }
                this.freeFromJail(player, index, false);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Location loc = town.getJailSpawn(index);
                player.sendMessage(String.format(TownySettings.getLangString("msg_town_spawn_warmup"), TownySettings.getTeleportWarmupTime()));
                TownyAPI.getInstance().jailTeleport(player, loc);
                this.sendToJail(player, index, town);
                if (days > 0) {
                    this.setJailDays(days);
                    TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you've_been_jailed_for_x_days"), days));
                }
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
        TownyUniverse.getInstance().getDataSource().saveResident(this);
    }

    public void setJailed(Resident resident, Integer index, Town town) {
        Player player = null;
        if (BukkitTools.isOnline(resident.getName())) {
            player = BukkitTools.getPlayer(resident.getName());
        }
        if (this.isJailed) {
            try {
                if (player != null) {
                    Location loc = this.hasTown() ? this.getTown().getSpawn() : player.getWorld().getSpawnLocation();
                    player.teleport(loc);
                }
                this.freeFromJail(player, index, false);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Location loc = town.getJailSpawn(index);
                player.teleport(loc);
                this.sendToJail(player, index, town);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
        TownyUniverse.getInstance().getDataSource().saveResident(this);
    }

    public boolean isJailed() {
        return this.isJailed;
    }

    public boolean hasJailSpawn() {
        return this.jailSpawn > 0;
    }

    public int getJailSpawn() {
        return this.jailSpawn;
    }

    public void setJailSpawn(Integer index) {
        this.jailSpawn = index;
    }

    public void removeJailSpawn() {
        this.jailSpawn = 0;
    }

    public String getJailTown() {
        return this.jailTown;
    }

    public void setJailTown(String jailTown) {
        if (jailTown == null) {
            this.jailTown = "";
            return;
        }
        this.jailTown = jailTown.trim();
    }

    public boolean hasJailTown(String jailtown) {
        return this.jailTown.equalsIgnoreCase(jailtown);
    }

    public int getJailDays() {
        return this.jailDays;
    }

    public void setJailDays(Integer days) {
        this.jailDays = days;
    }

    public boolean hasJailDays() {
        return this.jailDays > 0;
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String surname) {
        this.surname = surname.trim();
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public boolean isKing() {
        try {
            return this.getTown().getNation().isKing(this);
        }
        catch (TownyException e) {
            return false;
        }
    }

    public boolean isMayor() {
        return this.hasTown() && this.town.isMayor(this);
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() && this.town.hasNation();
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException(TownySettings.getLangString("msg_err_resident_doesnt_belong_to_any_town"));
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        if (town == null) {
            this.town = null;
            this.setTitle("");
            this.setSurname("");
            this.updatePerms();
            return;
        }
        if (this.town == town) {
            return;
        }
        if (this.hasTown()) {
            throw new AlreadyRegisteredException();
        }
        this.town = town;
        this.setTitle("");
        this.setSurname("");
        this.updatePerms();
    }

    public void setFriends(List<Resident> newFriends) {
        this.friends = newFriends;
    }

    public List<Resident> getFriends() {
        return this.friends;
    }

    public boolean removeFriend(Resident resident) throws NotRegisteredException {
        if (this.hasFriend(resident)) {
            return this.friends.remove(resident);
        }
        throw new NotRegisteredException();
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) throws AlreadyRegisteredException {
        if (this.hasFriend(resident)) {
            throw new AlreadyRegisteredException();
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        for (Resident resident : new ArrayList<Resident>(this.friends)) {
            try {
                this.removeFriend(resident);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
    }

    public void clear() throws EmptyTownException {
        this.removeAllFriends();
        if (this.hasTown()) {
            try {
                this.town.removeResident(this);
                this.setTitle("");
                this.setSurname("");
                this.updatePerms();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void updatePerms() {
        this.townRanks.clear();
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void updatePermsForNationRemoval() {
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Resident (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Registered: " + this.getRegistered());
        out.add(this.getTreeDepth(depth + 1) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return out;
    }

    public void clearTeleportRequest() {
        this.teleportRequestTime = -1L;
    }

    public void setTeleportRequestTime() {
        this.teleportRequestTime = System.currentTimeMillis();
    }

    public long getTeleportRequestTime() {
        return this.teleportRequestTime;
    }

    public void setTeleportDestination(Location spawnLoc) {
        this.teleportDestination = spawnLoc;
    }

    public Location getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean hasRequestedTeleport() {
        return this.teleportRequestTime != -1L;
    }

    public void setTeleportCost(double cost) {
        this.teleportCost = cost;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    @Override
    public List<String> getModes() {
        return this.modes;
    }

    @Override
    public boolean hasMode(String mode) {
        return this.modes.contains(mode.toLowerCase());
    }

    @Override
    public void toggleMode(String[] newModes, boolean notify) {
        for (String mode : newModes) {
            if (this.modes.contains(mode = mode.toLowerCase())) {
                this.modes.remove(mode);
                continue;
            }
            this.modes.add(mode);
        }
        if (this.modes.isEmpty()) {
            this.clearModes();
            return;
        }
        if (notify) {
            TownyMessaging.sendMsg(this, TownySettings.getLangString("msg_modes_set") + StringMgmt.join(this.getModes(), ","));
        }
    }

    @Override
    public void setModes(String[] modes, boolean notify) {
        this.modes.clear();
        this.toggleMode(modes, false);
        if (notify) {
            TownyMessaging.sendMsg(this, TownySettings.getLangString("msg_modes_set") + StringMgmt.join(this.getModes(), ","));
        }
    }

    @Override
    public void clearModes() {
        this.modes.clear();
        if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.getName(), true), 1L) == -1) {
            TownyMessaging.sendErrorMsg(TownySettings.getLangString("msg_err_could_not_set_default_modes_for") + this.getName() + ".");
        }
    }

    public void resetModes(String[] modes, boolean notify) {
        if (modes.length > 0) {
            this.toggleMode(modes, false);
        }
        if (notify) {
            TownyMessaging.sendMsg(this, TownySettings.getLangString("msg_modes_set") + StringMgmt.join(this.getModes(), ","));
        }
    }

    public boolean addTownRank(String rank) throws AlreadyRegisteredException {
        if (this.hasTown() && TownyPerms.getTownRanks().contains(rank)) {
            if (this.townRanks.contains(rank)) {
                throw new AlreadyRegisteredException();
            }
            this.townRanks.add(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentRankEvent(this, rank, this.town));
            return true;
        }
        return false;
    }

    public void setTownRanks(List<String> ranks) {
        this.townRanks.addAll(ranks);
    }

    public boolean hasTownRank(String rank) {
        return this.townRanks.contains(rank.toLowerCase());
    }

    public List<String> getTownRanks() {
        return this.townRanks;
    }

    public boolean removeTownRank(String rank) throws NotRegisteredException {
        if (this.townRanks.contains(rank)) {
            this.townRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentRankEvent(this, rank, this.town));
            return true;
        }
        throw new NotRegisteredException();
    }

    public boolean addNationRank(String rank) throws AlreadyRegisteredException {
        if (this.hasNation() && TownyPerms.getNationRanks().contains(rank)) {
            if (this.nationRanks.contains(rank)) {
                throw new AlreadyRegisteredException();
            }
            this.nationRanks.add(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setNationRanks(List<String> ranks) {
        this.nationRanks.addAll(ranks);
    }

    public boolean hasNationRank(String rank) {
        return this.nationRanks.contains(rank.toLowerCase());
    }

    public List<String> getNationRanks() {
        return this.nationRanks;
    }

    public boolean removeNationRank(String rank) throws NotRegisteredException {
        if (this.nationRanks.contains(rank)) {
            this.nationRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        throw new NotRegisteredException();
    }

    @Override
    protected World getBukkitWorld() {
        Player player = BukkitTools.getPlayer(this.getName());
        if (player != null) {
            return player.getWorld();
        }
        return super.getBukkitWorld();
    }

    public boolean isAlliedWith(Resident otherresident) {
        if (this.hasNation() && this.hasTown() && otherresident.hasTown() && otherresident.hasNation()) {
            try {
                if (this.getTown().getNation().hasAlly(otherresident.getTown().getNation())) {
                    return true;
                }
                return this.getTown().getNation().equals(otherresident.getTown().getNation());
            }
            catch (NotRegisteredException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public List<Invite> getReceivedInvites() {
        return this.receivedinvites;
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedinvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(String.format(TownySettings.getLangString("msg_err_player_has_too_many_invites"), this.getName()));
        }
        this.receivedinvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedinvites.remove(invite);
    }

    public void setConfirmationType(ConfirmationType confirmationType) {
        this.confirmationType = confirmationType;
    }

    public ConfirmationType getConfirmationType() {
        return this.confirmationType;
    }
}

