/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.TownTagChangeEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.TownyInviteReceiver;
import com.palmergames.bukkit.towny.invites.TownyInviteSender;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class Town
extends TownBlockOwner
implements ResidentList,
TownyInviteReceiver,
TownyInviteSender {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getTownAccountPrefix();
    private List<Resident> residents = new ArrayList<Resident>();
    private List<Resident> outlaws = new ArrayList<Resident>();
    private List<Location> outpostSpawns = new ArrayList<Location>();
    private List<Location> jailSpawns = new ArrayList<Location>();
    private Resident mayor;
    private int bonusBlocks = 0;
    private int purchasedBlocks = 0;
    private double taxes = TownySettings.getTownDefaultTax();
    private double plotTax = TownySettings.getTownDefaultPlotTax();
    private double commercialPlotTax = TownySettings.getTownDefaultShopTax();
    private double plotPrice = 0.0;
    private double embassyPlotTax = TownySettings.getTownDefaultEmbassyTax();
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private double spawnCost;
    private Nation nation;
    private boolean hasUpkeep = true;
    private boolean isPublic = TownySettings.getTownDefaultPublic();
    private boolean isTaxPercentage = TownySettings.getTownDefaultTaxPercentage();
    private boolean isOpen = TownySettings.getTownDefaultOpen();
    private String townBoard = "/town set board [msg]";
    private String tag = "";
    private TownBlock homeBlock;
    private TownyWorld world;
    private Location spawn;
    private boolean adminDisabledPVP = false;
    private boolean adminEnabledPVP = false;
    private UUID uuid;
    private long registered;
    private transient List<Invite> receivedinvites = new ArrayList<Invite>();
    private transient List<Invite> sentinvites = new ArrayList<Invite>();
    private HashSet<CustomDataField> metadata = null;

    public Town(String name) {
        super(name);
        this.permissions.loadDefault(this);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
        if (this.townBlocks.size() == 1 && !this.hasHomeBlock()) {
            try {
                this.setHomeBlock(townBlock);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public void setTag(String text) throws TownyException {
        if (text.length() > 4) {
            throw new TownyException(TownySettings.getLangString("msg_err_tag_too_long"));
        }
        this.tag = text.toUpperCase();
        if (this.tag.matches(" ")) {
            this.tag = "";
        }
        Bukkit.getPluginManager().callEvent((Event)new TownTagChangeEvent(this.tag, this));
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public Resident getMayor() {
        return this.mayor;
    }

    public void setTaxes(double taxes) {
        this.taxes = this.isTaxPercentage ? (taxes > TownySettings.getMaxTaxPercent() ? TownySettings.getMaxTaxPercent() : taxes) : (taxes > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : taxes);
    }

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public void setMayor(Resident mayor) throws TownyException {
        if (!this.hasResident(mayor)) {
            throw new TownyException(TownySettings.getLangString("msg_err_mayor_doesnt_belong_to_town"));
        }
        this.mayor = mayor;
        TownyPerms.assignPermissions(mayor, null);
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException(TownySettings.getLangString("msg_err_town_doesnt_belong_to_any_nation"));
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        if (nation == null) {
            this.nation = null;
            TownyPerms.updateTownPerms(this);
            return;
        }
        if (this.nation == nation) {
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
        TownyPerms.updateTownPerms(this);
    }

    @Override
    public List<Resident> getResidents() {
        return this.residents;
    }

    public List<Resident> getAssistants() {
        ArrayList<Resident> assistants = new ArrayList<Resident>();
        for (Resident assistant : this.residents) {
            if (!assistant.hasTownRank("assistant")) continue;
            assistants.add(assistant);
        }
        return assistants;
    }

    @Override
    public boolean hasResident(String name) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    public boolean hasAssistant(Resident resident) {
        return this.getAssistants().contains(resident);
    }

    public void addResident(Resident resident) throws AlreadyRegisteredException {
        this.addResidentCheck(resident);
        this.residents.add(resident);
        resident.setTown(this);
        BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentEvent(resident, this));
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_err_already_in_town"), resident.getName(), this.getFormattedName()));
        }
        if (resident.hasTown()) {
            try {
                if (!resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_err_already_in_town"), resident.getName(), resident.getTown().getFormattedName()));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() && this.nation.isCapital(this);
    }

    public void setHasUpkeep(boolean hasUpkeep) {
        this.hasUpkeep = hasUpkeep;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public void setHasMobs(boolean hasMobs) {
        this.permissions.mobs = hasMobs;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setPVP(boolean isPVP) {
        this.permissions.pvp = isPVP;
    }

    public void setAdminDisabledPVP(boolean isPVPDisabled) {
        this.adminDisabledPVP = isPVPDisabled;
    }

    public void setAdminEnabledPVP(boolean isPVPEnabled) {
        this.adminEnabledPVP = isPVPEnabled;
    }

    public boolean isPVP() {
        if (this.isAdminEnabledPVP()) {
            return true;
        }
        if (this.isAdminDisabledPVP()) {
            return false;
        }
        return this.permissions.pvp;
    }

    public boolean isAdminDisabledPVP() {
        return this.adminDisabledPVP;
    }

    public boolean isAdminEnabledPVP() {
        return this.adminEnabledPVP;
    }

    public void setBANG(boolean isBANG) {
        this.permissions.explosion = isBANG;
    }

    public boolean isBANG() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean isPercentage) {
        this.isTaxPercentage = isPercentage;
        if (this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean isFire) {
        this.permissions.fire = isFire;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setTownBoard(String townBoard) {
        this.townBoard = townBoard;
    }

    public String getTownBoard() {
        return this.townBoard;
    }

    public void setBonusBlocks(int bonusBlocks) {
        this.bonusBlocks = bonusBlocks;
    }

    public int getTotalBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public double getBonusBlockCost() {
        double nextprice = Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), this.getPurchasedBlocks()) * TownySettings.getPurchasedBonusBlocksCost();
        return nextprice;
    }

    public double getTownBlockCost() {
        double nextprice = Math.pow(TownySettings.getClaimPriceIncreaseValue(), this.getTownBlocks().size()) * TownySettings.getClaimPrice();
        return nextprice;
    }

    public double getTownBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(TownySettings.getLangString("msg_err_negative"));
        }
        int n = inputN;
        if (n == 0) {
            return n;
        }
        double nextprice = this.getTownBlockCost();
        double cost = nextprice;
        for (int i = 1; i < n; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), this.getTownBlocks().size() + i) * TownySettings.getClaimPrice());
            cost += nextprice;
        }
        cost = Math.round(cost);
        return cost;
    }

    public double getBonusBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(TownySettings.getLangString("msg_err_negative"));
        }
        int current = this.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchedBlocks(this) ? TownySettings.getMaxPurchedBlocks(this) - current : inputN;
        if (n == 0) {
            return n;
        }
        double nextprice = this.getBonusBlockCost();
        double cost = nextprice;
        for (int i = 1; i < n; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), this.getPurchasedBlocks() + i) * TownySettings.getPurchasedBonusBlocksCost());
            cost += nextprice;
        }
        cost = Math.round(cost);
        return cost;
    }

    public void addBonusBlocks(int bonusBlocks) {
        this.bonusBlocks += bonusBlocks;
    }

    public void setPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks = purchasedBlocks;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks += purchasedBlocks;
    }

    public boolean setHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            return false;
        }
        if (!this.hasTownBlock(homeBlock)) {
            throw new TownyException(TownySettings.getLangString("msg_err_town_has_no_claim_over_this_town_block"));
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            if (this.world != null && this.world.hasTown(this)) {
                this.world.removeTown(this);
            }
            this.setWorld(homeBlock.getWorld());
        }
        try {
            this.setSpawn(this.spawn);
        }
        catch (TownyException e) {
            this.spawn = null;
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (this.hasNation() && TownySettings.getNationRequiresProximity() > 0.0 && !this.getNation().getCapital().equals(this)) {
            double distance;
            Nation nation = this.getNation();
            Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
            Coord townCoord = this.getHomeBlock().getCoord();
            if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(this.getHomeBlock().getWorld().getName())) {
                TownyMessaging.sendNationMessagePrefixed(nation, String.format(TownySettings.getLangString("msg_nation_town_moved_their_homeblock_too_far"), this.getName()));
                try {
                    nation.removeTown(this);
                }
                catch (EmptyNationException e) {
                    e.printStackTrace();
                }
            }
            if ((distance = Math.sqrt(Math.pow(capitalCoord.getX() - townCoord.getX(), 2.0) + Math.pow(capitalCoord.getZ() - townCoord.getZ(), 2.0))) > TownySettings.getNationRequiresProximity()) {
                TownyMessaging.sendNationMessagePrefixed(nation, String.format(TownySettings.getLangString("msg_nation_town_moved_their_homeblock_too_far"), this.getName()));
                try {
                    nation.removeTown(this);
                }
                catch (EmptyNationException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public void forceSetHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            return;
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            if (this.world != null && this.world.hasTown(this)) {
                this.world.removeTown(this);
            }
            this.setWorld(homeBlock.getWorld());
        }
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException("Town has not set a home block.");
    }

    public void setWorld(TownyWorld world) {
        if (world == null) {
            this.world = null;
            return;
        }
        if (this.world == world) {
            return;
        }
        if (this.hasWorld()) {
            try {
                world.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = world;
        try {
            this.world.addTown(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
    }

    public TownyWorld getWorld() {
        if (this.world != null) {
            return this.world;
        }
        return TownyUniverse.getInstance().getDataSource().getTownWorld(this.getName());
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException, NotRegisteredException {
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException();
        }
        this.remove(resident);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void removeAllResidents() {
        for (Resident resident : new ArrayList<Resident>(this.residents)) {
            this.remove(resident);
        }
    }

    private void remove(Resident resident) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
            if (townBlock.getType() == TownBlockType.EMBASSY) continue;
            townBlock.setResident(null);
            try {
                townBlock.setPlotPrice(townBlock.getTown().getPlotPrice());
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
            TownyUniverse.getInstance().getDataSource().saveTownBlock(townBlock);
            townBlock.setType(townBlock.getType());
        }
        if (this.isMayor(resident) && this.residents.size() > 1) {
            for (Resident assistant : new ArrayList<Resident>(this.getAssistants())) {
                if (assistant == resident || !resident.hasTownRank("assistant")) continue;
                try {
                    this.setMayor(assistant);
                }
                catch (TownyException e) {
                    e.printStackTrace();
                }
            }
            if (this.isMayor(resident)) {
                for (Resident newMayor : new ArrayList<Resident>(this.getResidents())) {
                    if (newMayor == resident) continue;
                    try {
                        this.setMayor(newMayor);
                    }
                    catch (TownyException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            if (resident.hasTown()) {
                BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentEvent(resident, resident.getTown()));
            }
            resident.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
        }
        catch (NotRegisteredException | IllegalStateException e) {
            e.printStackTrace();
        }
        this.residents.remove(resident);
    }

    public void setSpawn(Location spawn) throws TownyException {
        if (!this.hasHomeBlock()) {
            throw new TownyException(TownySettings.getLangString("msg_err_homeblock_has_not_been_set"));
        }
        Coord spawnBlock = Coord.parseCoord(spawn);
        if (this.homeBlock.getX() != spawnBlock.getX() || this.homeBlock.getZ() != spawnBlock.getZ()) {
            throw new TownyException(TownySettings.getLangString("msg_err_spawn_not_within_homeblock"));
        }
        this.spawn = spawn;
    }

    public void forceSetSpawn(Location spawn) {
        this.spawn = spawn;
    }

    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn;
        }
        this.spawn = null;
        throw new TownyException(TownySettings.getLangString("msg_err_town_has_not_set_a_spawn_location"));
    }

    public boolean hasSpawn() {
        return this.hasHomeBlock() && this.spawn != null;
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public void clear() throws EmptyNationException {
        this.removeAllResidents();
        this.mayor = null;
        this.residents.clear();
        this.homeBlock = null;
        this.outpostSpawns.clear();
        this.jailSpawns.clear();
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) throws NotRegisteredException {
        if (!this.hasTownBlock(townBlock)) {
            throw new NotRegisteredException();
        }
        if (townBlock.isOutpost()) {
            this.removeOutpostSpawn(townBlock.getCoord());
        }
        if (townBlock.isJail()) {
            this.removeJailSpawn(townBlock.getCoord());
        }
        try {
            if (this.getHomeBlock() == townBlock) {
                this.setHomeBlock(null);
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        this.townBlocks.remove(townBlock);
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }

    public void addOutpostSpawn(Location spawn) throws TownyException {
        this.removeOutpostSpawn(Coord.parseCoord(spawn));
        Coord spawnBlock = Coord.parseCoord(spawn);
        try {
            TownBlock outpost = TownyUniverse.getInstance().getDataSource().getWorld(spawn.getWorld().getName()).getTownBlock(spawnBlock);
            if (outpost.getX() == spawnBlock.getX() && outpost.getZ() == spawnBlock.getZ()) {
                if (!outpost.isOutpost()) {
                    throw new TownyException(TownySettings.getLangString("msg_err_location_is_not_within_an_outpost_plot"));
                }
                this.outpostSpawns.add(spawn);
            }
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_err_location_is_not_within_a_town"));
        }
    }

    public void forceAddOutpostSpawn(Location spawn) {
        this.outpostSpawns.add(spawn);
    }

    public Location getOutpostSpawn(Integer index) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0 && TownySettings.isOutpostsLimitedByLevels()) {
            throw new TownyException(TownySettings.getLangString("msg_err_town_has_no_outpost_spawns_set"));
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return this.outpostSpawns.size() > 0;
    }

    public List<Location> getAllOutpostSpawns() {
        return this.outpostSpawns;
    }

    public void removeOutpostSpawn(Coord coord) {
        for (Location spawn : new ArrayList<Location>(this.outpostSpawns)) {
            Coord spawnBlock = Coord.parseCoord(spawn);
            if (coord.getX() != spawnBlock.getX() || coord.getZ() != spawnBlock.getZ()) continue;
            this.outpostSpawns.remove(spawn);
        }
    }

    public void setPlotPrice(double plotPrice) {
        this.plotPrice = plotPrice > TownySettings.getMaxPlotPrice() ? TownySettings.getMaxPlotPrice() : plotPrice;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType type) {
        double plotPrice = 0.0;
        switch (type.ordinal()) {
            case 0: {
                plotPrice = this.getPlotPrice();
                break;
            }
            case 1: {
                plotPrice = this.getCommercialPlotPrice();
                break;
            }
            case 3: {
                plotPrice = this.getEmbassyPlotPrice();
                break;
            }
            default: {
                plotPrice = this.getPlotPrice();
            }
        }
        if (plotPrice < 0.0) {
            plotPrice = 0.0;
        }
        return plotPrice;
    }

    public void setCommercialPlotPrice(double commercialPlotPrice) {
        this.commercialPlotPrice = commercialPlotPrice > TownySettings.getMaxPlotPrice() ? TownySettings.getMaxPlotPrice() : commercialPlotPrice;
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double embassyPlotPrice) {
        this.embassyPlotPrice = embassyPlotPrice > TownySettings.getMaxPlotPrice() ? TownySettings.getMaxPlotPrice() : embassyPlotPrice;
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    public void setSpawnCost(double spawnCost) {
        this.spawnCost = spawnCost;
    }

    public double getSpawnCost() {
        return this.spawnCost;
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() && townBlock == this.homeBlock;
    }

    public void setPlotTax(double plotTax) {
        this.plotTax = plotTax > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : plotTax;
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double commercialTax) {
        this.commercialPlotTax = commercialTax > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : commercialTax;
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double embassyPlotTax) {
        this.embassyPlotTax = embassyPlotTax > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : embassyPlotTax;
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void collect(double amount) throws EconomyException {
        if (TownySettings.isUsingEconomy()) {
            double bankcap = TownySettings.getTownBankCap();
            if (bankcap > 0.0 && amount + this.getHoldingBalance() > bankcap) {
                TownyMessaging.sendTownMessage(this, String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
                return;
            }
            this.collect(amount, null);
        }
    }

    public void withdrawFromBank(Resident resident, int amount) throws EconomyException, TownyException {
        if (TownySettings.isUsingEconomy()) {
            if (!this.payTo(amount, resident, "Town Withdraw")) {
                throw new TownyException(TownySettings.getLangString("msg_err_no_money"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_no_economy"));
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Town (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        out.add(this.getTreeDepth(depth + 1) + "Home: " + this.homeBlock);
        out.add(this.getTreeDepth(depth + 1) + "Bonus: " + this.bonusBlocks);
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        List<Resident> assistants = this.getAssistants();
        if (assistants.size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    protected World getBukkitWorld() {
        if (this.hasWorld()) {
            return BukkitTools.getWorld(this.getWorld().getName());
        }
        return super.getBukkitWorld();
    }

    @Override
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }

    public List<Location> getJailSpawns() {
        return this.jailSpawns;
    }

    public void addJailSpawn(Location spawn) throws TownyException {
        this.removeJailSpawn(Coord.parseCoord(spawn));
        Coord spawnBlock = Coord.parseCoord(spawn);
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            TownBlock jail = townyUniverse.getDataSource().getWorld(spawn.getWorld().getName()).getTownBlock(spawnBlock);
            if (jail.getX() == spawnBlock.getX() && jail.getZ() == spawnBlock.getZ()) {
                if (!jail.isJail()) {
                    throw new TownyException(TownySettings.getLangString("msg_err_location_is_not_within_a_jail_plot"));
                }
                this.jailSpawns.add(spawn);
                townyUniverse.getDataSource().saveTown(this);
            }
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_err_location_is_not_within_a_town"));
        }
    }

    public void removeJailSpawn(Coord coord) {
        for (Location spawn : new ArrayList<Location>(this.jailSpawns)) {
            Coord spawnBlock = Coord.parseCoord(spawn);
            if (coord.getX() != spawnBlock.getX() || coord.getZ() != spawnBlock.getZ()) continue;
            this.jailSpawns.remove(spawn);
            TownyUniverse.getInstance().getDataSource().saveTown(this);
        }
    }

    public void forceAddJailSpawn(Location spawn) {
        this.jailSpawns.add(spawn);
    }

    public Location getJailSpawn(Integer index) throws TownyException {
        if (this.getMaxJailSpawn() == 0) {
            throw new TownyException(TownySettings.getLangString("msg_err_town_has_no_jail_spawns_set"));
        }
        return this.jailSpawns.get(Math.min(this.getMaxJailSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxJailSpawn() {
        return this.jailSpawns.size();
    }

    public boolean hasJailSpawn() {
        return this.jailSpawns.size() > 0;
    }

    public List<Location> getAllJailSpawns() {
        return Collections.unmodifiableList(this.jailSpawns);
    }

    @Override
    public List<Resident> getOutlaws() {
        return this.outlaws;
    }

    public boolean hasOutlaw(String name) {
        for (Resident outlaw : this.outlaws) {
            if (!outlaw.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutlaw(Resident outlaw) {
        return this.outlaws.contains(outlaw);
    }

    public void addOutlaw(Resident resident) throws AlreadyRegisteredException {
        this.addOutlawCheck(resident);
        this.outlaws.add(resident);
    }

    public void addOutlawCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasOutlaw(resident)) {
            throw new AlreadyRegisteredException(TownySettings.getLangString("msg_err_resident_already_an_outlaw"));
        }
        if (resident.hasTown()) {
            try {
                if (resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(TownySettings.getLangString("msg_err_not_outlaw_in_your_town"));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeOutlaw(Resident resident) throws NotRegisteredException {
        if (!this.hasOutlaw(resident)) {
            throw new NotRegisteredException();
        }
        this.outlaws.remove(resident);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    public void setOutpostSpawns(List<Location> outpostSpawns) {
        this.outpostSpawns = outpostSpawns;
    }

    public boolean isAlliedWith(Town othertown) {
        if (this.hasNation() && othertown.hasNation()) {
            try {
                if (this.getNation().hasAlly(othertown.getNation())) {
                    return true;
                }
                return this.getNation().equals(othertown.getNation());
            }
            catch (NotRegisteredException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public List<Invite> getReceivedInvites() {
        return this.receivedinvites;
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedinvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(String.format(TownySettings.getLangString("msg_err_town_has_too_many_invites"), this.getName()));
        }
        this.receivedinvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedinvites.remove(invite);
    }

    @Override
    public List<Invite> getSentInvites() {
        return this.sentinvites;
    }

    @Override
    public void newSentInvite(Invite invite) throws TooManyInvitesException {
        if (this.sentinvites.size() > InviteHandler.getSentInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(TownySettings.getLangString("msg_err_town_sent_too_many_invites"));
        }
        this.sentinvites.add(invite);
    }

    @Override
    public void deleteSentInvite(Invite invite) {
        this.sentinvites.remove(invite);
    }

    public int getOutpostLimit() {
        return TownySettings.getMaxOutposts(this);
    }

    public boolean isOverOutpostLimit() {
        return this.getMaxOutpostSpawn() > this.getOutpostLimit();
    }

    public boolean isOverClaimed() {
        return this.getTownBlocks().size() > TownySettings.getMaxTownBlocks(this);
    }

    public void addMetaData(CustomDataField md) {
        if (this.getMetadata() == null) {
            this.metadata = new HashSet();
        }
        this.getMetadata().add(md);
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }

    public void removeMetaData(CustomDataField md) {
        if (!this.hasMeta()) {
            return;
        }
        this.getMetadata().remove(md);
        if (this.getMetadata().size() == 0) {
            this.metadata = null;
        }
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }

    public HashSet<CustomDataField> getMetadata() {
        return this.metadata;
    }

    public boolean hasMeta() {
        return this.getMetadata() != null;
    }

    public void setMetadata(String str) {
        if (this.metadata == null) {
            this.metadata = new HashSet();
        }
        String[] objects = str.split(";");
        for (int i = 0; i < objects.length; ++i) {
            this.metadata.add(CustomDataField.load(objects[i]));
        }
    }
}

