/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Town;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum TownBlockType {
    RESIDENTIAL(0, "default", "+"){}
    ,
    COMMERCIAL(1, "Shop", "C"){

        @Override
        public double getTax(Town town) {
            return town.getCommercialPlotTax() + town.getPlotTax();
        }
    }
    ,
    ARENA(2, "Arena", "A"){}
    ,
    EMBASSY(3, "Embassy", "E"){

        @Override
        public double getTax(Town town) {
            return town.getEmbassyPlotTax() + town.getPlotTax();
        }
    }
    ,
    WILDS(4, "Wilds", "W"){}
    ,
    SPLEEF(5, "Spleef", "+"){}
    ,
    INN(6, "Inn", "I"){}
    ,
    JAIL(7, "Jail", "J"){}
    ,
    FARM(8, "Farm", "F"){}
    ,
    BANK(9, "Bank", "B"){};

    private int id;
    private String name;
    private String asciiMapKey;
    private static final Map<Integer, TownBlockType> idLookup;
    private static final Map<String, TownBlockType> nameLookup;

    private TownBlockType(int id, String name, String asciiMapKey) {
        this.id = id;
        this.name = name;
        this.asciiMapKey = asciiMapKey;
    }

    public String toString() {
        return this.name;
    }

    public double getTax(Town town) {
        return town.getPlotTax();
    }

    public int getId() {
        return this.id;
    }

    public String getAsciiMapKey() {
        return this.asciiMapKey;
    }

    public static TownBlockType lookup(int id) {
        return idLookup.get(id);
    }

    public static TownBlockType lookup(String name) {
        return nameLookup.get(name.toLowerCase());
    }

    static {
        idLookup = new HashMap<Integer, TownBlockType>();
        nameLookup = new HashMap<String, TownBlockType>();
        for (TownBlockType s : EnumSet.allOf(TownBlockType.class)) {
            idLookup.put(s.getId(), s);
            nameLookup.put(s.toString().toLowerCase(), s);
        }
    }
}

