/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.inviteobjects;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.TownyInviteReceiver;
import com.palmergames.bukkit.towny.invites.TownyInviteSender;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import java.util.ArrayList;

public class TownJoinNationInvite
implements Invite {
    private String directsender;
    private TownyInviteReceiver receiver;
    private TownyInviteSender sender;

    public TownJoinNationInvite(String directsender, TownyInviteSender sender, TownyInviteReceiver receiver) {
        this.directsender = directsender;
        this.sender = sender;
        this.receiver = receiver;
    }

    @Override
    public String getDirectSender() {
        return this.directsender;
    }

    @Override
    public TownyInviteReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public TownyInviteSender getSender() {
        return this.sender;
    }

    @Override
    public void accept() throws TownyException {
        Town town = (Town)this.getReceiver();
        ArrayList<Town> towns = new ArrayList<Town>();
        towns.add(town);
        Nation nation = (Nation)this.getSender();
        NationCommand.nationAdd(nation, towns);
        town.deleteReceivedInvite(this);
        nation.deleteSentInvite(this);
    }

    @Override
    public void decline(boolean fromSender) {
        Town town = (Town)this.getReceiver();
        Nation nation = (Nation)this.getSender();
        town.deleteReceivedInvite(this);
        nation.deleteSentInvite(this);
        if (!fromSender) {
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_deny_invite"), town.getName()));
        } else {
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("nation_revoke_invite"), nation.getName()));
        }
    }
}

