/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.exceptions.InvalidMetadataTypeException;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataFieldType;
import com.palmergames.bukkit.towny.object.metadata.DecimalDataField;
import com.palmergames.bukkit.towny.object.metadata.IntegerDataField;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;

public abstract class CustomDataField<T> {
    private CustomDataFieldType type;
    private T value;
    private String key;

    public CustomDataField(String key, CustomDataFieldType type, T value) {
        this.type = type;
        this.setValue(value);
        this.key = key;
    }

    public CustomDataField(String key, CustomDataFieldType type) {
        this.type = type;
        this.value = null;
        this.key = key;
    }

    public CustomDataFieldType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        String out = "";
        out = out + this.type.getValue().toString();
        out = out + "," + this.getKey();
        out = out + "," + this.getValue();
        return out;
    }

    public static CustomDataField load(String str) {
        String[] tokens = str.split(",");
        CustomDataFieldType type = CustomDataFieldType.values()[Integer.parseInt(tokens[0])];
        String key = tokens[1];
        CustomDataField field = null;
        switch (type) {
            case IntegerField: {
                Integer intValue = Integer.parseInt(tokens[2]);
                field = new IntegerDataField(key, intValue);
                break;
            }
            case StringField: {
                field = new StringDataField(key, tokens[2]);
            }
            case BooleanField: {
                field = new BooleanDataField(key, Boolean.parseBoolean(tokens[2]));
                break;
            }
            case DecimalField: {
                field = new DecimalDataField(key, Double.parseDouble(tokens[2]));
            }
        }
        return field;
    }

    public void isValidType(String str) throws InvalidMetadataTypeException {
        switch (this.type) {
            case IntegerField: {
                try {
                    Integer.parseInt(str);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new InvalidMetadataTypeException(this.type);
                }
            }
            case BooleanField: {
                break;
            }
            case DecimalField: {
                try {
                    Double.parseDouble(str);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new InvalidMetadataTypeException(this.type);
                }
            }
        }
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof CustomDataField) {
            return ((CustomDataField)rhs).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public CustomDataField newCopy() {
        switch (this.type) {
            case BooleanField: {
                return new BooleanDataField(this.getKey(), (Boolean)this.getValue());
            }
            case IntegerField: {
                return new IntegerDataField(this.getKey(), (Integer)this.getValue());
            }
            case DecimalField: {
                return new DecimalDataField(this.getKey(), (Double)this.getValue());
            }
            case StringField: {
                return new StringDataField(this.getKey(), (String)this.getValue());
            }
        }
        return null;
    }
}

