/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.permissions.PermissionEventEnums;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.events.GMGroupEvent;
import org.anjocaido.groupmanager.events.GMSystemEvent;
import org.anjocaido.groupmanager.events.GMUserEvent;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

public class GroupManagerSource
extends TownyPermissionSource {
    public GroupManagerSource(Towny towny, Plugin test) {
        this.groupManager = (GroupManager)test;
        this.plugin = towny;
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new GMCustomEventListener(), (Plugin)this.plugin);
        }
        catch (IllegalPluginAccessException e) {
            System.out.print("Your Version of GroupManager is out of date. Please update.");
        }
    }

    @Override
    public String getPrefixSuffix(Resident resident, String node) {
        String group = "";
        String user = "";
        Player player = BukkitTools.getPlayer(resident.getName());
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        if (node == "prefix") {
            group = handler.getGroupPrefix(handler.getPrimaryGroup(player.getName()));
            user = handler.getUserPrefix(player.getName());
        } else if (node == "suffix") {
            group = handler.getGroupSuffix(handler.getPrimaryGroup(player.getName()));
            user = handler.getUserSuffix(player.getName());
        } else if (node == "userprefix") {
            group = "";
            user = handler.getUserSuffix(player.getName());
        } else if (node == "usersuffix") {
            group = "";
            user = handler.getUserSuffix(player.getName());
        } else if (node == "groupprefix") {
            group = handler.getGroupPrefix(handler.getPrimaryGroup(player.getName()));
            user = "";
        } else if (node == "groupsuffix") {
            group = handler.getGroupSuffix(handler.getPrimaryGroup(player.getName()));
            user = "";
        }
        if (group == null) {
            group = "";
        }
        if (user == null) {
            user = "";
        }
        if (!group.equals(user)) {
            user = group + user;
        }
        user = TownySettings.parseSingleLineString(user);
        return user;
    }

    @Override
    public int getGroupPermissionIntNode(String playerName, String node) {
        int iReturn = -1;
        Player player = BukkitTools.getPlayer(playerName);
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        iReturn = handler.getPermissionInteger(playerName, node);
        if (iReturn == -1) {
            iReturn = this.getEffectivePermIntNode(playerName, node);
        }
        return iReturn;
    }

    @Override
    public int getPlayerPermissionIntNode(String playerName, String node) {
        int iReturn = -1;
        Player player = BukkitTools.getPlayer(playerName);
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        iReturn = handler.getPermissionInteger(playerName, node);
        if (iReturn == -1) {
            iReturn = this.getEffectivePermIntNode(playerName, node);
        }
        return iReturn;
    }

    @Override
    public String getPlayerPermissionStringNode(String playerName, String node) {
        Player player = BukkitTools.getPlayer(playerName);
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getPermissionString(playerName, node);
    }

    @Override
    public String getPlayerGroup(Player player) {
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getGroup(player.getName());
    }

    protected class GMCustomEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGH)
        public void onGMUserEvent(GMUserEvent event) {
            block5: {
                Resident resident = null;
                Player player = null;
                try {
                    if (PermissionEventEnums.GMUser_Action.valueOf(event.getAction().name()) == null) break block5;
                    try {
                        resident = TownyUniverse.getInstance().getDataSource().getResident(event.getUserName());
                        player = BukkitTools.getPlayerExact(resident.getName());
                        if (player != null) {
                            String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                            GroupManagerSource.this.plugin.resetCache(player);
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMGroupEvent(GMGroupEvent event) {
            try {
                if (PermissionEventEnums.GMGroup_Action.valueOf(event.getAction().name()) != null) {
                    Group group = event.getGroup();
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null || !group.equals((Object)GroupManagerSource.this.getPlayerGroup(player))) continue;
                        String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                        GroupManagerSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMSystemEvent(GMSystemEvent event) {
            try {
                if (PermissionEventEnums.GMSystem_Action.valueOf(event.getAction().name()) != null) {
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null) continue;
                        String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                        GroupManagerSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

