/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.NewDayEvent;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.util.ChatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DailyTimerTask
extends TownyTimerTask {
    private double totalTownUpkeep = 0.0;
    private double totalNationUpkeep = 0.0;
    private List<String> removedTowns = new ArrayList<String>();
    private List<String> removedNations = new ArrayList<String>();

    public DailyTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        TownyUniverse townyUniverse;
        long start = System.currentTimeMillis();
        TownyMessaging.sendDebugMsg("New Day");
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_new_day_tax"), new Object[0]));
            try {
                TownyMessaging.sendDebugMsg("Collecting Town Taxes");
                this.collectTownTaxes();
                TownyMessaging.sendDebugMsg("Collecting Nation Taxes");
                this.collectNationTaxes();
                TownyMessaging.sendDebugMsg("Collecting Town Costs");
                this.collectTownCosts();
                TownyMessaging.sendDebugMsg("Collecting Nation Costs");
                this.collectNationCosts();
                Bukkit.getServer().getPluginManager().callEvent((Event)new NewDayEvent(this.removedTowns, this.removedNations, this.totalTownUpkeep, this.totalNationUpkeep, start));
            }
            catch (EconomyException ignored) {
                System.out.println("Economy Exception");
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        } else {
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_new_day"), new Object[0]));
        }
        if (TownySettings.isDeletingOldResidents()) {
            new ResidentPurge(this.plugin, null, TownySettings.getDeleteTime() * 1000L, TownySettings.isDeleteTownlessOnly()).start();
        }
        if (!(townyUniverse = TownyUniverse.getInstance()).getJailedResidentMap().isEmpty()) {
            for (final Resident resident : townyUniverse.getJailedResidentMap()) {
                if (resident.hasJailDays()) {
                    if (resident.getJailDays() == 1) {
                        resident.setJailDays(0);
                        new BukkitRunnable(){

                            public void run() {
                                Town jailTown = null;
                                try {
                                    jailTown = townyUniverse.getDataSource().getTown(resident.getJailTown());
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                                int index = resident.getJailSpawn();
                                resident.setJailed(resident, index, jailTown);
                            }
                        }.runTaskLater((Plugin)this.plugin, 20L);
                    } else {
                        resident.setJailDays(resident.getJailDays() - 1);
                    }
                }
                townyUniverse.getDataSource().saveResident(resident);
            }
        }
        TownyMessaging.sendDebugMsg("Cleaning up old backups.");
        townyUniverse.getDataSource().cleanupBackups();
        if (TownySettings.isBackingUpDaily()) {
            try {
                TownyMessaging.sendDebugMsg("Making backup.");
                townyUniverse.getDataSource().backup();
            }
            catch (IOException e) {
                TownyMessaging.sendErrorMsg("Could not create backup.");
                e.printStackTrace();
            }
        }
        TownyMessaging.sendDebugMsg("Finished New Day Code");
        TownyMessaging.sendDebugMsg("Universe Stats:");
        TownyMessaging.sendDebugMsg("    Residents: " + townyUniverse.getDataSource().getResidents().size());
        TownyMessaging.sendDebugMsg("    Towns: " + townyUniverse.getDataSource().getTowns().size());
        TownyMessaging.sendDebugMsg("    Nations: " + townyUniverse.getDataSource().getNations().size());
        for (TownyWorld world : townyUniverse.getDataSource().getWorlds()) {
            TownyMessaging.sendDebugMsg("    " + world.getName() + " (townblocks): " + world.getTownBlocks().size());
        }
        TownyMessaging.sendDebugMsg("Memory (Java Heap):");
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (max)", Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (total)", Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (free)", Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (used=total-free)", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        TownyMessaging.sendDebugMsg("newDay took " + (System.currentTimeMillis() - start) + "ms");
    }

    public void collectNationTaxes() throws EconomyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Nation> nations = new ArrayList<Nation>(townyUniverse.getDataSource().getNations());
        ListIterator nationItr = nations.listIterator();
        while (nationItr.hasNext()) {
            Nation nation = (Nation)nationItr.next();
            if (!townyUniverse.getDataSource().hasNation(nation.getName())) continue;
            this.collectNationTaxes(nation);
        }
    }

    protected void collectNationTaxes(Nation nation) throws EconomyException {
        if (nation.getTaxes() > 0.0) {
            ArrayList<Town> towns = new ArrayList<Town>(nation.getTowns());
            ListIterator townItr = towns.listIterator();
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            while (townItr.hasNext()) {
                Town town = (Town)townItr.next();
                if (townyUniverse.getDataSource().hasTown(town.getName())) {
                    if (town.isCapital() || !town.hasUpkeep() || town.payTo(nation.getTaxes(), nation, "Nation Tax")) continue;
                    try {
                        this.removedTowns.add(town.getName());
                        nation.removeTown(town);
                    }
                    catch (EmptyNationException emptyNationException) {
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                    townyUniverse.getDataSource().saveTown(town);
                    townyUniverse.getDataSource().saveNation(nation);
                    continue;
                }
                TownyMessaging.sendTownMessage(town, TownySettings.getPayedTownTaxMsg() + nation.getTaxes());
            }
            if (this.removedTowns != null) {
                if (this.removedTowns.size() == 1) {
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_couldnt_pay_tax"), ChatTools.list(this.removedTowns), "nation"));
                } else {
                    TownyMessaging.sendNationMessage(nation, ChatTools.list(this.removedTowns, TownySettings.getLangString("msg_couldnt_pay_nation_tax_multiple")));
                }
            }
        }
    }

    public void collectTownTaxes() throws EconomyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Town> towns = new ArrayList<Town>(townyUniverse.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!townyUniverse.getDataSource().hasTown(town.getName())) continue;
            this.collectTownTaxes(town);
        }
    }

    protected void collectTownTaxes(Town town) throws EconomyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (town.getTaxes() > 0.0) {
            ArrayList<Resident> residents = new ArrayList<Resident>(town.getResidents());
            ListIterator residentItr = residents.listIterator();
            ArrayList<String> removedResidents = new ArrayList<String>();
            while (residentItr.hasNext()) {
                Resident resident = (Resident)residentItr.next();
                if (!townyUniverse.getDataSource().hasResident(resident.getName())) continue;
                if (TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt") || resident.isNPC()) {
                    try {
                        TownyMessaging.sendResidentMessage(resident, TownySettings.getTaxExemptMsg());
                    }
                    catch (TownyException townyException) {}
                    continue;
                }
                if (town.isTaxPercentage()) {
                    double cost = resident.getHoldingBalance() * town.getTaxes() / 100.0;
                    resident.payTo(cost, town, "Town Tax (Percentage)");
                    continue;
                }
                if (resident.payTo(town.getTaxes(), town, "Town Tax")) continue;
                removedResidents.add(resident.getName());
                try {
                    resident.clear();
                    townyUniverse.getDataSource().saveTown(town);
                }
                catch (EmptyTownException e) {
                    townyUniverse.getDataSource().removeTown(town);
                }
                townyUniverse.getDataSource().saveResident(resident);
            }
            if (removedResidents != null) {
                if (removedResidents.size() == 1) {
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_couldnt_pay_tax"), ChatTools.list(removedResidents), "town"));
                } else {
                    TownyMessaging.sendTownMessage(town, ChatTools.list(removedResidents, TownySettings.getLangString("msg_couldnt_pay_town_tax_multiple")));
                }
            }
        }
        if (town.getPlotTax() > 0.0 || town.getCommercialPlotTax() > 0.0 || town.getEmbassyPlotTax() > 0.0) {
            ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>(town.getTownBlocks());
            ArrayList<String> lostPlots = new ArrayList<String>();
            ListIterator townBlockItr = townBlocks.listIterator();
            while (townBlockItr.hasNext()) {
                TownBlock townBlock = (TownBlock)townBlockItr.next();
                if (!townBlock.hasResident()) continue;
                try {
                    Resident resident = townBlock.getResident();
                    if (!townyUniverse.getDataSource().hasResident(resident.getName()) || resident.hasTown() && resident.getTown() == townBlock.getTown() && (TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt") || resident.isNPC()) || resident.payTo(townBlock.getType().getTax(town), town, String.format("Plot Tax (%s)", new Object[]{townBlock.getType()}))) continue;
                    if (!lostPlots.contains(resident.getName())) {
                        lostPlots.add(resident.getName());
                    }
                    townBlock.setResident(null);
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setType(townBlock.getType());
                    townyUniverse.getDataSource().saveResident(resident);
                    townyUniverse.getDataSource().saveTownBlock(townBlock);
                }
                catch (NotRegisteredException notRegisteredException) {}
            }
            if (lostPlots != null) {
                if (lostPlots.size() == 1) {
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_couldnt_pay_plot_taxes"), ChatTools.list(lostPlots)));
                } else {
                    TownyMessaging.sendTownMessage(town, ChatTools.list(lostPlots, TownySettings.getLangString("msg_couldnt_pay_plot_taxes_multiple")));
                }
            }
        }
    }

    public void collectTownCosts() throws EconomyException, TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Town> towns = new ArrayList<Town>(townyUniverse.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!townyUniverse.getDataSource().hasTown(town.getName()) || !town.hasUpkeep()) continue;
            double upkeep = TownySettings.getTownUpkeepCost(town);
            double upkeepPenalty = TownySettings.getTownPenaltyUpkeepCost(town);
            if (upkeepPenalty > 0.0 && upkeep > 0.0) {
                upkeep += upkeepPenalty;
            }
            this.totalTownUpkeep += upkeep;
            if (upkeep > 0.0) {
                if (town.pay(upkeep, "Town Upkeep")) continue;
                townyUniverse.getDataSource().removeTown(town);
                this.removedTowns.add(town.getName());
                continue;
            }
            if (!(upkeep < 0.0)) continue;
            if (TownySettings.isUpkeepPayingPlots()) {
                ArrayList<TownBlock> plots = new ArrayList<TownBlock>(town.getTownBlocks());
                for (TownBlock townBlock : plots) {
                    if (townBlock.hasResident()) {
                        townBlock.getResident().pay(upkeep / (double)plots.size(), "Negative Town Upkeep - Plot income");
                        continue;
                    }
                    town.pay(upkeep / (double)plots.size(), "Negative Town Upkeep - Plot income");
                }
                continue;
            }
            town.pay(upkeep, "Negative Town Upkeep");
        }
        if (this.removedTowns != null) {
            if (this.removedTowns.size() == 1) {
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_bankrupt_town2"), ChatTools.list(this.removedTowns)));
            } else {
                TownyMessaging.sendGlobalMessage(ChatTools.list(this.removedTowns, TownySettings.getLangString("msg_bankrupt_town_multiple")));
            }
        }
    }

    public void collectNationCosts() throws EconomyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Nation> nations = new ArrayList<Nation>(townyUniverse.getDataSource().getNations());
        ListIterator nationItr = nations.listIterator();
        while (nationItr.hasNext()) {
            Nation nation = (Nation)nationItr.next();
            if (!townyUniverse.getDataSource().hasNation(nation.getName())) continue;
            double upkeep = TownySettings.getNationUpkeepCost(nation);
            this.totalNationUpkeep += upkeep;
            if (upkeep > 0.0) {
                if (!nation.pay(TownySettings.getNationUpkeepCost(nation), "Nation Upkeep")) {
                    townyUniverse.getDataSource().removeNation(nation);
                    this.removedNations.add(nation.getName());
                }
                if (!nation.isNeutral() || nation.pay(TownySettings.getNationNeutralityCost(), "Nation Peace Upkeep")) continue;
                try {
                    nation.setNeutral(false);
                }
                catch (TownyException e) {
                    e.printStackTrace();
                }
                townyUniverse.getDataSource().saveNation(nation);
                TownyMessaging.sendNationMessage(nation, TownySettings.getLangString("msg_nation_not_peaceful"));
                continue;
            }
            if (!(upkeep < 0.0)) continue;
            nation.pay(upkeep, "Negative Nation Upkeep");
        }
        if (this.removedNations != null) {
            if (this.removedNations.size() == 1) {
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_bankrupt_nation2"), ChatTools.list(this.removedNations)));
            } else {
                TownyMessaging.sendGlobalMessage(ChatTools.list(this.removedNations, TownySettings.getLangString("msg_bankrupt_nation_multiple")));
            }
        }
    }
}

