/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.MobRemovalEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Rabbit;
import org.bukkit.event.Event;

public class MobRemovalTimerTask
extends TownyTimerTask {
    private Server server;
    public static List<Class<?>> classesOfWorldMobsToRemove = new ArrayList();
    public static List<Class<?>> classesOfTownMobsToRemove = new ArrayList();
    private boolean isRemovingKillerBunny;

    public MobRemovalTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
        classesOfWorldMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWorldMobRemovalEntities(), "WorldMob: ");
        classesOfTownMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getTownMobRemovalEntities(), "TownMob: ");
        this.isRemovingKillerBunny = TownySettings.isRemovingKillerBunny();
    }

    public static boolean isRemovingWorldEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfWorldMobsToRemove, livingEntity);
    }

    public static boolean isRemovingTownEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfTownMobsToRemove, livingEntity);
    }

    @Override
    public void run() {
        ArrayList<LivingEntity> livingEntitiesToRemove = new ArrayList<LivingEntity>();
        for (World world : this.server.getWorlds()) {
            TownyWorld townyWorld;
            try {
                townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(world.getName());
            }
            catch (NotRegisteredException | NullPointerException e) {
                continue;
            }
            if (!townyWorld.isUsingTowny() || townyWorld.isForceTownMobs() && townyWorld.hasWorldMobs()) continue;
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                block9: {
                    Coord coord;
                    Location livingEntityLoc = livingEntity.getLocation();
                    if (!world.isChunkLoaded(livingEntityLoc.getBlockX() >> 4, livingEntityLoc.getBlockZ() >> 4) || !townyWorld.hasTownBlock(coord = Coord.parseCoord(livingEntityLoc))) continue;
                    try {
                        Town town;
                        TownBlock townBlock = townyWorld.getTownBlock(coord);
                        if (townyWorld.isForceTownMobs() || townBlock.getPermissions().mobs || (town = townBlock.getTown()).hasMobs()) continue;
                        if (livingEntity.getType().equals((Object)EntityType.RABBIT) && this.isRemovingKillerBunny && ((Rabbit)livingEntity).getRabbitType().equals((Object)Rabbit.Type.THE_KILLER_BUNNY)) {
                            livingEntitiesToRemove.add(livingEntity);
                            continue;
                        }
                        if (!MobRemovalTimerTask.isRemovingTownEntity(livingEntity)) {
                        }
                        break block9;
                    }
                    catch (NotRegisteredException x) {
                        if (townyWorld.hasWorldMobs()) continue;
                        if (MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) break block9;
                    }
                    continue;
                }
                if (this.plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity) || TownySettings.isSkippingRemovalOfNamedMobs() && livingEntity.getCustomName() != null) continue;
                livingEntitiesToRemove.add(livingEntity);
            }
        }
        for (LivingEntity livingEntity : livingEntitiesToRemove) {
            MobRemovalEvent mobRemovalEvent = new MobRemovalEvent((Entity)livingEntity);
            this.plugin.getServer().getPluginManager().callEvent((Event)mobRemovalEvent);
            if (mobRemovalEvent.isCancelled()) continue;
            TownyMessaging.sendDebugMsg("MobRemoval Removed: " + livingEntity.toString());
            livingEntity.remove();
        }
    }
}

