/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public class PlotClaim
extends Thread {
    Towny plugin;
    private volatile Player player;
    private volatile Resident resident;
    private volatile TownyWorld world;
    private List<WorldCoord> selection;
    private boolean claim;
    private boolean admin;

    public PlotClaim(Towny plugin, Player player, Resident resident, List<WorldCoord> selection, boolean claim, boolean admin) {
        this.plugin = plugin;
        this.player = player;
        this.resident = resident;
        this.selection = selection;
        this.claim = claim;
        this.admin = admin;
        this.setPriority(1);
    }

    @Override
    public void run() {
        int claimed = 0;
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_process_claim"));
            } else {
                TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_process_unclaim"));
            }
        }
        if (this.selection != null) {
            for (WorldCoord worldCoord : this.selection) {
                try {
                    this.world = worldCoord.getTownyWorld();
                }
                catch (NotRegisteredException e) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_err_not_configured"));
                    continue;
                }
                try {
                    if (this.claim) {
                        if (!this.admin) {
                            if (!this.residentClaim(worldCoord)) continue;
                            ++claimed;
                            continue;
                        }
                        this.adminClaim(worldCoord);
                        ++claimed;
                        continue;
                    }
                    this.residentUnclaim(worldCoord);
                }
                catch (EconomyException e) {
                    TownyMessaging.sendErrorMsg((Object)this.player, e.getError());
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage());
                }
            }
        } else if (!this.claim) {
            this.residentUnclaimAll();
        }
        if (this.player != null) {
            if (this.claim) {
                if (this.selection != null && this.selection.size() > 0 && claimed > 0) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_claimed") + (this.selection.size() > 5 ? TownySettings.getLangString("msg_total_townblocks") + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                } else {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_not_claimed_1"));
                }
            } else if (this.selection != null) {
                TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_unclaimed") + (this.selection.size() > 5 ? TownySettings.getLangString("msg_total_townblocks") + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
            } else {
                TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_unclaimed"));
            }
        }
        TownyUniverse.getInstance().getDataSource().saveResident(this.resident);
        this.plugin.resetCache();
    }

    private boolean residentClaim(WorldCoord worldCoord) throws TownyException, EconomyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            Town town = townBlock.getTown();
            if (this.resident.hasTown() && this.resident.getTown() != town && !townBlock.getType().equals((Object)TownBlockType.EMBASSY) || !this.resident.hasTown() && !townBlock.getType().equals((Object)TownBlockType.EMBASSY)) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            try {
                Resident owner = townBlock.getResident();
                if (townBlock.getPlotPrice() != -1.0) {
                    if (TownySettings.isUsingEconomy() && !this.resident.payTo(townBlock.getPlotPrice(), owner, "Plot - Buy From Seller")) {
                        throw new TownyException(TownySettings.getLangString("msg_no_money_purchase_plot"));
                    }
                    int maxPlots = TownySettings.getMaxResidentPlots(this.resident);
                    int extraPlots = TownySettings.getMaxResidentExtraPlots(this.resident);
                    if (maxPlots != -1) {
                        maxPlots += extraPlots;
                    }
                    if (maxPlots >= 0 && this.resident.getTownBlocks().size() + 1 > maxPlots) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_max_plot_own"), maxPlots));
                    }
                    TownyMessaging.sendTownMessage(town, TownySettings.getBuyResidentPlotMsg(this.resident.getName(), owner.getName(), townBlock.getPlotPrice()));
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setResident(this.resident);
                    townBlock.setType(townBlock.getType());
                    townyUniverse.getDataSource().saveResident(owner);
                    townyUniverse.getDataSource().saveTownBlock(townBlock);
                    this.plugin.updateCache(worldCoord);
                    return true;
                }
                if (this.player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
                    if (TownySettings.isUsingEconomy() && !town.payTo(0.0, owner, "Plot - Buy Back")) {
                        throw new TownyException(TownySettings.getLangString("msg_town_no_money_purchase_plot"));
                    }
                    TownyMessaging.sendTownMessage(town, TownySettings.getBuyResidentPlotMsg(town.getName(), owner.getName(), 0.0));
                    townBlock.setResident(null);
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setType(townBlock.getType());
                    townyUniverse.getDataSource().saveResident(owner);
                    townyUniverse.getDataSource().saveTownBlock(townBlock);
                    return true;
                }
                throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_already_claimed"), owner.getName()));
            }
            catch (NotRegisteredException e) {
                if (townBlock.getPlotPrice() == -1.0) {
                    throw new TownyException(TownySettings.getLangString("msg_err_plot_nfs"));
                }
                double bankcap = TownySettings.getTownBankCap();
                if (bankcap > 0.0 && townBlock.getPlotPrice() + town.getHoldingBalance() > bankcap) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
                }
                if (TownySettings.isUsingEconomy() && !this.resident.payTo(townBlock.getPlotPrice(), town, "Plot - Buy From Town")) {
                    throw new TownyException(TownySettings.getLangString("msg_no_money_purchase_plot"));
                }
                townBlock.setPlotPrice(-1.0);
                townBlock.setResident(this.resident);
                townBlock.setType(townBlock.getType());
                townyUniverse.getDataSource().saveTownBlock(townBlock);
                return true;
            }
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
        }
    }

    private boolean residentUnclaim(WorldCoord worldCoord) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            townBlock.setResident(null);
            townBlock.setPlotPrice(townBlock.getTown().getPlotTypePrice(townBlock.getType()));
            townBlock.setType(townBlock.getType());
            TownyUniverse.getInstance().getDataSource().saveTownBlock(townBlock);
            this.plugin.updateCache(worldCoord);
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_not_own_place"));
        }
        return true;
    }

    private void residentUnclaimAll() {
        ArrayList<TownBlock> selection = new ArrayList<TownBlock>(this.resident.getTownBlocks());
        for (TownBlock townBlock : selection) {
            try {
                this.residentUnclaim(townBlock.getWorldCoord());
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage());
            }
        }
    }

    private void adminClaim(WorldCoord worldCoord) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            Town town = townBlock.getTown();
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            townBlock.setPlotPrice(-1.0);
            townBlock.setResident(this.resident);
            townBlock.setType(townBlock.getType());
            townyUniverse.getDataSource().saveTownBlock(townBlock);
            TownyMessaging.sendMessage((Object)BukkitTools.getPlayer(this.resident.getName()), String.format(TownySettings.getLangString("msg_admin_has_given_you_a_plot"), worldCoord.toString()));
        }
        catch (NotRegisteredException e) {
            throw new TownyException(TownySettings.getLangString("msg_not_claimed_1"));
        }
    }
}

