/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class EntityTypeUtil {
    public static boolean isInstanceOfAny(List<Class<?>> classesOfWorldMobsToRemove2, Object obj) {
        for (Class<?> c : classesOfWorldMobsToRemove2) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static List<Class<?>> parseLivingEntityClassNames(List<String> mobClassNames, String errorPrefix) {
        ArrayList livingEntityClasses = new ArrayList();
        for (String mobClassName : mobClassNames) {
            if (mobClassName.isEmpty()) continue;
            try {
                Class<?> c = Class.forName("org.bukkit.entity." + mobClassName);
                if (JavaUtil.isSubInterface(LivingEntity.class, c)) {
                    livingEntityClasses.add(c);
                    continue;
                }
                throw new Exception();
            }
            catch (ClassNotFoundException e) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable class.", errorPrefix, mobClassName));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable living entity.", errorPrefix, mobClassName));
            }
        }
        return livingEntityClasses;
    }
}

