/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ShopPlotUtil {
    public static boolean doesPlayerOwnShopPlot(Player player, Location location) {
        boolean owner = false;
        try {
            owner = TownyAPI.getInstance().getTownBlock(location).getResident().equals(TownyAPI.getInstance().getDataSource().getResident(player.getName()));
        }
        catch (NotRegisteredException e) {
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
        return owner && ShopPlotUtil.isShopPlot(location);
    }

    public static boolean doesPlayerHaveAbilityToEditShopPlot(Player player, Location location) {
        boolean build = PlayerCacheUtil.getCachePermission(player, location, Material.DIRT, TownyPermission.ActionType.BUILD);
        return build && ShopPlotUtil.isShopPlot(location);
    }

    public static boolean isShopPlot(Location location) {
        if (!TownyAPI.getInstance().isWilderness(location)) {
            TownBlock townblock = TownyAPI.getInstance().getTownBlock(location);
            return ShopPlotUtil.isShopPlot(townblock);
        }
        return false;
    }

    public static boolean isShopPlot(TownBlock townblock) {
        if (townblock != null) {
            return townblock.getType().equals((Object)TownBlockType.COMMERCIAL);
        }
        return false;
    }
}

