/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.war.flagwar.CellUnderAttack;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import org.bukkit.Location;

public class Cell {
    private String worldName;
    private int x;
    private int z;

    public Cell(String worldName, int x, int z) {
        this.worldName = worldName;
        this.x = x;
        this.z = z;
    }

    public Cell(Cell cell) {
        this.worldName = cell.getWorldName();
        this.x = cell.getX();
        this.z = cell.getZ();
    }

    public Cell(Location location) {
        this(Cell.parse(location));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public static Cell parse(String worldName, int x, int z) {
        int cellSize = Coord.getCellSize();
        int xresult = x / cellSize;
        int zresult = z / cellSize;
        boolean xneedfix = x % cellSize != 0;
        boolean zneedfix = z % cellSize != 0;
        return new Cell(worldName, xresult - (x < 0 && xneedfix ? 1 : 0), zresult - (z < 0 && zneedfix ? 1 : 0));
    }

    public static Cell parse(Location loc) {
        return Cell.parse(loc.getWorld().getName(), loc.getBlockX(), loc.getBlockZ());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 27 + (this.worldName == null ? 0 : this.worldName.hashCode());
        hash = hash * 27 + this.x;
        hash = hash * 27 + this.z;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell that = (Cell)obj;
        return this.x == that.x && this.z == that.z && (this.worldName == null ? that.worldName == null : this.worldName.equals(that.worldName));
    }

    public boolean isUnderAttack() {
        return TownyWar.isUnderAttack(this);
    }

    public CellUnderAttack getAttackData() {
        return TownyWar.getAttackData(this);
    }
}

