/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.war.flagwar.CellUnderAttack;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackCanceledEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellDefendedEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellWonEvent;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class TownyWarCustomListener
implements Listener {
    private final Towny plugin;

    public TownyWarCustomListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellAttackEvent(CellAttackEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            CellUnderAttack cell = event.getData();
            TownyWar.registerAttack(cell);
        }
        catch (Exception e) {
            event.setCancelled(true);
            event.setReason(e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellDefendedEvent(CellDefendedEvent event) {
        block21: {
            String playerName;
            if (event.isCancelled()) {
                return;
            }
            Player player = event.getPlayer();
            CellUnderAttack cell = event.getCell().getAttackData();
            try {
                TownyWar.townFlagged(TownyWar.cellToWorldCoord(cell).getTownBlock().getTown());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            TownyUniverse universe = TownyUniverse.getInstance();
            WorldCoord worldCoord = new WorldCoord(cell.getWorldName(), cell.getX(), cell.getZ());
            universe.removeWarZone(worldCoord);
            this.plugin.updateCache(worldCoord);
            if (player == null) {
                playerName = "Greater Forces";
            } else {
                playerName = player.getName();
                try {
                    playerName = universe.getDataSource().getResident(player.getName()).getFormattedName();
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
            }
            this.plugin.getServer().broadcastMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_defended"), playerName, cell.getCellString()));
            if (TownySettings.isUsingEconomy()) {
                try {
                    Resident defendingPlayer = null;
                    Resident attackingPlayer = universe.getDataSource().getResident(cell.getNameOfFlagOwner());
                    if (player != null) {
                        try {
                            defendingPlayer = universe.getDataSource().getResident(player.getName());
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                    }
                    String formattedMoney = TownyEconomyHandler.getFormattedBalance(TownyWarConfig.getDefendedAttackReward());
                    if (defendingPlayer == null) {
                        if (attackingPlayer.pay(TownyWarConfig.getDefendedAttackReward(), "War - Attack Was Defended (Greater Forces)")) {
                            try {
                                TownyMessaging.sendResidentMessage(attackingPlayer, String.format(TownySettings.getLangString("msg_enemy_war_area_defended_greater_forces"), formattedMoney));
                            }
                            catch (TownyException townyException) {}
                        }
                        break block21;
                    }
                    if (!attackingPlayer.payTo(TownyWarConfig.getDefendedAttackReward(), defendingPlayer, "War - Attack Was Defended")) break block21;
                    try {
                        TownyMessaging.sendResidentMessage(attackingPlayer, String.format(TownySettings.getLangString("msg_enemy_war_area_defended_attacker"), defendingPlayer.getFormattedName(), formattedMoney));
                    }
                    catch (TownyException townyException) {
                        // empty catch block
                    }
                    try {
                        TownyMessaging.sendResidentMessage(defendingPlayer, String.format(TownySettings.getLangString("msg_enemy_war_area_defended_defender"), attackingPlayer.getFormattedName(), formattedMoney));
                    }
                    catch (TownyException townyException) {}
                }
                catch (EconomyException | NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellWonEvent(CellWonEvent event) {
        block18: {
            if (event.isCancelled()) {
                return;
            }
            CellUnderAttack cell = event.getCellAttackData();
            TownyUniverse universe = TownyUniverse.getInstance();
            try {
                Resident attackingResident = universe.getDataSource().getResident(cell.getNameOfFlagOwner());
                Town attackingTown = attackingResident.getTown();
                Nation attackingNation = attackingTown.getNation();
                WorldCoord worldCoord = TownyWar.cellToWorldCoord(cell);
                universe.removeWarZone(worldCoord);
                TownBlock townBlock = worldCoord.getTownBlock();
                Town defendingTown = townBlock.getTown();
                TownyWar.townFlagged(defendingTown);
                double amount = 0.0;
                String moneyTranserMsg = null;
                if (TownySettings.isUsingEconomy()) {
                    try {
                        String reasonType;
                        if (townBlock.isHomeBlock()) {
                            amount = TownyWarConfig.getWonHomeblockReward();
                            reasonType = "Homeblock";
                        } else {
                            amount = TownyWarConfig.getWonTownblockReward();
                            reasonType = "Townblock";
                        }
                        if (amount > 0.0) {
                            String reason = String.format("War - Won Enemy %s (Pillage)", reasonType);
                            amount = Math.min(amount, defendingTown.getHoldingBalance());
                            defendingTown.payTo(amount, attackingResident, reason);
                            moneyTranserMsg = String.format(TownySettings.getLangString("msg_enemy_war_area_won_pillage"), attackingResident.getFormattedName(), TownyEconomyHandler.getFormattedBalance(amount), defendingTown.getFormattedName());
                        } else if (amount < 0.0) {
                            String reason = String.format("War - Won Enemy %s (Rebuild Cost)", reasonType);
                            if (!attackingResident.payTo(amount = -amount, defendingTown, reason)) {
                                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_won"), attackingResident.getFormattedName(), attackingNation.hasTag() ? attackingNation.getTag() : attackingNation.getFormattedName(), cell.getCellString()));
                            }
                            moneyTranserMsg = String.format(TownySettings.getLangString("msg_enemy_war_area_won_rebuilding"), attackingResident.getFormattedName(), TownyEconomyHandler.getFormattedBalance(amount), defendingTown.getFormattedName());
                        }
                    }
                    catch (EconomyException x) {
                        x.printStackTrace();
                    }
                }
                if (TownyWarConfig.isFlaggedTownblockTransfered()) {
                    universe.getDataSource().removeTownBlock(townBlock);
                    try {
                        ArrayList<WorldCoord> selection = new ArrayList<WorldCoord>();
                        selection.add(worldCoord);
                        TownCommand.checkIfSelectionIsValid(attackingTown, selection, false, 0.0, false);
                        new TownClaim(this.plugin, null, attackingTown, selection, false, true, false).start();
                    }
                    catch (TownyException townyException) {}
                } else {
                    TownyMessaging.sendTownMessage(attackingTown, String.format(TownySettings.getLangString("msg_war_defender_keeps_claims"), new Object[0]));
                    TownyMessaging.sendTownMessage(defendingTown, String.format(TownySettings.getLangString("msg_war_defender_keeps_claims"), new Object[0]));
                }
                this.plugin.updateCache(worldCoord);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_won"), attackingResident.getFormattedName(), attackingNation.hasTag() ? attackingNation.getTag() : attackingNation.getFormattedName(), cell.getCellString()));
                if (!TownySettings.isUsingEconomy() || amount == 0.0 || moneyTranserMsg == null) break block18;
                try {
                    TownyMessaging.sendResidentMessage(attackingResident, moneyTranserMsg);
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
                TownyMessaging.sendTownMessage(defendingTown, moneyTranserMsg);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellAttackCanceledEvent(CellAttackCanceledEvent event) {
        if (event.isCancelled()) {
            return;
        }
        CellUnderAttack cell = event.getCell();
        try {
            TownyWar.townFlagged(TownyWar.cellToWorldCoord(cell).getTownBlock().getTown());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        TownyUniverse universe = TownyUniverse.getInstance();
        WorldCoord worldCoord = new WorldCoord(cell.getWorldName(), cell.getX(), cell.getZ());
        universe.removeWarZone(worldCoord);
        this.plugin.updateCache(worldCoord);
        System.out.println(cell.getCellString());
    }
}

