/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.google.common.base.Charsets;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import de.themoep.idconverter.IdMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitTools {
    private static Towny plugin = null;
    private static Server server = null;

    public static void initialize(Towny plugin) {
        BukkitTools.plugin = plugin;
        server = plugin.getServer();
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String name) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : Bukkit.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)iterPlayer)) continue;
            if (name.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(name.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public static Player getPlayerExact(String name) {
        return BukkitTools.getServer().getPlayerExact(name);
    }

    public static Player getPlayer(String playerId) {
        return BukkitTools.getServer().getPlayer(playerId);
    }

    public static boolean isOnline(String playerId) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (!player.getName().equals(playerId)) continue;
            return true;
        }
        return false;
    }

    public static List<World> getWorlds() {
        return BukkitTools.getServer().getWorlds();
    }

    public static World getWorld(String name) {
        return BukkitTools.getServer().getWorld(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getServer() {
        Server server = BukkitTools.server;
        synchronized (server) {
            return BukkitTools.server;
        }
    }

    public static PluginManager getPluginManager() {
        return BukkitTools.getServer().getPluginManager();
    }

    public static BukkitScheduler getScheduler() {
        return BukkitTools.getServer().getScheduler();
    }

    public static int scheduleSyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, task, delay);
    }

    public static int scheduleAsyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, task, delay).getTaskId();
    }

    public static int scheduleSyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, task, delay, repeat);
    }

    public static int scheduleAsyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, task, delay, repeat).getTaskId();
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            m.put(world.getName(), 0);
        }
        for (Player player : BukkitTools.getServer().getOnlinePlayers()) {
            m.put(player.getWorld().getName(), m.get(player.getWorld().getName()) + 1);
        }
        return m;
    }

    @Deprecated
    public static Material getMaterial(int id) {
        return Material.getMaterial((String)IdMappings.getById(String.valueOf(id)).getFlatteningType());
    }

    public static int calcChunk(int value) {
        return value * TownySettings.getTownBlockSize() / 16;
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        return Bukkit.getOfflinePlayer((UUID)BukkitTools.getPlayerExact(name).getUniqueId());
    }

    public static OfflinePlayer getOfflinePlayerForVault(String name) {
        return Bukkit.getOfflinePlayer((UUID)UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)));
    }

    public static String convertCoordtoXYZ(Location loc) {
        String string = loc.getWorld().getName() + " " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
        return string;
    }

    public static boolean isSpigot() {
        try {
            Class.forName("org.bukkit.entity.Player$Spigot");
            return true;
        }
        catch (Throwable tr) {
            return false;
        }
    }
}

