/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChatTools {
    private static final int lineLength = 54;

    public static List<String> listArr(String[] args, String prefix) {
        return ChatTools.list(Arrays.asList(args), prefix);
    }

    public static List<String> list(List<String> args) {
        return ChatTools.list(args, "");
    }

    public static List<String> list(List<String> args, String prefix) {
        if (args.size() > 0) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < args.size() - 1; ++i) {
                line.append(args.get(i)).append(", ");
            }
            line.append(args.get(args.size() - 1));
            return ChatTools.color(prefix + line);
        }
        return new ArrayList<String>();
    }

    private static List<String> wordWrap(String[] tokens) {
        ArrayList<String> out = new ArrayList<String>();
        out.add("");
        for (String s : tokens) {
            if (ChatTools.stripColour((String)out.get(out.size() - 1)).length() + ChatTools.stripColour(s).length() + 1 > 54) {
                out.add("");
            }
            out.set(out.size() - 1, (String)out.get(out.size() - 1) + s + " ");
        }
        return out;
    }

    public static List<String> color(String line) {
        List<String> out = ChatTools.wordWrap(line.split(" "));
        String c = "f";
        for (int i = 0; i < out.size(); ++i) {
            if (!out.get(i).startsWith("\u00a7") && !c.equalsIgnoreCase("f")) {
                out.set(i, "\u00a7" + c + out.get(i));
            }
            for (int index = 0; index < 54; ++index) {
                try {
                    if (!out.get(i).substring(index, index + 1).equalsIgnoreCase("\u00a7")) continue;
                    c = out.get(i).substring(index + 1, index + 2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return out;
    }

    public static String stripColour(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.equals("\u00a7")) {
                ++i;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String formatTitle(String title) {
        String line = ".oOo.__________________________________________________.oOo.";
        int pivot = line.length() / 2;
        String center = ".[ \u00a7e" + title + "\u00a76" + " ].";
        String out = "\u00a76" + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    public static String formatCommand(String requirement, String command, String subCommand, String help) {
        String out = "  ";
        if (requirement.length() > 0) {
            out = out + "\u00a7c" + requirement + ": ";
        }
        out = out + "\u00a73" + command;
        if (subCommand.length() > 0) {
            out = out + " \u00a7b" + subCommand;
        }
        if (help.length() > 0) {
            out = out + " \u00a77 : " + help;
        }
        return out;
    }

    public static String[] formatList(String title, String subject, List<String> list, String page) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(0, ChatTools.formatTitle(title));
        output.add(1, subject);
        output.addAll(list);
        output.add(page);
        return output.toArray(new String[0]);
    }
}

