/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileMgmt {
    public static boolean checkOrCreateFolder(String folderPath) {
        File file = new File(folderPath);
        return file.exists() || file.mkdirs() || file.isDirectory();
    }

    public static boolean checkOrCreateFolders(String ... folders) {
        for (String folder : folders) {
            if (FileMgmt.checkOrCreateFolder(folder)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOrCreateFile(String filePath) {
        File file = new File(filePath);
        if (!FileMgmt.checkOrCreateFolder(file.getParentFile().getPath())) {
            return false;
        }
        try {
            return file.exists() || file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean checkOrCreateFiles(String ... files) {
        for (String file : files) {
            if (FileMgmt.checkOrCreateFile(file)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        File file = sourceLocation;
        synchronized (file) {
            if (sourceLocation.isDirectory()) {
                String[] children;
                if (!targetLocation.exists()) {
                    targetLocation.mkdir();
                }
                for (String aChildren : children = sourceLocation.list()) {
                    FileMgmt.copyDirectory(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
                }
            } else {
                FileOutputStream out = new FileOutputStream(targetLocation);
                try {
                    int len;
                    FileInputStream in = new FileInputStream(sourceLocation);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    System.out.println("Error: Could not access: " + sourceLocation);
                }
                ((OutputStream)out).close();
            }
        }
    }

    public static File unpackResourceFile(String filePath, String resource, String defaultRes) {
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        FileMgmt.checkOrCreateFile(filePath);
        try {
            String resString = FileMgmt.convertStreamToString("/" + resource);
            FileMgmt.stringToFile(resString, filePath);
        }
        catch (IOException e) {
            try {
                String resString = FileMgmt.convertStreamToString("/" + defaultRes);
                FileMgmt.stringToFile(resString, filePath);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(String name) throws IOException {
        if (name != null) {
            StringWriter writer = new StringWriter();
            InputStream is = FileMgmt.class.getResourceAsStream(name);
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                System.out.println("Exception ");
            }
            finally {
                try {
                    is.close();
                }
                catch (NullPointerException e) {
                    throw new IOException();
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static String convertFileToString(File file) {
        if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try (FileInputStream is = new FileInputStream(file);){
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
                ((Reader)reader).close();
            }
            catch (IOException e) {
                System.out.println("Exception ");
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static void stringToFile(String source, String FileName) {
        if (source != null) {
            FileMgmt.stringToFile(source, new File(FileName));
        }
    }

    public static void stringToFile(String source, File file) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            out.write(source);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Exception ");
        }
    }

    public static boolean listToFile(List<String> source, String targetLocation) {
        try {
            File file = new File(targetLocation);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            for (String aSource : source) {
                out.write(aSource + System.getProperty("line.separator"));
            }
            out.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Exception ");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(File sourceFile, String targetLocation) {
        File file = sourceFile;
        synchronized (file) {
            if (sourceFile.isFile()) {
                File f = new File(sourceFile.getParent() + File.separator + targetLocation + File.separator + sourceFile.getName());
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
                sourceFile.renameTo(new File(sourceFile.getParent() + File.separator + targetLocation, sourceFile.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectories(File destination, File ... sourceFolders) throws IOException {
        File[] fileArray = sourceFolders;
        synchronized (sourceFolders) {
            ZipOutputStream output = new ZipOutputStream((OutputStream)new FileOutputStream(destination), StandardCharsets.UTF_8);
            for (File sourceFolder : sourceFolders) {
                FileMgmt.recursiveZipDirectory(sourceFolder, output);
            }
            output.close();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveZipDirectory(File sourceFolder, ZipOutputStream zipStream) throws IOException {
        File file = sourceFolder;
        synchronized (file) {
            String[] dirList = sourceFolder.list();
            byte[] readBuffer = new byte[2156];
            for (String aDirList : dirList) {
                int bytesIn;
                File f = new File(sourceFolder, aDirList);
                if (f.isDirectory()) {
                    FileMgmt.recursiveZipDirectory(f, zipStream);
                    continue;
                }
                if (!f.isFile() || !f.canRead()) continue;
                FileInputStream input = new FileInputStream(f);
                ZipEntry anEntry = new ZipEntry(f.getPath());
                zipStream.putNextEntry(anEntry);
                while ((bytesIn = input.read(readBuffer)) != -1) {
                    zipStream.write(readBuffer, 0, bytesIn);
                }
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(File file) {
        File file2 = file;
        synchronized (file2) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        FileMgmt.deleteFile(child);
                    }
                }
                if (!((children = file.listFiles()) != null && children.length != 0 || file.delete())) {
                    System.out.println("Error: Could not delete folder: " + file.getPath());
                }
            } else if (file.isFile() && !file.delete()) {
                System.out.println("Error: Could not delete file: " + file.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldBackups(File backupsDir, long deleteAfter) {
        File file = backupsDir;
        synchronized (file) {
            File[] children;
            TreeSet<Long> deleted = new TreeSet<Long>();
            if (backupsDir.isDirectory() && (children = backupsDir.listFiles()) != null) {
                for (File child : children) {
                    try {
                        long age;
                        String[] tokens;
                        String lastToken;
                        long timeMade;
                        String filename = child.getName();
                        if (child.isFile() && filename.contains(".")) {
                            filename = filename.split("\\.")[0];
                        }
                        if ((timeMade = Long.parseLong(lastToken = (tokens = filename.split(" "))[tokens.length - 1])) < 0L || (age = System.currentTimeMillis() - timeMade) < deleteAfter) continue;
                        FileMgmt.deleteFile(child);
                        deleted.add(age);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (deleted.size() > 0) {
                System.out.println(String.format("[Towny] Deleting %d Old Backups (%s).", deleted.size(), deleted.size() > 1 ? String.format("%d-%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()), TimeUnit.MILLISECONDS.toDays((Long)deleted.last())) : String.format("%d days old", TimeUnit.MILLISECONDS.toDays((Long)deleted.first()))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deleteUnusedFiles(File residentDir, Set<String> fileNames) {
        File file = residentDir;
        synchronized (file) {
            File[] children;
            int count = 0;
            if (residentDir.isDirectory() && (children = residentDir.listFiles()) != null) {
                for (File child : children) {
                    try {
                        String filename = child.getName();
                        if (!child.isFile()) continue;
                        if (filename.contains(".txt")) {
                            filename = filename.split("\\.txt")[0];
                        }
                        if (fileNames.contains(filename.toLowerCase())) continue;
                        FileMgmt.deleteFile(child);
                        ++count;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (count > 0) {
                    System.out.println(String.format("[Towny] Deleted %d old files.", count));
                }
            }
        }
    }

    @Deprecated
    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }
}

