/*
 * Decompiled with CFR 0.152.
 */
package de.slikey.effectlib.util;

import de.slikey.effectlib.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public enum ParticleEffect {
    EXPLOSION_NORMAL("poof", "explode", 34, 0, -1),
    EXPLOSION_LARGE("explosion", "largeexplode", 19, 1, -1),
    EXPLOSION_HUGE("explosion_emitter", "hugeexplosion", 18, 2, -1),
    FIREWORKS_SPARK("firework", "fireworksSpark", 21, 3, -1),
    WATER_BUBBLE("bubble", "bubble", 4, 4, -1, false, true),
    WATER_SPLASH("splash", "splash", 43, 5, -1),
    WATER_WAKE("fishing", "wake", 22, 6, 7),
    SUSPENDED("underwater", "suspended", 42, 7, -1, false, true),
    SUSPENDED_DEPTH("", "depthSuspend", -1, 8, -1),
    CRIT("crit", "crit", 6, 9, -1),
    CRIT_MAGIC("enchanted_hit", "magicCrit", 14, 10, -1),
    SMOKE_NORMAL("smoke", "smoke", 37, 11, -1),
    SMOKE_LARGE("large_smoke", "largesmoke", 30, 12, -1),
    SPELL("effect", "spell", 12, 13, -1),
    SPELL_INSTANT("instant_effect", "instantSpell", 26, 14, -1),
    SPELL_MOB("entity_effect", "mobSpell", 17, 15, -1),
    SPELL_MOB_AMBIENT("ambient_entity_effect", "mobSpellAmbient", 0, 16, -1),
    SPELL_WITCH("witch", "witchMagic", 44, 17, -1),
    DRIP_WATER("dripping_water", "dripWater", 10, 18, -1),
    DRIP_LAVA("dripping_lava", "dripLava", 9, 19, -1),
    VILLAGER_HAPPY("happy_villager", "happyVillager", 24, 21, -1),
    VILLAGER_ANGRY("angry_villager", "angryVillager", 1, 20, -1),
    TOWN_AURA("mycelium", "townaura", 32, 22, -1),
    NOTE("note", "note", 33, 23, -1),
    PORTAL("portal", "portal", 35, 24, -1),
    ENCHANTMENT_TABLE("enchant", "enchantmenttable", 15, 25, -1),
    FLAME("flame", "flame", 23, 26, -1),
    LAVA("lava", "lava", 31, 27, -1),
    CLOUD("cloud", "cloud", 5, 29, -1),
    REDSTONE("dust", "reddust", 11, 30, -1),
    SNOWBALL("item_snowball", "snowballpoof", 29, 31, -1),
    SNOW_SHOVEL("", "snowshovel", -1, 32, -1),
    SLIME("item_slime", "slime", 28, 33, -1),
    HEART("heart", "heart", 25, 34, -1),
    BARRIER("barrier", "barrier", 2, 35, 8),
    ITEM_CRACK("item", "iconcrack", 27, 36, -1, true),
    BLOCK_CRACK("block", "blockcrack", 3, 37, -1, true),
    BLOCK_DUST("block", "blockdust", 3, 38, 7, true),
    WATER_DROP("rain", "droplet", 36, 39, 8),
    MOB_APPEARANCE("elder_guardian", "mobappearance", 13, 41, 8),
    DRAGON_BREATH("dragon_breath", "dragonbreath", 8, 42, 9),
    END_ROD("end_rod", "endRod", 16, 43, 9),
    DAMAGE_INDICATOR("damage_indicator", "damageIndicator", 7, 44, 9),
    SWEEP_ATTACK("sweep_attack", "sweepAttack", 40, 45, 9),
    FALLING_DUST("falling_dust", "fallingdust", 20, 46, 10, true),
    TOTEM("totem_of_undying", "totem", 41, 47, 11),
    SPIT("spit", "spit", 38, 48, 11),
    SQUID_INK("squid_ink", "", 39, -1, 13, false, true),
    BUBBLE_POP("bubble_pop", "", 45, -1, 13, false, true),
    CURRENT_DOWN("current_down", "", 46, -1, 13, false, true),
    BUBBLE_COLUMN_UP("bubble_column_up", "", 47, -1, 13, false, true),
    NAUTILUS("nautilus", "", -1, 48, -1),
    FOOTSTEP("", "footstep", -1, 28, -1),
    ITEM_TAKE("", "take", -1, 40, 8);

    private static final int LONG_DISTANCE = 16;
    private static final int LONG_DISTANCE_SQUARED = 256;
    private final String legacyName;
    private final String name;
    private final int legacyId;
    private final int id;
    private final int requiredVersion;
    private final boolean requiresData;
    private final boolean requiresWater;

    private ParticleEffect(String name, String legacyName, int id, int legacyId, int requiredVersion, boolean requiresData, boolean requiresWater) {
        this.name = name;
        this.legacyName = legacyName;
        this.id = id;
        this.legacyId = legacyId;
        this.requiredVersion = requiredVersion;
        this.requiresData = requiresData;
        this.requiresWater = requiresWater;
    }

    private ParticleEffect(String name, String legacyName, int id, int legacyId, int requiredVersion, boolean requiresData) {
        this(name, legacyName, id, legacyId, requiredVersion, requiresData, false);
    }

    private ParticleEffect(String name, String legacyName, int id, int legacyId, int requiredVersion) {
        this(name, legacyName, id, legacyId, requiredVersion, false);
    }

    public String getLegacyName() {
        return this.legacyName;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getLegacyId() {
        return this.legacyId;
    }

    public int getRequiredVersion() {
        return this.requiredVersion;
    }

    public boolean getRequiresData() {
        return this.requiresData;
    }

    public boolean getRequiresWater() {
        return this.requiresWater;
    }

    public boolean isSupported() {
        if (this.requiredVersion == -1) {
            return true;
        }
        return ParticlePacket.getVersion() >= this.requiredVersion;
    }

    private static boolean isWater(Location location) {
        Material material = location.getBlock().getType();
        return material == Material.WATER || material == Material.STATIONARY_WATER;
    }

    private static boolean isLongDistance(Location location, List<Player> players) {
        for (Player player : players) {
            if (!(player.getLocation().distanceSquared(location) > 256.0)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDataCorrect(ParticleEffect effect, ParticleData data) {
        return (effect == BLOCK_CRACK || effect == BLOCK_DUST || effect == FALLING_DUST) && data instanceof BlockData || effect == ITEM_CRACK && data instanceof ItemData;
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, double range, List<Player> targetPlayers) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect requires additional data");
        }
        if (this.requiresWater && !ParticleEffect.isWater(center)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        ParticlePacket particle = new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, range > 16.0, null);
        if (targetPlayers != null) {
            particle.sendTo(center, targetPlayers);
        } else {
            particle.sendTo(center, range);
        }
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, double range) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        this.display(offsetX, offsetY, offsetZ, speed, amount, center, range, null);
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect requires additional data");
        }
        if (this.requiresWater && !ParticleEffect.isWater(center)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, ParticleEffect.isLongDistance(center, players), null).sendTo(center, players);
    }

    public void display(float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, Player ... players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        this.display(offsetX, offsetY, offsetZ, speed, amount, center, Arrays.asList(players));
    }

    public void display(Vector direction, float speed, Location center, double range) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect requires additional data");
        }
        if (this.requiresWater && !ParticleEffect.isWater(center)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        ParticlePacket particle = new ParticlePacket(this, direction, speed, range > 16.0, null);
        particle.sendTo(center, range);
    }

    public void display(Vector direction, float speed, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect requires additional data");
        }
        if (this.requiresWater && !ParticleEffect.isWater(center)) {
            throw new IllegalArgumentException("There is no water at the center location");
        }
        new ParticlePacket(this, direction, speed, ParticleEffect.isLongDistance(center, players), null).sendTo(center, players);
    }

    public void display(Vector direction, float speed, Location center, Player ... players) throws ParticleVersionException, ParticleDataException, IllegalArgumentException {
        this.display(direction, speed, center, Arrays.asList(players));
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, double range, List<Player> targetPlayers) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (!this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect does not require additional data");
        }
        if (data == null) {
            return;
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect: " + data + " for " + (Object)((Object)this));
        }
        ParticlePacket particle = new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, range > 16.0, data);
        if (targetPlayers != null) {
            particle.sendTo(center, targetPlayers);
        } else {
            particle.sendTo(center, range);
        }
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, double range) throws ParticleVersionException, ParticleDataException {
        this.display(data, offsetX, offsetY, offsetZ, speed, amount, center, range, null);
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (!this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect: " + data + " for " + (Object)((Object)this));
        }
        new ParticlePacket(this, offsetX, offsetY, offsetZ, speed, amount, ParticleEffect.isLongDistance(center, players), data).sendTo(center, players);
    }

    public void display(ParticleData data, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, Player ... players) throws ParticleVersionException, ParticleDataException {
        this.display(data, offsetX, offsetY, offsetZ, speed, amount, center, Arrays.asList(players));
    }

    public void display(ParticleData data, Vector direction, float speed, Location center, double range) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (!this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect: " + data + " for " + (Object)((Object)this));
        }
        new ParticlePacket(this, direction, speed, range > 16.0, data).sendTo(center, range);
    }

    public void display(ParticleData data, Vector direction, float speed, Location center, List<Player> players) throws ParticleVersionException, ParticleDataException {
        if (!this.isSupported()) {
            throw new ParticleVersionException("The " + (Object)((Object)this) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
        }
        if (!this.requiresData) {
            throw new ParticleDataException("The " + (Object)((Object)this) + " particle effect does not require additional data");
        }
        if (!ParticleEffect.isDataCorrect(this, data)) {
            throw new ParticleDataException("The particle data type is incorrect: " + data + " for " + (Object)((Object)this));
        }
        new ParticlePacket(this, direction, speed, ParticleEffect.isLongDistance(center, players), data).sendTo(center, players);
    }

    public void display(ParticleData data, Vector direction, float speed, Location center, Player ... players) throws ParticleVersionException, ParticleDataException {
        this.display(data, direction, speed, center, Arrays.asList(players));
    }

    @Deprecated
    public void display(Location center, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        this.display(offsetX, offsetY, offsetZ, speed, amount, center, range);
    }

    @Deprecated
    public void display(Location center, double range) {
        this.display(0.0f, 0.0f, 0.0f, 0.0f, 1, center, range);
    }

    @Deprecated
    public void display(ParticleData data, Location center, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        if (this.requiresData) {
            this.display(data, offsetX, offsetY, offsetZ, speed, amount, center, range);
        } else {
            this.display(offsetX, offsetY, offsetZ, speed, amount, center, range);
        }
    }

    public void display(Location center, Color color, double range) {
        this.display(null, center, color, range, 0.0f, 0.0f, 0.0f, 1.0f, 0);
    }

    public void display(ParticleData data, Location center, Color color, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount) {
        this.display(data, center, color, range, offsetX, offsetY, offsetZ, speed, amount, null);
    }

    public void display(ParticleData data, Location center, Color color, double range, float offsetX, float offsetY, float offsetZ, float speed, int amount, List<Player> targetPlayers) {
        if (color != null && (this == REDSTONE || this == SPELL_MOB || this == SPELL_MOB_AMBIENT)) {
            amount = 0;
            if (speed == 0.0f) {
                speed = 1.0f;
            }
            offsetX = (float)color.getRed() / 255.0f;
            offsetY = (float)color.getGreen() / 255.0f;
            offsetZ = (float)color.getBlue() / 255.0f;
            if (offsetX < Float.MIN_NORMAL) {
                offsetX = Float.MIN_NORMAL;
            }
        }
        if (this.requiresData) {
            this.display(data, offsetX, offsetY, offsetZ, speed, amount, center, range, targetPlayers);
        } else {
            this.display(offsetX, offsetY, offsetZ, speed, amount, center, range, targetPlayers);
        }
    }

    public boolean requiresData() {
        return this.requiresData;
    }

    public boolean requiresWater() {
        return this.requiresWater;
    }

    public ParticleData getData(Material material, Byte blockData) {
        ParticleData data = null;
        if (blockData == null) {
            blockData = 0;
        }
        if ((this == BLOCK_CRACK || this == ITEM_CRACK || this == BLOCK_DUST || this == FALLING_DUST) && material != null && material != Material.AIR) {
            data = this == ITEM_CRACK ? new ItemData(material, blockData) : new BlockData(material, blockData);
        }
        return data;
    }

    public static final class ParticlePacket {
        private static int version;
        private static boolean isKcauldron;
        private static final int[] emptyData;
        private static Object[] enumParticles;
        private static Class<?> enumParticle;
        private static Constructor<?> packetConstructor;
        private static Field packet_idField;
        private static Field packet_locationXField;
        private static Field packet_locationYField;
        private static Field packet_locationZField;
        private static Field packet_offsetXField;
        private static Field packet_offsetYField;
        private static Field packet_offsetZField;
        private static Field packet_speedField;
        private static Field packet_amountField;
        private static Field packet_longDistanceField;
        private static Field packet_dataField;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static boolean initialized;
        private final ParticleEffect effect;
        private final float offsetX;
        private final float offsetY;
        private final float offsetZ;
        private final float speed;
        private final int amount;
        private final boolean longDistance;
        private final ParticleData data;
        private Object packet;

        public static void skipInitialization() {
            initialized = true;
        }

        public ParticlePacket(ParticleEffect effect, float offsetX, float offsetY, float offsetZ, float speed, int amount, boolean longDistance, ParticleData data) throws IllegalArgumentException {
            ParticlePacket.initialize();
            if (speed < 0.0f) {
                throw new IllegalArgumentException("The speed is lower than 0");
            }
            if (amount < 0) {
                throw new IllegalArgumentException("The amount is lower than 0");
            }
            this.effect = effect;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.speed = speed;
            this.amount = amount;
            this.longDistance = longDistance;
            this.data = data;
        }

        public ParticlePacket(ParticleEffect effect, Vector direction, float speed, boolean longDistance, ParticleData data) throws IllegalArgumentException {
            ParticlePacket.initialize();
            if (speed < 0.0f) {
                throw new IllegalArgumentException("The speed is lower than 0");
            }
            this.effect = effect;
            this.offsetX = (float)direction.getX();
            this.offsetY = (float)direction.getY();
            this.offsetZ = (float)direction.getZ();
            this.speed = speed;
            this.amount = 0;
            this.longDistance = longDistance;
            this.data = data;
        }

        public static void initialize() throws VersionIncompatibleException {
            if (initialized) {
                return;
            }
            try {
                isKcauldron = false;
                String[] pieces = StringUtils.split((String)ReflectionUtils.PackageType.getServerVersion(), (String)"_");
                version = Integer.parseInt(pieces[1]);
                if (version > 7) {
                    enumParticle = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("EnumParticle");
                    enumParticles = enumParticle.getEnumConstants();
                }
                Class<?> packetClass = ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass(version < 7 ? "Packet63WorldParticles" : "PacketPlayOutWorldParticles");
                packetConstructor = ReflectionUtils.getConstructor(packetClass, new Class[0]);
                getHandle = ReflectionUtils.getMethod("CraftPlayer", ReflectionUtils.PackageType.CRAFTBUKKIT_ENTITY, "getHandle", new Class[0]);
                playerConnection = ReflectionUtils.getField("EntityPlayer", ReflectionUtils.PackageType.MINECRAFT_SERVER, false, "playerConnection");
                sendPacket = ReflectionUtils.getMethod(playerConnection.getType(), "sendPacket", ReflectionUtils.PackageType.MINECRAFT_SERVER.getClass("Packet"));
                if (version >= 13) {
                    packet_idField = ReflectionUtils.getField(packetClass, true, "j");
                    packet_locationXField = ReflectionUtils.getField(packetClass, true, "a");
                    packet_locationYField = ReflectionUtils.getField(packetClass, true, "b");
                    packet_locationZField = ReflectionUtils.getField(packetClass, true, "c");
                    packet_offsetXField = ReflectionUtils.getField(packetClass, true, "d");
                    packet_offsetYField = ReflectionUtils.getField(packetClass, true, "e");
                    packet_offsetZField = ReflectionUtils.getField(packetClass, true, "f");
                    packet_speedField = ReflectionUtils.getField(packetClass, true, "g");
                    packet_amountField = ReflectionUtils.getField(packetClass, true, "h");
                    packet_longDistanceField = ReflectionUtils.getField(packetClass, true, "i");
                } else {
                    packet_idField = ReflectionUtils.getField(packetClass, true, "a");
                    packet_locationXField = ReflectionUtils.getField(packetClass, true, "b");
                    packet_locationYField = ReflectionUtils.getField(packetClass, true, "c");
                    packet_locationZField = ReflectionUtils.getField(packetClass, true, "d");
                    packet_offsetXField = ReflectionUtils.getField(packetClass, true, "e");
                    packet_offsetYField = ReflectionUtils.getField(packetClass, true, "f");
                    packet_offsetZField = ReflectionUtils.getField(packetClass, true, "g");
                    packet_speedField = ReflectionUtils.getField(packetClass, true, "h");
                    packet_amountField = ReflectionUtils.getField(packetClass, true, "i");
                    if (version > 7) {
                        packet_longDistanceField = ReflectionUtils.getField(packetClass, true, "j");
                        packet_dataField = ReflectionUtils.getField(packetClass, true, "k");
                    }
                }
            }
            catch (Exception exception) {
                try {
                    isKcauldron = true;
                    Class<?> packetClass = Class.forName("net.minecraft.network.play.server.S2APacketParticles");
                    packetConstructor = ReflectionUtils.getConstructor(packetClass, new Class[0]);
                    getHandle = ReflectionUtils.getMethod("CraftPlayer", ReflectionUtils.PackageType.CRAFTBUKKIT_ENTITY, "getHandle", new Class[0]);
                    playerConnection = Class.forName("net.minecraft.entity.player.EntityPlayerMP").getDeclaredField("field_71135_a");
                    sendPacket = playerConnection.getType().getDeclaredMethod("func_147359_a", Class.forName("net.minecraft.network.Packet"));
                    packet_idField = ReflectionUtils.getField(packetClass, true, "field_149236_a");
                    packet_locationXField = ReflectionUtils.getField(packetClass, true, "field_149234_b");
                    packet_locationYField = ReflectionUtils.getField(packetClass, true, "field_149235_c");
                    packet_locationZField = ReflectionUtils.getField(packetClass, true, "field_149232_d");
                    packet_offsetXField = ReflectionUtils.getField(packetClass, true, "field_149233_e");
                    packet_offsetYField = ReflectionUtils.getField(packetClass, true, "field_149230_f");
                    packet_offsetZField = ReflectionUtils.getField(packetClass, true, "field_149231_g");
                    packet_speedField = ReflectionUtils.getField(packetClass, true, "field_149237_h");
                    packet_amountField = ReflectionUtils.getField(packetClass, true, "field_149238_i");
                }
                catch (Exception e) {
                    throw new VersionIncompatibleException("Your current bukkit version seems to be incompatible with this library", exception);
                }
            }
            initialized = true;
        }

        public static int getVersion() {
            return version;
        }

        public static boolean isInitialized() {
            return initialized;
        }

        public void sendTo(Location center, Player player) throws PacketInstantiationException, PacketSendingException {
            if (this.packet == null) {
                try {
                    Object id;
                    this.packet = packetConstructor.newInstance(new Object[0]);
                    if (version < 8) {
                        id = this.effect.getLegacyName() + (this.data == null ? "" : this.data.getPacketDataString());
                    } else if (version < 13) {
                        id = enumParticles[this.effect.getLegacyId()];
                    } else {
                        if (this.effect.getId() < 0) {
                            throw new ParticleVersionException("The " + (Object)((Object)this.effect) + " particle effect is not supported by your server version " + ParticlePacket.getVersion());
                        }
                        id = enumParticles[this.effect.getId()];
                    }
                    packet_idField.set(this.packet, id);
                    packet_locationXField.set(this.packet, Float.valueOf((float)center.getX()));
                    packet_locationYField.set(this.packet, Float.valueOf((float)center.getY()));
                    packet_locationZField.set(this.packet, Float.valueOf((float)center.getZ()));
                    packet_offsetXField.set(this.packet, Float.valueOf(this.offsetX));
                    packet_offsetYField.set(this.packet, Float.valueOf(this.offsetY));
                    packet_offsetZField.set(this.packet, Float.valueOf(this.offsetZ));
                    packet_speedField.set(this.packet, Float.valueOf(this.speed));
                    packet_amountField.set(this.packet, this.amount);
                    if (packet_longDistanceField != null) {
                        packet_longDistanceField.set(this.packet, this.longDistance);
                    }
                    if (packet_dataField != null) {
                        packet_dataField.set(this.packet, this.data == null ? emptyData : this.data.getPacketData());
                    }
                }
                catch (Exception exception) {
                    throw new PacketInstantiationException("Packet instantiation failed", exception);
                }
            }
            try {
                sendPacket.invoke(playerConnection.get(getHandle.invoke((Object)player, new Object[0])), this.packet);
            }
            catch (Exception exception) {
                throw new PacketSendingException("Failed to send the packet to player '" + player.getName() + "'", exception);
            }
        }

        public void sendTo(Location center, List<Player> players) throws IllegalArgumentException {
            if (players.isEmpty()) {
                throw new IllegalArgumentException("The player list is empty");
            }
            for (Player player : players) {
                this.sendTo(center, player);
            }
        }

        public void sendTo(Location center, double range) throws IllegalArgumentException {
            if (range < 1.0) {
                throw new IllegalArgumentException("The range is lower than 1");
            }
            String worldName = center.getWorld().getName();
            double squared = range * range;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(center) > squared) continue;
                this.sendTo(center, player);
            }
        }

        static {
            emptyData = new int[0];
        }

        private static final class PacketSendingException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketSendingException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static final class PacketInstantiationException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public PacketInstantiationException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        private static final class VersionIncompatibleException
        extends RuntimeException {
            private static final long serialVersionUID = 3203085387160737484L;

            public VersionIncompatibleException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    private static final class ParticleVersionException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleVersionException(String message) {
            super(message);
        }
    }

    private static final class ParticleDataException
    extends RuntimeException {
        private static final long serialVersionUID = 3203085387160737484L;

        public ParticleDataException(String message) {
            super(message);
        }
    }

    public static final class BlockData
    extends ParticleData {
        public BlockData(Material material, byte data) throws IllegalArgumentException {
            int[] nArray;
            if (ParticlePacket.getVersion() >= 13) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = material.getId();
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = data << 12 | material.getId() & 0xFFF;
            }
            super(material, data, nArray);
            if (!material.isBlock()) {
                throw new IllegalArgumentException("The material is not a block");
            }
        }
    }

    public static final class ItemData
    extends ParticleData {
        public ItemData(Material material, byte data) {
            int[] nArray;
            if (ParticlePacket.getVersion() >= 13) {
                int[] nArray2 = new int[4];
                nArray2[0] = material.getId();
                nArray2[1] = 1;
                nArray2[2] = data;
                nArray = nArray2;
                nArray2[3] = 0;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = material.getId();
                nArray = nArray3;
                nArray3[1] = data;
            }
            super(material, data, nArray);
        }
    }

    public static abstract class ParticleData {
        private final Material material;
        private final byte data;
        private final int[] packetData;

        public ParticleData(Material material, byte data, int[] packetData) {
            this.material = material;
            this.data = data;
            this.packetData = packetData;
        }

        public Material getMaterial() {
            return this.material;
        }

        public byte getData() {
            return this.data;
        }

        public int[] getPacketData() {
            return this.packetData;
        }

        public String getPacketDataString() {
            if (this.packetData.length >= 2) {
                return "_" + this.packetData[0] + "_" + this.packetData[1];
            }
            if (this.packetData.length == 1) {
                return "_" + this.packetData[0];
            }
            return "";
        }
    }
}

