/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.util.StringUtil;

@Deprecated
public class WhitelistCommand
extends VanillaCommand {
    private static final List<String> WHITELIST_SUBCOMMANDS = ImmutableList.of((Object)"add", (Object)"remove", (Object)"on", (Object)"off", (Object)"list", (Object)"reload");

    public WhitelistCommand() {
        super("whitelist");
        this.description = "Manages the list of players allowed to use this server";
        this.usageMessage = "/whitelist (add|remove) <player>\n/whitelist (on|off|list|reload)";
        this.setPermission("bukkit.command.whitelist.reload;bukkit.command.whitelist.enable;bukkit.command.whitelist.disable;bukkit.command.whitelist.list;bukkit.command.whitelist.add;bukkit.command.whitelist.remove");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reload")) {
                if (this.badPerm(sender, "reload")) {
                    return true;
                }
                Bukkit.reloadWhitelist();
                Command.broadcastCommandMessage(sender, "Reloaded white-list from file");
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                if (this.badPerm(sender, "enable")) {
                    return true;
                }
                Bukkit.setWhitelist(true);
                Command.broadcastCommandMessage(sender, "Turned on white-listing");
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                if (this.badPerm(sender, "disable")) {
                    return true;
                }
                Bukkit.setWhitelist(false);
                Command.broadcastCommandMessage(sender, "Turned off white-listing");
                return true;
            }
            if (args[0].equalsIgnoreCase("list")) {
                if (this.badPerm(sender, "list")) {
                    return true;
                }
                StringBuilder result = new StringBuilder();
                for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                    if (result.length() > 0) {
                        result.append(", ");
                    }
                    result.append(player.getName());
                }
                sender.sendMessage("White-listed players: " + result.toString());
                return true;
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("add")) {
                if (this.badPerm(sender, "add")) {
                    return true;
                }
                Bukkit.getOfflinePlayer(args[1]).setWhitelisted(true);
                Command.broadcastCommandMessage(sender, "Added " + args[1] + " to white-list");
                return true;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                if (this.badPerm(sender, "remove")) {
                    return true;
                }
                Bukkit.getOfflinePlayer(args[1]).setWhitelisted(false);
                Command.broadcastCommandMessage(sender, "Removed " + args[1] + " from white-list");
                return true;
            }
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Correct command usage:\n" + this.usageMessage);
        return false;
    }

    private boolean badPerm(CommandSender sender, String perm) {
        if (!sender.hasPermission("bukkit.command.whitelist." + perm)) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "You do not have permission to perform this action.");
            return true;
        }
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], WHITELIST_SUBCOMMANDS, new ArrayList(WHITELIST_SUBCOMMANDS.size()));
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("add")) {
                ArrayList<String> completions = new ArrayList<String>();
                OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
                int n = offlinePlayerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OfflinePlayer player = offlinePlayerArray[n2];
                    String name = player.getName();
                    if (StringUtil.startsWithIgnoreCase(name, args[1]) && !player.isWhitelisted()) {
                        completions.add(name);
                    }
                    ++n2;
                }
                return completions;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                ArrayList<String> completions = new ArrayList<String>();
                for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
                    String name = player.getName();
                    if (!StringUtil.startsWithIgnoreCase(name, args[1])) continue;
                    completions.add(name);
                }
                return completions;
            }
        }
        return ImmutableList.of();
    }
}

