/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public record Advancement(Optional<MinecraftKey> parent, Optional<AdvancementDisplay> display, AdvancementRewards rewards, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent, Optional<IChatBaseComponent> name) {
    private static final Codec<Map<String, Criterion<?>>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, Criterion.CODEC).validate((T var0) -> var0.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)var0));
    public static final Codec<Advancement> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)MinecraftKey.CODEC.optionalFieldOf("parent").forGetter(Advancement::parent), (App)AdvancementDisplay.CODEC.optionalFieldOf("display").forGetter(Advancement::display), (App)AdvancementRewards.CODEC.optionalFieldOf("rewards", (Object)AdvancementRewards.EMPTY).forGetter(Advancement::rewards), (App)CRITERIA_CODEC.fieldOf("criteria").forGetter(Advancement::criteria), (App)AdvancementRequirements.CODEC.optionalFieldOf("requirements").forGetter(var0 -> Optional.of(var0.requirements())), (App)Codec.BOOL.optionalFieldOf("sends_telemetry_event", (Object)false).forGetter(Advancement::sendsTelemetryEvent)).apply((Applicative)var02, (var0, var1, var2, var3, var4, var5) -> {
        AdvancementRequirements var6 = var4.orElseGet(() -> AdvancementRequirements.allOf(var3.keySet()));
        return new Advancement((Optional<MinecraftKey>)var0, (Optional<AdvancementDisplay>)var1, (AdvancementRewards)var2, (Map<String, Criterion<?>>)var3, var6, (boolean)var5);
    })).validate(Advancement::validate);
    public static final StreamCodec<RegistryFriendlyByteBuf, Advancement> STREAM_CODEC = StreamCodec.ofMember(Advancement::write, Advancement::read);

    public Advancement(Optional<MinecraftKey> var0, Optional<AdvancementDisplay> var1, AdvancementRewards var2, Map<String, Criterion<?>> var3, AdvancementRequirements var4, boolean var5) {
        this(var0, var1, var2, Map.copyOf(var3), var4, var5, var1.map(Advancement::decorateName));
    }

    private static DataResult<Advancement> validate(Advancement var0) {
        return var0.requirements().validate(var0.criteria().keySet()).map(var1 -> var0);
    }

    private static IChatBaseComponent decorateName(AdvancementDisplay var0) {
        IChatBaseComponent var12 = var0.getTitle();
        EnumChatFormat var2 = var0.getType().getChatColor();
        IChatMutableComponent var3 = ChatComponentUtils.mergeStyles(var12.copy(), ChatModifier.EMPTY.withColor(var2)).append("\n").append(var0.getDescription());
        IChatMutableComponent var4 = var12.copy().withStyle(var1 -> var1.withHoverEvent(new ChatHoverable.e(var3)));
        return ChatComponentUtils.wrapInSquareBrackets(var4).withStyle(var2);
    }

    public static IChatBaseComponent name(AdvancementHolder var0) {
        return var0.value().name().orElseGet(() -> IChatBaseComponent.literal(var0.id().toString()));
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeOptional(this.parent, PacketDataSerializer::writeResourceLocation);
        AdvancementDisplay.STREAM_CODEC.apply(ByteBufCodecs::optional).encode(var0, this.display);
        this.requirements.write(var0);
        var0.writeBoolean(this.sendsTelemetryEvent);
    }

    private static Advancement read(RegistryFriendlyByteBuf var0) {
        return new Advancement(var0.readOptional(PacketDataSerializer::readResourceLocation), (Optional)AdvancementDisplay.STREAM_CODEC.apply(ByteBufCodecs::optional).decode(var0), AdvancementRewards.EMPTY, Map.of(), new AdvancementRequirements(var0), var0.readBoolean());
    }

    public boolean isRoot() {
        return this.parent.isEmpty();
    }

    public void validate(ProblemReporter var0, HolderGetter.a var1) {
        this.criteria.forEach((var2, var3) -> {
            CriterionValidator var4 = new CriterionValidator(var0.forChild(new ProblemReporter.i((String)var2)), var1);
            var3.triggerInstance().validate(var4);
        });
    }

    public static class SerializedAdvancement {
        private Optional<MinecraftKey> parent = Optional.empty();
        private Optional<AdvancementDisplay> display = Optional.empty();
        private AdvancementRewards rewards = AdvancementRewards.EMPTY;
        private final ImmutableMap.Builder<String, Criterion<?>> criteria = ImmutableMap.builder();
        private Optional<AdvancementRequirements> requirements = Optional.empty();
        private AdvancementRequirements.a requirementsStrategy = AdvancementRequirements.a.AND;
        private boolean sendsTelemetryEvent;

        public static SerializedAdvancement advancement() {
            return new SerializedAdvancement().sendsTelemetryEvent();
        }

        public static SerializedAdvancement recipeAdvancement() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement parent(AdvancementHolder var0) {
            this.parent = Optional.of(var0.id());
            return this;
        }

        @Deprecated(forRemoval=true)
        public SerializedAdvancement parent(MinecraftKey var0) {
            this.parent = Optional.of(var0);
            return this;
        }

        public SerializedAdvancement display(ItemStack var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new AdvancementDisplay(var0, var1, var2, Optional.ofNullable(var3).map(ClientAsset.b::new), var4, var5, var6, var7));
        }

        public SerializedAdvancement display(IMaterial var0, IChatBaseComponent var1, IChatBaseComponent var2, @Nullable MinecraftKey var3, AdvancementFrameType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new AdvancementDisplay(new ItemStack(var0.asItem()), var1, var2, Optional.ofNullable(var3).map(ClientAsset.b::new), var4, var5, var6, var7));
        }

        public SerializedAdvancement display(AdvancementDisplay var0) {
            this.display = Optional.of(var0);
            return this;
        }

        public SerializedAdvancement rewards(AdvancementRewards.a var0) {
            return this.rewards(var0.build());
        }

        public SerializedAdvancement rewards(AdvancementRewards var0) {
            this.rewards = var0;
            return this;
        }

        public SerializedAdvancement addCriterion(String var0, Criterion<?> var1) {
            this.criteria.put((Object)var0, var1);
            return this;
        }

        public SerializedAdvancement requirements(AdvancementRequirements.a var0) {
            this.requirementsStrategy = var0;
            return this;
        }

        public SerializedAdvancement requirements(AdvancementRequirements var0) {
            this.requirements = Optional.of(var0);
            return this;
        }

        public SerializedAdvancement sendsTelemetryEvent() {
            this.sendsTelemetryEvent = true;
            return this;
        }

        public AdvancementHolder build(MinecraftKey var0) {
            ImmutableMap var1 = this.criteria.buildOrThrow();
            AdvancementRequirements var2 = this.requirements.orElseGet(() -> this.a((Map)var1));
            return new AdvancementHolder(var0, new Advancement(this.parent, this.display, this.rewards, (Map<String, Criterion<?>>)var1, var2, this.sendsTelemetryEvent));
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> var0, String var1) {
            AdvancementHolder var2 = this.build(MinecraftKey.parse(var1));
            var0.accept(var2);
            return var2;
        }

        private /* synthetic */ AdvancementRequirements a(Map var0) {
            return this.requirementsStrategy.create(var0.keySet());
        }
    }
}

