/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.GameTypePredicate;
import net.minecraft.advancements.critereon.InputPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public record CriterionConditionPlayer(CriterionConditionValue.IntegerRange level, GameTypePredicate gameType, List<e<?>> stats, Object2BooleanMap<ResourceKey<IRecipe<?>>> recipes, Map<MinecraftKey, c> advancements, Optional<CriterionConditionEntity> lookingAt, Optional<InputPredicate> input) implements EntitySubPredicate
{
    public static final int LOOKING_AT_RANGE = 100;
    public static final MapCodec<CriterionConditionPlayer> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("level", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionPlayer::level), (App)GameTypePredicate.CODEC.optionalFieldOf("gamemode", (Object)GameTypePredicate.ANY).forGetter(CriterionConditionPlayer::gameType), (App)e.CODEC.listOf().optionalFieldOf("stats", List.of()).forGetter(CriterionConditionPlayer::stats), (App)ExtraCodecs.object2BooleanMap(IRecipe.KEY_CODEC).optionalFieldOf("recipes", (Object)Object2BooleanMaps.emptyMap()).forGetter(CriterionConditionPlayer::recipes), (App)Codec.unboundedMap(MinecraftKey.CODEC, c.CODEC).optionalFieldOf("advancements", Map.of()).forGetter(CriterionConditionPlayer::advancements), (App)CriterionConditionEntity.CODEC.optionalFieldOf("looking_at").forGetter(CriterionConditionPlayer::lookingAt), (App)InputPredicate.CODEC.optionalFieldOf("input").forGetter(CriterionConditionPlayer::input)).apply((Applicative)var0, CriterionConditionPlayer::new));

    @Override
    public boolean matches(Entity var02, WorldServer var1, @Nullable Vec3D var2) {
        Object var10;
        Object var7;
        if (!(var02 instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer var3 = (EntityPlayer)var02;
        if (!this.level.matches(var3.experienceLevel)) {
            return false;
        }
        if (!this.gameType.matches(var3.gameMode())) {
            return false;
        }
        ServerStatisticManager var4 = var3.getStats();
        for (e<?> e2 : this.stats) {
            if (e2.matches(var4)) continue;
            return false;
        }
        RecipeBookServer var5 = var3.getRecipeBook();
        for (Object2BooleanMap.Entry var72 : this.recipes.object2BooleanEntrySet()) {
            if (var5.contains((ResourceKey)var72.getKey()) == var72.getBooleanValue()) continue;
            return false;
        }
        if (!this.advancements.isEmpty()) {
            AdvancementDataPlayer advancementDataPlayer = var3.getAdvancements();
            var7 = var3.level().getServer().getAdvancements();
            for (Map.Entry<MinecraftKey, c> entry : this.advancements.entrySet()) {
                var10 = ((AdvancementDataWorld)var7).get(entry.getKey());
                if (var10 != null && entry.getValue().test(advancementDataPlayer.getOrStartProgress((AdvancementHolder)var10))) continue;
                return false;
            }
        }
        if (this.lookingAt.isPresent()) {
            Vec3D vec3D = var3.getEyePosition();
            var7 = var3.getViewVector(1.0f);
            Vec3D var8 = vec3D.add(((Vec3D)var7).x * 100.0, ((Vec3D)var7).y * 100.0, ((Vec3D)var7).z * 100.0);
            MovingObjectPositionEntity movingObjectPositionEntity = ProjectileHelper.getEntityHitResult(var3.level(), var3, vec3D, var8, new AxisAlignedBB(vec3D, var8).inflate(1.0), var0 -> !var0.isSpectator(), 0.0f);
            if (movingObjectPositionEntity == null || movingObjectPositionEntity.getType() != MovingObjectPosition.EnumMovingObjectType.ENTITY) {
                return false;
            }
            var10 = movingObjectPositionEntity.getEntity();
            if (!this.lookingAt.get().matches(var3, (Entity)var10) || !var3.hasLineOfSight((Entity)var10)) {
                return false;
            }
        }
        return !this.input.isPresent() || this.input.get().matches(var3.getLastClientInput());
    }

    public MapCodec<CriterionConditionPlayer> codec() {
        return EntitySubPredicates.PLAYER;
    }

    record e<T>(StatisticWrapper<T> type, Holder<T> value, CriterionConditionValue.IntegerRange range, Supplier<Statistic<T>> stat) {
        public static final Codec<e<?>> CODEC = BuiltInRegistries.STAT_TYPE.byNameCodec().dispatch(e::type, e::createTypedCodec);

        public e(StatisticWrapper<T> var0, Holder<T> var1, CriterionConditionValue.IntegerRange var2) {
            this(var0, var1, var2, (Supplier<Statistic<T>>)Suppliers.memoize(() -> var0.get(var1.value())));
        }

        private static <T> MapCodec<e<T>> createTypedCodec(StatisticWrapper<T> var0) {
            return RecordCodecBuilder.mapCodec(var12 -> var12.group((App)var0.getRegistry().holderByNameCodec().fieldOf("stat").forGetter(e::value), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("value", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(e::range)).apply((Applicative)var12, (var1, var2) -> new e(var0, var1, (CriterionConditionValue.IntegerRange)var2)));
        }

        public boolean matches(StatisticManager var0) {
            return this.range.matches(var0.getValue(this.stat.get()));
        }
    }

    static interface c
    extends Predicate<AdvancementProgress> {
        public static final Codec<c> CODEC = Codec.either(b.CODEC, a.CODEC).xmap(Either::unwrap, var0 -> {
            if (var0 instanceof b) {
                b var1 = (b)var0;
                return Either.left((Object)var1);
            }
            if (var0 instanceof a) {
                a var2 = (a)var0;
                return Either.right((Object)var2);
            }
            throw new UnsupportedOperationException();
        });
    }

    public static class d {
        private CriterionConditionValue.IntegerRange level = CriterionConditionValue.IntegerRange.ANY;
        private GameTypePredicate gameType = GameTypePredicate.ANY;
        private final ImmutableList.Builder<e<?>> stats = ImmutableList.builder();
        private final Object2BooleanMap<ResourceKey<IRecipe<?>>> recipes = new Object2BooleanOpenHashMap();
        private final Map<MinecraftKey, c> advancements = Maps.newHashMap();
        private Optional<CriterionConditionEntity> lookingAt = Optional.empty();
        private Optional<InputPredicate> input = Optional.empty();

        public static d player() {
            return new d();
        }

        public d setLevel(CriterionConditionValue.IntegerRange var0) {
            this.level = var0;
            return this;
        }

        public <T> d addStat(StatisticWrapper<T> var0, Holder.c<T> var1, CriterionConditionValue.IntegerRange var2) {
            this.stats.add(new e<T>(var0, var1, var2));
            return this;
        }

        public d addRecipe(ResourceKey<IRecipe<?>> var0, boolean var1) {
            this.recipes.put(var0, var1);
            return this;
        }

        public d setGameType(GameTypePredicate var0) {
            this.gameType = var0;
            return this;
        }

        public d setLookingAt(CriterionConditionEntity.a var0) {
            this.lookingAt = Optional.of(var0.build());
            return this;
        }

        public d checkAdvancementDone(MinecraftKey var0, boolean var1) {
            this.advancements.put(var0, new b(var1));
            return this;
        }

        public d checkAdvancementCriterions(MinecraftKey var0, Map<String, Boolean> var1) {
            this.advancements.put(var0, new a((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(var1)));
            return this;
        }

        public d hasInput(InputPredicate var0) {
            this.input = Optional.of(var0);
            return this;
        }

        public CriterionConditionPlayer build() {
            return new CriterionConditionPlayer(this.level, this.gameType, (List<e<?>>)this.stats.build(), this.recipes, this.advancements, this.lookingAt, this.input);
        }
    }

    record a(Object2BooleanMap<String> criterions) implements c
    {
        public static final Codec<a> CODEC = ExtraCodecs.object2BooleanMap(Codec.STRING).xmap(a::new, a::criterions);

        @Override
        public boolean test(AdvancementProgress var0) {
            for (Object2BooleanMap.Entry var2 : this.criterions.object2BooleanEntrySet()) {
                CriterionProgress var3 = var0.getCriterion((String)var2.getKey());
                if (var3 != null && var3.isDone() == var2.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    record b(boolean state) implements c
    {
        public static final Codec<b> CODEC = Codec.BOOL.xmap(b::new, b::state);

        @Override
        public boolean test(AdvancementProgress var0) {
            return var0.isDone() == this.state;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }
}

