/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;

public interface CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.range.swapped"));

    public a<T> bounds();

    default public Optional<T> min() {
        return this.bounds().min;
    }

    default public Optional<T> max() {
        return this.bounds().max;
    }

    default public boolean isAny() {
        return this.bounds().isAny();
    }

    public static final class a<T extends Number>
    extends Record {
        final Optional<T> min;
        final Optional<T> max;

        public a(Optional<T> var0, Optional<T> var1) {
            this.min = var0;
            this.max = var1;
        }

        public boolean isAny() {
            return this.min().isEmpty() && this.max().isEmpty();
        }

        public DataResult<a<T>> validateSwappedBoundsInCodec() {
            if (this.areSwapped()) {
                return DataResult.error(() -> "Swapped bounds in range: " + String.valueOf(this.min()) + " is higher than " + String.valueOf(this.max()));
            }
            return DataResult.success((Object)this);
        }

        public boolean areSwapped() {
            return this.min.isPresent() && this.max.isPresent() && ((Comparable)((Object)((Number)this.min.get()))).compareTo((Number)this.max.get()) > 0;
        }

        public Optional<T> asPoint() {
            Optional<T> var1;
            Optional<T> var0 = this.min();
            return var0.equals(var1 = this.max()) ? var0 : Optional.empty();
        }

        public static <T extends Number> a<T> any() {
            return new a(Optional.empty(), Optional.empty());
        }

        public static <T extends Number> a<T> exactly(T var0) {
            Optional<T> var1 = Optional.of(var0);
            return new a<T>(var1, var1);
        }

        public static <T extends Number> a<T> between(T var0, T var1) {
            return new a<T>(Optional.of(var0), Optional.of(var1));
        }

        public static <T extends Number> a<T> atLeast(T var0) {
            return new a<T>(Optional.of(var0), Optional.empty());
        }

        public static <T extends Number> a<T> atMost(T var0) {
            return new a(Optional.empty(), Optional.of(var0));
        }

        public <U extends Number> a<U> map(Function<T, U> var0) {
            return new a<U>(this.min.map(var0), this.max.map(var0));
        }

        static <T extends Number> Codec<a<T>> createCodec(Codec<T> var03) {
            Codec var12 = RecordCodecBuilder.create(var1 -> var1.group((App)var03.optionalFieldOf("min").forGetter(a::min), (App)var03.optionalFieldOf("max").forGetter(a::max)).apply((Applicative)var1, a::new));
            return Codec.either((Codec)var12, var03).xmap(var02 -> (a)var02.map(var0 -> var0, var0 -> a.exactly((Number)var0)), var0 -> {
                Optional var1 = var0.asPoint();
                return var1.isPresent() ? Either.right((Object)((Number)var1.get())) : Either.left((Object)var0);
            });
        }

        static <B extends ByteBuf, T extends Number> StreamCodec<B, a<T>> createStreamCodec(final StreamCodec<B, T> var0) {
            return new StreamCodec<B, a<T>>(){
                private static final int MIN_FLAG = 1;
                private static final int MAX_FLAG = 2;

                @Override
                public a<T> decode(B var02) {
                    byte var1 = var02.readByte();
                    Optional var2 = (var1 & 1) != 0 ? Optional.of((Number)var0.decode(var02)) : Optional.empty();
                    Optional var3 = (var1 & 2) != 0 ? Optional.of((Number)var0.decode(var02)) : Optional.empty();
                    return new a(var2, var3);
                }

                @Override
                public void encode(B var02, a<T> var1) {
                    Optional<Number> var22 = var1.min();
                    Optional<Number> var3 = var1.max();
                    var02.writeByte((var22.isPresent() ? 1 : 0) | (var3.isPresent() ? 2 : 0));
                    var22.ifPresent(var2 -> var0.encode(var02, var2));
                    var3.ifPresent(var2 -> var0.encode(var02, var2));
                }

                @Override
                public /* synthetic */ void encode(Object object, Object object2) {
                    this.encode((Object)((ByteBuf)object), (a)object2);
                }

                @Override
                public /* synthetic */ Object decode(Object object) {
                    return this.decode((B)((ByteBuf)object));
                }
            };
        }

        public static <T extends Number> a<T> fromReader(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
            if (!var0.canRead()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
            }
            int var3 = var0.getCursor();
            try {
                Optional<T> var5;
                Optional<T> var4 = a.readNumber(var0, var1, var2);
                if (var0.canRead(2) && var0.peek() == '.' && var0.peek(1) == '.') {
                    var0.skip();
                    var0.skip();
                    var5 = a.readNumber(var0, var1, var2);
                } else {
                    var5 = var4;
                }
                if (var4.isEmpty() && var5.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
                }
                return new a<T>(var4, var5);
            }
            catch (CommandSyntaxException var4) {
                var0.setCursor(var3);
                throw new CommandSyntaxException(var4.getType(), var4.getRawMessage(), var4.getInput(), var3);
            }
        }

        private static <T extends Number> Optional<T> readNumber(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
            int var3 = var0.getCursor();
            while (var0.canRead() && a.isAllowedInputChar(var0)) {
                var0.skip();
            }
            String var4 = var0.getString().substring(var3, var0.getCursor());
            if (var4.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of((Number)var1.apply(var4));
            }
            catch (NumberFormatException var5) {
                throw var2.get().createWithContext((ImmutableStringReader)var0, (Object)var4);
            }
        }

        private static boolean isAllowedInputChar(StringReader var0) {
            char var1 = var0.peek();
            if (var1 >= '0' && var1 <= '9' || var1 == '-') {
                return true;
            }
            if (var1 == '.') {
                return !var0.canRead(2) || var0.peek(1) != '.';
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "min;max", "min", "max"}, this, var0);
        }

        public Optional<T> min() {
            return this.min;
        }

        public Optional<T> max() {
            return this.max;
        }
    }

    public record c(a<Float> bounds) implements CriterionConditionValue<Float>
    {
        public static final c ANY = new c(a.any());
        public static final Codec<c> CODEC = a.createCodec(Codec.FLOAT).xmap(c::new, c::bounds);
        public static final StreamCodec<ByteBuf, c> STREAM_CODEC = a.createStreamCodec(ByteBufCodecs.FLOAT).map(c::new, c::bounds);

        public static c fromReader(StringReader var0) throws CommandSyntaxException {
            a<Float> var1 = a.fromReader(var0, Float::parseFloat, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidFloat());
            return new c(var1);
        }
    }

    public record DoubleRange(a<Double> bounds, a<Double> boundsSqr) implements CriterionConditionValue<Double>
    {
        public static final DoubleRange ANY = new DoubleRange(a.any());
        public static final Codec<DoubleRange> CODEC = a.createCodec(Codec.DOUBLE).validate(a::validateSwappedBoundsInCodec).xmap(DoubleRange::new, DoubleRange::bounds);
        public static final StreamCodec<ByteBuf, DoubleRange> STREAM_CODEC = a.createStreamCodec(ByteBufCodecs.DOUBLE).map(DoubleRange::new, DoubleRange::bounds);

        private DoubleRange(a<Double> var0) {
            this(var0, var0.map(MathHelper::square));
        }

        public static DoubleRange exactly(double var0) {
            return new DoubleRange(a.exactly(var0));
        }

        public static DoubleRange between(double var0, double var2) {
            return new DoubleRange(a.between(var0, var2));
        }

        public static DoubleRange atLeast(double var0) {
            return new DoubleRange(a.atLeast(var0));
        }

        public static DoubleRange atMost(double var0) {
            return new DoubleRange(a.atMost(var0));
        }

        public boolean matches(double var0) {
            if (this.bounds.min.isPresent() && (Double)this.bounds.min.get() > var0) {
                return false;
            }
            return this.bounds.max.isEmpty() || !((Double)this.bounds.max.get() < var0);
        }

        public boolean matchesSqr(double var0) {
            if (this.boundsSqr.min.isPresent() && (Double)this.boundsSqr.min.get() > var0) {
                return false;
            }
            return this.boundsSqr.max.isEmpty() || !((Double)this.boundsSqr.max.get() < var0);
        }

        public static DoubleRange fromReader(StringReader var0) throws CommandSyntaxException {
            int var1 = var0.getCursor();
            a<Double> var2 = a.fromReader(var0, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble());
            if (var2.areSwapped()) {
                var0.setCursor(var1);
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new DoubleRange(var2);
        }
    }

    public record IntegerRange(a<Integer> bounds, a<Long> boundsSqr) implements CriterionConditionValue<Integer>
    {
        public static final IntegerRange ANY = new IntegerRange(a.any());
        public static final Codec<IntegerRange> CODEC = a.createCodec(Codec.INT).validate(a::validateSwappedBoundsInCodec).xmap(IntegerRange::new, IntegerRange::bounds);
        public static final StreamCodec<ByteBuf, IntegerRange> STREAM_CODEC = a.createStreamCodec(ByteBufCodecs.INT).map(IntegerRange::new, IntegerRange::bounds);

        private IntegerRange(a<Integer> var02) {
            this(var02, var02.map(var0 -> MathHelper.square(var0.longValue())));
        }

        public static IntegerRange exactly(int var0) {
            return new IntegerRange(a.exactly(var0));
        }

        public static IntegerRange between(int var0, int var1) {
            return new IntegerRange(a.between(var0, var1));
        }

        public static IntegerRange atLeast(int var0) {
            return new IntegerRange(a.atLeast(var0));
        }

        public static IntegerRange atMost(int var0) {
            return new IntegerRange(a.atMost(var0));
        }

        public boolean matches(int var0) {
            if (this.bounds.min.isPresent() && (Integer)this.bounds.min.get() > var0) {
                return false;
            }
            return this.bounds.max.isEmpty() || (Integer)this.bounds.max.get() >= var0;
        }

        public boolean matchesSqr(long var0) {
            if (this.boundsSqr.min.isPresent() && (Long)this.boundsSqr.min.get() > var0) {
                return false;
            }
            return this.boundsSqr.max.isEmpty() || (Long)this.boundsSqr.max.get() >= var0;
        }

        public static IntegerRange fromReader(StringReader var0) throws CommandSyntaxException {
            int var1 = var0.getCursor();
            a<Integer> var2 = a.fromReader(var0, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt());
            if (var2.areSwapped()) {
                var0.setCursor(var1);
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new IntegerRange(var2);
        }
    }
}

