/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(c.CODEC, c::valueCodec).xmap(var0 -> {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap var1 = new Reference2ObjectArrayMap(var0.size());
        for (Map.Entry var3 : var0.entrySet()) {
            c var4 = (c)var3.getKey();
            if (var4.removed()) {
                var1.put(var4.type(), Optional.empty());
                continue;
            }
            var1.put(var4.type(), Optional.of(var3.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)var1);
    }, var0 -> {
        Reference2ObjectArrayMap var1 = new Reference2ObjectArrayMap(var0.map.size());
        for (Map.Entry var3 : Reference2ObjectMaps.fastIterable(var0.map)) {
            DataComponentType var4 = (DataComponentType)var3.getKey();
            if (var4.isTransient()) continue;
            Optional var5 = (Optional)var3.getValue();
            if (var5.isPresent()) {
                var1.put((Object)new c(var4, false), var5.get());
                continue;
            }
            var1.put((Object)new c(var4, true), (Object)Unit.INSTANCE);
        }
        return var1;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = DataComponentPatch.createStreamCodec(new b(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> var0) {
            return var0.streamCodec().cast();
        }
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> DELIMITED_STREAM_CODEC = DataComponentPatch.createStreamCodec(new b(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> var0) {
            StreamCodec var1 = var0.streamCodec().cast();
            return var1.apply(ByteBufCodecs.registryFriendlyLengthPrefixed(Integer.MAX_VALUE));
        }
    });
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    private static StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> createStreamCodec(final b var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

            @Override
            public DataComponentPatch decode(RegistryFriendlyByteBuf var02) {
                DataComponentType var6;
                int var5;
                int var1 = var02.readVarInt();
                int var2 = var02.readVarInt();
                if (var1 == 0 && var2 == 0) {
                    return EMPTY;
                }
                int var3 = var1 + var2;
                Reference2ObjectArrayMap var4 = new Reference2ObjectArrayMap(Math.min(var3, 65536));
                for (var5 = 0; var5 < var1; ++var5) {
                    var6 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(var02);
                    Object var7 = var0.apply(var6).decode(var02);
                    var4.put((Object)var6, Optional.of(var7));
                }
                for (var5 = 0; var5 < var2; ++var5) {
                    var6 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(var02);
                    var4.put((Object)var6, Optional.empty());
                }
                return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)var4);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, DataComponentPatch var1) {
                Object var6;
                if (var1.isEmpty()) {
                    var02.writeVarInt(0);
                    var02.writeVarInt(0);
                    return;
                }
                int var2 = 0;
                int var3 = 0;
                for (Reference2ObjectMap.Entry var5 : Reference2ObjectMaps.fastIterable(var1.map)) {
                    if (((Optional)var5.getValue()).isPresent()) {
                        ++var2;
                        continue;
                    }
                    ++var3;
                }
                var02.writeVarInt(var2);
                var02.writeVarInt(var3);
                for (Reference2ObjectMap.Entry var5 : Reference2ObjectMaps.fastIterable(var1.map)) {
                    var6 = (Optional)var5.getValue();
                    if (!((Optional)var6).isPresent()) continue;
                    DataComponentType var7 = (DataComponentType)var5.getKey();
                    DataComponentType.STREAM_CODEC.encode(var02, var7);
                    this.encodeComponent(var02, var7, ((Optional)var6).get());
                }
                for (Reference2ObjectMap.Entry var5 : Reference2ObjectMaps.fastIterable(var1.map)) {
                    if (!((Optional)var5.getValue()).isEmpty()) continue;
                    var6 = (DataComponentType)var5.getKey();
                    DataComponentType.STREAM_CODEC.encode(var02, var6);
                }
            }

            private <T> void encodeComponent(RegistryFriendlyByteBuf var02, DataComponentType<T> var1, Object var2) {
                var0.apply(var1).encode(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (DataComponentPatch)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> var0) {
        this.map = var0;
    }

    public static a builder() {
        return new a();
    }

    @Nullable
    public <T> Optional<? extends T> get(DataComponentType<? extends T> var0) {
        return (Optional)this.map.get(var0);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> var0) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap var1 = new Reference2ObjectArrayMap(this.map);
        var1.keySet().removeIf(var0);
        if (var1.isEmpty()) {
            return EMPTY;
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)var1);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public d split() {
        if (this.isEmpty()) {
            return d.EMPTY;
        }
        DataComponentMap.a var0 = DataComponentMap.builder();
        Set var1 = Sets.newIdentityHashSet();
        this.map.forEach((var2, var3) -> {
            if (var3.isPresent()) {
                var0.setUnchecked(var2, var3.get());
            } else {
                var1.add(var2);
            }
        });
        return new d(var0.build(), var1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof DataComponentPatch)) return false;
        DataComponentPatch var1 = (DataComponentPatch)var0;
        if (!this.map.equals(var1.map)) return false;
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> var0) {
        StringBuilder var1 = new StringBuilder();
        var1.append('{');
        boolean var2 = true;
        for (Map.Entry var4 : Reference2ObjectMaps.fastIterable(var0)) {
            if (var2) {
                var2 = false;
            } else {
                var1.append(", ");
            }
            Optional var5 = (Optional)var4.getValue();
            if (var5.isPresent()) {
                var1.append(var4.getKey());
                var1.append("=>");
                var1.append(var5.get());
                continue;
            }
            var1.append(REMOVED_PREFIX);
            var1.append(var4.getKey());
        }
        var1.append('}');
        return var1.toString();
    }

    @FunctionalInterface
    static interface b {
        public <T> StreamCodec<? super RegistryFriendlyByteBuf, T> apply(DataComponentType<T> var1);
    }

    public static class a {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        a() {
        }

        public <T> a set(DataComponentType<T> var0, T var1) {
            this.map.put(var0, Optional.of(var1));
            return this;
        }

        public <T> a remove(DataComponentType<T> var0) {
            this.map.put(var0, Optional.empty());
            return this;
        }

        public <T> a set(TypedDataComponent<T> var0) {
            return this.set(var0.type(), var0.value());
        }

        public DataComponentPatch build() {
            if (this.map.isEmpty()) {
                return EMPTY;
            }
            return new DataComponentPatch(this.map);
        }
    }

    public record d(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final d EMPTY = new d(DataComponentMap.EMPTY, Set.of());
    }

    record c(DataComponentType<?> type, boolean removed) {
        public static final Codec<c> CODEC = Codec.STRING.flatXmap(var0 -> {
            MinecraftKey var2;
            DataComponentType<?> var3;
            boolean var1 = var0.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if (var1) {
                var0 = var0.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            if ((var3 = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(var2 = MinecraftKey.tryParse(var0))) == null) {
                return DataResult.error(() -> "No component with type: '" + String.valueOf(var2) + "'");
            }
            if (var3.isTransient()) {
                return DataResult.error(() -> "'" + String.valueOf(var2) + "' is not a persistent component");
            }
            return DataResult.success((Object)new c(var3, var1));
        }, var0 -> {
            DataComponentType<?> var1 = var0.type();
            MinecraftKey var2 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(var1);
            if (var2 == null) {
                return DataResult.error(() -> "Unregistered component: " + String.valueOf(var1));
            }
            return DataResult.success((Object)(var0.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf(var2) : var2.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

