/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record HashedPatchMap(Map<DataComponentType<?>, Integer> addedComponents, Set<DataComponentType<?>> removedComponents) {
    public static final StreamCodec<RegistryFriendlyByteBuf, HashedPatchMap> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(HashMap::new, ByteBufCodecs.registry(Registries.DATA_COMPONENT_TYPE), ByteBufCodecs.INT, 256), HashedPatchMap::addedComponents, ByteBufCodecs.collection(HashSet::new, ByteBufCodecs.registry(Registries.DATA_COMPONENT_TYPE), 256), HashedPatchMap::removedComponents, HashedPatchMap::new);

    public static HashedPatchMap create(DataComponentPatch var0, a var1) {
        DataComponentPatch.d var22 = var0.split();
        IdentityHashMap var3 = new IdentityHashMap(var22.added().size());
        var22.added().forEach(var2 -> var3.put(var2.type(), (Integer)var1.apply(var2)));
        return new HashedPatchMap(var3, var22.removed());
    }

    public boolean matches(DataComponentPatch var0, a var1) {
        DataComponentPatch.d var2 = var0.split();
        if (!var2.removed().equals(this.removedComponents)) {
            return false;
        }
        if (this.addedComponents.size() != var2.added().size()) {
            return false;
        }
        for (TypedDataComponent<?> var4 : var2.added()) {
            Integer var5 = this.addedComponents.get(var4.type());
            if (var5 == null) {
                return false;
            }
            Integer var6 = (Integer)var1.apply(var4);
            if (var6.equals(var5)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface a
    extends Function<TypedDataComponent<?>, Integer> {
    }
}

