/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;

public record SelectorContents(SelectorPattern selector, Optional<IChatBaseComponent> separator) implements ComponentContents
{
    public static final MapCodec<SelectorContents> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)SelectorPattern.CODEC.fieldOf("selector").forGetter(SelectorContents::selector), (App)ComponentSerialization.CODEC.optionalFieldOf("separator").forGetter(SelectorContents::separator)).apply((Applicative)var0, SelectorContents::new));

    public MapCodec<SelectorContents> codec() {
        return MAP_CODEC;
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null) {
            return IChatBaseComponent.empty();
        }
        Optional<IChatMutableComponent> var3 = ChatComponentUtils.updateForEntity(var0, this.separator, var1, var2);
        return ChatComponentUtils.formatList(this.selector.resolved().findEntities(var0), var3, Entity::getDisplayName);
    }

    @Override
    public <T> Optional<T> visit(IChatFormatted.b<T> var0, ChatModifier var1) {
        return var0.accept(var1, this.selector.pattern());
    }

    @Override
    public <T> Optional<T> visit(IChatFormatted.a<T> var0) {
        return var0.accept(this.selector.pattern());
    }

    @Override
    public String toString() {
        return "pattern{" + String.valueOf(this.selector) + "}";
    }
}

