/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.MathHelper;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public Boolean decode(ByteBuf var0) {
            return var0.readBoolean();
        }

        @Override
        public void encode(ByteBuf var0, Boolean var1) {
            var0.writeBoolean(var1.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Boolean)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public Byte decode(ByteBuf var0) {
            return var0.readByte();
        }

        @Override
        public void encode(ByteBuf var0, Byte var1) {
            var0.writeByte((int)var1.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Byte)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> ROTATION_BYTE = BYTE.map(MathHelper::unpackDegrees, MathHelper::packDegrees);
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        @Override
        public Short decode(ByteBuf var0) {
            return var0.readShort();
        }

        @Override
        public void encode(ByteBuf var0, Short var1) {
            var0.writeShort((int)var1.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Short)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return var0.readUnsignedShort();
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            var0.writeShort(var1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return var0.readInt();
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            var0.writeInt(var1.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return VarInt.read(var0);
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            VarInt.write(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_VAR_INT = VAR_INT.map(var0 -> var0 == 0 ? OptionalInt.empty() : OptionalInt.of(var0 - 1), var0 -> var0.isPresent() ? var0.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf var0) {
            return var0.readLong();
        }

        @Override
        public void encode(ByteBuf var0, Long var1) {
            var0.writeLong(var1.longValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf var0) {
            return VarLong.read(var0);
        }

        @Override
        public void encode(ByteBuf var0, Long var1) {
            VarLong.write(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Long)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        public Float decode(ByteBuf var0) {
            return Float.valueOf(var0.readFloat());
        }

        @Override
        public void encode(ByteBuf var0, Float var1) {
            var0.writeFloat(var1.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Float)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        public Double decode(ByteBuf var0) {
            return var0.readDouble();
        }

        @Override
        public void encode(ByteBuf var0, Double var1) {
            var0.writeDouble(var1.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Double)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        @Override
        public byte[] decode(ByteBuf var0) {
            return PacketDataSerializer.readByteArray(var0);
        }

        @Override
        public void encode(ByteBuf var0, byte[] var1) {
            PacketDataSerializer.writeByteArray(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (byte[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, long[]> LONG_ARRAY = new StreamCodec<ByteBuf, long[]>(){

        @Override
        public long[] decode(ByteBuf var0) {
            return PacketDataSerializer.readLongArray(var0);
        }

        @Override
        public void encode(ByteBuf var0, long[] var1) {
            PacketDataSerializer.writeLongArray(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (long[])object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, NBTBase> TAG = ByteBufCodecs.tagCodec(() -> NBTReadLimiter.create(0x200000L));
    public static final StreamCodec<ByteBuf, NBTBase> TRUSTED_TAG = ByteBufCodecs.tagCodec(NBTReadLimiter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, NBTTagCompound> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> NBTReadLimiter.create(0x200000L));
    public static final StreamCodec<ByteBuf, NBTTagCompound> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NBTReadLimiter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<NBTTagCompound>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<NBTTagCompound>>(){

        @Override
        public Optional<NBTTagCompound> decode(ByteBuf var0) {
            return Optional.ofNullable(PacketDataSerializer.readNbt(var0));
        }

        @Override
        public void encode(ByteBuf var0, Optional<NBTTagCompound> var1) {
            PacketDataSerializer.writeNbt(var0, var1.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Optional)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> VECTOR3F = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        public Vector3f decode(ByteBuf var0) {
            return PacketDataSerializer.readVector3f(var0);
        }

        @Override
        public void encode(ByteBuf var0, Vector3f var1) {
            PacketDataSerializer.writeVector3f(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vector3f)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionf>(){

        @Override
        public Quaternionf decode(ByteBuf var0) {
            return PacketDataSerializer.readQuaternion(var0);
        }

        @Override
        public void encode(ByteBuf var0, Quaternionf var1) {
            PacketDataSerializer.writeQuaternion(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Quaternionf)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> CONTAINER_ID = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return PacketDataSerializer.readContainerId(var0);
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            PacketDataSerializer.writeContainerId(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int MAX_PROPERTY_NAME_LENGTH = 64;
        private static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
        private static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
        private static final int MAX_PROPERTIES = 16;

        @Override
        public PropertyMap decode(ByteBuf var02) {
            int var1 = ByteBufCodecs.readCount(var02, 16);
            ImmutableMultimap.Builder var2 = ImmutableMultimap.builder();
            for (int var3 = 0; var3 < var1; ++var3) {
                String var4 = Utf8String.read(var02, 64);
                String var5 = Utf8String.read(var02, Short.MAX_VALUE);
                String var6 = PacketDataSerializer.readNullable(var02, var0 -> Utf8String.read(var0, 1024));
                Property var7 = new Property(var4, var5, var6);
                var2.put((Object)var7.name(), (Object)var7);
            }
            return new PropertyMap((Multimap)var2.build());
        }

        @Override
        public void encode(ByteBuf var02, PropertyMap var12) {
            ByteBufCodecs.writeCount(var02, var12.size(), 16);
            for (Property var3 : var12.values()) {
                Utf8String.write(var02, var3.name(), 64);
                Utf8String.write(var02, var3.value(), Short.MAX_VALUE);
                PacketDataSerializer.writeNullable(var02, var3.signature(), (var0, var1) -> Utf8String.write(var0, var1, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (PropertyMap)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final StreamCodec<ByteBuf, String> PLAYER_NAME = ByteBufCodecs.stringUtf8(16);
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = StreamCodec.composite(UUIDUtil.STREAM_CODEC, GameProfile::id, PLAYER_NAME, GameProfile::name, GAME_PROFILE_PROPERTIES, GameProfile::properties, GameProfile::new);
    public static final StreamCodec<ByteBuf, Integer> RGB_COLOR = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf var0) {
            return ARGB.color(var0.readByte() & 0xFF, var0.readByte() & 0xFF, var0.readByte() & 0xFF);
        }

        @Override
        public void encode(ByteBuf var0, Integer var1) {
            var0.writeByte(ARGB.red(var1));
            var0.writeByte(ARGB.green(var1));
            var0.writeByte(ARGB.blue(var1));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Integer)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int var0) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            public byte[] decode(ByteBuf var02) {
                return PacketDataSerializer.readByteArray(var02, var0);
            }

            @Override
            public void encode(ByteBuf var02, byte[] var1) {
                if (var1.length > var0) {
                    throw new EncoderException("ByteArray with size " + var1.length + " is bigger than allowed " + var0);
                }
                PacketDataSerializer.writeByteArray(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (byte[])object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int var0) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            public String decode(ByteBuf var02) {
                return Utf8String.read(var02, var0);
            }

            @Override
            public void encode(ByteBuf var02, String var1) {
                Utf8String.write(var02, var1, var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (String)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, Optional<NBTBase>> optionalTagCodec(final Supplier<NBTReadLimiter> var0) {
        return new StreamCodec<ByteBuf, Optional<NBTBase>>(){

            @Override
            public Optional<NBTBase> decode(ByteBuf var02) {
                return Optional.ofNullable(PacketDataSerializer.readNbt(var02, (NBTReadLimiter)var0.get()));
            }

            @Override
            public void encode(ByteBuf var02, Optional<NBTBase> var1) {
                PacketDataSerializer.writeNbt(var02, var1.orElse(null));
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTBase> tagCodec(final Supplier<NBTReadLimiter> var0) {
        return new StreamCodec<ByteBuf, NBTBase>(){

            @Override
            public NBTBase decode(ByteBuf var02) {
                NBTBase var1 = PacketDataSerializer.readNbt(var02, (NBTReadLimiter)var0.get());
                if (var1 == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return var1;
            }

            @Override
            public void encode(ByteBuf var02, NBTBase var1) {
                if (var1 == NBTTagEnd.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                PacketDataSerializer.writeNbt(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (NBTBase)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTTagCompound> compoundTagCodec(Supplier<NBTReadLimiter> var02) {
        return ByteBufCodecs.tagCodec(var02).map(var0 -> {
            if (var0 instanceof NBTTagCompound) {
                NBTTagCompound var1 = (NBTTagCompound)var0;
                return var1;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(var0));
        }, var0 -> var0);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> var0) {
        return ByteBufCodecs.fromCodec(var0, NBTReadLimiter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> var0) {
        return ByteBufCodecs.fromCodec(var0, () -> NBTReadLimiter.create(0x200000L));
    }

    public static <T, B extends ByteBuf, V> StreamCodec.a<B, T, V> fromCodec(final DynamicOps<T> var0, final Codec<V> var1) {
        return var2 -> new StreamCodec<B, V>(){

            @Override
            public V decode(B var02) {
                Object var12 = var2.decode(var02);
                return var1.parse(var0, var12).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var12)));
            }

            @Override
            public void encode(B var02, V var12) {
                Object var22 = var1.encodeStart(var0, var12).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)));
                var2.encode(var02, var22);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> var0, Supplier<NBTReadLimiter> var1) {
        return ByteBufCodecs.tagCodec(var1).apply(ByteBufCodecs.fromCodec(DynamicOpsNBT.INSTANCE, var0));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> var0) {
        return ByteBufCodecs.fromCodecWithRegistries(var0, NBTReadLimiter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> var0) {
        return ByteBufCodecs.fromCodecWithRegistries(var0, () -> NBTReadLimiter.create(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> var0, Supplier<NBTReadLimiter> var1) {
        final StreamCodec<ByteBuf, NBTBase> var2 = ByteBufCodecs.tagCodec(var1);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            public T decode(RegistryFriendlyByteBuf var02) {
                NBTBase var12 = (NBTBase)var2.decode(var02);
                RegistryOps<NBTBase> var22 = var02.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
                return var0.parse(var22, (Object)var12).getOrThrow(var1 -> new DecoderException("Failed to decode: " + var1 + " " + String.valueOf(var12)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, T var12) {
                RegistryOps<NBTBase> var22 = var02.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
                NBTBase var3 = (NBTBase)var0.encodeStart(var22, var12).getOrThrow(var1 -> new EncoderException("Failed to encode: " + var1 + " " + String.valueOf(var12)));
                var2.encode(var02, var3);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<? super B, V> var0) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B var02) {
                if (var02.readBoolean()) {
                    return Optional.of(var0.decode(var02));
                }
                return Optional.empty();
            }

            @Override
            public void encode(B var02, Optional<V> var1) {
                if (var1.isPresent()) {
                    var02.writeBoolean(true);
                    var0.encode(var02, var1.get());
                } else {
                    var02.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Optional)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static int readCount(ByteBuf var0, int var1) {
        int var2 = VarInt.read(var0);
        if (var2 > var1) {
            throw new DecoderException(var2 + " elements exceeded max size of: " + var1);
        }
        return var2;
    }

    public static void writeCount(ByteBuf var0, int var1, int var2) {
        if (var1 > var2) {
            throw new EncoderException(var1 + " elements exceeded max size of: " + var2);
        }
        VarInt.write(var0, var1);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> var0, StreamCodec<? super B, V> var1) {
        return ByteBufCodecs.collection(var0, var1, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> var0, final StreamCodec<? super B, V> var1, final int var2) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B var02) {
                int var12 = ByteBufCodecs.readCount(var02, var2);
                Collection var22 = (Collection)var0.apply(Math.min(var12, 65536));
                for (int var3 = 0; var3 < var12; ++var3) {
                    var22.add(var1.decode(var02));
                }
                return var22;
            }

            @Override
            public void encode(B var02, C var12) {
                ByteBufCodecs.writeCount(var02, var12.size(), var2);
                for (Object var3 : var12) {
                    var1.encode(var02, var3);
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (C)((Collection)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.a<B, V, C> collection(IntFunction<C> var0) {
        return var1 -> ByteBufCodecs.collection(var0, var1);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> list() {
        return var0 -> ByteBufCodecs.collection(ArrayList::new, var0);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> list(int var0) {
        return var1 -> ByteBufCodecs.collection(ArrayList::new, var1, var0);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> var0, StreamCodec<? super B, K> var1, StreamCodec<? super B, V> var2) {
        return ByteBufCodecs.map(var0, var1, var2, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> var0, final StreamCodec<? super B, K> var1, final StreamCodec<? super B, V> var2, final int var3) {
        return new StreamCodec<B, M>(){

            @Override
            public void encode(B var02, M var12) {
                ByteBufCodecs.writeCount(var02, var12.size(), var3);
                var12.forEach((var3, var4) -> {
                    var1.encode(var02, var3);
                    var2.encode(var02, var4);
                });
            }

            @Override
            public M decode(B var02) {
                int var12 = ByteBufCodecs.readCount(var02, var3);
                Map var22 = (Map)var0.apply(Math.min(var12, 65536));
                for (int var32 = 0; var32 < var12; ++var32) {
                    Object var4 = var1.decode(var02);
                    Object var5 = var2.decode(var02);
                    var22.put(var4, var5);
                }
                return var22;
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (M)((Map)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> var0, final StreamCodec<? super B, R> var1) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B var02) {
                if (var02.readBoolean()) {
                    return Either.left(var0.decode(var02));
                }
                return Either.right(var1.decode(var02));
            }

            @Override
            public void encode(B var02, Either<L, R> var12) {
                var12.ifLeft(var2 -> {
                    var02.writeBoolean(true);
                    var0.encode(var02, var2);
                }).ifRight(var2 -> {
                    var02.writeBoolean(false);
                    var1.encode(var02, var2);
                });
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((Object)((ByteBuf)object), (Either)((Either)object2));
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, V> lengthPrefixed(final int var0, final BiFunction<B, ByteBuf, B> var1) {
        return var2 -> new StreamCodec<B, V>(){

            @Override
            public V decode(B var02) {
                int var12 = VarInt.read(var02);
                if (var12 > var0) {
                    throw new DecoderException("Buffer size " + var12 + " is larger than allowed limit of " + var0);
                }
                int var22 = var02.readerIndex();
                ByteBuf var3 = (ByteBuf)var1.apply(var02, var02.slice(var22, var12));
                var02.readerIndex(var22 + var12);
                return var2.decode(var3);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void encode(B var02, V var12) {
                ByteBuf var22 = (ByteBuf)var1.apply(var02, var02.alloc().buffer());
                try {
                    var2.encode(var22, var12);
                    int var3 = var22.readableBytes();
                    if (var3 > var0) {
                        throw new EncoderException("Buffer size " + var3 + " is  larger than allowed limit of " + var0);
                    }
                    VarInt.write(var02, var3);
                    var02.writeBytes(var22);
                }
                finally {
                    var22.release();
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((B)((ByteBuf)object), (V)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((B)((ByteBuf)object));
            }
        };
    }

    public static <V> StreamCodec.a<ByteBuf, V, V> lengthPrefixed(int var02) {
        return ByteBufCodecs.lengthPrefixed(var02, (var0, var1) -> var1);
    }

    public static <V> StreamCodec.a<RegistryFriendlyByteBuf, V, V> registryFriendlyLengthPrefixed(int var02) {
        return ByteBufCodecs.lengthPrefixed(var02, (var0, var1) -> new RegistryFriendlyByteBuf((ByteBuf)var1, var0.registryAccess()));
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> var0, final ToIntFunction<T> var1) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T decode(ByteBuf var02) {
                int var12 = VarInt.read(var02);
                return var0.apply(var12);
            }

            @Override
            public void encode(ByteBuf var02, T var12) {
                int var2 = var1.applyAsInt(var12);
                VarInt.write(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(Registry<T> var0) {
        return ByteBufCodecs.idMapper(var0::byIdOrThrow, var0::getIdOrThrow);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends IRegistry<T>> var0, final Function<IRegistry<T>, Registry<R>> var1) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private Registry<R> getRegistryOrThrow(RegistryFriendlyByteBuf var02) {
                return (Registry)var1.apply(var02.registryAccess().lookupOrThrow(var0));
            }

            @Override
            public R decode(RegistryFriendlyByteBuf var02) {
                int var12 = VarInt.read(var02);
                return this.getRegistryOrThrow(var02).byIdOrThrow(var12);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, R var12) {
                int var2 = this.getRegistryOrThrow(var02).getIdOrThrow(var12);
                VarInt.write(var02, var2);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends IRegistry<T>> var02) {
        return ByteBufCodecs.registry(var02, var0 -> var0);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends IRegistry<T>> var0) {
        return ByteBufCodecs.registry(var0, IRegistry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends IRegistry<T>> var0, final StreamCodec<? super RegistryFriendlyByteBuf, T> var1) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private Registry<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf var02) {
                return var02.registryAccess().lookupOrThrow(var0).asHolderIdMap();
            }

            @Override
            public Holder<T> decode(RegistryFriendlyByteBuf var02) {
                int var12 = VarInt.read(var02);
                if (var12 == 0) {
                    return Holder.direct(var1.decode(var02));
                }
                return this.getRegistryOrThrow(var02).byIdOrThrow(var12 - 1);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, Holder<T> var12) {
                switch (var12.kind()) {
                    case REFERENCE: {
                        int var2 = this.getRegistryOrThrow(var02).getIdOrThrow(var12);
                        VarInt.write(var02, var2 + 1);
                        break;
                    }
                    case DIRECT: {
                        VarInt.write(var02, 0);
                        var1.encode(var02, var12.value());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (Holder)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends IRegistry<T>> var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry(var0);
            }

            @Override
            public HolderSet<T> decode(RegistryFriendlyByteBuf var02) {
                int var1 = VarInt.read(var02) - 1;
                if (var1 == -1) {
                    HolderLookup.b var2 = var02.registryAccess().lookupOrThrow(var0);
                    return (HolderSet)var2.get(TagKey.create(var0, (MinecraftKey)MinecraftKey.STREAM_CODEC.decode(var02))).orElseThrow();
                }
                ArrayList<Holder> var2 = new ArrayList<Holder>(Math.min(var1, 65536));
                for (int var3 = 0; var3 < var1; ++var3) {
                    var2.add((Holder)this.holderCodec.decode(var02));
                }
                return HolderSet.direct(var2);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, HolderSet<T> var1) {
                Optional var2 = var1.unwrapKey();
                if (var2.isPresent()) {
                    VarInt.write(var02, 0);
                    MinecraftKey.STREAM_CODEC.encode(var02, var2.get().location());
                } else {
                    VarInt.write(var02, var1.size() + 1);
                    for (Holder holder : var1) {
                        this.holderCodec.encode(var02, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (HolderSet)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static StreamCodec<ByteBuf, JsonElement> lenientJson(final int var0) {
        return new StreamCodec<ByteBuf, JsonElement>(){
            private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

            @Override
            public JsonElement decode(ByteBuf var02) {
                String var1 = Utf8String.read(var02, var0);
                try {
                    return LenientJsonParser.parse(var1);
                }
                catch (JsonSyntaxException var2) {
                    throw new DecoderException("Failed to parse JSON", (Throwable)var2);
                }
            }

            @Override
            public void encode(ByteBuf var02, JsonElement var1) {
                String var2 = GSON.toJson(var1);
                Utf8String.write(var02, var2, var0);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((ByteBuf)object, (JsonElement)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((ByteBuf)object);
            }
        };
    }
}

