/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public record PacketPlayOutMap(MapId mapId, byte scale, boolean locked, Optional<List<MapIcon>> decorations, Optional<WorldMap.c> colorPatch) implements Packet<PacketListenerPlayOut>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutMap> STREAM_CODEC = StreamCodec.composite(MapId.STREAM_CODEC, PacketPlayOutMap::mapId, ByteBufCodecs.BYTE, PacketPlayOutMap::scale, ByteBufCodecs.BOOL, PacketPlayOutMap::locked, MapIcon.STREAM_CODEC.apply(ByteBufCodecs.list()).apply(ByteBufCodecs::optional), PacketPlayOutMap::decorations, WorldMap.c.STREAM_CODEC, PacketPlayOutMap::colorPatch, PacketPlayOutMap::new);

    public PacketPlayOutMap(MapId var0, byte var1, boolean var2, @Nullable Collection<MapIcon> var3, @Nullable WorldMap.c var4) {
        this(var0, var1, var2, var3 != null ? Optional.of(List.copyOf(var3)) : Optional.empty(), Optional.ofNullable(var4));
    }

    @Override
    public PacketType<PacketPlayOutMap> type() {
        return GamePacketTypes.CLIENTBOUND_MAP_ITEM_DATA;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMapItemData(this);
    }

    public void applyToMap(WorldMap var0) {
        this.decorations.ifPresent(var0::addClientSideDecorations);
        this.colorPatch.ifPresent(var1 -> var1.applyToMap(var0));
    }
}

