/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutWorldParticles
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutWorldParticles> STREAM_CODEC = Packet.codec(PacketPlayOutWorldParticles::write, PacketPlayOutWorldParticles::new);
    private final double x;
    private final double y;
    private final double z;
    private final float xDist;
    private final float yDist;
    private final float zDist;
    private final float maxSpeed;
    private final int count;
    private final boolean overrideLimiter;
    private final boolean alwaysShow;
    private final ParticleParam particle;

    public <T extends ParticleParam> PacketPlayOutWorldParticles(T var0, boolean var1, boolean var2, double var3, double var5, double var7, float var9, float var10, float var11, float var12, int var13) {
        this.particle = var0;
        this.overrideLimiter = var1;
        this.alwaysShow = var2;
        this.x = var3;
        this.y = var5;
        this.z = var7;
        this.xDist = var9;
        this.yDist = var10;
        this.zDist = var11;
        this.maxSpeed = var12;
        this.count = var13;
    }

    private PacketPlayOutWorldParticles(RegistryFriendlyByteBuf var0) {
        this.overrideLimiter = var0.readBoolean();
        this.alwaysShow = var0.readBoolean();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.xDist = var0.readFloat();
        this.yDist = var0.readFloat();
        this.zDist = var0.readFloat();
        this.maxSpeed = var0.readFloat();
        this.count = var0.readInt();
        this.particle = (ParticleParam)Particles.STREAM_CODEC.decode(var0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeBoolean(this.overrideLimiter);
        var0.writeBoolean(this.alwaysShow);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.xDist);
        var0.writeFloat(this.yDist);
        var0.writeFloat(this.zDist);
        var0.writeFloat(this.maxSpeed);
        var0.writeInt(this.count);
        Particles.STREAM_CODEC.encode(var0, this.particle);
    }

    @Override
    public PacketType<PacketPlayOutWorldParticles> type() {
        return GamePacketTypes.CLIENTBOUND_LEVEL_PARTICLES;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleParticleEvent(this);
    }

    public boolean isOverrideLimiter() {
        return this.overrideLimiter;
    }

    public boolean alwaysShow() {
        return this.alwaysShow;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getXDist() {
        return this.xDist;
    }

    public float getYDist() {
        return this.yDist;
    }

    public float getZDist() {
        return this.zDist;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getCount() {
        return this.count;
    }

    public ParticleParam getParticle() {
        return this.particle;
    }
}

