/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.PlayerList;

public class CommandBanList {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("banlist").requires(net.minecraft.commands.CommandDispatcher.hasPermission(3))).executes(var0 -> {
            PlayerList var1 = ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList();
            return CommandBanList.showList((CommandListenerWrapper)var0.getSource(), Lists.newArrayList((Iterable)Iterables.concat(var1.getBans().getEntries(), var1.getIpBans().getEntries())));
        })).then(net.minecraft.commands.CommandDispatcher.literal("ips").executes(var0 -> CommandBanList.showList((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getIpBans().getEntries())))).then(net.minecraft.commands.CommandDispatcher.literal("players").executes(var0 -> CommandBanList.showList((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getServer().getPlayerList().getBans().getEntries()))));
    }

    private static int showList(CommandListenerWrapper var0, Collection<? extends ExpirableListEntry<?>> var1) {
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.banlist.none"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.banlist.list", var1.size()), false);
            for (ExpirableListEntry<?> var3 : var1) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.banlist.entry", var3.getDisplayName(), var3.getSource(), var3.getReasonMessage()), false);
            }
        }
        return var1.size();
    }
}

