/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class CommandDebug {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_NOT_RUNNING = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_RUNNING = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.debug.alreadyRunning"));
    static final SimpleCommandExceptionType NO_RECURSIVE_TRACES = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.debug.function.noRecursion"));
    static final SimpleCommandExceptionType NO_RETURN_RUN = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.debug.function.noReturnRun"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("debug").requires(net.minecraft.commands.CommandDispatcher.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.literal("start").executes(var0 -> CommandDebug.start((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> CommandDebug.stop((CommandListenerWrapper)var0.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("function").requires(net.minecraft.commands.CommandDispatcher.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.argument("name", ArgumentTag.functions()).suggests(CommandFunction.SUGGEST_FUNCTION).executes((Command)new a()))));
    }

    private static int start(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (var1.isTimeProfilerRunning()) {
            throw ERROR_ALREADY_RUNNING.create();
        }
        var1.startTimeProfiler();
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.debug.started"), true);
        return 0;
    }

    private static int stop(CommandListenerWrapper var0) throws CommandSyntaxException {
        MinecraftServer var1 = var0.getServer();
        if (!var1.isTimeProfilerRunning()) {
            throw ERROR_NOT_RUNNING.create();
        }
        MethodProfilerResults var2 = var1.stopTimeProfiler();
        double var3 = (double)var2.getNanoDuration() / (double)TimeRange.NANOSECONDS_PER_SECOND;
        double var5 = (double)var2.getTickDuration() / var3;
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", var3), var2.getTickDuration(), String.format(Locale.ROOT, "%.2f", var5)), true);
        return (int)var5;
    }

    static class a
    extends CustomCommandExecutor.b<CommandListenerWrapper>
    implements CustomCommandExecutor.a<CommandListenerWrapper> {
        a() {
        }

        @Override
        public void runGuarded(CommandListenerWrapper var0, ContextChain<CommandListenerWrapper> var1, ChainModifiers var2, ExecutionControl<CommandListenerWrapper> var3) throws CommandSyntaxException {
            if (var2.isReturn()) {
                throw NO_RETURN_RUN.create();
            }
            if (var3.tracer() != null) {
                throw NO_RECURSIVE_TRACES.create();
            }
            CommandContext var42 = var1.getTopContext();
            Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>> var52 = ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var42, "name");
            MinecraftServer var6 = var0.getServer();
            String var7 = "debug-trace-" + SystemUtils.getFilenameFormattedDateTime() + ".txt";
            CommandDispatcher<CommandListenerWrapper> var8 = var0.getServer().getFunctions().getDispatcher();
            int var9 = 0;
            try {
                Path var10 = var6.getFile("debug");
                Files.createDirectories(var10, new FileAttribute[0]);
                final PrintWriter var11 = new PrintWriter(Files.newBufferedWriter(var10.resolve(var7), StandardCharsets.UTF_8, new OpenOption[0]));
                b var12 = new b(var11);
                var3.tracer(var12);
                for (final net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper> var14 : var52) {
                    try {
                        CommandListenerWrapper var15 = var0.withSource(var12).withMaximumPermission(2);
                        InstantiatedFunction<CommandListenerWrapper> var16 = var14.instantiate(null, var8);
                        var3.queueNext(new CallFunction<CommandListenerWrapper>(this, var16, CommandResultCallback.EMPTY, false){

                            @Override
                            public void execute(CommandListenerWrapper var0, ExecutionContext<CommandListenerWrapper> var1, Frame var2) {
                                var11.println(var14.id());
                                super.execute(var0, var1, var2);
                            }

                            @Override
                            public /* synthetic */ void execute(Object object, ExecutionContext executionContext, Frame frame) {
                                this.execute((CommandListenerWrapper)object, (ExecutionContext<CommandListenerWrapper>)executionContext, frame);
                            }
                        }.bind(var15));
                        var9 += var16.entries().size();
                    }
                    catch (FunctionInstantiationException var15) {
                        var0.sendFailure(var15.messageComponent());
                    }
                }
            }
            catch (IOException | UncheckedIOException var10) {
                LOGGER.warn("Tracing failed", (Throwable)var10);
                var0.sendFailure(IChatBaseComponent.translatable("commands.debug.function.traceFailed"));
            }
            int var10 = var9;
            var3.queueNext((var4, var5) -> {
                if (var52.size() == 1) {
                    var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.debug.function.success.single", var10, IChatBaseComponent.translationArg(((net.minecraft.commands.functions.CommandFunction)var52.iterator().next()).id()), var7), true);
                } else {
                    var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.debug.function.success.multiple", var10, var52.size(), var7), true);
                }
            });
        }

        @Override
        public /* synthetic */ void runGuarded(ExecutionCommandSource executionCommandSource, ContextChain contextChain, ChainModifiers chainModifiers, ExecutionControl executionControl) throws CommandSyntaxException {
            this.runGuarded((CommandListenerWrapper)executionCommandSource, (ContextChain<CommandListenerWrapper>)contextChain, chainModifiers, (ExecutionControl<CommandListenerWrapper>)executionControl);
        }
    }

    static class b
    implements ICommandListener,
    TraceCallbacks {
        public static final int INDENT_OFFSET = 1;
        private final PrintWriter output;
        private int lastIndent;
        private boolean waitingForResult;

        b(PrintWriter var0) {
            this.output = var0;
        }

        private void indentAndSave(int var0) {
            this.printIndent(var0);
            this.lastIndent = var0;
        }

        private void printIndent(int var0) {
            for (int var1 = 0; var1 < var0 + 1; ++var1) {
                this.output.write("    ");
            }
        }

        private void newLine() {
            if (this.waitingForResult) {
                this.output.println();
                this.waitingForResult = false;
            }
        }

        @Override
        public void onCommand(int var0, String var1) {
            this.newLine();
            this.indentAndSave(var0);
            this.output.print("[C] ");
            this.output.print(var1);
            this.waitingForResult = true;
        }

        @Override
        public void onReturn(int var0, String var1, int var2) {
            if (this.waitingForResult) {
                this.output.print(" -> ");
                this.output.println(var2);
                this.waitingForResult = false;
            } else {
                this.indentAndSave(var0);
                this.output.print("[R = ");
                this.output.print(var2);
                this.output.print("] ");
                this.output.println(var1);
            }
        }

        @Override
        public void onCall(int var0, MinecraftKey var1, int var2) {
            this.newLine();
            this.indentAndSave(var0);
            this.output.print("[F] ");
            this.output.print(var1);
            this.output.print(" size=");
            this.output.println(var2);
        }

        @Override
        public void onError(String var0) {
            this.newLine();
            this.indentAndSave(this.lastIndent + 1);
            this.output.print("[E] ");
            this.output.print(var0);
        }

        @Override
        public void sendSystemMessage(IChatBaseComponent var0) {
            this.newLine();
            this.printIndent(this.lastIndent + 1);
            this.output.print("[M] ");
            this.output.println(var0.getString());
        }

        @Override
        public boolean acceptsSuccess() {
            return true;
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }

        @Override
        public boolean alwaysAccepts() {
            return true;
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((Writer)this.output);
        }
    }
}

