/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.time.Duration;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class CommandLocate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_NOT_FOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.locate.structure.not_found", var0));
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.locate.structure.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.locate.biome.not_found", var0));
    private static final DynamicCommandExceptionType ERROR_POI_NOT_FOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.locate.poi.not_found", var0));
    private static final int MAX_STRUCTURE_SEARCH_RADIUS = 100;
    private static final int MAX_BIOME_SEARCH_RADIUS = 6400;
    private static final int BIOME_SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int BIOME_SAMPLE_RESOLUTION_VERTICAL = 64;
    private static final int POI_SEARCH_RADIUS = 256;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("locate").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("structure").then(net.minecraft.commands.CommandDispatcher.argument("structure", ResourceOrTagKeyArgument.resourceOrTagKey(Registries.STRUCTURE)).executes(var0 -> CommandLocate.locateStructure((CommandListenerWrapper)var0.getSource(), ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext<CommandListenerWrapper>)var0, "structure", Registries.STRUCTURE, ERROR_STRUCTURE_INVALID)))))).then(net.minecraft.commands.CommandDispatcher.literal("biome").then(net.minecraft.commands.CommandDispatcher.argument("biome", ResourceOrTagArgument.resourceOrTag(var1, Registries.BIOME)).executes(var0 -> CommandLocate.locateBiome((CommandListenerWrapper)var0.getSource(), ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandListenerWrapper>)var0, "biome", Registries.BIOME)))))).then(net.minecraft.commands.CommandDispatcher.literal("poi").then(net.minecraft.commands.CommandDispatcher.argument("poi", ResourceOrTagArgument.resourceOrTag(var1, Registries.POINT_OF_INTEREST_TYPE)).executes(var0 -> CommandLocate.locatePoi((CommandListenerWrapper)var0.getSource(), ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandListenerWrapper>)var0, "poi", Registries.POINT_OF_INTEREST_TYPE))))));
    }

    private static Optional<? extends HolderSet.b<Structure>> getHolders(ResourceOrTagKeyArgument.c<Structure> var0, IRegistry<Structure> var12) {
        return (Optional)var0.unwrap().map(var1 -> var12.get((ResourceKey)var1).map(var0 -> HolderSet.direct(var0)), var12::get);
    }

    private static int locateStructure(CommandListenerWrapper var0, ResourceOrTagKeyArgument.c<Structure> var1) throws CommandSyntaxException {
        HolderLookup.b var2 = var0.getLevel().registryAccess().lookupOrThrow(Registries.STRUCTURE);
        HolderSet var3 = CommandLocate.getHolders(var1, (IRegistry<Structure>)var2).orElseThrow(() -> ERROR_STRUCTURE_INVALID.create((Object)var1.asPrintable()));
        BlockPosition var4 = BlockPosition.containing(var0.getPosition());
        WorldServer var5 = var0.getLevel();
        Stopwatch var6 = Stopwatch.createStarted((Ticker)SystemUtils.TICKER);
        Pair<BlockPosition, Holder<Structure>> var7 = var5.getChunkSource().getGenerator().findNearestMapStructure(var5, var3, var4, 100, false);
        var6.stop();
        if (var7 == null) {
            throw ERROR_STRUCTURE_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var4, var7, "commands.locate.structure.success", false, var6.elapsed());
    }

    private static int locateBiome(CommandListenerWrapper var0, ResourceOrTagArgument.c<BiomeBase> var1) throws CommandSyntaxException {
        BlockPosition var2 = BlockPosition.containing(var0.getPosition());
        Stopwatch var3 = Stopwatch.createStarted((Ticker)SystemUtils.TICKER);
        Pair<BlockPosition, Holder<BiomeBase>> var4 = var0.getLevel().findClosestBiome3d(var1, var2, 6400, 32, 64);
        var3.stop();
        if (var4 == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var2, var4, "commands.locate.biome.success", true, var3.elapsed());
    }

    private static int locatePoi(CommandListenerWrapper var0, ResourceOrTagArgument.c<VillagePlaceType> var1) throws CommandSyntaxException {
        BlockPosition var2 = BlockPosition.containing(var0.getPosition());
        WorldServer var3 = var0.getLevel();
        Stopwatch var4 = Stopwatch.createStarted((Ticker)SystemUtils.TICKER);
        Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> var5 = var3.getPoiManager().findClosestWithType(var1, var2, 256, VillagePlace.Occupancy.ANY);
        var4.stop();
        if (var5.isEmpty()) {
            throw ERROR_POI_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var2, var5.get().swap(), "commands.locate.poi.success", false, var4.elapsed());
    }

    public static int showLocateResult(CommandListenerWrapper var0, ResourceOrTagArgument.c<?> var12, BlockPosition var22, Pair<BlockPosition, ? extends Holder<?>> var3, String var4, boolean var5, Duration var6) {
        String var7 = (String)var12.unwrap().map(var1 -> var12.asPrintable(), var2 -> var12.asPrintable() + " (" + ((Holder)var3.getSecond()).getRegisteredName() + ")");
        return CommandLocate.showLocateResult(var0, var22, var3, var4, var5, var7, var6);
    }

    public static int showLocateResult(CommandListenerWrapper var02, ResourceOrTagKeyArgument.c<?> var12, BlockPosition var2, Pair<BlockPosition, ? extends Holder<?>> var3, String var4, boolean var5, Duration var6) {
        String var7 = (String)var12.unwrap().map(var0 -> var0.location().toString(), var1 -> "#" + String.valueOf(var1.location()) + " (" + ((Holder)var3.getSecond()).getRegisteredName() + ")");
        return CommandLocate.showLocateResult(var02, var2, var3, var4, var5, var7, var6);
    }

    private static int showLocateResult(CommandListenerWrapper var0, BlockPosition var1, Pair<BlockPosition, ? extends Holder<?>> var22, String var3, boolean var4, String var5, Duration var6) {
        BlockPosition var7 = (BlockPosition)var22.getFirst();
        int var8 = var4 ? MathHelper.floor(MathHelper.sqrt((float)var1.distSqr(var7))) : MathHelper.floor(CommandLocate.dist(var1.getX(), var1.getZ(), var7.getX(), var7.getZ()));
        String var9 = var4 ? String.valueOf(var7.getY()) : "~";
        IChatMutableComponent var10 = ChatComponentUtils.wrapInSquareBrackets(IChatBaseComponent.translatable("chat.coordinates", var7.getX(), var9, var7.getZ())).withStyle(var2 -> var2.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable.SuggestCommand("/tp @s " + var7.getX() + " " + var9 + " " + var7.getZ())).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.translatable("chat.coordinates.tooltip"))));
        var0.sendSuccess(() -> IChatBaseComponent.translatable(var3, var5, var10, var8), false);
        LOGGER.info("Locating element {} took {} ms", (Object)var5, (Object)var6.toMillis());
        return var8;
    }

    private static float dist(int var0, int var1, int var2, int var3) {
        int var4 = var2 - var0;
        int var5 = var3 - var1;
        return MathHelper.sqrt(var4 * var4 + var5 * var5);
    }
}

