/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;

public interface OutgoingRpcMethod<Params, Result> {
    public static final String NOTIFICATION_PREFIX = "notification/";

    public MethodInfo info();

    public a attributes();

    @Nullable
    default public JsonElement encodeParams(Params var0) {
        return null;
    }

    @Nullable
    default public Result decodeResult(JsonElement var0) {
        return null;
    }

    public static e<g> notification() {
        return new e<g>((var0, var1) -> {
            if (var0.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (var0.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new g(var0, var1);
        });
    }

    public static <Params> e<d<Params>> notification(Codec<Params> var0) {
        return new e<d<Params>>((var1, var2) -> {
            if (var1.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (var1.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new d(var1, var2, var0);
        });
    }

    public static <Result> e<f<Result>> request(Codec<Result> var0) {
        return new e<f<Result>>((var1, var2) -> {
            if (var1.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (var1.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new f(var1, var2, var0);
        });
    }

    public static <Params, Result> e<c<Params, Result>> request(Codec<Params> var0, Codec<Result> var1) {
        return new e<c<Params, Result>>((var2, var3) -> {
            if (var2.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (var2.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new c(var2, var3, var0, var1);
        });
    }

    public static class e<T extends OutgoingRpcMethod<?, ?>> {
        public static final a DEFAULT_ATTRIBUTES = new a(true);
        private final b<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;

        public e(b<T> var0) {
            this.method = var0;
        }

        public e<T> description(String var0) {
            this.description = var0;
            return this;
        }

        public e<T> response(ResultInfo var0) {
            this.resultInfo = var0;
            return this;
        }

        public e<T> param(ParamInfo var0) {
            this.paramInfo = var0;
            return this;
        }

        private T build() {
            MethodInfo var0 = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create(var0, DEFAULT_ATTRIBUTES);
        }

        public Holder.c<T> register(String var0) {
            return this.register(MinecraftKey.withDefaultNamespace(OutgoingRpcMethod.NOTIFICATION_PREFIX + var0));
        }

        private Holder.c<T> register(MinecraftKey var0) {
            return IRegistry.registerForHolder(BuiltInRegistries.OUTGOING_RPC_METHOD, var0, this.build());
        }
    }

    @FunctionalInterface
    public static interface b<T extends OutgoingRpcMethod<?, ?>> {
        public T create(MethodInfo var1, a var2);
    }

    public record c<Params, Result>(MethodInfo info, a attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec) implements OutgoingRpcMethod<Params, Result>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params var0) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, var0).getOrThrow();
        }

        @Override
        public Result decodeResult(JsonElement var0) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow();
        }
    }

    public record a(boolean discoverable) {
    }

    public record f<Result>(MethodInfo info, a attributes, Codec<Result> resultCodec) implements OutgoingRpcMethod<Void, Result>
    {
        @Override
        public Result decodeResult(JsonElement var0) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow();
        }
    }

    public record d<Params>(MethodInfo info, a attributes, Codec<Params> paramsCodec) implements OutgoingRpcMethod<Params, Void>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params var0) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, var0).getOrThrow();
        }
    }

    public record g(MethodInfo info, a attributes) implements OutgoingRpcMethod<Void, Void>
    {
    }
}

