/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameAndId;

public interface MinecraftPlayerListService {
    public List<EntityPlayer> getPlayers();

    @Nullable
    public EntityPlayer getPlayer(UUID var1);

    default public CompletableFuture<Optional<NameAndId>> getUser(Optional<UUID> var0, Optional<String> var1) {
        if (var0.isPresent()) {
            Optional<NameAndId> var2 = this.getCachedUserById(var0.get());
            if (var2.isPresent()) {
                return CompletableFuture.completedFuture(var2);
            }
            return CompletableFuture.supplyAsync(() -> this.fetchUserById((UUID)var0.get()), SystemUtils.nonCriticalIoPool());
        }
        if (var1.isPresent()) {
            return CompletableFuture.supplyAsync(() -> this.fetchUserByName((String)var1.get()), SystemUtils.nonCriticalIoPool());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public Optional<NameAndId> fetchUserByName(String var1);

    public Optional<NameAndId> fetchUserById(UUID var1);

    public Optional<NameAndId> getCachedUserById(UUID var1);

    public Optional<EntityPlayer> getPlayer(Optional<UUID> var1, Optional<String> var2);

    public List<EntityPlayer> getPlayersWithAddress(String var1);

    @Nullable
    public EntityPlayer getPlayerByName(String var1);

    public void remove(EntityPlayer var1, ClientInfo var2);
}

