/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<Boolean> AUTHENTICATED_KEY = AttributeKey.valueOf((String)"authenticated");
    public static final String AUTH_HEADER = "Authorization";
    public static final String BEARER_PREFIX = "Bearer ";
    private final SecurityConfig securityConfig;

    public AuthenticationHandler(SecurityConfig var0) {
        this.securityConfig = var0;
    }

    public void channelRead(ChannelHandlerContext var0, Object var1) throws Exception {
        Object var3;
        String var2 = this.getClientIp(var0);
        if (var1 instanceof HttpRequest) {
            var3 = (HttpRequest)var1;
            a var4 = this.performSecurityChecks((HttpRequest)var3);
            if (var4.isAllowed()) {
                var0.channel().attr(AUTHENTICATED_KEY).set((Object)true);
            } else {
                this.LOGGER.debug("Authentication rejected for connection with ip {}: {}", (Object)var2, (Object)var4.getReason());
                var0.channel().attr(AUTHENTICATED_KEY).set((Object)false);
                this.sendUnauthorizedResponse(var0, var4.getReason());
                return;
            }
        }
        if (Boolean.TRUE.equals(var3 = (Boolean)var0.channel().attr(AUTHENTICATED_KEY).get())) {
            super.channelRead(var0, var1);
        } else {
            this.LOGGER.debug("Dropping unauthenticated connection with ip {}", (Object)var2);
            var0.close();
        }
    }

    private a performSecurityChecks(HttpRequest var0) {
        if (!this.validateAuthentication(var0)) {
            return a.denied("Invalid or missing API key");
        }
        return a.allowed();
    }

    private boolean validateAuthentication(HttpRequest var0) {
        String var1 = var0.headers().get(AUTH_HEADER);
        if (var1 == null || var1.trim().isEmpty()) {
            return false;
        }
        if (!var1.startsWith(BEARER_PREFIX)) {
            return false;
        }
        String var2 = var1.substring(BEARER_PREFIX.length()).trim();
        return this.isValidApiKey(var2);
    }

    public boolean isValidApiKey(String var0) {
        if (var0 == null || var0.isEmpty()) {
            return false;
        }
        byte[] var1 = var0.getBytes(StandardCharsets.UTF_8);
        byte[] var2 = this.securityConfig.secretKey().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(var1, var2);
    }

    private String getClientIp(ChannelHandlerContext var0) {
        InetSocketAddress var1 = (InetSocketAddress)var0.channel().remoteAddress();
        return var1.getAddress().getHostAddress();
    }

    private void sendUnauthorizedResponse(ChannelHandlerContext var0, String var12) {
        String var2 = "{\"error\":\"Unauthorized\",\"message\":\"" + var12 + "\"}";
        byte[] var3 = var2.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse var4 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])var3));
        var4.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        var4.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)var3.length);
        var4.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        var0.writeAndFlush((Object)var4).addListener(var1 -> var0.close());
    }

    static class a {
        private final boolean allowed;
        private final String reason;

        private a(boolean var0, String var1) {
            this.allowed = var0;
            this.reason = var1;
        }

        public static a allowed() {
            return new a(true, null);
        }

        public static a denied(String var0) {
            return new a(false, var0);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

