/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.sounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;

public record SoundEffect(MinecraftKey location, Optional<Float> fixedRange) {
    public static final Codec<SoundEffect> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("sound_id").forGetter(SoundEffect::location), (App)Codec.FLOAT.lenientOptionalFieldOf("range").forGetter(SoundEffect::fixedRange)).apply((Applicative)var0, SoundEffect::create));
    public static final Codec<Holder<SoundEffect>> CODEC = RegistryFileCodec.create(Registries.SOUND_EVENT, DIRECT_CODEC);
    public static final StreamCodec<ByteBuf, SoundEffect> DIRECT_STREAM_CODEC = StreamCodec.composite(MinecraftKey.STREAM_CODEC, SoundEffect::location, ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), SoundEffect::fixedRange, SoundEffect::create);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SoundEffect>> STREAM_CODEC = ByteBufCodecs.holder(Registries.SOUND_EVENT, DIRECT_STREAM_CODEC);

    private static SoundEffect create(MinecraftKey var0, Optional<Float> var12) {
        return var12.map(var1 -> SoundEffect.createFixedRangeEvent(var0, var1.floatValue())).orElseGet(() -> SoundEffect.createVariableRangeEvent(var0));
    }

    public static SoundEffect createVariableRangeEvent(MinecraftKey var0) {
        return new SoundEffect(var0, Optional.empty());
    }

    public static SoundEffect createFixedRangeEvent(MinecraftKey var0, float var1) {
        return new SoundEffect(var0, Optional.of(Float.valueOf(var1)));
    }

    public float getRange(float var0) {
        return this.fixedRange.orElse(Float.valueOf(var0 > 1.0f ? 16.0f * var0 : 16.0f)).floatValue();
    }
}

