/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public class ARGB {
    public static int alpha(int var0) {
        return var0 >>> 24;
    }

    public static int red(int var0) {
        return var0 >> 16 & 0xFF;
    }

    public static int green(int var0) {
        return var0 >> 8 & 0xFF;
    }

    public static int blue(int var0) {
        return var0 & 0xFF;
    }

    public static int color(int var0, int var1, int var2, int var3) {
        return (var0 & 0xFF) << 24 | (var1 & 0xFF) << 16 | (var2 & 0xFF) << 8 | var3 & 0xFF;
    }

    public static int color(int var0, int var1, int var2) {
        return ARGB.color(255, var0, var1, var2);
    }

    public static int color(Vec3D var0) {
        return ARGB.color(ARGB.as8BitChannel((float)var0.x()), ARGB.as8BitChannel((float)var0.y()), ARGB.as8BitChannel((float)var0.z()));
    }

    public static int multiply(int var0, int var1) {
        if (var0 == -1) {
            return var1;
        }
        if (var1 == -1) {
            return var0;
        }
        return ARGB.color(ARGB.alpha(var0) * ARGB.alpha(var1) / 255, ARGB.red(var0) * ARGB.red(var1) / 255, ARGB.green(var0) * ARGB.green(var1) / 255, ARGB.blue(var0) * ARGB.blue(var1) / 255);
    }

    public static int scaleRGB(int var0, float var1) {
        return ARGB.scaleRGB(var0, var1, var1, var1);
    }

    public static int scaleRGB(int var0, float var1, float var2, float var3) {
        return ARGB.color(ARGB.alpha(var0), Math.clamp((long)((int)((float)ARGB.red(var0) * var1)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(var0) * var2)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(var0) * var3)), 0, 255));
    }

    public static int scaleRGB(int var0, int var1) {
        return ARGB.color(ARGB.alpha(var0), Math.clamp((long)ARGB.red(var0) * (long)var1 / 255L, 0, 255), Math.clamp((long)ARGB.green(var0) * (long)var1 / 255L, 0, 255), Math.clamp((long)ARGB.blue(var0) * (long)var1 / 255L, 0, 255));
    }

    public static int greyscale(int var0) {
        int var1 = (int)((float)ARGB.red(var0) * 0.3f + (float)ARGB.green(var0) * 0.59f + (float)ARGB.blue(var0) * 0.11f);
        return ARGB.color(var1, var1, var1);
    }

    public static int lerp(float var0, int var1, int var2) {
        int var3 = MathHelper.lerpInt(var0, ARGB.alpha(var1), ARGB.alpha(var2));
        int var4 = MathHelper.lerpInt(var0, ARGB.red(var1), ARGB.red(var2));
        int var5 = MathHelper.lerpInt(var0, ARGB.green(var1), ARGB.green(var2));
        int var6 = MathHelper.lerpInt(var0, ARGB.blue(var1), ARGB.blue(var2));
        return ARGB.color(var3, var4, var5, var6);
    }

    public static int opaque(int var0) {
        return var0 | 0xFF000000;
    }

    public static int transparent(int var0) {
        return var0 & 0xFFFFFF;
    }

    public static int color(int var0, int var1) {
        return var0 << 24 | var1 & 0xFFFFFF;
    }

    public static int color(float var0, int var1) {
        return ARGB.as8BitChannel(var0) << 24 | var1 & 0xFFFFFF;
    }

    public static int white(float var0) {
        return ARGB.as8BitChannel(var0) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float var0, float var1, float var2, float var3) {
        return ARGB.color(ARGB.as8BitChannel(var0), ARGB.as8BitChannel(var1), ARGB.as8BitChannel(var2), ARGB.as8BitChannel(var3));
    }

    public static Vector3f vector3fFromRGB24(int var0) {
        float var1 = (float)ARGB.red(var0) / 255.0f;
        float var2 = (float)ARGB.green(var0) / 255.0f;
        float var3 = (float)ARGB.blue(var0) / 255.0f;
        return new Vector3f(var1, var2, var3);
    }

    public static int average(int var0, int var1) {
        return ARGB.color((ARGB.alpha(var0) + ARGB.alpha(var1)) / 2, (ARGB.red(var0) + ARGB.red(var1)) / 2, (ARGB.green(var0) + ARGB.green(var1)) / 2, (ARGB.blue(var0) + ARGB.blue(var1)) / 2);
    }

    public static int as8BitChannel(float var0) {
        return MathHelper.floor(var0 * 255.0f);
    }

    public static float alphaFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.alpha(var0));
    }

    public static float redFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.red(var0));
    }

    public static float greenFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.green(var0));
    }

    public static float blueFloat(int var0) {
        return ARGB.from8BitChannel(ARGB.blue(var0));
    }

    private static float from8BitChannel(int var0) {
        return (float)var0 / 255.0f;
    }

    public static int toABGR(int var0) {
        return var0 & 0xFF00FF00 | (var0 & 0xFF0000) >> 16 | (var0 & 0xFF) << 16;
    }

    public static int fromABGR(int var0) {
        return ARGB.toABGR(var0);
    }

    public static int setBrightness(int var0, float var1) {
        float var13;
        float var12;
        float var11;
        float var10;
        int var2 = ARGB.red(var0);
        int var3 = ARGB.green(var0);
        int var4 = ARGB.blue(var0);
        int var5 = ARGB.alpha(var0);
        int var6 = Math.max(Math.max(var2, var3), var4);
        int var7 = Math.min(Math.min(var2, var3), var4);
        float var8 = var6 - var7;
        float var9 = var6 != 0 ? var8 / (float)var6 : 0.0f;
        if (var9 == 0.0f) {
            var10 = 0.0f;
        } else {
            var11 = (float)(var6 - var2) / var8;
            var12 = (float)(var6 - var3) / var8;
            var13 = (float)(var6 - var4) / var8;
            var10 = var2 == var6 ? var13 - var12 : (var3 == var6 ? 2.0f + var11 - var13 : 4.0f + var12 - var11);
            if ((var10 /= 6.0f) < 0.0f) {
                var10 += 1.0f;
            }
        }
        if (var9 == 0.0f) {
            var3 = var4 = Math.round(var1 * 255.0f);
            var2 = var4;
            return ARGB.color(var5, var2, var3, var4);
        }
        var11 = (var10 - (float)Math.floor(var10)) * 6.0f;
        var12 = var11 - (float)Math.floor(var11);
        var13 = var1 * (1.0f - var9);
        float var14 = var1 * (1.0f - var9 * var12);
        float var15 = var1 * (1.0f - var9 * (1.0f - var12));
        switch ((int)var11) {
            case 0: {
                var2 = Math.round(var1 * 255.0f);
                var3 = Math.round(var15 * 255.0f);
                var4 = Math.round(var13 * 255.0f);
                break;
            }
            case 1: {
                var2 = Math.round(var14 * 255.0f);
                var3 = Math.round(var1 * 255.0f);
                var4 = Math.round(var13 * 255.0f);
                break;
            }
            case 2: {
                var2 = Math.round(var13 * 255.0f);
                var3 = Math.round(var1 * 255.0f);
                var4 = Math.round(var15 * 255.0f);
                break;
            }
            case 3: {
                var2 = Math.round(var13 * 255.0f);
                var3 = Math.round(var14 * 255.0f);
                var4 = Math.round(var1 * 255.0f);
                break;
            }
            case 4: {
                var2 = Math.round(var15 * 255.0f);
                var3 = Math.round(var13 * 255.0f);
                var4 = Math.round(var1 * 255.0f);
                break;
            }
            case 5: {
                var2 = Math.round(var1 * 255.0f);
                var3 = Math.round(var13 * 255.0f);
                var4 = Math.round(var14 * 255.0f);
            }
        }
        return ARGB.color(var5, var2, var3, var4);
    }
}

