/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.core.EnumDirection;

public class SegmentedAnglePrecision {
    private final int mask;
    private final int precision;
    private final float degreeToAngle;
    private final float angleToDegree;

    public SegmentedAnglePrecision(int var0) {
        if (var0 < 2) {
            throw new IllegalArgumentException("Precision cannot be less than 2 bits");
        }
        if (var0 > 30) {
            throw new IllegalArgumentException("Precision cannot be greater than 30 bits");
        }
        int var1 = 1 << var0;
        this.mask = var1 - 1;
        this.precision = var0;
        this.degreeToAngle = (float)var1 / 360.0f;
        this.angleToDegree = 360.0f / (float)var1;
    }

    public boolean isSameAxis(int var0, int var1) {
        int var2 = this.getMask() >> 1;
        return (var0 & var2) == (var1 & var2);
    }

    public int fromDirection(EnumDirection var0) {
        if (var0.getAxis().isVertical()) {
            return 0;
        }
        int var1 = var0.get2DDataValue();
        return var1 << this.precision - 2;
    }

    public int fromDegreesWithTurns(float var0) {
        return Math.round(var0 * this.degreeToAngle);
    }

    public int fromDegrees(float var0) {
        return this.normalize(this.fromDegreesWithTurns(var0));
    }

    public float toDegreesWithTurns(int var0) {
        return (float)var0 * this.angleToDegree;
    }

    public float toDegrees(int var0) {
        float var1 = this.toDegreesWithTurns(this.normalize(var0));
        return var1 >= 180.0f ? var1 - 360.0f : var1;
    }

    public int normalize(int var0) {
        return var0 & this.mask;
    }

    public int getMask() {
        return this.mask;
    }
}

