/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.FileUtils;

public class SessionLock
implements AutoCloseable {
    public static final String LOCK_FILE = "session.lock";
    private final FileChannel lockFile;
    private final FileLock lock;
    private static final ByteBuffer DUMMY;

    public static SessionLock create(Path var0) throws IOException {
        Path var1 = var0.resolve(LOCK_FILE);
        FileUtils.createDirectoriesSafe(var0);
        FileChannel var2 = FileChannel.open(var1, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            var2.write(DUMMY.duplicate());
            var2.force(true);
            FileLock var3 = var2.tryLock();
            if (var3 == null) {
                throw ExceptionWorldConflict.alreadyLocked(var1);
            }
            return new SessionLock(var2, var3);
        }
        catch (IOException var3) {
            try {
                var2.close();
            }
            catch (IOException var4) {
                var3.addSuppressed(var4);
            }
            throw var3;
        }
    }

    private SessionLock(FileChannel var0, FileLock var1) {
        this.lockFile = var0;
        this.lock = var1;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.lock.isValid()) {
                this.lock.release();
            }
        }
        finally {
            if (this.lockFile.isOpen()) {
                this.lockFile.close();
            }
        }
    }

    public boolean isValid() {
        return this.lock.isValid();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocked(Path var0) throws IOException {
        Path var1 = var0.resolve(LOCK_FILE);
        try (FileChannel var2 = FileChannel.open(var1, StandardOpenOption.WRITE);){
            boolean bl;
            block15: {
                FileLock var3 = var2.tryLock();
                try {
                    boolean bl2 = bl = var3 == null;
                    if (var3 == null) break block15;
                }
                catch (Throwable throwable) {
                    if (var3 != null) {
                        try {
                            var3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                var3.close();
            }
            return bl;
        }
        catch (AccessDeniedException var22) {
            return true;
        }
        catch (NoSuchFileException var23) {
            return false;
        }
    }

    static {
        byte[] var0 = "\u2603".getBytes(Charsets.UTF_8);
        DUMMY = ByteBuffer.allocateDirect(var0.length);
        DUMMY.put(var0);
        DUMMY.flip();
    }

    public static class ExceptionWorldConflict
    extends IOException {
        private ExceptionWorldConflict(Path var0, String var1) {
            super(String.valueOf(var0.toAbsolutePath()) + ": " + var1);
        }

        public static ExceptionWorldConflict alreadyLocked(Path var0) {
            return new ExceptionWorldConflict(var0, "already locked (possibly by other Minecraft instance?)");
        }
    }
}

