/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.function.UnaryOperator;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class AttributesRenameFix
extends DataFix {
    private final String name;
    private final UnaryOperator<String> renames;

    public AttributesRenameFix(Schema var0, String var1, UnaryOperator<String> var2) {
        super(var0, false);
        this.name = var1;
        this.renames = var2;
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped(this.name + " (Components)", this.getInputSchema().getType(DataConverterTypes.DATA_COMPONENTS), this::fixDataComponents), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped(this.name + " (Entity)", this.getInputSchema().getType(DataConverterTypes.ENTITY), this::fixEntity), this.fixTypeEverywhereTyped(this.name + " (Player)", this.getInputSchema().getType(DataConverterTypes.PLAYER), this::fixEntity)});
    }

    private Typed<?> fixDataComponents(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), var02 -> var02.update("minecraft:attribute_modifiers", var0 -> var0.update("modifiers", var02 -> (Dynamic)DataFixUtils.orElse(var02.asStreamOpt().result().map(var0 -> var0.map(this::fixTypeField)).map(arg_0 -> ((Dynamic)var02).createList(arg_0)), (Object)var02))));
    }

    private Typed<?> fixEntity(Typed<?> var02) {
        return var02.update(DSL.remainderFinder(), var0 -> var0.update("attributes", var02 -> (Dynamic)DataFixUtils.orElse(var02.asStreamOpt().result().map(var0 -> var0.map(this::fixIdField)).map(arg_0 -> ((Dynamic)var02).createList(arg_0)), (Object)var02)));
    }

    private Dynamic<?> fixIdField(Dynamic<?> var0) {
        return ExtraDataFixUtils.fixStringField(var0, "id", this.renames);
    }

    private Dynamic<?> fixTypeField(Dynamic<?> var0) {
        return ExtraDataFixUtils.fixStringField(var0, "type", this.renames);
    }
}

