/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ChunkHeightAndBiomeFix
extends DataFix {
    public static final String DATAFIXER_CONTEXT_TAG = "__context";
    private static final String NAME = "ChunkHeightAndBiomeFix";
    private static final int OLD_SECTION_COUNT = 16;
    private static final int NEW_SECTION_COUNT = 24;
    private static final int NEW_MIN_SECTION_Y = -4;
    public static final int BLOCKS_PER_SECTION = 4096;
    private static final int LONGS_PER_SECTION = 64;
    private static final int HEIGHTMAP_BITS = 9;
    private static final long HEIGHTMAP_MASK = 511L;
    private static final int HEIGHTMAP_OFFSET = 64;
    private static final String[] HEIGHTMAP_TYPES = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
    private static final Set<String> STATUS_IS_OR_AFTER_SURFACE = Set.of("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> STATUS_IS_OR_AFTER_NOISE = Set.of("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> BLOCKS_BEFORE_FEATURE_STATUS = Set.of("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta");
    private static final int BIOME_CONTAINER_LAYER_SIZE = 16;
    private static final int BIOME_CONTAINER_SIZE = 64;
    private static final int BIOME_CONTAINER_TOP_LAYER_OFFSET = 1008;
    public static final String DEFAULT_BIOME = "minecraft:plains";
    private static final Int2ObjectMap<String> BIOMES_BY_ID = new Int2ObjectOpenHashMap();

    public ChunkHeightAndBiomeFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.CHUNK);
        OpticFinder var1 = var0.findField("Level");
        OpticFinder var2 = var1.type().findField("Sections");
        Schema var3 = this.getOutputSchema();
        Type var42 = var3.getType(DataConverterTypes.CHUNK);
        Type var5 = var42.findField("Level").type();
        Type var6 = var5.findField("Sections").type();
        return this.fixTypeEverywhereTyped(NAME, var0, var42, var4 -> var4.updateTyped(var1, var5, var3 -> {
            Object var4 = (Dynamic)var3.get(DSL.remainderFinder());
            OptionalDynamic var52 = ((Dynamic)var4.get(DSL.remainderFinder())).get(DATAFIXER_CONTEXT_TAG);
            String var6 = var52.get("dimension").asString().result().orElse("");
            String var72 = var52.get("generator").asString().result().orElse("");
            boolean var8 = "minecraft:overworld".equals(var6);
            MutableBoolean var9 = new MutableBoolean();
            int var10 = var8 ? -4 : 0;
            Dynamic<?>[] var11 = ChunkHeightAndBiomeFix.getBiomeContainers(var4, var8, var10, var9);
            Dynamic<?> var12 = ChunkHeightAndBiomeFix.makePalettedContainer(var4.createList(Stream.of(var4.createMap((Map)ImmutableMap.of((Object)var4.createString("Name"), (Object)var4.createString("minecraft:air"))))));
            HashSet var13 = Sets.newHashSet();
            MutableObject var14 = new MutableObject(() -> null);
            var3 = var3.updateTyped(var2, var6, var7 -> {
                IntOpenHashSet var8 = new IntOpenHashSet();
                Dynamic var9 = (Dynamic)var7.write().result().orElseThrow(() -> new IllegalStateException("Malformed Chunk.Level.Sections"));
                List var10 = var9.asStream().map(arg_0 -> ChunkHeightAndBiomeFix.a(var13, var12, var10, var11, (IntSet)var8, var14, arg_0)).collect(Collectors.toCollection(ArrayList::new));
                for (int var11 = 0; var11 < var11.length; ++var11) {
                    int var12 = var11 + var10;
                    if (!var8.add(var12)) continue;
                    Dynamic var13 = var4.createMap(Map.of(var4.createString("Y"), var4.createInt(var12)));
                    var13 = var13.set("block_states", var12);
                    var13 = var13.set("biomes", var11[var11]);
                    var10.add(var13);
                }
                return SystemUtils.readTypedOrThrow(var6, var4.createList(var10.stream()));
            });
            return var3.update(DSL.remainderFinder(), var5 -> {
                if (var8) {
                    var5 = this.predictChunkStatusBeforeSurface((Dynamic<?>)var5, var13);
                }
                return ChunkHeightAndBiomeFix.updateChunkTag(var5, var8, var9.booleanValue(), "minecraft:noise".equals(var72), (Supplier)var14.getValue());
            });
        }));
    }

    private Dynamic<?> predictChunkStatusBeforeSurface(Dynamic<?> var0, Set<String> var12) {
        return var0.update("Status", var1 -> {
            boolean var4;
            String var2 = var1.asString("empty");
            if (STATUS_IS_OR_AFTER_SURFACE.contains(var2)) {
                return var1;
            }
            var12.remove("minecraft:air");
            boolean var3 = !var12.isEmpty();
            var12.removeAll(BLOCKS_BEFORE_FEATURE_STATUS);
            boolean bl = var4 = !var12.isEmpty();
            if (var4) {
                return var1.createString("liquid_carvers");
            }
            if ("noise".equals(var2) || var3) {
                return var1.createString("noise");
            }
            if ("biomes".equals(var2)) {
                return var1.createString("structure_references");
            }
            return var1;
        });
    }

    private static Dynamic<?>[] getBiomeContainers(Dynamic<?> var0, boolean var12, int var22, MutableBoolean var3) {
        Object[] var4 = new Dynamic[var12 ? 24 : 16];
        int[] var5 = var0.get("Biomes").asIntStreamOpt().result().map(IntStream::toArray).orElse(null);
        if (var5 != null && var5.length == 1536) {
            var3.setValue(true);
            for (int var6 = 0; var6 < 24; ++var6) {
                int var7 = var6;
                var4[var6] = ChunkHeightAndBiomeFix.makeBiomeContainer(var0, var2 -> ChunkHeightAndBiomeFix.getOldBiome(var5, var7 * 64 + var2));
            }
        } else if (var5 != null && var5.length == 1024) {
            int var8;
            int var6 = 0;
            while (var6 < 16) {
                int var7 = var6 - var22;
                var8 = var6++;
                var4[var7] = ChunkHeightAndBiomeFix.makeBiomeContainer(var0, var2 -> ChunkHeightAndBiomeFix.getOldBiome(var5, var8 * 64 + var2));
            }
            if (var12) {
                Dynamic<?> var62 = ChunkHeightAndBiomeFix.makeBiomeContainer(var0, var1 -> ChunkHeightAndBiomeFix.getOldBiome(var5, var1 % 16));
                Dynamic<?> var7 = ChunkHeightAndBiomeFix.makeBiomeContainer(var0, var1 -> ChunkHeightAndBiomeFix.getOldBiome(var5, var1 % 16 + 1008));
                for (var8 = 0; var8 < 4; ++var8) {
                    var4[var8] = var62;
                }
                for (var8 = 20; var8 < 24; ++var8) {
                    var4[var8] = var7;
                }
            }
        } else {
            Arrays.fill(var4, ChunkHeightAndBiomeFix.makePalettedContainer(var0.createList(Stream.of(var0.createString(DEFAULT_BIOME)))));
        }
        return var4;
    }

    private static int getOldBiome(int[] var0, int var1) {
        return var0[var1] & 0xFF;
    }

    private static Dynamic<?> updateChunkTag(Dynamic<?> var0, boolean var1, boolean var2, boolean var3, Supplier<ChunkProtoTickListFix.a> var4) {
        Dynamic var6;
        String var7;
        var0 = var0.remove("Biomes");
        if (!var1) {
            return ChunkHeightAndBiomeFix.updateCarvingMasks(var0, 16, 0);
        }
        if (var2) {
            return ChunkHeightAndBiomeFix.updateCarvingMasks(var0, 24, 0);
        }
        var0 = ChunkHeightAndBiomeFix.updateHeightmaps(var0);
        var0 = ChunkHeightAndBiomeFix.addPaddingEntries(var0, "LiquidsToBeTicked");
        var0 = ChunkHeightAndBiomeFix.addPaddingEntries(var0, "PostProcessing");
        var0 = ChunkHeightAndBiomeFix.addPaddingEntries(var0, "ToBeTicked");
        var0 = ChunkHeightAndBiomeFix.updateCarvingMasks(var0, 24, 4);
        var0 = var0.update("UpgradeData", ChunkHeightAndBiomeFix::shiftUpgradeData);
        if (!var3) {
            return var0;
        }
        Optional var5 = var0.get("Status").result();
        if (var5.isPresent() && !"empty".equals(var7 = (var6 = (Dynamic)var5.get()).asString(""))) {
            ChunkProtoTickListFix.a var8;
            var0 = var0.set("blending_data", var0.createMap((Map)ImmutableMap.of((Object)var0.createString("old_noise"), (Object)var0.createBoolean(STATUS_IS_OR_AFTER_NOISE.contains(var7)))));
            if (!SharedConstants.DEBUG_DISABLE_BELOW_ZERO_RETROGENERATION && (var8 = var4.get()) != null) {
                BitSet var9 = new BitSet(256);
                boolean var10 = var7.equals("noise");
                for (int var11 = 0; var11 < 16; ++var11) {
                    for (int var12 = 0; var12 < 16; ++var12) {
                        boolean var15;
                        Dynamic<?> var13 = var8.get(var12, 0, var11);
                        boolean var14 = var13 != null && "minecraft:bedrock".equals(var13.get("Name").asString(""));
                        boolean bl = var15 = var13 != null && "minecraft:air".equals(var13.get("Name").asString(""));
                        if (var15) {
                            var9.set(var11 * 16 + var12);
                        }
                        var10 |= var14;
                    }
                }
                if (var10 && var9.cardinality() != var9.size()) {
                    Dynamic var11 = "full".equals(var7) ? var0.createString("heightmaps") : var6;
                    var0 = var0.set("below_zero_retrogen", var0.createMap((Map)ImmutableMap.of((Object)var0.createString("target_status"), (Object)var11, (Object)var0.createString("missing_bedrock"), (Object)var0.createLongList(LongStream.of(var9.toLongArray())))));
                    var0 = var0.set("Status", var0.createString("empty"));
                }
                var0 = var0.set("isLightOn", var0.createBoolean(false));
            }
        }
        return var0;
    }

    private static <T> Dynamic<T> shiftUpgradeData(Dynamic<T> var02) {
        return var02.update("Indices", var0 -> {
            HashMap var1 = new HashMap();
            var0.getMapValues().ifSuccess(var12 -> var12.forEach((var1, var2) -> {
                try {
                    var1.asString().result().map(Integer::parseInt).ifPresent(var3 -> {
                        int var4 = var3 - -4;
                        var1.put(var1.createString(Integer.toString(var4)), var2);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }));
            return var0.createMap(var1);
        });
    }

    private static Dynamic<?> updateCarvingMasks(Dynamic<?> var0, int var1, int var2) {
        Dynamic var32 = var0.get("CarvingMasks").orElseEmptyMap();
        var32 = var32.updateMapValues(var3 -> {
            long[] var4 = BitSet.valueOf(((Dynamic)var3.getSecond()).asByteBuffer().array()).toLongArray();
            long[] var5 = new long[64 * var1];
            System.arraycopy(var4, 0, var5, 64 * var2, var4.length);
            return Pair.of((Object)((Dynamic)var3.getFirst()), (Object)var0.createLongList(LongStream.of(var5)));
        });
        return var0.set("CarvingMasks", var32);
    }

    private static Dynamic<?> addPaddingEntries(Dynamic<?> var0, String var1) {
        List var2 = var0.get(var1).orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        if (var2.size() == 24) {
            return var0;
        }
        Dynamic var3 = var0.emptyList();
        for (int var4 = 0; var4 < 4; ++var4) {
            var2.add(0, var3);
            var2.add(var3);
        }
        return var0.set(var1, var0.createList(var2.stream()));
    }

    private static Dynamic<?> updateHeightmaps(Dynamic<?> var02) {
        return var02.update("Heightmaps", var0 -> {
            for (String var4 : HEIGHTMAP_TYPES) {
                var0 = var0.update(var4, ChunkHeightAndBiomeFix::getFixedHeightmap);
            }
            return var0;
        });
    }

    private static Dynamic<?> getFixedHeightmap(Dynamic<?> var02) {
        return var02.createLongList(var02.asLongStream().map(var0 -> {
            long var2 = 0L;
            int var4 = 0;
            while (var4 + 9 <= 64) {
                long var5 = var0 >> var4 & 0x1FFL;
                long var7 = var5 == 0L ? 0L : Math.min(var5 + 64L, 511L);
                var2 |= var7 << var4;
                var4 += 9;
            }
            return var2;
        }));
    }

    private static Dynamic<?> makeBiomeContainer(Dynamic<?> var0, Int2IntFunction var12) {
        int var4;
        Int2IntLinkedOpenHashMap var2 = new Int2IntLinkedOpenHashMap();
        for (int var3 = 0; var3 < 64; ++var3) {
            var4 = var12.applyAsInt(var3);
            if (var2.containsKey(var4)) continue;
            var2.put(var4, var2.size());
        }
        Dynamic var3 = var0.createList(var2.keySet().stream().map(var1 -> var0.createString((String)BIOMES_BY_ID.getOrDefault(var1.intValue(), (Object)DEFAULT_BIOME))));
        var4 = ChunkHeightAndBiomeFix.ceillog2(var2.size());
        if (var4 == 0) {
            return ChunkHeightAndBiomeFix.makePalettedContainer(var3);
        }
        int var5 = 64 / var4;
        int var6 = (64 + var5 - 1) / var5;
        long[] var7 = new long[var6];
        int var8 = 0;
        int var9 = 0;
        for (int var10 = 0; var10 < 64; ++var10) {
            int var11 = var12.applyAsInt(var10);
            int n2 = var8++;
            var7[n2] = var7[n2] | (long)var2.get(var11) << var9;
            if ((var9 += var4) + var4 <= 64) continue;
            var9 = 0;
        }
        Dynamic var10 = var0.createLongList(Arrays.stream(var7));
        return ChunkHeightAndBiomeFix.makePalettedContainer(var3, var10);
    }

    private static Dynamic<?> makePalettedContainer(Dynamic<?> var0) {
        return var0.createMap((Map)ImmutableMap.of((Object)var0.createString("palette"), var0));
    }

    private static Dynamic<?> makePalettedContainer(Dynamic<?> var0, Dynamic<?> var1) {
        return var0.createMap((Map)ImmutableMap.of((Object)var0.createString("palette"), var0, (Object)var0.createString("data"), var1));
    }

    private static Dynamic<?> makeOptimizedPalettedContainer(Dynamic<?> var0, Dynamic<?> var1) {
        List var2 = var0.asStream().collect(Collectors.toCollection(ArrayList::new));
        if (var2.size() == 1) {
            return ChunkHeightAndBiomeFix.makePalettedContainer(var0);
        }
        var0 = ChunkHeightAndBiomeFix.padPaletteEntries(var0, var1, var2);
        return ChunkHeightAndBiomeFix.makePalettedContainer(var0, var1);
    }

    private static Dynamic<?> padPaletteEntries(Dynamic<?> var0, Dynamic<?> var1, List<Dynamic<?>> var2) {
        int var7;
        int var8;
        long var3 = var1.asLongStream().count() * 64L;
        long var5 = var3 / 4096L;
        if (var5 > (long)(var8 = ChunkHeightAndBiomeFix.ceillog2(var7 = var2.size()))) {
            Dynamic var9 = var0.createMap((Map)ImmutableMap.of((Object)var0.createString("Name"), (Object)var0.createString("minecraft:air")));
            int var10 = (1 << (int)(var5 - 1L)) + 1;
            int var11 = var10 - var7;
            for (int var12 = 0; var12 < var11; ++var12) {
                var2.add(var9);
            }
            return var0.createList(var2.stream());
        }
        return var0;
    }

    public static int ceillog2(int var0) {
        if (var0 == 0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(var0) / Math.log(2.0));
    }

    private static /* synthetic */ Dynamic a(Set var0, Dynamic var1, int var22, Dynamic[] var3, IntSet var4, MutableObject var5, Dynamic var6) {
        int var7 = var6.get("Y").asInt(0);
        Dynamic var8 = (Dynamic)DataFixUtils.orElse(var6.get("Palette").result().flatMap(var2 -> {
            var2.asStream().map(var0 -> var0.get("Name").asString("minecraft:air")).forEach(var0::add);
            return var6.get("BlockStates").result().map(var1 -> ChunkHeightAndBiomeFix.makeOptimizedPalettedContainer(var2, var1));
        }), (Object)var1);
        Dynamic var9 = var6;
        int var10 = var7 - var22;
        if (var10 >= 0 && var10 < var3.length) {
            var9 = var9.set("biomes", var3[var10]);
        }
        var4.add(var7);
        if (var6.get("Y").asInt(Integer.MAX_VALUE) == 0) {
            var5.setValue(() -> {
                List var1 = var8.get("palette").asList(Function.identity());
                long[] var2 = var8.get("data").asLongStream().toArray();
                return new ChunkProtoTickListFix.a(var1, var2);
            });
        }
        return var9.set("block_states", var8).remove("Palette").remove("BlockStates");
    }

    static {
        BIOMES_BY_ID.put(0, (Object)"minecraft:ocean");
        BIOMES_BY_ID.put(1, (Object)DEFAULT_BIOME);
        BIOMES_BY_ID.put(2, (Object)"minecraft:desert");
        BIOMES_BY_ID.put(3, (Object)"minecraft:mountains");
        BIOMES_BY_ID.put(4, (Object)"minecraft:forest");
        BIOMES_BY_ID.put(5, (Object)"minecraft:taiga");
        BIOMES_BY_ID.put(6, (Object)"minecraft:swamp");
        BIOMES_BY_ID.put(7, (Object)"minecraft:river");
        BIOMES_BY_ID.put(8, (Object)"minecraft:nether_wastes");
        BIOMES_BY_ID.put(9, (Object)"minecraft:the_end");
        BIOMES_BY_ID.put(10, (Object)"minecraft:frozen_ocean");
        BIOMES_BY_ID.put(11, (Object)"minecraft:frozen_river");
        BIOMES_BY_ID.put(12, (Object)"minecraft:snowy_tundra");
        BIOMES_BY_ID.put(13, (Object)"minecraft:snowy_mountains");
        BIOMES_BY_ID.put(14, (Object)"minecraft:mushroom_fields");
        BIOMES_BY_ID.put(15, (Object)"minecraft:mushroom_field_shore");
        BIOMES_BY_ID.put(16, (Object)"minecraft:beach");
        BIOMES_BY_ID.put(17, (Object)"minecraft:desert_hills");
        BIOMES_BY_ID.put(18, (Object)"minecraft:wooded_hills");
        BIOMES_BY_ID.put(19, (Object)"minecraft:taiga_hills");
        BIOMES_BY_ID.put(20, (Object)"minecraft:mountain_edge");
        BIOMES_BY_ID.put(21, (Object)"minecraft:jungle");
        BIOMES_BY_ID.put(22, (Object)"minecraft:jungle_hills");
        BIOMES_BY_ID.put(23, (Object)"minecraft:jungle_edge");
        BIOMES_BY_ID.put(24, (Object)"minecraft:deep_ocean");
        BIOMES_BY_ID.put(25, (Object)"minecraft:stone_shore");
        BIOMES_BY_ID.put(26, (Object)"minecraft:snowy_beach");
        BIOMES_BY_ID.put(27, (Object)"minecraft:birch_forest");
        BIOMES_BY_ID.put(28, (Object)"minecraft:birch_forest_hills");
        BIOMES_BY_ID.put(29, (Object)"minecraft:dark_forest");
        BIOMES_BY_ID.put(30, (Object)"minecraft:snowy_taiga");
        BIOMES_BY_ID.put(31, (Object)"minecraft:snowy_taiga_hills");
        BIOMES_BY_ID.put(32, (Object)"minecraft:giant_tree_taiga");
        BIOMES_BY_ID.put(33, (Object)"minecraft:giant_tree_taiga_hills");
        BIOMES_BY_ID.put(34, (Object)"minecraft:wooded_mountains");
        BIOMES_BY_ID.put(35, (Object)"minecraft:savanna");
        BIOMES_BY_ID.put(36, (Object)"minecraft:savanna_plateau");
        BIOMES_BY_ID.put(37, (Object)"minecraft:badlands");
        BIOMES_BY_ID.put(38, (Object)"minecraft:wooded_badlands_plateau");
        BIOMES_BY_ID.put(39, (Object)"minecraft:badlands_plateau");
        BIOMES_BY_ID.put(40, (Object)"minecraft:small_end_islands");
        BIOMES_BY_ID.put(41, (Object)"minecraft:end_midlands");
        BIOMES_BY_ID.put(42, (Object)"minecraft:end_highlands");
        BIOMES_BY_ID.put(43, (Object)"minecraft:end_barrens");
        BIOMES_BY_ID.put(44, (Object)"minecraft:warm_ocean");
        BIOMES_BY_ID.put(45, (Object)"minecraft:lukewarm_ocean");
        BIOMES_BY_ID.put(46, (Object)"minecraft:cold_ocean");
        BIOMES_BY_ID.put(47, (Object)"minecraft:deep_warm_ocean");
        BIOMES_BY_ID.put(48, (Object)"minecraft:deep_lukewarm_ocean");
        BIOMES_BY_ID.put(49, (Object)"minecraft:deep_cold_ocean");
        BIOMES_BY_ID.put(50, (Object)"minecraft:deep_frozen_ocean");
        BIOMES_BY_ID.put(127, (Object)"minecraft:the_void");
        BIOMES_BY_ID.put(129, (Object)"minecraft:sunflower_plains");
        BIOMES_BY_ID.put(130, (Object)"minecraft:desert_lakes");
        BIOMES_BY_ID.put(131, (Object)"minecraft:gravelly_mountains");
        BIOMES_BY_ID.put(132, (Object)"minecraft:flower_forest");
        BIOMES_BY_ID.put(133, (Object)"minecraft:taiga_mountains");
        BIOMES_BY_ID.put(134, (Object)"minecraft:swamp_hills");
        BIOMES_BY_ID.put(140, (Object)"minecraft:ice_spikes");
        BIOMES_BY_ID.put(149, (Object)"minecraft:modified_jungle");
        BIOMES_BY_ID.put(151, (Object)"minecraft:modified_jungle_edge");
        BIOMES_BY_ID.put(155, (Object)"minecraft:tall_birch_forest");
        BIOMES_BY_ID.put(156, (Object)"minecraft:tall_birch_hills");
        BIOMES_BY_ID.put(157, (Object)"minecraft:dark_forest_hills");
        BIOMES_BY_ID.put(158, (Object)"minecraft:snowy_taiga_mountains");
        BIOMES_BY_ID.put(160, (Object)"minecraft:giant_spruce_taiga");
        BIOMES_BY_ID.put(161, (Object)"minecraft:giant_spruce_taiga_hills");
        BIOMES_BY_ID.put(162, (Object)"minecraft:modified_gravelly_mountains");
        BIOMES_BY_ID.put(163, (Object)"minecraft:shattered_savanna");
        BIOMES_BY_ID.put(164, (Object)"minecraft:shattered_savanna_plateau");
        BIOMES_BY_ID.put(165, (Object)"minecraft:eroded_badlands");
        BIOMES_BY_ID.put(166, (Object)"minecraft:modified_wooded_badlands_plateau");
        BIOMES_BY_ID.put(167, (Object)"minecraft:modified_badlands_plateau");
        BIOMES_BY_ID.put(168, (Object)"minecraft:bamboo_jungle");
        BIOMES_BY_ID.put(169, (Object)"minecraft:bamboo_jungle_hills");
        BIOMES_BY_ID.put(170, (Object)"minecraft:soul_sand_valley");
        BIOMES_BY_ID.put(171, (Object)"minecraft:crimson_forest");
        BIOMES_BY_ID.put(172, (Object)"minecraft:warped_forest");
        BIOMES_BY_ID.put(173, (Object)"minecraft:basalt_deltas");
        BIOMES_BY_ID.put(174, (Object)"minecraft:dripstone_caves");
        BIOMES_BY_ID.put(175, (Object)"minecraft:lush_caves");
        BIOMES_BY_ID.put(177, (Object)"minecraft:meadow");
        BIOMES_BY_ID.put(178, (Object)"minecraft:grove");
        BIOMES_BY_ID.put(179, (Object)"minecraft:snowy_slopes");
        BIOMES_BY_ID.put(180, (Object)"minecraft:snowcapped_peaks");
        BIOMES_BY_ID.put(181, (Object)"minecraft:lofty_peaks");
        BIOMES_BY_ID.put(182, (Object)"minecraft:stony_peaks");
    }
}

