/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DropInvalidSignDataFix
extends DataFix {
    private final String entityName;

    public DropInvalidSignDataFix(Schema var0, String var1) {
        super(var0, false);
        this.entityName = var1;
    }

    private <T> Dynamic<T> fix(Dynamic<T> var0) {
        var0 = var0.update("front_text", DropInvalidSignDataFix::fixText);
        var0 = var0.update("back_text", DropInvalidSignDataFix::fixText);
        for (String var2 : BlockEntitySignDoubleSidedEditableTextFix.FIELDS_TO_DROP) {
            var0 = var0.remove(var2);
        }
        return var0;
    }

    private static <T> Dynamic<T> fixText(Dynamic<T> var0) {
        Optional var1 = var0.get("filtered_messages").asStreamOpt().result();
        if (var1.isEmpty()) {
            return var0;
        }
        Dynamic var22 = LegacyComponentDataFixUtils.createEmptyComponent(var0.getOps());
        List<Dynamic> var32 = var0.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List var4 = Streams.mapWithIndex((Stream)((Stream)var1.get()), (var2, var3) -> {
            Dynamic var5 = var3 < (long)var32.size() ? (Dynamic)var32.get((int)var3) : var22;
            return var2.equals((Object)var22) ? var5 : var2;
        }).toList();
        if (var4.equals(var32)) {
            return var0.remove("filtered_messages");
        }
        return var0.set("filtered_messages", var0.createList(var4.stream()));
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.BLOCK_ENTITY);
        Type var1 = this.getInputSchema().getChoiceType(DataConverterTypes.BLOCK_ENTITY, this.entityName);
        OpticFinder var22 = DSL.namedChoice((String)this.entityName, (Type)var1);
        return this.fixTypeEverywhereTyped("DropInvalidSignDataFix for " + this.entityName, var0, var2 -> var2.updateTyped(var22, var1, var1 -> {
            Object var2 = ((Dynamic)var1.get(DSL.remainderFinder())).get("_filtered_correct").asBoolean(false);
            if (var2) {
                return var1.update(DSL.remainderFinder(), var0 -> var0.remove("_filtered_correct"));
            }
            return SystemUtils.writeAndReadTypedOrThrow(var1, var1, this::fix);
        }));
    }
}

