/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Map;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class StatsRenameFix
extends DataFix {
    private final String name;
    private final Map<String, String> renames;

    public StatsRenameFix(Schema var0, String var1, Map<String, String> var2) {
        super(var0, false);
        this.name = var1;
        this.renames = var2;
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.createStatRule(), (TypeRewriteRule)this.createCriteriaRule());
    }

    private TypeRewriteRule createCriteriaRule() {
        Type var0 = this.getOutputSchema().getType(DataConverterTypes.OBJECTIVE);
        Type var1 = this.getInputSchema().getType(DataConverterTypes.OBJECTIVE);
        OpticFinder var2 = var1.findField("CriteriaType");
        TaggedChoice.TaggedChoiceType var32 = (TaggedChoice.TaggedChoiceType)var2.type().findChoiceType("type", -1).orElseThrow(() -> new IllegalStateException("Can't find choice type for criteria"));
        Type var4 = (Type)var32.types().get("minecraft:custom");
        if (var4 == null) {
            throw new IllegalStateException("Failed to find custom criterion type variant");
        }
        OpticFinder var5 = DSL.namedChoice((String)"minecraft:custom", (Type)var4);
        OpticFinder var6 = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.namespacedString());
        return this.fixTypeEverywhereTyped(this.name, var1, var0, var3 -> var3.updateTyped(var2, var2 -> var2.updateTyped(var5, var1 -> var1.update(var6, var0 -> this.renames.getOrDefault(var0, (String)var0)))));
    }

    private TypeRewriteRule createStatRule() {
        Type var0 = this.getOutputSchema().getType(DataConverterTypes.STATS);
        Type var1 = this.getInputSchema().getType(DataConverterTypes.STATS);
        OpticFinder var2 = var1.findField("stats");
        OpticFinder var32 = var2.type().findField("minecraft:custom");
        OpticFinder var4 = DataConverterSchemaNamed.namespacedString().finder();
        return this.fixTypeEverywhereTyped(this.name, var1, var0, var3 -> var3.updateTyped(var2, var2 -> var2.updateTyped(var32, var1 -> var1.update(var4, var0 -> this.renames.getOrDefault(var0, (String)var0)))));
    }
}

