/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.IInventory;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ContainerUtil {
    public static final String TAG_ITEMS = "Items";

    public static ItemStack removeItem(List<ItemStack> var0, int var1, int var2) {
        if (var1 < 0 || var1 >= var0.size() || var0.get(var1).isEmpty() || var2 <= 0) {
            return ItemStack.EMPTY;
        }
        return var0.get(var1).split(var2);
    }

    public static ItemStack takeItem(List<ItemStack> var0, int var1) {
        if (var1 < 0 || var1 >= var0.size()) {
            return ItemStack.EMPTY;
        }
        return var0.set(var1, ItemStack.EMPTY);
    }

    public static void saveAllItems(ValueOutput var0, NonNullList<ItemStack> var1) {
        ContainerUtil.saveAllItems(var0, var1, true);
    }

    public static void saveAllItems(ValueOutput var0, NonNullList<ItemStack> var1, boolean var2) {
        ValueOutput.a<ItemStackWithSlot> var3 = var0.list(TAG_ITEMS, ItemStackWithSlot.CODEC);
        for (int var4 = 0; var4 < var1.size(); ++var4) {
            ItemStack var5 = var1.get(var4);
            if (var5.isEmpty()) continue;
            var3.add(new ItemStackWithSlot(var4, var5));
        }
        if (var3.isEmpty() && !var2) {
            var0.discard(TAG_ITEMS);
        }
    }

    public static void loadAllItems(ValueInput var0, NonNullList<ItemStack> var1) {
        for (ItemStackWithSlot var3 : var0.listOrEmpty(TAG_ITEMS, ItemStackWithSlot.CODEC)) {
            if (!var3.isValidInContainer(var1.size())) continue;
            var1.set(var3.slot(), var3.stack());
        }
    }

    public static int clearOrCountMatchingItems(IInventory var0, Predicate<ItemStack> var1, int var2, boolean var3) {
        int var4 = 0;
        for (int var5 = 0; var5 < var0.getContainerSize(); ++var5) {
            ItemStack var6 = var0.getItem(var5);
            int var7 = ContainerUtil.clearOrCountMatchingItems(var6, var1, var2 - var4, var3);
            if (var7 > 0 && !var3 && var6.isEmpty()) {
                var0.setItem(var5, ItemStack.EMPTY);
            }
            var4 += var7;
        }
        return var4;
    }

    public static int clearOrCountMatchingItems(ItemStack var0, Predicate<ItemStack> var1, int var2, boolean var3) {
        if (var0.isEmpty() || !var1.test(var0)) {
            return 0;
        }
        if (var3) {
            return var0.getCount();
        }
        int var4 = var2 < 0 ? var0.getCount() : Math.min(var2, var0.getCount());
        var0.shrink(var4);
        return var4;
    }
}

