/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;

@Immutable
public class DifficultyDamageScaler {
    private static final float DIFFICULTY_TIME_GLOBAL_OFFSET = -72000.0f;
    private static final float MAX_DIFFICULTY_TIME_GLOBAL = 1440000.0f;
    private static final float MAX_DIFFICULTY_TIME_LOCAL = 3600000.0f;
    private final EnumDifficulty base;
    private final float effectiveDifficulty;

    public DifficultyDamageScaler(EnumDifficulty var0, long var1, long var3, float var5) {
        this.base = var0;
        this.effectiveDifficulty = this.calculateDifficulty(var0, var1, var3, var5);
    }

    public EnumDifficulty getDifficulty() {
        return this.base;
    }

    public float getEffectiveDifficulty() {
        return this.effectiveDifficulty;
    }

    public boolean isHard() {
        return this.effectiveDifficulty >= (float)EnumDifficulty.HARD.ordinal();
    }

    public boolean isHarderThan(float var0) {
        return this.effectiveDifficulty > var0;
    }

    public float getSpecialMultiplier() {
        if (this.effectiveDifficulty < 2.0f) {
            return 0.0f;
        }
        if (this.effectiveDifficulty > 4.0f) {
            return 1.0f;
        }
        return (this.effectiveDifficulty - 2.0f) / 2.0f;
    }

    private float calculateDifficulty(EnumDifficulty var0, long var1, long var3, float var5) {
        if (var0 == EnumDifficulty.PEACEFUL) {
            return 0.0f;
        }
        boolean var6 = var0 == EnumDifficulty.HARD;
        float var7 = 0.75f;
        float var8 = MathHelper.clamp(((float)var1 + -72000.0f) / 1440000.0f, 0.0f, 1.0f) * 0.25f;
        var7 += var8;
        float var9 = 0.0f;
        var9 += MathHelper.clamp((float)var3 / 3600000.0f, 0.0f, 1.0f) * (var6 ? 1.0f : 0.75f);
        var9 += MathHelper.clamp(var5 * 0.25f, 0.0f, var8);
        if (var0 == EnumDifficulty.EASY) {
            var9 *= 0.5f;
        }
        return (float)var0.getId() * (var7 += var9);
    }
}

