/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugEntityBlockIntersection;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public abstract class Entity
implements SyncedDataHolder,
DebugValueSource,
INamableTileEntity,
ItemOwner,
EntityAccess,
ScoreHolder,
DataComponentGetter {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_ID = "id";
    public static final String TAG_UUID = "UUID";
    public static final String TAG_PASSENGERS = "Passengers";
    public static final String TAG_DATA = "data";
    public static final String TAG_POS = "Pos";
    public static final String TAG_MOTION = "Motion";
    public static final String TAG_ROTATION = "Rotation";
    public static final String TAG_PORTAL_COOLDOWN = "PortalCooldown";
    public static final String TAG_NO_GRAVITY = "NoGravity";
    public static final String TAG_AIR = "Air";
    public static final String TAG_ON_GROUND = "OnGround";
    public static final String TAG_FALL_DISTANCE = "fall_distance";
    public static final String TAG_FIRE = "Fire";
    public static final String TAG_SILENT = "Silent";
    public static final String TAG_GLOWING = "Glowing";
    public static final String TAG_INVULNERABLE = "Invulnerable";
    public static final String TAG_CUSTOM_NAME = "CustomName";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    public static final int CONTENTS_SLOT_INDEX = 0;
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    private static final Codec<List<String>> TAG_LIST_CODEC = Codec.STRING.sizeLimitedListOf(1024);
    public static final float DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2 = 0.2f;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5 = 0.500001;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0 = 0.999999;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    public static final int BASE_SAFE_FALL_DISTANCE = 3;
    private static final AxisAlignedBB INITIAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    private static final int MAX_BLOCK_ITERATIONS_ALONG_TRAVEL_PER_TICK = 16;
    private static final double MAX_MOVEMENT_RESETTING_TRACE_DISTANCE = 8.0;
    private static double viewScale = 1.0;
    private final EntityTypes<?> type;
    private boolean requiresPrecisePosition;
    private int id = ENTITY_COUNTER.incrementAndGet();
    public boolean blocksBuilding;
    public ImmutableList<Entity> passengers = ImmutableList.of();
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    private World level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3D position;
    private BlockPosition blockPosition;
    private ChunkCoordIntPair chunkPosition;
    private Vec3D deltaMovement = Vec3D.ZERO;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AxisAlignedBB bb = INITIAL_AABB;
    public boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3D stuckSpeedMultiplier = Vec3D.ZERO;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float moveDist;
    public float flyDist;
    public double fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public boolean noPhysics;
    public final RandomSource random = RandomSource.create();
    public int tickCount;
    private int remainingFireTicks;
    public boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<FluidType>> fluidHeight = new Object2DoubleArrayMap(2);
    protected boolean wasEyeInWater;
    private final Set<TagKey<FluidType>> fluidOnEyes = new HashSet<TagKey<FluidType>>();
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final DataWatcher entityData;
    protected static final DataWatcherObject<Byte> DATA_SHARED_FLAGS_ID = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    private static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final DataWatcherObject<Integer> DATA_AIR_SUPPLY_ID = DataWatcher.defineId(Entity.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> DATA_CUSTOM_NAME = DataWatcher.defineId(Entity.class, DataWatcherRegistry.OPTIONAL_COMPONENT);
    private static final DataWatcherObject<Boolean> DATA_CUSTOM_NAME_VISIBLE = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_SILENT = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_NO_GRAVITY = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    protected static final DataWatcherObject<EntityPose> DATA_POSE = DataWatcher.defineId(Entity.class, DataWatcherRegistry.POSE);
    private static final DataWatcherObject<Integer> DATA_TICKS_FROZEN = DataWatcher.defineId(Entity.class, DataWatcherRegistry.INT);
    private EntityInLevelCallback levelCallback = EntityInLevelCallback.NULL;
    private final VecDeltaCodec packetPositionCodec = new VecDeltaCodec();
    public boolean hasImpulse;
    @Nullable
    public PortalProcessor portalProcess;
    public int portalCooldown;
    private boolean invulnerable;
    protected UUID uuid = MathHelper.createInsecureUUID(this.random);
    protected String stringUUID = this.uuid.toString();
    private boolean hasGlowingTag;
    private final Set<String> tags = Sets.newHashSet();
    private final double[] pistonDeltas = new double[]{0.0, 0.0, 0.0};
    private long pistonDeltasGameTime;
    private EntitySize dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public Optional<BlockPosition> mainSupportingBlockPos = Optional.empty();
    private boolean onGroundNoBlocks = false;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    public boolean hasVisualFire;
    @Nullable
    private IBlockData inBlockState = null;
    public static final int MAX_MOVEMENTS_HANDELED_PER_TICK = 100;
    private final ArrayDeque<c> movementThisTick = new ArrayDeque(100);
    private final List<c> finalMovementsThisTick = new ObjectArrayList();
    private final LongSet visitedBlocks = new LongOpenHashSet();
    private final InsideBlockEffectApplier.a insideEffectCollector = new InsideBlockEffectApplier.a();
    private CustomData customData = CustomData.EMPTY;

    public Entity(EntityTypes<?> var0, World var1) {
        this.type = var0;
        this.level = var1;
        this.dimensions = var0.getDimensions();
        this.position = Vec3D.ZERO;
        this.blockPosition = BlockPosition.ZERO;
        this.chunkPosition = ChunkCoordIntPair.ZERO;
        DataWatcher.a var2 = new DataWatcher.a(this);
        var2.define(DATA_SHARED_FLAGS_ID, (byte)0);
        var2.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        var2.define(DATA_CUSTOM_NAME_VISIBLE, false);
        var2.define(DATA_CUSTOM_NAME, Optional.empty());
        var2.define(DATA_SILENT, false);
        var2.define(DATA_NO_GRAVITY, false);
        var2.define(DATA_POSE, EntityPose.STANDING);
        var2.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData(var2);
        this.entityData = var2.build();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.dimensions.eyeHeight();
    }

    public boolean isColliding(BlockPosition var0, IBlockData var1) {
        VoxelShape var2 = var1.getCollisionShape(this.level(), var0, VoxelShapeCollision.of(this)).move(var0);
        return VoxelShapes.joinIsNotEmpty(var2, VoxelShapes.create(this.getBoundingBox()), OperatorBoolean.AND);
    }

    public int getTeamColor() {
        ScoreboardTeam var0 = this.getTeam();
        if (var0 != null && ((ScoreboardTeamBase)var0).getColor().getColor() != null) {
            return ((ScoreboardTeamBase)var0).getColor().getColor();
        }
        return 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean canInteractWithLevel() {
        return this.isAlive() && !this.isRemoved() && !this.isSpectator();
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void syncPacketPositionCodec(double var0, double var2, double var4) {
        this.packetPositionCodec.setBase(new Vec3D(var0, var2, var4));
    }

    public VecDeltaCodec getPositionCodec() {
        return this.packetPositionCodec;
    }

    public EntityTypes<?> getType() {
        return this.type;
    }

    public boolean getRequiresPrecisePosition() {
        return this.requiresPrecisePosition;
    }

    public void setRequiresPrecisePosition(boolean var0) {
        this.requiresPrecisePosition = var0;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int var0) {
        this.id = var0;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String var0) {
        if (this.tags.size() >= 1024) {
            return false;
        }
        return this.tags.add(var0);
    }

    public boolean removeTag(String var0) {
        return this.tags.remove(var0);
    }

    public void kill(WorldServer var0) {
        this.remove(RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public final void discard() {
        this.remove(RemovalReason.DISCARDED);
    }

    protected abstract void defineSynchedData(DataWatcher.a var1);

    public DataWatcher getEntityData() {
        return this.entityData;
    }

    public boolean equals(Object var0) {
        if (var0 instanceof Entity) {
            return ((Entity)var0).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason var0) {
        this.setRemoved(var0);
    }

    public void onClientRemoval() {
    }

    public void onRemoval(RemovalReason var0) {
    }

    public void setPose(EntityPose var0) {
        this.entityData.set(DATA_POSE, var0);
    }

    public EntityPose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean hasPose(EntityPose var0) {
        return this.getPose() == var0;
    }

    public boolean closerThan(Entity var0, double var1) {
        return this.position().closerThan(var0.position(), var1);
    }

    public boolean closerThan(Entity var0, double var1, double var3) {
        double var5 = var0.getX() - this.getX();
        double var7 = var0.getY() - this.getY();
        double var9 = var0.getZ() - this.getZ();
        return MathHelper.lengthSquared(var5, var9) < MathHelper.square(var1) && MathHelper.square(var7) < MathHelper.square(var3);
    }

    protected void setRot(float var0, float var1) {
        this.setYRot(var0 % 360.0f);
        this.setXRot(var1 % 360.0f);
    }

    public final void setPos(Vec3D var0) {
        this.setPos(var0.x(), var0.y(), var0.z());
    }

    public void setPos(double var0, double var2, double var4) {
        this.setPosRaw(var0, var2, var4);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected final AxisAlignedBB makeBoundingBox() {
        return this.makeBoundingBox(this.position);
    }

    protected AxisAlignedBB makeBoundingBox(Vec3D var0) {
        return this.dimensions.makeBoundingBox(var0);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double var0, double var2) {
        float var4 = (float)var2 * 0.15f;
        float var5 = (float)var0 * 0.15f;
        this.setXRot(this.getXRot() + var4);
        this.setYRot(this.getYRot() + var5);
        this.setXRot(MathHelper.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += var4;
        this.yRotO += var5;
        this.xRotO = MathHelper.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        WorldServer var1;
        GameProfilerFiller var0 = Profiler.get();
        var0.push("entityBaseTick");
        this.inBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        this.handlePortal();
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        World world = this.level();
        if (world instanceof WorldServer) {
            var1 = (WorldServer)world;
            if (this.remainingFireTicks > 0) {
                if (this.fireImmune()) {
                    this.clearFire();
                } else {
                    if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                        this.hurtServer(var1, this.damageSources().onFire(), 1.0f);
                    }
                    this.setRemainingFireTicks(this.remainingFireTicks - 1);
                }
            }
        } else {
            this.clearFire();
        }
        if (this.isInLava()) {
            this.fallDistance *= 0.5;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide()) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        world = this.level();
        if (world instanceof WorldServer) {
            var1 = (WorldServer)world;
            if (this instanceof Leashable) {
                Leashable.tickLeash(var1, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        var0.pop();
    }

    public void setSharedFlagOnFire(boolean var0) {
        this.setSharedFlag(0, var0 || this.hasVisualFire);
    }

    public void checkBelowWorld() {
        if (this.getY() < (double)(this.level().getMinY() - 64)) {
            this.onBelowWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public void setPortalCooldown(int var0) {
        this.portalCooldown = var0;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public void lavaIgnite() {
        if (this.fireImmune()) {
            return;
        }
        this.igniteForSeconds(15.0f);
    }

    public void lavaHurt() {
        WorldServer var0;
        if (this.fireImmune()) {
            return;
        }
        World world = this.level();
        if (world instanceof WorldServer && this.hurtServer(var0 = (WorldServer)world, this.damageSources().lava(), 4.0f) && this.shouldPlayLavaHurtSound() && !this.isSilent()) {
            var0.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.GENERIC_BURN, this.getSoundSource(), 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
    }

    protected boolean shouldPlayLavaHurtSound() {
        return true;
    }

    public final void igniteForSeconds(float var0) {
        this.igniteForTicks(MathHelper.floor(var0 * 20.0f));
    }

    public void igniteForTicks(int var0) {
        if (this.remainingFireTicks < var0) {
            this.setRemainingFireTicks(var0);
        }
        this.clearFreeze();
    }

    public void setRemainingFireTicks(int var0) {
        this.remainingFireTicks = var0;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(Math.min(0, this.getRemainingFireTicks()));
    }

    protected void onBelowWorld() {
        this.discard();
    }

    public boolean isFree(double var0, double var2, double var4) {
        return this.isFree(this.getBoundingBox().move(var0, var2, var4));
    }

    private boolean isFree(AxisAlignedBB var0) {
        return this.level().noCollision(this, var0) && !this.level().containsAnyLiquid(var0);
    }

    public void setOnGround(boolean var0) {
        this.onGround = var0;
        this.checkSupportingBlock(var0, null);
    }

    public void setOnGroundWithMovement(boolean var0, Vec3D var1) {
        this.setOnGroundWithMovement(var0, this.horizontalCollision, var1);
    }

    public void setOnGroundWithMovement(boolean var0, boolean var1, Vec3D var2) {
        this.onGround = var0;
        this.horizontalCollision = var1;
        this.checkSupportingBlock(var0, var2);
    }

    public boolean isSupportedBy(BlockPosition var0) {
        return this.mainSupportingBlockPos.isPresent() && this.mainSupportingBlockPos.get().equals(var0);
    }

    protected void checkSupportingBlock(boolean var0, @Nullable Vec3D var1) {
        if (var0) {
            AxisAlignedBB var2 = this.getBoundingBox();
            AxisAlignedBB var3 = new AxisAlignedBB(var2.minX, var2.minY - 1.0E-6, var2.minZ, var2.maxX, var2.minY, var2.maxZ);
            Optional<BlockPosition> var4 = this.level.findSupportingBlock(this, var3);
            if (var4.isPresent() || this.onGroundNoBlocks) {
                this.mainSupportingBlockPos = var4;
            } else if (var1 != null) {
                AxisAlignedBB var5 = var3.move(-var1.x, 0.0, -var1.z);
                var4 = this.level.findSupportingBlock(this, var5);
                this.mainSupportingBlockPos = var4;
            }
            this.onGroundNoBlocks = var4.isEmpty();
        } else {
            this.onGroundNoBlocks = false;
            if (this.mainSupportingBlockPos.isPresent()) {
                this.mainSupportingBlockPos = Optional.empty();
            }
        }
    }

    public boolean onGround() {
        return this.onGround;
    }

    public void move(EnumMoveType var0, Vec3D var1) {
        Object var10;
        Object var9;
        Object var8;
        Vec3D var3;
        double var4;
        if (this.noPhysics) {
            this.setPos(this.getX() + var1.x, this.getY() + var1.y, this.getZ() + var1.z);
            this.horizontalCollision = false;
            this.verticalCollision = false;
            this.verticalCollisionBelow = false;
            this.minorHorizontalCollision = false;
            return;
        }
        if (var0 == EnumMoveType.PISTON && (var1 = this.limitPistonMovement(var1)).equals(Vec3D.ZERO)) {
            return;
        }
        GameProfilerFiller var2 = Profiler.get();
        var2.push("move");
        if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
            if (var0 != EnumMoveType.PISTON) {
                var1 = var1.multiply(this.stuckSpeedMultiplier);
            }
            this.stuckSpeedMultiplier = Vec3D.ZERO;
            this.setDeltaMovement(Vec3D.ZERO);
        }
        if ((var4 = (var3 = this.collide(var1 = this.maybeBackOffFromEdge(var1, var0))).lengthSqr()) > 1.0E-7 || var1.lengthSqr() - var4 < 1.0E-7) {
            if (this.fallDistance != 0.0 && var4 >= 1.0) {
                double var6 = Math.min(var3.length(), 8.0);
                var8 = this.position().add(var3.normalize().scale(var6));
                var9 = this.level().clip(new RayTrace(this.position(), (Vec3D)var8, RayTrace.BlockCollisionOption.FALLDAMAGE_RESETTING, RayTrace.FluidCollisionOption.WATER, this));
                if (((MovingObjectPositionBlock)var9).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
                    this.resetFallDistance();
                }
            }
            Vec3D var6 = this.position();
            Vec3D var7 = var6.add(var3);
            this.addMovementThisTick(new c(var6, var7, var1));
            this.setPos(var7);
        }
        var2.pop();
        var2.push("rest");
        boolean var6 = !MathHelper.equal(var1.x, var3.x);
        boolean var7 = !MathHelper.equal(var1.z, var3.z);
        boolean bl = this.horizontalCollision = var6 || var7;
        if (Math.abs(var1.y) > 0.0 || this.isLocalInstanceAuthoritative()) {
            this.verticalCollision = var1.y != var3.y;
            this.verticalCollisionBelow = this.verticalCollision && var1.y < 0.0;
            this.setOnGroundWithMovement(this.verticalCollisionBelow, this.horizontalCollision, var3);
        }
        this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(var3) : false;
        var8 = this.getOnPosLegacy();
        var9 = this.level().getBlockState((BlockPosition)var8);
        if (this.isLocalInstanceAuthoritative()) {
            this.checkFallDamage(var3.y, this.onGround(), (IBlockData)var9, (BlockPosition)var8);
        }
        if (this.isRemoved()) {
            var2.pop();
            return;
        }
        if (this.horizontalCollision) {
            var10 = this.getDeltaMovement();
            this.setDeltaMovement(var6 ? 0.0 : ((Vec3D)var10).x, ((Vec3D)var10).y, var7 ? 0.0 : ((Vec3D)var10).z);
        }
        if (this.canSimulateMovement()) {
            var10 = ((BlockBase.BlockData)var9).getBlock();
            if (var1.y != var3.y) {
                ((Block)var10).updateEntityMovementAfterFallOn(this.level(), this);
            }
        }
        if ((!this.level().isClientSide() || this.isLocalInstanceAuthoritative()) && ((MovementEmission)((Object)(var10 = this.getMovementEmission()))).emitsAnything() && !this.isPassenger()) {
            this.applyMovementEmissionAndPlaySound((MovementEmission)((Object)var10), var3, (BlockPosition)var8, (IBlockData)var9);
        }
        float var102 = this.getBlockSpeedFactor();
        this.setDeltaMovement(this.getDeltaMovement().multiply(var102, 1.0, var102));
        var2.pop();
    }

    private void applyMovementEmissionAndPlaySound(MovementEmission var0, Vec3D var1, BlockPosition var2, IBlockData var3) {
        float var4 = 0.6f;
        float var5 = (float)(var1.length() * (double)0.6f);
        float var6 = (float)(var1.horizontalDistance() * (double)0.6f);
        BlockPosition var7 = this.getOnPos();
        IBlockData var8 = this.level().getBlockState(var7);
        boolean var9 = this.isStateClimbable(var8);
        this.moveDist += var9 ? var5 : var6;
        this.flyDist += var5;
        if (this.moveDist > this.nextStep && !var8.isAir()) {
            boolean var10 = var7.equals(var2);
            boolean var11 = this.vibrationAndSoundEffectsFromBlock(var2, var3, var0.emitsSounds(), var10, var1);
            if (!var10) {
                var11 |= this.vibrationAndSoundEffectsFromBlock(var7, var8, false, var0.emitsEvents(), var1);
            }
            if (var11) {
                this.nextStep = this.nextStep();
            } else if (this.isInWater()) {
                this.nextStep = this.nextStep();
                if (var0.emitsSounds()) {
                    this.waterSwimSound();
                }
                if (var0.emitsEvents()) {
                    this.gameEvent(GameEvent.SWIM);
                }
            }
        } else if (var8.isAir()) {
            this.processFlappingMovement();
        }
    }

    protected void applyEffectsFromBlocks() {
        this.finalMovementsThisTick.clear();
        this.finalMovementsThisTick.addAll(this.movementThisTick);
        this.movementThisTick.clear();
        if (this.finalMovementsThisTick.isEmpty()) {
            this.finalMovementsThisTick.add(new c(this.oldPosition(), this.position()));
        } else if (this.finalMovementsThisTick.getLast().to.distanceToSqr(this.position()) > 9.999999439624929E-11) {
            this.finalMovementsThisTick.add(new c(this.finalMovementsThisTick.getLast().to, this.position()));
        }
        this.applyEffectsFromBlocks(this.finalMovementsThisTick);
    }

    private void addMovementThisTick(c var0) {
        if (this.movementThisTick.size() >= 100) {
            c var1 = this.movementThisTick.removeFirst();
            c var2 = this.movementThisTick.removeFirst();
            c var3 = new c(var1.from(), var2.to());
            this.movementThisTick.addFirst(var3);
        }
        this.movementThisTick.add(var0);
    }

    public void removeLatestMovementRecording() {
        if (!this.movementThisTick.isEmpty()) {
            this.movementThisTick.removeLast();
        }
    }

    protected void clearMovementThisTick() {
        this.movementThisTick.clear();
    }

    public void applyEffectsFromBlocks(Vec3D var0, Vec3D var1) {
        this.applyEffectsFromBlocks(List.of(new c(var0, var1)));
    }

    private void applyEffectsFromBlocks(List<c> var0) {
        boolean var4;
        if (!this.isAffectedByBlocks()) {
            return;
        }
        if (this.onGround()) {
            BlockPosition var1 = this.getOnPosLegacy();
            IBlockData var2 = this.level().getBlockState(var1);
            var2.getBlock().stepOn(this.level(), var1, var2, this);
        }
        boolean var1 = this.isOnFire();
        boolean var2 = this.isFreezing();
        int var3 = this.getRemainingFireTicks();
        this.checkInsideBlocks(var0, this.insideEffectCollector);
        this.insideEffectCollector.applyAndClear(this);
        if (this.isInRain()) {
            this.clearFire();
        }
        if (var1 && !this.isOnFire() || var2 && !this.isFreezing()) {
            this.playEntityOnFireExtinguishedSound();
        }
        boolean bl = var4 = this.getRemainingFireTicks() > var3;
        if (!(this.level().isClientSide() || this.isOnFire() || var4)) {
            this.setRemainingFireTicks(-this.getFireImmuneTicks());
        }
    }

    protected boolean isAffectedByBlocks() {
        return !this.isRemoved() && !this.noPhysics;
    }

    private boolean isStateClimbable(IBlockData var0) {
        return var0.is(TagsBlock.CLIMBABLE) || var0.is(Blocks.POWDER_SNOW);
    }

    private boolean vibrationAndSoundEffectsFromBlock(BlockPosition var0, IBlockData var1, boolean var2, boolean var3, Vec3D var4) {
        if (var1.isAir()) {
            return false;
        }
        boolean var5 = this.isStateClimbable(var1);
        if ((this.onGround() || var5 || this.isCrouching() && var4.y == 0.0 || this.isOnRails()) && !this.isSwimming()) {
            if (var2) {
                this.walkingStepSound(var0, var1);
            }
            if (var3) {
                this.level().gameEvent(GameEvent.STEP, this.position(), GameEvent.a.of(this, var1));
            }
            return true;
        }
        return false;
    }

    protected boolean isHorizontalCollisionMinor(Vec3D var0) {
        return false;
    }

    protected void playEntityOnFireExtinguishedSound() {
        if (!this.level.isClientSide()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.GENERIC_EXTINGUISH_FIRE, this.getSoundSource(), 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
    }

    public void extinguishFire() {
        if (this.isOnFire()) {
            this.playEntityOnFireExtinguishedSound();
        }
        this.clearFire();
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    @Deprecated
    public BlockPosition getOnPosLegacy() {
        return this.getOnPos(0.2f);
    }

    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    public BlockPosition getOnPos() {
        return this.getOnPos(1.0E-5f);
    }

    protected BlockPosition getOnPos(float var0) {
        if (this.mainSupportingBlockPos.isPresent()) {
            BlockPosition var1 = this.mainSupportingBlockPos.get();
            if (var0 > 1.0E-5f) {
                IBlockData var2 = this.level().getBlockState(var1);
                if ((double)var0 <= 0.5 && var2.is(TagsBlock.FENCES) || var2.is(TagsBlock.WALLS) || var2.getBlock() instanceof BlockFenceGate) {
                    return var1;
                }
                return var1.atY(MathHelper.floor(this.position.y - (double)var0));
            }
            return var1;
        }
        int var1 = MathHelper.floor(this.position.x);
        int var2 = MathHelper.floor(this.position.y - (double)var0);
        int var3 = MathHelper.floor(this.position.z);
        return new BlockPosition(var1, var2, var3);
    }

    protected float getBlockJumpFactor() {
        float var0 = this.level().getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float var1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)var0 == 1.0 ? var1 : var0;
    }

    protected float getBlockSpeedFactor() {
        IBlockData var0 = this.level().getBlockState(this.blockPosition());
        float var1 = var0.getBlock().getSpeedFactor();
        if (var0.is(Blocks.WATER) || var0.is(Blocks.BUBBLE_COLUMN)) {
            return var1;
        }
        return (double)var1 == 1.0 ? this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : var1;
    }

    protected Vec3D maybeBackOffFromEdge(Vec3D var0, EnumMoveType var1) {
        return var0;
    }

    protected Vec3D limitPistonMovement(Vec3D var0) {
        if (var0.lengthSqr() <= 1.0E-7) {
            return var0;
        }
        long var1 = this.level().getGameTime();
        if (var1 != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = var1;
        }
        if (var0.x != 0.0) {
            double var3 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.X, var0.x);
            return Math.abs(var3) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(var3, 0.0, 0.0);
        }
        if (var0.y != 0.0) {
            double var3 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.Y, var0.y);
            return Math.abs(var3) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(0.0, var3, 0.0);
        }
        if (var0.z != 0.0) {
            double var3 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.Z, var0.z);
            return Math.abs(var3) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(0.0, 0.0, var3);
        }
        return Vec3D.ZERO;
    }

    private double applyPistonMovementRestriction(EnumDirection.EnumAxis var0, double var1) {
        int var3 = var0.ordinal();
        double var4 = MathHelper.clamp(var1 + this.pistonDeltas[var3], -0.51, 0.51);
        var1 = var4 - this.pistonDeltas[var3];
        this.pistonDeltas[var3] = var4;
        return var1;
    }

    public double getAvailableSpaceBelow(double var0) {
        AxisAlignedBB var2 = this.getBoundingBox();
        AxisAlignedBB var3 = var2.setMinY(var2.minY - var0).setMaxY(var2.minY);
        List<VoxelShape> var4 = Entity.collectAllColliders(this, this.level, var3);
        if (var4.isEmpty()) {
            return var0;
        }
        return -VoxelShapes.collide(EnumDirection.EnumAxis.Y, var2, var4, -var0);
    }

    private Vec3D collide(Vec3D var0) {
        boolean var7;
        AxisAlignedBB var1 = this.getBoundingBox();
        List<VoxelShape> var2 = this.level().getEntityCollisions(this, var1.expandTowards(var0));
        Vec3D var3 = var0.lengthSqr() == 0.0 ? var0 : Entity.collideBoundingBox(this, var0, var1, this.level(), var2);
        boolean var4 = var0.x != var3.x;
        boolean var5 = var0.y != var3.y;
        boolean var6 = var0.z != var3.z;
        boolean bl = var7 = var5 && var0.y < 0.0;
        if (this.maxUpStep() > 0.0f && (var7 || this.onGround()) && (var4 || var6)) {
            float[] var12;
            AxisAlignedBB var8 = var7 ? var1.move(0.0, var3.y, 0.0) : var1;
            AxisAlignedBB var9 = var8.expandTowards(var0.x, this.maxUpStep(), var0.z);
            if (!var7) {
                var9 = var9.expandTowards(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> var10 = Entity.collectColliders(this, this.level, var2, var9);
            float var11 = (float)var3.y;
            for (float var16 : var12 = Entity.collectCandidateStepUpHeights(var8, var10, this.maxUpStep(), var11)) {
                Vec3D var17 = Entity.collideWithShapes(new Vec3D(var0.x, var16, var0.z), var8, var10);
                if (!(var17.horizontalDistanceSqr() > var3.horizontalDistanceSqr())) continue;
                double var18 = var1.minY - var8.minY;
                return var17.subtract(0.0, var18, 0.0);
            }
        }
        return var3;
    }

    private static float[] collectCandidateStepUpHeights(AxisAlignedBB var0, List<VoxelShape> var1, float var2, float var3) {
        FloatArraySet var4 = new FloatArraySet(4);
        block0: for (VoxelShape var6 : var1) {
            DoubleList var7 = var6.getCoords(EnumDirection.EnumAxis.Y);
            DoubleListIterator doubleListIterator = var7.iterator();
            while (doubleListIterator.hasNext()) {
                double var9 = (Double)doubleListIterator.next();
                float var11 = (float)(var9 - var0.minY);
                if (var11 < 0.0f || var11 == var3) continue;
                if (var11 > var2) continue block0;
                var4.add(var11);
            }
        }
        float[] var5 = var4.toFloatArray();
        FloatArrays.unstableSort((float[])var5);
        return var5;
    }

    public static Vec3D collideBoundingBox(@Nullable Entity var0, Vec3D var1, AxisAlignedBB var2, World var3, List<VoxelShape> var4) {
        List<VoxelShape> var5 = Entity.collectColliders(var0, var3, var4, var2.expandTowards(var1));
        return Entity.collideWithShapes(var1, var2, var5);
    }

    public static List<VoxelShape> collectAllColliders(@Nullable Entity var0, World var1, AxisAlignedBB var2) {
        List<VoxelShape> var3 = var1.getEntityCollisions(var0, var2);
        return Entity.collectColliders(var0, var1, var3, var2);
    }

    private static List<VoxelShape> collectColliders(@Nullable Entity var0, World var1, List<VoxelShape> var2, AxisAlignedBB var3) {
        boolean var6;
        ImmutableList.Builder var4 = ImmutableList.builderWithExpectedSize((int)(var2.size() + 1));
        if (!var2.isEmpty()) {
            var4.addAll(var2);
        }
        WorldBorder var5 = var1.getWorldBorder();
        boolean bl = var6 = var0 != null && var5.isInsideCloseToBorder(var0, var3);
        if (var6) {
            var4.add((Object)var5.getCollisionShape());
        }
        var4.addAll(var1.getBlockCollisions(var0, var3));
        return var4.build();
    }

    private static Vec3D collideWithShapes(Vec3D var0, AxisAlignedBB var1, List<VoxelShape> var2) {
        if (var2.isEmpty()) {
            return var0;
        }
        Vec3D var3 = Vec3D.ZERO;
        for (EnumDirection.EnumAxis var5 : EnumDirection.axisStepOrder(var0)) {
            double var6 = var0.get(var5);
            if (var6 == 0.0) continue;
            double var8 = VoxelShapes.collide(var5, var1.move(var3), var2, var6);
            var3 = var3.with(var5, var8);
        }
        return var3;
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEffect getSwimSound() {
        return SoundEffects.GENERIC_SWIM;
    }

    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.GENERIC_SPLASH;
    }

    protected SoundEffect getSwimHighSpeedSplashSound() {
        return SoundEffects.GENERIC_SPLASH;
    }

    private void checkInsideBlocks(List<c> var0, InsideBlockEffectApplier.a var1) {
        if (!this.isAffectedByBlocks()) {
            return;
        }
        LongSet var2 = this.visitedBlocks;
        for (c var4 : var0) {
            Vec3D var5 = var4.from;
            Vec3D var6 = var4.to().subtract(var4.from());
            int var7 = 16;
            if (var4.axisDependentOriginalMovement().isPresent() && var6.lengthSqr() > 0.0) {
                for (EnumDirection.EnumAxis var9 : EnumDirection.axisStepOrder(var4.axisDependentOriginalMovement().get())) {
                    double var10 = var6.get(var9);
                    if (var10 == 0.0) continue;
                    Vec3D var12 = var5.relative(var9.getPositive(), var10);
                    var7 -= this.checkInsideBlocks(var5, var12, var1, var2, var7);
                    var5 = var12;
                }
            } else {
                var7 -= this.checkInsideBlocks(var4.from(), var4.to(), var1, var2, 16);
            }
            if (var7 > 0) continue;
            this.checkInsideBlocks(var4.to(), var4.to(), var1, var2, 1);
        }
        var2.clear();
    }

    private int checkInsideBlocks(Vec3D var0, Vec3D var1, InsideBlockEffectApplier.a var2, LongSet var3, int var4) {
        Object var8;
        AxisAlignedBB var5 = this.makeBoundingBox(var1).deflate(1.0E-5f);
        boolean var6 = var0.distanceToSqr(var1) > MathHelper.square(0.9999900000002526);
        World world = this.level;
        boolean var7 = world instanceof WorldServer && ((WorldServer)(var8 = (WorldServer)world)).getServer().debugSubscribers().hasAnySubscriberFor(DebugSubscriptions.ENTITY_BLOCK_INTERSECTIONS);
        var8 = new AtomicInteger();
        IBlockAccess.forEachBlockIntersectedBetween(var0, var1, var5, (arg_0, arg_1) -> this.a(var4, (AtomicInteger)var8, var7, var0, var1, var3, var6, var5, var2, arg_0, arg_1));
        return ((AtomicInteger)var8).get() + 1;
    }

    private void debugBlockIntersection(WorldServer var0, BlockPosition var1, boolean var2, boolean var3) {
        DebugEntityBlockIntersection var4 = var3 ? DebugEntityBlockIntersection.IN_FLUID : (var2 ? DebugEntityBlockIntersection.IN_BLOCK : DebugEntityBlockIntersection.IN_AIR);
        var0.debugSynchronizers().sendBlockValue(var1, DebugSubscriptions.ENTITY_BLOCK_INTERSECTIONS, var4);
    }

    public boolean collidedWithFluid(Fluid var0, BlockPosition var1, Vec3D var2, Vec3D var3) {
        AxisAlignedBB var4 = var0.getAABB(this.level(), var1);
        return var4 != null && this.collidedWithShapeMovingFrom(var2, var3, List.of(var4));
    }

    public boolean collidedWithShapeMovingFrom(Vec3D var0, Vec3D var1, List<AxisAlignedBB> var2) {
        AxisAlignedBB var3 = this.makeBoundingBox(var0);
        Vec3D var4 = var1.subtract(var0);
        return var3.collidedAlongVector(var4, var2);
    }

    protected void onInsideBlock(IBlockData var0) {
    }

    public BlockPosition adjustSpawnLocation(WorldServer var0, BlockPosition var1) {
        BlockPosition var2 = var0.getRespawnData().pos();
        Vec3D var3 = var2.getCenter();
        int var4 = var0.getChunkAt(var2).getHeight(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var2.getX(), var2.getZ()) + 1;
        return BlockPosition.containing(var3.x, var4, var3.z);
    }

    public void gameEvent(Holder<GameEvent> var0, @Nullable Entity var1) {
        this.level().gameEvent(var1, var0, this.position);
    }

    public void gameEvent(Holder<GameEvent> var0) {
        this.gameEvent(var0, this);
    }

    private void walkingStepSound(BlockPosition var0, IBlockData var1) {
        this.playStepSound(var0, var1);
        if (this.shouldPlayAmethystStepSound(var1)) {
            this.playAmethystStepSound();
        }
    }

    protected void waterSwimSound() {
        Entity var0 = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float var1 = var0 == this ? 0.35f : 0.4f;
        Vec3D var2 = var0.getDeltaMovement();
        float var3 = Math.min(1.0f, (float)Math.sqrt(var2.x * var2.x * (double)0.2f + var2.y * var2.y + var2.z * var2.z * (double)0.2f) * var1);
        this.playSwimSound(var3);
    }

    protected BlockPosition getPrimaryStepSoundBlockPos(BlockPosition var0) {
        BlockPosition var1 = var0.above();
        IBlockData var2 = this.level().getBlockState(var1);
        if (var2.is(TagsBlock.INSIDE_STEP_SOUND_BLOCKS) || var2.is(TagsBlock.COMBINATION_STEP_SOUND_BLOCKS)) {
            return var1;
        }
        return var0;
    }

    protected void playCombinationStepSounds(IBlockData var0, IBlockData var1) {
        SoundEffectType var2 = var0.getSoundType();
        this.playSound(var2.getStepSound(), var2.getVolume() * 0.15f, var2.getPitch());
        this.playMuffledStepSound(var1);
    }

    protected void playMuffledStepSound(IBlockData var0) {
        SoundEffectType var1 = var0.getSoundType();
        this.playSound(var1.getStepSound(), var1.getVolume() * 0.05f, var1.getPitch() * 0.8f);
    }

    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        SoundEffectType var2 = var1.getSoundType();
        this.playSound(var2.getStepSound(), var2.getVolume() * 0.15f, var2.getPitch());
    }

    private boolean shouldPlayAmethystStepSound(IBlockData var0) {
        return var0.is(TagsBlock.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float var0 = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
        float var1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.playSound(SoundEffects.AMETHYST_BLOCK_CHIME, var1, var0);
        this.lastCrystalSoundPlayTick = this.tickCount;
    }

    protected void playSwimSound(float var0) {
        this.playSound(this.getSwimSound(), var0, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEffect var0, float var1, float var2) {
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), var0, this.getSoundSource(), var1, var2);
        }
    }

    public void playSound(SoundEffect var0) {
        if (!this.isSilent()) {
            this.playSound(var0, 1.0f, 1.0f);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean var0) {
        this.entityData.set(DATA_SILENT, var0);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean var0) {
        this.entityData.set(DATA_NO_GRAVITY, var0);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public final double getGravity() {
        return this.isNoGravity() ? 0.0 : this.getDefaultGravity();
    }

    protected void applyGravity() {
        double var0 = this.getGravity();
        if (var0 != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -var0, 0.0));
        }
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean dampensVibrations() {
        return false;
    }

    public final void doCheckFallDamage(double var0, double var2, double var4, boolean var6) {
        if (this.touchingUnloadedChunk()) {
            return;
        }
        this.checkSupportingBlock(var6, new Vec3D(var0, var2, var4));
        BlockPosition var7 = this.getOnPosLegacy();
        IBlockData var8 = this.level().getBlockState(var7);
        this.checkFallDamage(var2, var6, var8, var7);
    }

    protected void checkFallDamage(double var02, boolean var2, IBlockData var3, BlockPosition var4) {
        if (!this.isInWater() && var02 < 0.0) {
            this.fallDistance -= (double)((float)var02);
        }
        if (var2) {
            if (this.fallDistance > 0.0) {
                var3.getBlock().fallOn(this.level(), var3, var4, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position, GameEvent.a.of(this, this.mainSupportingBlockPos.map(var0 -> this.level().getBlockState((BlockPosition)var0)).orElse(var3)));
            }
            this.resetFallDistance();
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(double var0, float var2, DamageSource var3) {
        if (this.type.is(TagsEntity.FALL_DAMAGE_IMMUNE)) {
            return false;
        }
        this.propagateFallToPassengers(var0, var2, var3);
        return false;
    }

    protected void propagateFallToPassengers(double var0, float var2, DamageSource var3) {
        if (this.isVehicle()) {
            for (Entity var5 : this.getPassengers()) {
                var5.causeFallDamage(var0, var2, var3);
            }
        }
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    boolean isInRain() {
        BlockPosition var0 = this.blockPosition();
        return this.level().isRainingAt(var0) || this.level().isRainingAt(BlockPosition.containing(var0.getX(), this.getBoundingBox().maxY, var0.getZ()));
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInLiquid() {
        return this.isInWater() || this.isInLava();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public boolean isInShallowWater() {
        return this.isInWater() && !this.isUnderWater();
    }

    public boolean isInClouds() {
        Optional<Integer> var0 = this.level.dimensionType().cloudHeight();
        if (var0.isEmpty()) {
            return false;
        }
        int var1 = var0.get();
        if (this.getY() + (double)this.getBbHeight() < (double)var1) {
            return false;
        }
        int var2 = var1 + 4;
        return this.getY() <= (double)var2;
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level().getFluidState(this.blockPosition).is(TagsFluid.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double var0 = this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean var2 = this.updateFluidHeightAndDoFluidPushing(TagsFluid.LAVA, var0);
        return this.isInWater() || var2;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        AbstractBoat var0;
        Entity entity = this.getVehicle();
        if (entity instanceof AbstractBoat && !(var0 = (AbstractBoat)entity).isUnderWater()) {
            this.wasTouchingWater = false;
        } else if (this.updateFluidHeightAndDoFluidPushing(TagsFluid.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        Object var3;
        this.wasEyeInWater = this.isEyeInFluid(TagsFluid.WATER);
        this.fluidOnEyes.clear();
        double var0 = this.getEyeY();
        Entity var2 = this.getVehicle();
        if (var2 instanceof AbstractBoat && !((AbstractBoat)(var3 = (AbstractBoat)var2)).isUnderWater() && ((Entity)var3).getBoundingBox().maxY >= var0 && ((Entity)var3).getBoundingBox().minY <= var0) {
            return;
        }
        var3 = BlockPosition.containing(this.getX(), var0, this.getZ());
        Fluid var4 = this.level().getFluidState((BlockPosition)var3);
        double var5 = (float)((BaseBlockPosition)var3).getY() + var4.getHeight(this.level(), (BlockPosition)var3);
        if (var5 > var0) {
            var4.getTags().forEach(this.fluidOnEyes::add);
        }
    }

    protected void doWaterSplashEffect() {
        double var8;
        double var6;
        Entity var0 = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float var1 = var0 == this ? 0.2f : 0.9f;
        Vec3D var2 = var0.getDeltaMovement();
        float var3 = Math.min(1.0f, (float)Math.sqrt(var2.x * var2.x * (double)0.2f + var2.y * var2.y + var2.z * var2.z * (double)0.2f) * var1);
        if (var3 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), var3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), var3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float var4 = MathHelper.floor(this.getY());
        int var5 = 0;
        while ((float)var5 < 1.0f + this.dimensions.width() * 20.0f) {
            var6 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            var8 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(Particles.BUBBLE, this.getX() + var6, var4 + 1.0f, this.getZ() + var8, var2.x, var2.y - this.random.nextDouble() * (double)0.2f, var2.z);
            ++var5;
        }
        var5 = 0;
        while ((float)var5 < 1.0f + this.dimensions.width() * 20.0f) {
            var6 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            var8 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(Particles.SPLASH, this.getX() + var6, var4 + 1.0f, this.getZ() + var8, var2.x, var2.y, var2.z);
            ++var5;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    @Deprecated
    protected IBlockData getBlockStateOnLegacy() {
        return this.level().getBlockState(this.getOnPosLegacy());
    }

    public IBlockData getBlockStateOn() {
        return this.level().getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        BlockPosition var0 = this.getOnPosLegacy();
        IBlockData var1 = this.level().getBlockState(var0);
        if (var1.getRenderShape() != EnumRenderType.INVISIBLE) {
            Vec3D var2 = this.getDeltaMovement();
            BlockPosition var3 = this.blockPosition();
            double var4 = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            double var6 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            if (var3.getX() != var0.getX()) {
                var4 = MathHelper.clamp(var4, (double)var0.getX(), (double)var0.getX() + 1.0);
            }
            if (var3.getZ() != var0.getZ()) {
                var6 = MathHelper.clamp(var6, (double)var0.getZ(), (double)var0.getZ() + 1.0);
            }
            this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, var1), var4, this.getY() + 0.1, var6, var2.x * -4.0, 1.5, var2.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<FluidType> var0) {
        return this.fluidOnEyes.contains(var0);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(TagsFluid.LAVA) > 0.0;
    }

    public void moveRelative(float var0, Vec3D var1) {
        Vec3D var2 = Entity.getInputVector(var1, var0, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(var2));
    }

    protected static Vec3D getInputVector(Vec3D var0, float var1, float var2) {
        double var3 = var0.lengthSqr();
        if (var3 < 1.0E-7) {
            return Vec3D.ZERO;
        }
        Vec3D var5 = (var3 > 1.0 ? var0.normalize() : var0).scale(var1);
        float var6 = MathHelper.sin(var2 * ((float)Math.PI / 180));
        float var7 = MathHelper.cos(var2 * ((float)Math.PI / 180));
        return new Vec3D(var5.x * (double)var7 - var5.z * (double)var6, var5.y, var5.z * (double)var7 + var5.x * (double)var6);
    }

    @Deprecated
    public float getLightLevelDependentMagicValue() {
        if (this.level().hasChunkAt(this.getBlockX(), this.getBlockZ())) {
            return this.level().getLightLevelDependentMagicValue(BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ()));
        }
        return 0.0f;
    }

    public void absSnapTo(double var0, double var2, double var4, float var6, float var7) {
        this.absSnapTo(var0, var2, var4);
        this.absSnapRotationTo(var6, var7);
    }

    public void absSnapRotationTo(float var0, float var1) {
        this.setYRot(var0 % 360.0f);
        this.setXRot(MathHelper.clamp(var1, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void absSnapTo(double var0, double var2, double var4) {
        double var6 = MathHelper.clamp(var0, -3.0E7, 3.0E7);
        double var8 = MathHelper.clamp(var4, -3.0E7, 3.0E7);
        this.xo = var6;
        this.yo = var2;
        this.zo = var8;
        this.setPos(var6, var2, var8);
    }

    public void snapTo(Vec3D var0) {
        this.snapTo(var0.x, var0.y, var0.z);
    }

    public void snapTo(double var0, double var2, double var4) {
        this.snapTo(var0, var2, var4, this.getYRot(), this.getXRot());
    }

    public void snapTo(BlockPosition var0, float var1, float var2) {
        this.snapTo(var0.getBottomCenter(), var1, var2);
    }

    public void snapTo(Vec3D var0, float var1, float var2) {
        this.snapTo(var0.x, var0.y, var0.z, var1, var2);
    }

    public void snapTo(double var0, double var2, double var4, float var6, float var7) {
        this.setPosRaw(var0, var2, var4);
        this.setYRot(var6);
        this.setXRot(var7);
        this.setOldPosAndRot();
        this.reapplyPosition();
    }

    public final void setOldPosAndRot() {
        this.setOldPos();
        this.setOldRot();
    }

    public final void setOldPosAndRot(Vec3D var0, float var1, float var2) {
        this.setOldPos(var0);
        this.setOldRot(var1, var2);
    }

    protected void setOldPos() {
        this.setOldPos(this.position);
    }

    public void setOldRot() {
        this.setOldRot(this.getYRot(), this.getXRot());
    }

    private void setOldPos(Vec3D var0) {
        this.xo = this.xOld = var0.x;
        this.yo = this.yOld = var0.y;
        this.zo = this.zOld = var0.z;
    }

    private void setOldRot(float var0, float var1) {
        this.yRotO = var0;
        this.xRotO = var1;
    }

    public final Vec3D oldPosition() {
        return new Vec3D(this.xOld, this.yOld, this.zOld);
    }

    public float distanceTo(Entity var0) {
        float var1 = (float)(this.getX() - var0.getX());
        float var2 = (float)(this.getY() - var0.getY());
        float var3 = (float)(this.getZ() - var0.getZ());
        return MathHelper.sqrt(var1 * var1 + var2 * var2 + var3 * var3);
    }

    public double distanceToSqr(double var0, double var2, double var4) {
        double var6 = this.getX() - var0;
        double var8 = this.getY() - var2;
        double var10 = this.getZ() - var4;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public double distanceToSqr(Entity var0) {
        return this.distanceToSqr(var0.position());
    }

    public double distanceToSqr(Vec3D var0) {
        double var1 = this.getX() - var0.x;
        double var3 = this.getY() - var0.y;
        double var5 = this.getZ() - var0.z;
        return var1 * var1 + var3 * var3 + var5 * var5;
    }

    public void playerTouch(EntityHuman var0) {
    }

    public void push(Entity var0) {
        double var3;
        if (this.isPassengerOfSameVehicle(var0)) {
            return;
        }
        if (var0.noPhysics || this.noPhysics) {
            return;
        }
        double var1 = var0.getX() - this.getX();
        double var5 = MathHelper.absMax(var1, var3 = var0.getZ() - this.getZ());
        if (var5 >= (double)0.01f) {
            var5 = Math.sqrt(var5);
            var1 /= var5;
            var3 /= var5;
            double var7 = 1.0 / var5;
            if (var7 > 1.0) {
                var7 = 1.0;
            }
            var1 *= var7;
            var3 *= var7;
            var1 *= (double)0.05f;
            var3 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-var1, 0.0, -var3);
            }
            if (!var0.isVehicle() && var0.isPushable()) {
                var0.push(var1, 0.0, var3);
            }
        }
    }

    public void push(Vec3D var0) {
        this.push(var0.x, var0.y, var0.z);
    }

    public void push(double var0, double var2, double var4) {
        this.setDeltaMovement(this.getDeltaMovement().add(var0, var2, var4));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    @Deprecated
    public final void hurt(DamageSource var0, float var1) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            this.hurtServer(var2, var0, var1);
        }
    }

    @Deprecated
    public final boolean hurtOrSimulate(DamageSource var0, float var1) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            return this.hurtServer(var2, var0, var1);
        }
        return this.hurtClient(var0);
    }

    public abstract boolean hurtServer(WorldServer var1, DamageSource var2, float var3);

    public boolean hurtClient(DamageSource var0) {
        return false;
    }

    public final Vec3D getViewVector(float var0) {
        return this.calculateViewVector(this.getViewXRot(var0), this.getViewYRot(var0));
    }

    public EnumDirection getNearestViewDirection() {
        return EnumDirection.getApproximateNearest(this.getViewVector(1.0f));
    }

    public float getViewXRot(float var0) {
        return this.getXRot(var0);
    }

    public float getViewYRot(float var0) {
        return this.getYRot(var0);
    }

    public float getXRot(float var0) {
        if (var0 == 1.0f) {
            return this.getXRot();
        }
        return MathHelper.lerp(var0, this.xRotO, this.getXRot());
    }

    public float getYRot(float var0) {
        if (var0 == 1.0f) {
            return this.getYRot();
        }
        return MathHelper.rotLerp(var0, this.yRotO, this.getYRot());
    }

    public final Vec3D calculateViewVector(float var0, float var1) {
        float var2 = var0 * ((float)Math.PI / 180);
        float var3 = -var1 * ((float)Math.PI / 180);
        float var4 = MathHelper.cos(var3);
        float var5 = MathHelper.sin(var3);
        float var6 = MathHelper.cos(var2);
        float var7 = MathHelper.sin(var2);
        return new Vec3D(var5 * var6, -var7, var4 * var6);
    }

    public final Vec3D getUpVector(float var0) {
        return this.calculateUpVector(this.getViewXRot(var0), this.getViewYRot(var0));
    }

    protected final Vec3D calculateUpVector(float var0, float var1) {
        return this.calculateViewVector(var0 - 90.0f, var1);
    }

    public final Vec3D getEyePosition() {
        return new Vec3D(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3D getEyePosition(float var0) {
        double var1 = MathHelper.lerp((double)var0, this.xo, this.getX());
        double var3 = MathHelper.lerp((double)var0, this.yo, this.getY()) + (double)this.getEyeHeight();
        double var5 = MathHelper.lerp((double)var0, this.zo, this.getZ());
        return new Vec3D(var1, var3, var5);
    }

    public Vec3D getLightProbePosition(float var0) {
        return this.getEyePosition(var0);
    }

    public final Vec3D getPosition(float var0) {
        double var1 = MathHelper.lerp((double)var0, this.xo, this.getX());
        double var3 = MathHelper.lerp((double)var0, this.yo, this.getY());
        double var5 = MathHelper.lerp((double)var0, this.zo, this.getZ());
        return new Vec3D(var1, var3, var5);
    }

    public MovingObjectPosition pick(double var0, float var2, boolean var3) {
        Vec3D var4 = this.getEyePosition(var2);
        Vec3D var5 = this.getViewVector(var2);
        Vec3D var6 = var4.add(var5.x * var0, var5.y * var0, var5.z * var0);
        return this.level().clip(new RayTrace(var4, var6, RayTrace.BlockCollisionOption.OUTLINE, var3 ? RayTrace.FluidCollisionOption.ANY : RayTrace.FluidCollisionOption.NONE, this));
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive() && this.isPickable();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void awardKillScore(Entity var0, DamageSource var1) {
        if (var0 instanceof EntityPlayer) {
            CriterionTriggers.ENTITY_KILLED_PLAYER.trigger((EntityPlayer)var0, this, var1);
        }
    }

    public boolean shouldRender(double var0, double var2, double var4) {
        double var6 = this.getX() - var0;
        double var8 = this.getY() - var2;
        double var10 = this.getZ() - var4;
        double var12 = var6 * var6 + var8 * var8 + var10 * var10;
        return this.shouldRenderAtSqrDistance(var12);
    }

    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize();
        if (Double.isNaN(var2)) {
            var2 = 1.0;
        }
        return var0 < (var2 *= 64.0 * viewScale) * var2;
    }

    public boolean saveAsPassenger(ValueOutput var0) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String var1 = this.getEncodeId();
        if (var1 == null) {
            return false;
        }
        var0.putString(TAG_ID, var1);
        this.saveWithoutId(var0);
        return true;
    }

    public boolean save(ValueOutput var0) {
        if (this.isPassenger()) {
            return false;
        }
        return this.saveAsPassenger(var0);
    }

    public void saveWithoutId(ValueOutput var0) {
        try {
            int var1;
            if (this.vehicle != null) {
                var0.store(TAG_POS, Vec3D.CODEC, new Vec3D(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
            } else {
                var0.store(TAG_POS, Vec3D.CODEC, this.position());
            }
            var0.store(TAG_MOTION, Vec3D.CODEC, this.getDeltaMovement());
            var0.store(TAG_ROTATION, Vec2F.CODEC, new Vec2F(this.getYRot(), this.getXRot()));
            var0.putDouble(TAG_FALL_DISTANCE, this.fallDistance);
            var0.putShort(TAG_FIRE, (short)this.remainingFireTicks);
            var0.putShort(TAG_AIR, (short)this.getAirSupply());
            var0.putBoolean(TAG_ON_GROUND, this.onGround());
            var0.putBoolean(TAG_INVULNERABLE, this.invulnerable);
            var0.putInt(TAG_PORTAL_COOLDOWN, this.portalCooldown);
            var0.store(TAG_UUID, UUIDUtil.CODEC, this.getUUID());
            var0.storeNullable(TAG_CUSTOM_NAME, ComponentSerialization.CODEC, this.getCustomName());
            if (this.isCustomNameVisible()) {
                var0.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                var0.putBoolean(TAG_SILENT, this.isSilent());
            }
            if (this.isNoGravity()) {
                var0.putBoolean(TAG_NO_GRAVITY, this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                var0.putBoolean(TAG_GLOWING, true);
            }
            if ((var1 = this.getTicksFrozen()) > 0) {
                var0.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                var0.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                var0.store("Tags", TAG_LIST_CODEC, List.copyOf(this.tags));
            }
            if (!this.customData.isEmpty()) {
                var0.store(TAG_DATA, CustomData.CODEC, this.customData);
            }
            this.addAdditionalSaveData(var0);
            if (this.isVehicle()) {
                ValueOutput.b var2 = var0.childrenList(TAG_PASSENGERS);
                for (Entity var4 : this.getPassengers()) {
                    ValueOutput var5;
                    if (var4.saveAsPassenger(var5 = var2.addChild())) continue;
                    var2.discardLast();
                }
                if (var2.isEmpty()) {
                    var0.discard(TAG_PASSENGERS);
                }
            }
        }
        catch (Throwable var1) {
            CrashReport var2 = CrashReport.forThrowable(var1, "Saving entity NBT");
            CrashReportSystemDetails var3 = var2.addCategory("Entity being saved");
            this.fillCrashReportCategory(var3);
            throw new ReportedException(var2);
        }
    }

    public void load(ValueInput var02) {
        try {
            Vec3D var1 = var02.read(TAG_POS, Vec3D.CODEC).orElse(Vec3D.ZERO);
            Vec3D var2 = var02.read(TAG_MOTION, Vec3D.CODEC).orElse(Vec3D.ZERO);
            Vec2F var3 = var02.read(TAG_ROTATION, Vec2F.CODEC).orElse(Vec2F.ZERO);
            this.setDeltaMovement(Math.abs(var2.x) > 10.0 ? 0.0 : var2.x, Math.abs(var2.y) > 10.0 ? 0.0 : var2.y, Math.abs(var2.z) > 10.0 ? 0.0 : var2.z);
            this.hasImpulse = true;
            double var4 = 3.0000512E7;
            this.setPosRaw(MathHelper.clamp(var1.x, -3.0000512E7, 3.0000512E7), MathHelper.clamp(var1.y, -2.0E7, 2.0E7), MathHelper.clamp(var1.z, -3.0000512E7, 3.0000512E7));
            this.setYRot(var3.x);
            this.setXRot(var3.y);
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = var02.getDoubleOr(TAG_FALL_DISTANCE, 0.0);
            this.remainingFireTicks = var02.getShortOr(TAG_FIRE, (short)0);
            this.setAirSupply(var02.getIntOr(TAG_AIR, this.getMaxAirSupply()));
            this.onGround = var02.getBooleanOr(TAG_ON_GROUND, false);
            this.invulnerable = var02.getBooleanOr(TAG_INVULNERABLE, false);
            this.portalCooldown = var02.getIntOr(TAG_PORTAL_COOLDOWN, 0);
            var02.read(TAG_UUID, UUIDUtil.CODEC).ifPresent(var0 -> {
                this.uuid = var0;
                this.stringUUID = this.uuid.toString();
            });
            if (!(Double.isFinite(this.getX()) && Double.isFinite(this.getY()) && Double.isFinite(this.getZ()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (!Double.isFinite(this.getYRot()) || !Double.isFinite(this.getXRot())) {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            this.reapplyPosition();
            this.setRot(this.getYRot(), this.getXRot());
            this.setCustomName(var02.read(TAG_CUSTOM_NAME, ComponentSerialization.CODEC).orElse(null));
            this.setCustomNameVisible(var02.getBooleanOr("CustomNameVisible", false));
            this.setSilent(var02.getBooleanOr(TAG_SILENT, false));
            this.setNoGravity(var02.getBooleanOr(TAG_NO_GRAVITY, false));
            this.setGlowingTag(var02.getBooleanOr(TAG_GLOWING, false));
            this.setTicksFrozen(var02.getIntOr("TicksFrozen", 0));
            this.hasVisualFire = var02.getBooleanOr("HasVisualFire", false);
            this.customData = var02.read(TAG_DATA, CustomData.CODEC).orElse(CustomData.EMPTY);
            this.tags.clear();
            var02.read("Tags", TAG_LIST_CODEC).ifPresent(this.tags::addAll);
            this.readAdditionalSaveData(var02);
            if (this.repositionEntityAfterLoad()) {
                this.reapplyPosition();
            }
        }
        catch (Throwable var1) {
            CrashReport var2 = CrashReport.forThrowable(var1, "Loading entity NBT");
            CrashReportSystemDetails var3 = var2.addCategory("Entity being loaded");
            this.fillCrashReportCategory(var3);
            throw new ReportedException(var2);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    public final String getEncodeId() {
        EntityTypes<?> var0 = this.getType();
        MinecraftKey var1 = EntityTypes.getKey(var0);
        return !var0.canSerialize() ? null : var1.toString();
    }

    protected abstract void readAdditionalSaveData(ValueInput var1);

    protected abstract void addAdditionalSaveData(ValueOutput var1);

    @Nullable
    public EntityItem spawnAtLocation(WorldServer var0, IMaterial var1) {
        return this.spawnAtLocation(var0, new ItemStack(var1), 0.0f);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer var0, ItemStack var1) {
        return this.spawnAtLocation(var0, var1, 0.0f);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer var0, ItemStack var1, Vec3D var2) {
        if (var1.isEmpty()) {
            return null;
        }
        EntityItem var3 = new EntityItem(var0, this.getX() + var2.x, this.getY() + var2.y, this.getZ() + var2.z, var1);
        var3.setDefaultPickUpDelay();
        var0.addFreshEntity(var3);
        return var3;
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer var0, ItemStack var1, float var2) {
        return this.spawnAtLocation(var0, var1, new Vec3D(0.0, var2, 0.0));
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float var0 = this.dimensions.width() * 0.8f;
        AxisAlignedBB var12 = AxisAlignedBB.ofSize(this.getEyePosition(), var0, 1.0E-6, var0);
        return BlockPosition.betweenClosedStream(var12).anyMatch(var1 -> {
            IBlockData var2 = this.level().getBlockState((BlockPosition)var1);
            return !var2.isAir() && var2.isSuffocating(this.level(), (BlockPosition)var1) && VoxelShapes.joinIsNotEmpty(var2.getCollisionShape(this.level(), (BlockPosition)var1).move((BaseBlockPosition)var1), VoxelShapes.create(var12), OperatorBoolean.AND);
        });
    }

    public EnumInteractionResult interact(EntityHuman var0, EnumHand var12) {
        Object var4;
        Object var3;
        Entity entity;
        Object var2;
        Entity entity2;
        if (!this.level().isClientSide() && var0.isSecondaryUseActive() && (entity2 = this) instanceof Leashable && (var2 = (Leashable)((Object)entity2)).canBeLeashed() && this.isAlive() && (!((entity = this) instanceof EntityLiving) || !((EntityLiving)(var3 = (EntityLiving)entity)).isBaby()) && !(var4 = Leashable.leashableInArea(this, var1 -> var1.getLeashHolder() == var0)).isEmpty()) {
            boolean var5 = false;
            Iterator iterator = var4.iterator();
            while (iterator.hasNext()) {
                Leashable var7 = (Leashable)iterator.next();
                if (!var7.canHaveALeashAttachedTo(this)) continue;
                var7.setLeashedTo(this, true);
                var5 = true;
            }
            if (var5) {
                this.level().gameEvent(GameEvent.ENTITY_ACTION, this.blockPosition(), GameEvent.a.of(var0));
                this.playSound(SoundEffects.LEAD_TIED);
                return EnumInteractionResult.SUCCESS_SERVER.withoutItem();
            }
        }
        if (((ItemStack)(var2 = var0.getItemInHand(var12))).is(Items.SHEARS) && this.shearOffAllLeashConnections(var0)) {
            ((ItemStack)var2).hurtAndBreak(1, (EntityLiving)var0, var12);
            return EnumInteractionResult.SUCCESS;
        }
        var4 = this;
        if (var4 instanceof EntityInsentient) {
            var3 = (EntityInsentient)var4;
            if (((ItemStack)var2).is(Items.SHEARS) && ((EntityInsentient)var3).canShearEquipment(var0) && !var0.isSecondaryUseActive() && this.attemptToShearEquipment(var0, var12, (ItemStack)var2, (EntityInsentient)var3)) {
                return EnumInteractionResult.SUCCESS;
            }
        }
        if (this.isAlive() && (var4 = this) instanceof Leashable) {
            var3 = (Leashable)var4;
            if (var3.getLeashHolder() == var0) {
                if (!this.level().isClientSide()) {
                    if (var0.hasInfiniteMaterials()) {
                        var3.removeLeash();
                    } else {
                        var3.dropLeash();
                    }
                    this.gameEvent(GameEvent.ENTITY_INTERACT, var0);
                    this.playSound(SoundEffects.LEAD_UNTIED);
                }
                return EnumInteractionResult.SUCCESS.withoutItem();
            }
            var4 = var0.getItemInHand(var12);
            if (((ItemStack)var4).is(Items.LEAD) && !(var3.getLeashHolder() instanceof EntityHuman)) {
                if (!this.level().isClientSide() && var3.canHaveALeashAttachedTo(var0)) {
                    if (var3.isLeashed()) {
                        var3.dropLeash();
                    }
                    var3.setLeashedTo(var0, true);
                    this.playSound(SoundEffects.LEAD_TIED);
                    ((ItemStack)var4).shrink(1);
                }
                return EnumInteractionResult.SUCCESS;
            }
        }
        return EnumInteractionResult.PASS;
    }

    public boolean shearOffAllLeashConnections(@Nullable EntityHuman var0) {
        World world;
        boolean var1 = this.dropAllLeashConnections(var0);
        if (var1 && (world = this.level()) instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            var2.playSound(null, this.blockPosition(), SoundEffects.SHEARS_SNIP, var0 != null ? var0.getSoundSource() : this.getSoundSource());
        }
        return var1;
    }

    public boolean dropAllLeashConnections(@Nullable EntityHuman var0) {
        Leashable var3;
        List<Leashable> var1 = Leashable.leashableLeashedTo(this);
        boolean var2 = !var1.isEmpty();
        Entity entity = this;
        if (entity instanceof Leashable && (var3 = (Leashable)((Object)entity)).isLeashed()) {
            var3.dropLeash();
            var2 = true;
        }
        for (Leashable var4 : var1) {
            var4.dropLeash();
        }
        if (var2) {
            this.gameEvent(GameEvent.SHEAR, var0);
            return true;
        }
        return false;
    }

    private boolean attemptToShearEquipment(EntityHuman var0, EnumHand var1, ItemStack var2, EntityInsentient var3) {
        for (EnumItemSlot var5 : EnumItemSlot.VALUES) {
            ItemStack var6 = var3.getItemBySlot(var5);
            Equippable var7 = var6.get(DataComponents.EQUIPPABLE);
            if (var7 == null || !var7.canBeSheared() || EnchantmentManager.has(var6, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !var0.isCreative()) continue;
            var2.hurtAndBreak(1, (EntityLiving)var0, var1.asEquipmentSlot());
            Vec3D var8 = this.dimensions.attachments().getAverage(EntityAttachment.PASSENGER);
            var3.setItemSlotAndDropWhenKilled(var5, ItemStack.EMPTY);
            this.gameEvent(GameEvent.SHEAR, var0);
            this.playSound(var7.shearingSound().value());
            World world = this.level();
            if (world instanceof WorldServer) {
                WorldServer var9 = (WorldServer)world;
                this.spawnAtLocation(var9, var6, var8);
                CriterionTriggers.PLAYER_SHEARED_EQUIPMENT.trigger((EntityPlayer)var0, var6, var3);
            }
            return true;
        }
        return false;
    }

    public boolean canCollideWith(Entity var0) {
        return var0.canBeCollidedWith(this) && !this.isPassengerOfSameVehicle(var0);
    }

    public boolean canBeCollidedWith(@Nullable Entity var0) {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3D.ZERO);
        this.tick();
        if (!this.isPassenger()) {
            return;
        }
        this.getVehicle().positionRider(this);
    }

    public final void positionRider(Entity var0) {
        if (!this.hasPassenger(var0)) {
            return;
        }
        this.positionRider(var0, Entity::setPos);
    }

    protected void positionRider(Entity var0, MoveFunction var1) {
        Vec3D var2 = this.getPassengerRidingPosition(var0);
        Vec3D var3 = var0.getVehicleAttachmentPoint(this);
        var1.accept(var0, var2.x - var3.x, var2.y - var3.y, var2.z - var3.z);
    }

    public void onPassengerTurned(Entity var0) {
    }

    public Vec3D getVehicleAttachmentPoint(Entity var0) {
        return this.getAttachments().get(EntityAttachment.VEHICLE, 0, this.yRot);
    }

    public Vec3D getPassengerRidingPosition(Entity var0) {
        return this.position().add(this.getPassengerAttachmentPoint(var0, this.dimensions, 1.0f));
    }

    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return Entity.getDefaultPassengerAttachmentPoint(this, var0, var1.attachments());
    }

    protected static Vec3D getDefaultPassengerAttachmentPoint(Entity var0, Entity var1, EntityAttachments var2) {
        int var3 = var0.getPassengers().indexOf(var1);
        return var2.getClamped(EntityAttachment.PASSENGER, var3, var0.yRot);
    }

    public final boolean startRiding(Entity var0) {
        return this.startRiding(var0, false, true);
    }

    public boolean showVehicleHealth() {
        return this instanceof EntityLiving;
    }

    public boolean startRiding(Entity var02, boolean var1, boolean var2) {
        if (var02 == this.vehicle) {
            return false;
        }
        if (!var02.couldAcceptPassenger()) {
            return false;
        }
        if (!this.level().isClientSide() && !var02.type.canSerialize()) {
            return false;
        }
        Entity var3 = var02;
        while (var3.vehicle != null) {
            if (var3.vehicle == this) {
                return false;
            }
            var3 = var3.vehicle;
        }
        if (!(var1 || this.canRide(var02) && var02.canAddPassenger(this))) {
            return false;
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
        this.setPose(EntityPose.STANDING);
        this.vehicle = var02;
        this.vehicle.addPassenger(this);
        if (var2) {
            this.level().gameEvent(this, GameEvent.ENTITY_MOUNT, this.vehicle.position);
            var02.getIndirectPassengersStream().filter(var0 -> var0 instanceof EntityPlayer).forEach(var0 -> CriterionTriggers.START_RIDING_TRIGGER.trigger((EntityPlayer)var0));
        }
        return true;
    }

    protected boolean canRide(Entity var0) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    public void ejectPassengers() {
        for (int var0 = this.passengers.size() - 1; var0 >= 0; --var0) {
            ((Entity)this.passengers.get(var0)).stopRiding();
        }
    }

    public void removeVehicle() {
        if (this.vehicle != null) {
            Entity var0 = this.vehicle;
            this.vehicle = null;
            var0.removePassenger(this);
            RemovalReason var1 = this.getRemovalReason();
            if (var1 == null || var1.shouldDestroy()) {
                this.level().gameEvent(this, GameEvent.ENTITY_DISMOUNT, var0.position);
            }
        }
    }

    public void stopRiding() {
        this.removeVehicle();
    }

    protected void addPassenger(Entity var0) {
        if (var0.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)var0);
        } else {
            ArrayList var1 = Lists.newArrayList(this.passengers);
            if (!this.level().isClientSide() && var0 instanceof EntityHuman && !(this.getFirstPassenger() instanceof EntityHuman)) {
                var1.add(0, var0);
            } else {
                var1.add(var0);
            }
            this.passengers = ImmutableList.copyOf((Collection)var1);
        }
    }

    protected void removePassenger(Entity var0) {
        if (var0.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == var0 ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(var1 -> var1 != var0).collect(ImmutableList.toImmutableList());
        var0.boardingCooldown = 60;
    }

    protected boolean canAddPassenger(Entity var0) {
        return this.passengers.isEmpty();
    }

    protected boolean couldAcceptPassenger() {
        return true;
    }

    public final boolean isInterpolating() {
        return this.getInterpolation() != null && this.getInterpolation().hasActiveInterpolation();
    }

    public final void moveOrInterpolateTo(Vec3D var0, float var1, float var2) {
        this.moveOrInterpolateTo(Optional.of(var0), Optional.of(Float.valueOf(var1)), Optional.of(Float.valueOf(var2)));
    }

    public final void moveOrInterpolateTo(float var0, float var1) {
        this.moveOrInterpolateTo(Optional.empty(), Optional.of(Float.valueOf(var0)), Optional.of(Float.valueOf(var1)));
    }

    public final void moveOrInterpolateTo(Vec3D var0) {
        this.moveOrInterpolateTo(Optional.of(var0), Optional.empty(), Optional.empty());
    }

    public final void moveOrInterpolateTo(Optional<Vec3D> var02, Optional<Float> var1, Optional<Float> var2) {
        InterpolationHandler var3 = this.getInterpolation();
        if (var3 != null) {
            var3.interpolateTo(var02.orElse(var3.position()), var1.orElse(Float.valueOf(var3.yRot())).floatValue(), var2.orElse(Float.valueOf(var3.xRot())).floatValue());
        } else {
            var02.ifPresent(this::setPos);
            var1.ifPresent(var0 -> this.setYRot(var0.floatValue() % 360.0f));
            var2.ifPresent(var0 -> this.setXRot(var0.floatValue() % 360.0f));
        }
    }

    @Nullable
    public InterpolationHandler getInterpolation() {
        return null;
    }

    public void lerpHeadTo(float var0, int var1) {
        this.setYHeadRot(var0);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3D getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3D getHandHoldingItemAngle(Item var0) {
        Entity entity = this;
        if (entity instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)entity;
            boolean var2 = var1.getOffhandItem().is(var0) && !var1.getMainHandItem().is(var0);
            EnumMainHand var3 = var2 ? var1.getMainArm().getOpposite() : var1.getMainArm();
            return this.calculateViewVector(0.0f, this.getYRot() + (float)(var3 == EnumMainHand.RIGHT ? 80 : -80)).scale(0.5);
        }
        return Vec3D.ZERO;
    }

    public Vec2F getRotationVector() {
        return new Vec2F(this.getXRot(), this.getYRot());
    }

    public Vec3D getForward() {
        return Vec3D.directionFromRotation(this.getRotationVector());
    }

    public void setAsInsidePortal(Portal var0, BlockPosition var1) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
            return;
        }
        if (this.portalProcess == null || !this.portalProcess.isSamePortal(var0)) {
            this.portalProcess = new PortalProcessor(var0, var1.immutable());
        } else if (!this.portalProcess.isInsidePortalThisTick()) {
            this.portalProcess.updateEntryPosition(var1.immutable());
            this.portalProcess.setAsInsidePortalThisTick(true);
        }
    }

    protected void handlePortal() {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var0 = (WorldServer)world;
        this.processPortalCooldown();
        if (this.portalProcess == null) {
            return;
        }
        if (this.portalProcess.processPortalTeleportation(var0, this, this.canUsePortal(false))) {
            GameProfilerFiller var1 = Profiler.get();
            var1.push("portal");
            this.setPortalCooldown();
            TeleportTransition var2 = this.portalProcess.getPortalDestination(var0, this);
            if (var2 != null) {
                WorldServer var3 = var2.newLevel();
                if (var0.getServer().isAllowedToEnterPortal(var3) && (var3.dimension() == var0.dimension() || this.canTeleport(var0, var3))) {
                    this.teleport(var2);
                }
            }
            var1.pop();
        } else if (this.portalProcess.hasExpired()) {
            this.portalProcess = null;
        }
    }

    public int getDimensionChangingDelay() {
        Entity var0 = this.getFirstPassenger();
        return var0 instanceof EntityPlayer ? var0.getDimensionChangingDelay() : 300;
    }

    public void lerpMotion(Vec3D var0) {
        this.setDeltaMovement(var0);
    }

    public void handleDamageEvent(DamageSource var0) {
    }

    public void handleEntityEvent(byte var0) {
        switch (var0) {
            case 53: {
                BlockHoney.showSlideParticles(this);
            }
        }
    }

    public void animateHurt(float var0) {
    }

    public boolean isOnFire() {
        boolean var0 = this.level() != null && this.level().isClientSide();
        return !this.fireImmune() && (this.remainingFireTicks > 0 || var0 && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean dismountsUnderwater() {
        return this.getType().is(TagsEntity.DISMOUNTS_UNDERWATER);
    }

    public boolean canControlVehicle() {
        return !this.getType().is(TagsEntity.NON_CONTROLLING_RIDER);
    }

    public void setShiftKeyDown(boolean var0) {
        this.setSharedFlag(1, var0);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.hasPose(EntityPose.CROUCHING);
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean var0) {
        this.setSharedFlag(3, var0);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.hasPose(EntityPose.SWIMMING);
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean var0) {
        this.setSharedFlag(4, var0);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean var0) {
        this.hasGlowingTag = var0;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        if (this.level().isClientSide()) {
            return this.getSharedFlag(6);
        }
        return this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(EntityHuman var0) {
        if (var0.isSpectator()) {
            return false;
        }
        ScoreboardTeam var1 = this.getTeam();
        if (var1 != null && var0 != null && var0.getTeam() == var1 && ((ScoreboardTeamBase)var1).canSeeFriendlyInvisibles()) {
            return false;
        }
        return this.isInvisible();
    }

    public boolean isOnRails() {
        return false;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, WorldServer> var0) {
    }

    @Nullable
    public ScoreboardTeam getTeam() {
        return this.level().getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public final boolean isAlliedTo(@Nullable Entity var0) {
        if (var0 == null) {
            return false;
        }
        return this == var0 || this.considersEntityAsAlly(var0) || var0.considersEntityAsAlly(this);
    }

    protected boolean considersEntityAsAlly(Entity var0) {
        return this.isAlliedTo(var0.getTeam());
    }

    public boolean isAlliedTo(@Nullable ScoreboardTeamBase var0) {
        if (this.getTeam() != null) {
            return this.getTeam().isAlliedTo(var0);
        }
        return false;
    }

    public void setInvisible(boolean var0) {
        this.setSharedFlag(5, var0);
    }

    public boolean getSharedFlag(int var0) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << var0) != 0;
    }

    public void setSharedFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (var1) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(var2 | 1 << var0));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(var2 & ~(1 << var0)));
        }
    }

    public int getMaxAirSupply() {
        return 300;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int var0) {
        this.entityData.set(DATA_AIR_SUPPLY_ID, var0);
    }

    public void clearFreeze() {
        this.setTicksFrozen(0);
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int var0) {
        this.entityData.set(DATA_TICKS_FROZEN, var0);
    }

    public float getPercentFrozen() {
        int var0 = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), var0) / (float)var0;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(WorldServer var0, EntityLightning var1) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        if (this.remainingFireTicks == 0) {
            this.igniteForSeconds(8.0f);
        }
        this.hurtServer(var0, this.damageSources().lightningBolt(), 5.0f);
    }

    public void onAboveBubbleColumn(boolean var0, BlockPosition var1) {
        Entity.handleOnAboveBubbleColumn(this, var0, var1);
    }

    protected static void handleOnAboveBubbleColumn(Entity var0, boolean var1, BlockPosition var2) {
        Vec3D var3 = var0.getDeltaMovement();
        double var4 = var1 ? Math.max(-0.9, var3.y - 0.03) : Math.min(1.8, var3.y + 0.1);
        var0.setDeltaMovement(var3.x, var4, var3.z);
        Entity.sendBubbleColumnParticles(var0.level, var2);
    }

    protected static void sendBubbleColumnParticles(World var0, BlockPosition var1) {
        if (var0 instanceof WorldServer) {
            WorldServer var2 = (WorldServer)var0;
            for (int var3 = 0; var3 < 2; ++var3) {
                var2.sendParticles(Particles.SPLASH, (double)var1.getX() + var0.random.nextDouble(), var1.getY() + 1, (double)var1.getZ() + var0.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                var2.sendParticles(Particles.BUBBLE, (double)var1.getX() + var0.random.nextDouble(), var1.getY() + 1, (double)var1.getZ() + var0.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void onInsideBubbleColumn(boolean var0) {
        Entity.handleOnInsideBubbleColumn(this, var0);
    }

    protected static void handleOnInsideBubbleColumn(Entity var0, boolean var1) {
        Vec3D var2 = var0.getDeltaMovement();
        double var3 = var1 ? Math.max(-0.3, var2.y - 0.03) : Math.min(0.7, var2.y + 0.06);
        var0.setDeltaMovement(var2.x, var3, var2.z);
        var0.resetFallDistance();
    }

    public boolean killedEntity(WorldServer var0, EntityLiving var1, DamageSource var2) {
        return true;
    }

    public void checkFallDistanceAccumulation() {
        if (this.getDeltaMovement().y() > -0.5 && this.fallDistance > 1.0) {
            this.fallDistance = 1.0;
        }
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0;
    }

    protected void moveTowardsClosestSpace(double var0, double var2, double var4) {
        BlockPosition var6 = BlockPosition.containing(var0, var2, var4);
        Vec3D var7 = new Vec3D(var0 - (double)var6.getX(), var2 - (double)var6.getY(), var4 - (double)var6.getZ());
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        EnumDirection var9 = EnumDirection.UP;
        double var10 = Double.MAX_VALUE;
        for (EnumDirection var15 : new EnumDirection[]{EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.WEST, EnumDirection.EAST, EnumDirection.UP}) {
            double var18;
            var8.setWithOffset((BaseBlockPosition)var6, var15);
            if (this.level().getBlockState(var8).isCollisionShapeFullBlock(this.level(), var8)) continue;
            double var16 = var7.get(var15.getAxis());
            double d2 = var18 = var15.getAxisDirection() == EnumDirection.EnumAxisDirection.POSITIVE ? 1.0 - var16 : var16;
            if (!(var18 < var10)) continue;
            var10 = var18;
            var9 = var15;
        }
        float var12 = this.random.nextFloat() * 0.2f + 0.1f;
        float var13 = var9.getAxisDirection().getStep();
        Vec3D var14 = this.getDeltaMovement().scale(0.75);
        if (var9.getAxis() == EnumDirection.EnumAxis.X) {
            this.setDeltaMovement(var13 * var12, var14.y, var14.z);
        } else if (var9.getAxis() == EnumDirection.EnumAxis.Y) {
            this.setDeltaMovement(var14.x, var13 * var12, var14.z);
        } else if (var9.getAxis() == EnumDirection.EnumAxis.Z) {
            this.setDeltaMovement(var14.x, var14.y, var13 * var12);
        }
    }

    public void makeStuckInBlock(IBlockData var0, Vec3D var1) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = var1;
    }

    private static IChatBaseComponent removeAction(IChatBaseComponent var0) {
        IChatMutableComponent var1 = var0.plainCopy().setStyle(var0.getStyle().withClickEvent(null));
        for (IChatBaseComponent var3 : var0.getSiblings()) {
            var1.append(Entity.removeAction(var3));
        }
        return var1;
    }

    @Override
    public IChatBaseComponent getName() {
        IChatBaseComponent var0 = this.getCustomName();
        if (var0 != null) {
            return Entity.removeAction(var0);
        }
        return this.getTypeName();
    }

    protected IChatBaseComponent getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity var0) {
        return this == var0;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float var0) {
    }

    public void setYBodyRot(float var0) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity var0) {
        return false;
    }

    public String toString() {
        String var0;
        String string = var0 = this.level() == null ? "~NULL~" : this.level().toString();
        if (this.removalReason != null) {
            return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getPlainTextName(), this.id, var0, this.getX(), this.getY(), this.getZ(), this.removalReason});
        }
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getPlainTextName(), this.id, var0, this.getX(), this.getY(), this.getZ());
    }

    public final boolean isInvulnerableToBase(DamageSource var0) {
        return this.isRemoved() || this.invulnerable && !var0.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !var0.isCreativePlayer() || var0.is(DamageTypeTags.IS_FIRE) && this.fireImmune() || var0.is(DamageTypeTags.IS_FALL) && this.getType().is(TagsEntity.FALL_DAMAGE_IMMUNE);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean var0) {
        this.invulnerable = var0;
    }

    public void copyPosition(Entity var0) {
        this.snapTo(var0.getX(), var0.getY(), var0.getZ(), var0.getYRot(), var0.getXRot());
    }

    public void restoreFrom(Entity var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(this.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            this.load(TagValueInput.create((ProblemReporter)var1, (HolderLookup.a)this.registryAccess(), var2.buildResult()));
        }
        this.portalCooldown = var0.portalCooldown;
        this.portalProcess = var0.portalProcess;
    }

    @Nullable
    public Entity teleport(TeleportTransition var0) {
        boolean var3;
        WorldServer var1;
        block6: {
            block5: {
                World world = this.level();
                if (!(world instanceof WorldServer)) break block5;
                var1 = (WorldServer)world;
                if (!this.isRemoved()) break block6;
            }
            return null;
        }
        WorldServer var2 = var0.newLevel();
        boolean bl = var3 = var2.dimension() != var1.dimension();
        if (!var0.asPassenger()) {
            this.stopRiding();
        }
        if (var3) {
            return this.teleportCrossDimension(var1, var2, var0);
        }
        return this.teleportSameDimension(var1, var0);
    }

    private Entity teleportSameDimension(WorldServer var0, TeleportTransition var1) {
        for (Entity var3 : this.getPassengers()) {
            var3.teleport(this.calculatePassengerTransition(var1, var3));
        }
        GameProfilerFiller var2 = Profiler.get();
        var2.push("teleportSameDimension");
        this.teleportSetPosition(PositionMoveRotation.of(var1), var1.relatives());
        if (!var1.asPassenger()) {
            this.sendTeleportTransitionToRidingPlayers(var1);
        }
        var1.postTeleportTransition().onTransition(this);
        var2.pop();
        return this;
    }

    @Nullable
    private Entity teleportCrossDimension(WorldServer var0, WorldServer var1, TeleportTransition var2) {
        Entity var62;
        List<Entity> var3 = this.getPassengers();
        ArrayList<Entity> var4 = new ArrayList<Entity>(var3.size());
        this.ejectPassengers();
        for (Entity var62 : var3) {
            Entity var7 = var62.teleport(this.calculatePassengerTransition(var2, var62));
            if (var7 == null) continue;
            var4.add(var7);
        }
        GameProfilerFiller var5 = Profiler.get();
        var5.push("teleportCrossDimension");
        var62 = this.getType().create(var1, EntitySpawnReason.DIMENSION_TRAVEL);
        if (var62 == null) {
            var5.pop();
            return null;
        }
        var62.restoreFrom(this);
        this.removeAfterChangingDimensions();
        var62.teleportSetPosition(PositionMoveRotation.of(this), PositionMoveRotation.of(var2), var2.relatives());
        var1.addDuringTeleport(var62);
        for (Entity var8 : var4) {
            var8.startRiding(var62, true, false);
        }
        var1.resetEmptyTime();
        var2.postTeleportTransition().onTransition(var62);
        this.teleportSpectators(var2, var0);
        var5.pop();
        return var62;
    }

    protected void teleportSpectators(TeleportTransition var0, WorldServer var1) {
        List<EntityPlayer> var2 = List.copyOf(var1.players());
        for (EntityPlayer var4 : var2) {
            if (var4.getCamera() != this) continue;
            var4.teleport(var0);
            var4.setCamera(null);
        }
    }

    private TeleportTransition calculatePassengerTransition(TeleportTransition var0, Entity var1) {
        float var2 = var0.yRot() + (var0.relatives().contains((Object)Relative.Y_ROT) ? 0.0f : var1.getYRot() - this.getYRot());
        float var3 = var0.xRot() + (var0.relatives().contains((Object)Relative.X_ROT) ? 0.0f : var1.getXRot() - this.getXRot());
        Vec3D var4 = var1.position().subtract(this.position());
        Vec3D var5 = var0.position().add(var0.relatives().contains((Object)Relative.X) ? 0.0 : var4.x(), var0.relatives().contains((Object)Relative.Y) ? 0.0 : var4.y(), var0.relatives().contains((Object)Relative.Z) ? 0.0 : var4.z());
        return var0.withPosition(var5).withRotation(var2, var3).transitionAsPassenger();
    }

    private void sendTeleportTransitionToRidingPlayers(TeleportTransition var0) {
        EntityLiving var1 = this.getControllingPassenger();
        for (Entity var3 : this.getIndirectPassengers()) {
            if (!(var3 instanceof EntityPlayer)) continue;
            EntityPlayer var4 = (EntityPlayer)var3;
            if (var1 != null && var4.getId() == var1.getId()) {
                var4.connection.send(PacketPlayOutEntityTeleport.teleport(this.getId(), PositionMoveRotation.of(var0), var0.relatives(), this.onGround));
                continue;
            }
            var4.connection.send(PacketPlayOutEntityTeleport.teleport(this.getId(), PositionMoveRotation.of(this), Set.of(), this.onGround));
        }
    }

    public void teleportSetPosition(PositionMoveRotation var0, Set<Relative> var1) {
        this.teleportSetPosition(PositionMoveRotation.of(this), var0, var1);
    }

    public void teleportSetPosition(PositionMoveRotation var0, PositionMoveRotation var1, Set<Relative> var2) {
        PositionMoveRotation var3 = PositionMoveRotation.calculateAbsolute(var0, var1, var2);
        this.setPosRaw(var3.position().x, var3.position().y, var3.position().z);
        this.setYRot(var3.yRot());
        this.setYHeadRot(var3.yRot());
        this.setXRot(var3.xRot());
        this.reapplyPosition();
        this.setOldPosAndRot();
        this.setDeltaMovement(var3.deltaMovement());
        this.clearMovementThisTick();
    }

    public void forceSetRotation(float var0, boolean var1, float var2, boolean var3) {
        Set<Relative> var4 = Relative.rotation(var1, var3);
        PositionMoveRotation var5 = PositionMoveRotation.of(this);
        PositionMoveRotation var6 = var5.withRotation(var0, var2);
        PositionMoveRotation var7 = PositionMoveRotation.calculateAbsolute(var5, var6, var4);
        this.setYRot(var7.yRot());
        this.setYHeadRot(var7.yRot());
        this.setXRot(var7.xRot());
        this.setOldRot();
    }

    public void placePortalTicket(BlockPosition var0) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            var1.getChunkSource().addTicketWithRadius(TicketType.PORTAL, new ChunkCoordIntPair(var0), 3);
        }
    }

    protected void removeAfterChangingDimensions() {
        Object object;
        Object var0;
        this.setRemoved(RemovalReason.CHANGED_DIMENSION);
        Entity entity = this;
        if (entity instanceof Leashable) {
            var0 = (Leashable)((Object)entity);
            var0.removeLeash();
        }
        if ((object = this) instanceof WaypointTransmitter) {
            var0 = (WaypointTransmitter)object;
            object = this.level;
            if (object instanceof WorldServer) {
                WorldServer var1 = (WorldServer)object;
                var1.getWaypointManager().untrackWaypoint((WaypointTransmitter)var0);
            }
        }
    }

    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return BlockPortalShape.getRelativePosition(var1, var0, this.position(), this.getDimensions(this.getPose()));
    }

    public boolean canUsePortal(boolean var0) {
        return (var0 || !this.isPassenger()) && this.isAlive();
    }

    public boolean canTeleport(World var0, World var1) {
        if (var0.dimension() == World.END && var1.dimension() == World.OVERWORLD) {
            for (Entity var3 : this.getPassengers()) {
                if (!(var3 instanceof EntityPlayer)) continue;
                EntityPlayer var4 = (EntityPlayer)var3;
                if (var4.seenCredits) continue;
                return false;
            }
        }
        return true;
    }

    public float getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4, float var5) {
        return var5;
    }

    public boolean shouldBlockExplode(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, float var4) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        var0.setDetail("Entity Type", () -> String.valueOf(EntityTypes.getKey(this.getType())) + " (" + this.getClass().getCanonicalName() + ")");
        var0.setDetail("Entity ID", this.id);
        var0.setDetail("Entity Name", () -> this.getPlainTextName());
        var0.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        var0.setDetail("Entity's Block location", CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this.level(), MathHelper.floor(this.getX()), MathHelper.floor(this.getY()), MathHelper.floor(this.getZ())));
        Vec3D var1 = this.getDeltaMovement();
        var0.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", var1.x, var1.y, var1.z));
        var0.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        var0.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID var0) {
        this.uuid = var0;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    @Override
    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double var0) {
        viewScale = var0;
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return ScoreboardTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(var0 -> var0.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(var0));
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean var0) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, var0);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public boolean teleportTo(WorldServer var0, double var1, double var3, double var5, Set<Relative> var7, float var8, float var9, boolean var10) {
        Entity var11 = this.teleport(new TeleportTransition(var0, new Vec3D(var1, var3, var5), Vec3D.ZERO, var8, var9, var7, TeleportTransition.DO_NOTHING));
        return var11 != null;
    }

    public void dismountTo(double var0, double var2, double var4) {
        this.teleportTo(var0, var2, var4);
    }

    public void teleportTo(double var0, double var2, double var4) {
        if (!(this.level() instanceof WorldServer)) {
            return;
        }
        this.snapTo(var0, var2, var4, this.getYRot(), this.getXRot());
        this.teleportPassengers();
    }

    private void teleportPassengers() {
        this.getSelfAndPassengers().forEach(var0 -> {
            for (Entity var2 : var0.passengers) {
                var0.positionRider(var2, Entity::snapTo);
            }
        });
    }

    public void teleportRelative(double var0, double var2, double var4) {
        this.teleportTo(this.getX() + var0, this.getY() + var2, this.getZ() + var4);
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    @Override
    public void onSyncedDataUpdated(List<DataWatcher.c<?>> var0) {
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_POSE.equals(var0)) {
            this.refreshDimensions();
        }
    }

    @Deprecated
    protected void fixupDimensions() {
        EntitySize var1;
        EntityPose var0 = this.getPose();
        this.dimensions = var1 = this.getDimensions(var0);
        this.eyeHeight = var1.eyeHeight();
    }

    public void refreshDimensions() {
        boolean var3;
        EntitySize var2;
        EntitySize var0 = this.dimensions;
        EntityPose var1 = this.getPose();
        this.dimensions = var2 = this.getDimensions(var1);
        this.eyeHeight = var2.eyeHeight();
        this.reapplyPosition();
        boolean bl = var3 = var2.width() <= 4.0f && var2.height() <= 4.0f;
        if (!(this.level.isClientSide() || this.firstTick || this.noPhysics || !var3 || !(var2.width() > var0.width()) && !(var2.height() > var0.height()) || this instanceof EntityHuman)) {
            this.fudgePositionAfterSizeChange(var0);
        }
    }

    public boolean fudgePositionAfterSizeChange(EntitySize var0) {
        VoxelShape var9;
        Optional<Vec3D> var10;
        double var5;
        double var3;
        EntitySize var1 = this.getDimensions(this.getPose());
        Vec3D var2 = this.position().add(0.0, (double)var0.height() / 2.0, 0.0);
        VoxelShape var7 = VoxelShapes.create(AxisAlignedBB.ofSize(var2, var3 = (double)Math.max(0.0f, var1.width() - var0.width()) + 1.0E-6, var5 = (double)Math.max(0.0f, var1.height() - var0.height()) + 1.0E-6, var3));
        Optional<Vec3D> var8 = this.level.findFreePosition(this, var7, var2, var1.width(), var1.height(), var1.width());
        if (var8.isPresent()) {
            this.setPos(var8.get().add(0.0, (double)(-var1.height()) / 2.0, 0.0));
            return true;
        }
        if (var1.width() > var0.width() && var1.height() > var0.height() && (var10 = this.level.findFreePosition(this, var9 = VoxelShapes.create(AxisAlignedBB.ofSize(var2, var3, 1.0E-6, var3)), var2, var1.width(), var0.height(), var1.width())).isPresent()) {
            this.setPos(var10.get().add(0.0, (double)(-var0.height()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection getDirection() {
        return EnumDirection.fromYRot(this.getYRot());
    }

    public EnumDirection getMotionDirection() {
        return this.getDirection();
    }

    protected ChatHoverable createHoverEvent() {
        return new ChatHoverable.c(new ChatHoverable.b(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(EntityPlayer var0) {
        return true;
    }

    @Override
    public final AxisAlignedBB getBoundingBox() {
        return this.bb;
    }

    public final void setBoundingBox(AxisAlignedBB var0) {
        this.bb = var0;
    }

    public final float getEyeHeight(EntityPose var0) {
        return this.getDimensions(var0).eyeHeight();
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public SlotAccess getSlot(int var0) {
        return SlotAccess.NULL;
    }

    public EnumInteractionResult interactAt(EntityHuman var0, Vec3D var1, EnumHand var2) {
        return EnumInteractionResult.PASS;
    }

    public boolean ignoreExplosion(Explosion var0) {
        return false;
    }

    public void startSeenByPlayer(EntityPlayer var0) {
    }

    public void stopSeenByPlayer(EntityPlayer var0) {
    }

    public float rotate(EnumBlockRotation var0) {
        float var1 = MathHelper.wrapDegrees(this.getYRot());
        return switch (var0) {
            case EnumBlockRotation.CLOCKWISE_180 -> var1 + 180.0f;
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> var1 + 270.0f;
            case EnumBlockRotation.CLOCKWISE_90 -> var1 + 90.0f;
            default -> var1;
        };
    }

    public float mirror(EnumBlockMirror var0) {
        float var1 = MathHelper.wrapDegrees(this.getYRot());
        return switch (var0) {
            case EnumBlockMirror.FRONT_BACK -> -var1;
            case EnumBlockMirror.LEFT_RIGHT -> 180.0f - var1;
            default -> var1;
        };
    }

    public ProjectileDeflection deflection(IProjectile var0) {
        return this.getType().is(TagsEntity.DEFLECTS_PROJECTILES) ? ProjectileDeflection.REVERSE : ProjectileDeflection.NONE;
    }

    @Nullable
    public EntityLiving getControllingPassenger() {
        return null;
    }

    public final boolean hasControllingPassenger() {
        return this.getControllingPassenger() != null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity var0) {
        return this.passengers.contains((Object)var0);
    }

    public boolean hasPassenger(Predicate<Entity> var0) {
        for (Entity var2 : this.passengers) {
            if (!var0.test(var2)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public int countPlayerPassengers() {
        return (int)this.getIndirectPassengersStream().filter(var0 -> var0 instanceof EntityHuman).count();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return this.countPlayerPassengers() == 1;
    }

    public Entity getRootVehicle() {
        Entity var0 = this;
        while (var0.isPassenger()) {
            var0 = var0.getVehicle();
        }
        return var0;
    }

    public boolean isPassengerOfSameVehicle(Entity var0) {
        return this.getRootVehicle() == var0.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity var0) {
        if (!var0.isPassenger()) {
            return false;
        }
        Entity var1 = var0.getVehicle();
        if (var1 == this) {
            return true;
        }
        return this.hasIndirectPassenger(var1);
    }

    public final boolean isLocalInstanceAuthoritative() {
        if (this.level.isClientSide()) {
            return this.isLocalClientAuthoritative();
        }
        return !this.isClientAuthoritative();
    }

    protected boolean isLocalClientAuthoritative() {
        EntityLiving var0 = this.getControllingPassenger();
        return var0 != null && var0.isLocalClientAuthoritative();
    }

    public boolean isClientAuthoritative() {
        EntityLiving var0 = this.getControllingPassenger();
        return var0 != null && var0.isClientAuthoritative();
    }

    public boolean canSimulateMovement() {
        return this.isLocalInstanceAuthoritative();
    }

    public boolean isEffectiveAi() {
        return this.isLocalInstanceAuthoritative();
    }

    protected static Vec3D getCollisionHorizontalEscapeVector(double var0, double var2, float var4) {
        double var5 = (var0 + var2 + (double)1.0E-5f) / 2.0;
        float var7 = -MathHelper.sin(var4 * ((float)Math.PI / 180));
        float var8 = MathHelper.cos(var4 * ((float)Math.PI / 180));
        float var9 = Math.max(Math.abs(var7), Math.abs(var8));
        return new Vec3D((double)var7 * var5 / (double)var9, 0.0, (double)var8 * var5 / (double)var9);
    }

    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        return new Vec3D(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    @Nullable
    public Entity getControlledVehicle() {
        return this.vehicle != null && this.vehicle.getControllingPassenger() == this ? this.vehicle : null;
    }

    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.NORMAL;
    }

    public SoundCategory getSoundSource() {
        return SoundCategory.NEUTRAL;
    }

    public int getFireImmuneTicks() {
        return 0;
    }

    public CommandListenerWrapper createCommandSourceStackForNameResolution(WorldServer var0) {
        return new CommandListenerWrapper(ICommandListener.NULL, this.position(), this.getRotationVector(), var0, 0, this.getPlainTextName(), this.getDisplayName(), var0.getServer(), this);
    }

    public void lookAt(ArgumentAnchor.Anchor var0, Vec3D var1) {
        Vec3D var2 = var0.apply(this);
        double var3 = var1.x - var2.x;
        double var5 = var1.y - var2.y;
        double var7 = var1.z - var2.z;
        double var9 = Math.sqrt(var3 * var3 + var7 * var7);
        this.setXRot(MathHelper.wrapDegrees((float)(-(MathHelper.atan2(var5, var9) * 57.2957763671875))));
        this.setYRot(MathHelper.wrapDegrees((float)(MathHelper.atan2(var7, var3) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getPreciseBodyRotation(float var0) {
        return MathHelper.lerp(var0, this.yRotO, this.yRot);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<FluidType> var0, double var1) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AxisAlignedBB var3 = this.getBoundingBox().deflate(0.001);
        int var4 = MathHelper.floor(var3.minX);
        int var5 = MathHelper.ceil(var3.maxX);
        int var6 = MathHelper.floor(var3.minY);
        int var7 = MathHelper.ceil(var3.maxY);
        int var8 = MathHelper.floor(var3.minZ);
        int var9 = MathHelper.ceil(var3.maxZ);
        double var10 = 0.0;
        boolean var12 = this.isPushedByFluid();
        boolean var13 = false;
        Vec3D var14 = Vec3D.ZERO;
        int var15 = 0;
        BlockPosition.MutableBlockPosition var16 = new BlockPosition.MutableBlockPosition();
        for (int var17 = var4; var17 < var5; ++var17) {
            for (int var18 = var6; var18 < var7; ++var18) {
                for (int var19 = var8; var19 < var9; ++var19) {
                    double var21;
                    var16.set(var17, var18, var19);
                    Fluid var20 = this.level().getFluidState(var16);
                    if (!var20.is(var0) || !((var21 = (double)((float)var18 + var20.getHeight(this.level(), var16))) >= var3.minY)) continue;
                    var13 = true;
                    var10 = Math.max(var21 - var3.minY, var10);
                    if (!var12) continue;
                    Vec3D var23 = var20.getFlow(this.level(), var16);
                    if (var10 < 0.4) {
                        var23 = var23.scale(var10);
                    }
                    var14 = var14.add(var23);
                    ++var15;
                }
            }
        }
        if (var14.length() > 0.0) {
            if (var15 > 0) {
                var14 = var14.scale(1.0 / (double)var15);
            }
            if (!(this instanceof EntityHuman)) {
                var14 = var14.normalize();
            }
            Vec3D var17 = this.getDeltaMovement();
            var14 = var14.scale(var1);
            double var18 = 0.003;
            if (Math.abs(var17.x) < 0.003 && Math.abs(var17.z) < 0.003 && var14.length() < 0.0045000000000000005) {
                var14 = var14.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(var14));
        }
        this.fluidHeight.put(var0, var10);
        return var13;
    }

    public boolean touchingUnloadedChunk() {
        AxisAlignedBB var0 = this.getBoundingBox().inflate(1.0);
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.ceil(var0.maxX);
        int var3 = MathHelper.floor(var0.minZ);
        int var4 = MathHelper.ceil(var0.maxZ);
        return !this.level().hasChunksAt(var1, var3, var2, var4);
    }

    public double getFluidHeight(TagKey<FluidType> var0) {
        return this.fluidHeight.getDouble(var0);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width();
    }

    public final float getBbHeight() {
        return this.dimensions.height();
    }

    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        return new PacketPlayOutSpawnEntity(this, var0);
    }

    public EntitySize getDimensions(EntityPose var0) {
        return this.type.getDimensions();
    }

    public final EntityAttachments getAttachments() {
        return this.dimensions.attachments();
    }

    @Override
    public Vec3D position() {
        return this.position;
    }

    public Vec3D trackingPosition() {
        return this.position();
    }

    @Override
    public BlockPosition blockPosition() {
        return this.blockPosition;
    }

    public IBlockData getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.level().getBlockState(this.blockPosition());
        }
        return this.inBlockState;
    }

    public ChunkCoordIntPair chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3D getDeltaMovement() {
        return this.deltaMovement;
    }

    public void setDeltaMovement(Vec3D var0) {
        this.deltaMovement = var0;
    }

    public void addDeltaMovement(Vec3D var0) {
        this.setDeltaMovement(this.getDeltaMovement().add(var0));
    }

    public void setDeltaMovement(double var0, double var2, double var4) {
        this.setDeltaMovement(new Vec3D(var0, var2, var4));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double var0) {
        return this.position.x + (double)this.getBbWidth() * var0;
    }

    public double getRandomX(double var0) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * var0);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double var0) {
        return this.position.y + (double)this.getBbHeight() * var0;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double var0) {
        return this.position.z + (double)this.getBbWidth() * var0;
    }

    public double getRandomZ(double var0) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * var0);
    }

    public final void setPosRaw(double var0, double var2, double var4) {
        if (this.position.x != var0 || this.position.y != var2 || this.position.z != var4) {
            World world;
            this.position = new Vec3D(var0, var2, var4);
            int var6 = MathHelper.floor(var0);
            int var7 = MathHelper.floor(var2);
            int var8 = MathHelper.floor(var4);
            if (var6 != this.blockPosition.getX() || var7 != this.blockPosition.getY() || var8 != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPosition(var6, var7, var8);
                this.inBlockState = null;
                if (SectionPosition.blockToSectionCoord(var6) != this.chunkPosition.x || SectionPosition.blockToSectionCoord(var8) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkCoordIntPair(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
            if (!this.firstTick && (world = this.level) instanceof WorldServer) {
                WorldServer var9 = (WorldServer)world;
                if (!this.isRemoved()) {
                    WaypointTransmitter var10;
                    Entity entity = this;
                    if (entity instanceof WaypointTransmitter && (var10 = (WaypointTransmitter)((Object)entity)).isTransmittingWaypoint()) {
                        var9.getWaypointManager().updateWaypoint(var10);
                    }
                    if ((entity = this) instanceof EntityPlayer && ((EntityPlayer)(var10 = (EntityPlayer)entity)).isReceivingWaypoints() && ((EntityPlayer)var10).connection != null) {
                        var9.getWaypointManager().updatePlayer((EntityPlayer)var10);
                    }
                }
            }
        }
    }

    public void checkDespawn() {
    }

    public Vec3D[] getQuadLeashHolderOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.0, 0.5, 0.5, 0.0);
    }

    public boolean supportQuadLeashAsHolder() {
        return false;
    }

    public void notifyLeashHolder(Leashable var0) {
    }

    public void notifyLeasheeRemoved(Leashable var0) {
    }

    public Vec3D getRopeHoldPosition(float var0) {
        return this.getPosition(var0).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        int var1 = var0.getId();
        double var2 = var0.getX();
        double var4 = var0.getY();
        double var6 = var0.getZ();
        this.syncPacketPositionCodec(var2, var4, var6);
        this.snapTo(var2, var4, var6, var0.getYRot(), var0.getXRot());
        this.setId(var1);
        this.setUUID(var0.getUUID());
        this.setDeltaMovement(var0.getMovement());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean var0) {
        this.isInPowderSnow = var0;
    }

    public boolean canFreeze() {
        return !this.getType().is(TagsEntity.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return this.getTicksFrozen() > 0;
    }

    public float getYRot() {
        return this.yRot;
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public void setYRot(float var0) {
        if (!Float.isFinite(var0)) {
            SystemUtils.logAndPauseIfInIde("Invalid entity rotation: " + var0 + ", discarding.");
            return;
        }
        this.yRot = var0;
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float var0) {
        if (!Float.isFinite(var0)) {
            SystemUtils.logAndPauseIfInIde("Invalid entity rotation: " + var0 + ", discarding.");
            return;
        }
        this.xRot = Math.clamp(var0 % 360.0f, -90.0f, 90.0f);
    }

    public boolean canSprint() {
        return false;
    }

    public float maxUpStep() {
        return 0.0f;
    }

    public void onExplosionHit(@Nullable Entity var0) {
    }

    @Override
    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason var0) {
        if (this.removalReason == null) {
            this.removalReason = var0;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        this.getPassengers().forEach(Entity::stopRiding);
        this.levelCallback.onRemove(var0);
        this.onRemoval(var0);
    }

    public void unsetRemoved() {
        this.removalReason = null;
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback var0) {
        this.levelCallback = var0;
    }

    @Override
    public boolean shouldBeSaved() {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        if (this.isPassenger()) {
            return false;
        }
        return !this.isVehicle() || !this.hasExactlyOnePlayerPassenger();
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(WorldServer var0, BlockPosition var1) {
        return true;
    }

    public boolean isFlyingVehicle() {
        return false;
    }

    @Override
    public World level() {
        return this.level;
    }

    protected void setLevel(World var0) {
        this.level = var0;
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public IRegistryCustom registryAccess() {
        return this.level().registryAccess();
    }

    protected void lerpPositionAndRotationStep(int var0, double var1, double var3, double var5, double var7, double var9) {
        double var11 = 1.0 / (double)var0;
        double var13 = MathHelper.lerp(var11, this.getX(), var1);
        double var15 = MathHelper.lerp(var11, this.getY(), var3);
        double var17 = MathHelper.lerp(var11, this.getZ(), var5);
        float var19 = (float)MathHelper.rotLerp(var11, (double)this.getYRot(), var7);
        float var20 = (float)MathHelper.lerp(var11, (double)this.getXRot(), var9);
        this.setPos(var13, var15, var17);
        this.setRot(var19, var20);
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public Vec3D getKnownMovement() {
        EntityLiving entityLiving = this.getControllingPassenger();
        if (entityLiving instanceof EntityHuman) {
            EntityHuman var0 = (EntityHuman)entityLiving;
            if (this.isAlive()) {
                return var0.getKnownMovement();
            }
        }
        return this.getDeltaMovement();
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        return this.type.getDefaultLootTable();
    }

    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.CUSTOM_NAME);
        this.applyImplicitComponentIfPresent(var0, DataComponents.CUSTOM_DATA);
    }

    public final void applyComponentsFromItemStack(ItemStack var0) {
        this.applyImplicitComponents(var0.getComponents());
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.CUSTOM_NAME) {
            return Entity.castComponentValue(var0, this.getCustomName());
        }
        if (var0 == DataComponents.CUSTOM_DATA) {
            return Entity.castComponentValue(var0, this.customData);
        }
        return null;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> T castComponentValue(DataComponentType<T> var0, @Nullable Object var1) {
        return (T)var1;
    }

    public <T> void setComponent(DataComponentType<T> var0, T var1) {
        this.applyImplicitComponent(var0, var1);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.CUSTOM_NAME) {
            this.setCustomName(Entity.castComponentValue(DataComponents.CUSTOM_NAME, var1));
            return true;
        }
        if (var0 == DataComponents.CUSTOM_DATA) {
            this.customData = Entity.castComponentValue(DataComponents.CUSTOM_DATA, var1);
            return true;
        }
        return false;
    }

    protected <T> boolean applyImplicitComponentIfPresent(DataComponentGetter var0, DataComponentType<T> var1) {
        T var2 = var0.get(var1);
        if (var2 != null) {
            return this.applyImplicitComponent(var1, var2);
        }
        return false;
    }

    public ProblemReporter.f problemPath() {
        return new a(this);
    }

    @Override
    public void registerDebugValues(WorldServer var0, DebugValueSource.a var1) {
    }

    private /* synthetic */ boolean a(int var0, AtomicInteger var1, boolean var2, Vec3D var3, Vec3D var4, LongSet var5, boolean var6, AxisAlignedBB var7, InsideBlockEffectApplier.a var8, BlockPosition var9, int var10) {
        if (!this.isAlive()) {
            return false;
        }
        if (var10 >= var0) {
            return false;
        }
        var1.set(var10);
        IBlockData var11 = this.level().getBlockState(var9);
        if (var11.isAir()) {
            if (var2) {
                this.debugBlockIntersection((WorldServer)this.level(), var9.immutable(), false, false);
            }
            return true;
        }
        VoxelShape var12 = var11.getEntityInsideCollisionShape(this.level(), var9, this);
        boolean var13 = var12 == VoxelShapes.block() || this.collidedWithShapeMovingFrom(var3, var4, var12.move(new Vec3D(var9)).toAabbs());
        boolean var14 = this.collidedWithFluid(var11.getFluidState(), var9, var3, var4);
        if (!var13 && !var14 || !var5.add(var9.asLong())) {
            return true;
        }
        if (var13) {
            try {
                boolean var15 = var6 || var7.intersects(var9);
                var8.advanceStep(var10);
                var11.entityInside(this.level(), var9, this, var8, var15);
                this.onInsideBlock(var11);
            }
            catch (Throwable var15) {
                CrashReport var16 = CrashReport.forThrowable(var15, "Colliding entity with block");
                CrashReportSystemDetails var17 = var16.addCategory("Block being collided with");
                CrashReportSystemDetails.populateBlockDetails(var17, this.level(), var9, var11);
                CrashReportSystemDetails var18 = var16.addCategory("Entity being checked for collision");
                this.fillCrashReportCategory(var18);
                throw new ReportedException(var16);
            }
        }
        if (var14) {
            var8.advanceStep(var10);
            var11.getFluidState().entityInside(this.level(), var9, this, var8);
        }
        if (var2) {
            this.debugBlockIntersection((WorldServer)this.level(), var9.immutable(), var13, var14);
        }
        return true;
    }

    public static final class RemovalReason
    extends Enum<RemovalReason> {
        public static final /* enum */ RemovalReason KILLED = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason DISCARDED = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason UNLOADED_TO_CHUNK = new RemovalReason(false, true);
        public static final /* enum */ RemovalReason UNLOADED_WITH_PLAYER = new RemovalReason(false, false);
        public static final /* enum */ RemovalReason CHANGED_DIMENSION = new RemovalReason(false, false);
        private final boolean destroy;
        private final boolean save;
        private static final /* synthetic */ RemovalReason[] h;

        public static RemovalReason[] values() {
            return (RemovalReason[])h.clone();
        }

        public static RemovalReason valueOf(String var0) {
            return Enum.valueOf(RemovalReason.class, var0);
        }

        private RemovalReason(boolean var2, boolean var3) {
            this.destroy = var2;
            this.save = var3;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }

        private static /* synthetic */ RemovalReason[] c() {
            return new RemovalReason[]{KILLED, DISCARDED, UNLOADED_TO_CHUNK, UNLOADED_WITH_PLAYER, CHANGED_DIMENSION};
        }

        static {
            h = RemovalReason.c();
        }
    }

    static final class c
    extends Record {
        final Vec3D from;
        final Vec3D to;
        private final Optional<Vec3D> axisDependentOriginalMovement;

        public c(Vec3D var0, Vec3D var1, Vec3D var2) {
            this(var0, var1, Optional.of(var2));
        }

        public c(Vec3D var0, Vec3D var1) {
            this(var0, var1, Optional.empty());
        }

        private c(Vec3D var0, Vec3D var1, Optional<Vec3D> var2) {
            this.from = var0;
            this.to = var1;
            this.axisDependentOriginalMovement = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "from", "to", "axisDependentOriginalMovement"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "from", "to", "axisDependentOriginalMovement"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "from", "to", "axisDependentOriginalMovement"}, this, var0);
        }

        public Vec3D from() {
            return this.from;
        }

        public Vec3D to() {
            return this.to;
        }

        public Optional<Vec3D> axisDependentOriginalMovement() {
            return this.axisDependentOriginalMovement;
        }
    }

    public static final class MovementEmission
    extends Enum<MovementEmission> {
        public static final /* enum */ MovementEmission NONE = new MovementEmission(false, false);
        public static final /* enum */ MovementEmission SOUNDS = new MovementEmission(true, false);
        public static final /* enum */ MovementEmission EVENTS = new MovementEmission(false, true);
        public static final /* enum */ MovementEmission ALL = new MovementEmission(true, true);
        final boolean sounds;
        final boolean events;
        private static final /* synthetic */ MovementEmission[] g;

        public static MovementEmission[] values() {
            return (MovementEmission[])g.clone();
        }

        public static MovementEmission valueOf(String var0) {
            return Enum.valueOf(MovementEmission.class, var0);
        }

        private MovementEmission(boolean var2, boolean var3) {
            this.sounds = var2;
            this.events = var3;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }

        private static /* synthetic */ MovementEmission[] d() {
            return new MovementEmission[]{NONE, SOUNDS, EVENTS, ALL};
        }

        static {
            g = MovementEmission.d();
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    record a(Entity entity) implements ProblemReporter.f
    {
        @Override
        public String get() {
            return this.entity.toString();
        }
    }
}

