/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.portal.TeleportTransition;

public class PortalProcessor {
    private final Portal portal;
    private BlockPosition entryPosition;
    private int portalTime;
    private boolean insidePortalThisTick;

    public PortalProcessor(Portal var0, BlockPosition var1) {
        this.portal = var0;
        this.entryPosition = var1;
        this.insidePortalThisTick = true;
    }

    public boolean processPortalTeleportation(WorldServer var0, Entity var1, boolean var2) {
        if (this.insidePortalThisTick) {
            this.insidePortalThisTick = false;
            return var2 && this.portalTime++ >= this.portal.getPortalTransitionTime(var0, var1);
        }
        this.decayTick();
        return false;
    }

    @Nullable
    public TeleportTransition getPortalDestination(WorldServer var0, Entity var1) {
        return this.portal.getPortalDestination(var0, var1, this.entryPosition);
    }

    public Portal.a getPortalLocalTransition() {
        return this.portal.getLocalTransition();
    }

    private void decayTick() {
        this.portalTime = Math.max(this.portalTime - 4, 0);
    }

    public boolean hasExpired() {
        return this.portalTime <= 0;
    }

    public BlockPosition getEntryPosition() {
        return this.entryPosition;
    }

    public void updateEntryPosition(BlockPosition var0) {
        this.entryPosition = var0;
    }

    public int getPortalTime() {
        return this.portalTime;
    }

    public boolean isInsidePortalThisTick() {
        return this.insidePortalThisTick;
    }

    public void setAsInsidePortalThisTick(boolean var0) {
        this.insidePortalThisTick = var0;
    }

    public boolean isSamePortal(Portal var0) {
        return this.portal == var0;
    }
}

