/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.function.TriConsumer;

public class TransportItemsBetweenContainers
extends Behavior<EntityCreature> {
    public static final int TARGET_INTERACTION_TIME = 60;
    private static final int VISITED_POSITIONS_MEMORY_TIME = 6000;
    private static final int TRANSPORTED_ITEM_MAX_STACK_SIZE = 16;
    private static final int MAX_VISITED_POSITIONS = 10;
    private static final int MAX_UNREACHABLE_POSITIONS = 50;
    private static final int PASSENGER_MOB_TARGET_SEARCH_DISTANCE = 1;
    private static final int IDLE_COOLDOWN = 140;
    private static final double CLOSE_ENOUGH_TO_START_QUEUING_DISTANCE = 3.0;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_DISTANCE = 0.5;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_PATH_END_DISTANCE = 1.0;
    private static final double CLOSE_ENOUGH_TO_CONTINUE_INTERACTING_WITH_TARGET = 2.0;
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final Predicate<IBlockData> sourceBlockType;
    private final Predicate<IBlockData> destinationBlockType;
    private final Predicate<d> shouldQueueForTarget;
    private final Consumer<EntityCreature> onStartTravelling;
    private final Map<a, b> onTargetInteractionActions;
    @Nullable
    private d target = null;
    private c state;
    @Nullable
    private a interactionState;
    private int ticksSinceReachingTarget;

    public TransportItemsBetweenContainers(float var0, Predicate<IBlockData> var1, Predicate<IBlockData> var2, int var3, int var4, Map<a, b> var5, Consumer<EntityCreature> var6, Predicate<d> var7) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISITED_BLOCK_POSITIONS, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
        this.sourceBlockType = var1;
        this.destinationBlockType = var2;
        this.horizontalSearchDistance = var3;
        this.verticalSearchDistance = var4;
        this.onStartTravelling = var6;
        this.shouldQueueForTarget = var7;
        this.onTargetInteractionActions = var5;
        this.state = c.TRAVELLING;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        NavigationAbstract navigationAbstract = var1.getNavigation();
        if (navigationAbstract instanceof Navigation) {
            Navigation var4 = (Navigation)navigationAbstract;
            var4.setCanPathToTargetsBelowSurface(true);
        }
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return !var1.isLeashed();
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return var1.getBrain().getMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS).isEmpty() && !var1.isPanicking() && !var1.isLeashed();
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected void tick(WorldServer var0, EntityCreature var1, long var2) {
        boolean var4 = this.updateInvalidTarget(var0, var1);
        if (this.target == null) {
            this.stop(var0, var1, var2);
            return;
        }
        if (var4) {
            return;
        }
        if (this.state.equals((Object)c.QUEUING)) {
            this.onQueuingForTarget(this.target, var0, var1);
        }
        if (this.state.equals((Object)c.TRAVELLING)) {
            this.onTravelToTarget(this.target, var0, var1);
        }
        if (this.state.equals((Object)c.INTERACTING)) {
            this.onReachedTarget(this.target, var0, var1);
        }
    }

    private boolean updateInvalidTarget(WorldServer var0, EntityCreature var1) {
        if (!this.hasValidTarget(var0, var1)) {
            this.stopTargetingCurrentTarget(var1);
            Optional<d> var2 = this.getTransportTarget(var0, var1);
            if (var2.isPresent()) {
                this.target = var2.get();
                this.onStartTravelling(var1);
                this.setVisitedBlockPos(var1, var0, this.target.pos);
                return true;
            }
            this.enterCooldownAfterNoMatchingTargetFound(var1);
            return true;
        }
        return false;
    }

    private void onQueuingForTarget(d var0, World var1, EntityCreature var2) {
        if (!this.isAnotherMobInteractingWithTarget(var0, var1)) {
            this.resumeTravelling(var2);
        }
    }

    protected void onTravelToTarget(d var0, World var1, EntityCreature var2) {
        if (this.isWithinTargetDistance(3.0, var0, var1, var2, this.getCenterPos(var2)) && this.isAnotherMobInteractingWithTarget(var0, var1)) {
            this.startQueuing(var2);
        } else if (this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(var2), var0, var1, var2, this.getCenterPos(var2))) {
            this.startOnReachedTargetInteraction(var0, var2);
        } else {
            this.walkTowardsTarget(var2);
        }
    }

    private Vec3D getCenterPos(EntityCreature var0) {
        return this.setMiddleYPosition(var0, var0.position());
    }

    protected void onReachedTarget(d var0, World var12, EntityCreature var22) {
        if (!this.isWithinTargetDistance(2.0, var0, var12, var22, this.getCenterPos(var22))) {
            this.onStartTravelling(var22);
        } else {
            ++this.ticksSinceReachingTarget;
            this.onTargetInteraction(var0, var22);
            if (this.ticksSinceReachingTarget >= 60) {
                this.doReachedTargetInteraction(var22, var0.container, this::pickUpItems, (var1, var2) -> this.stopTargetingCurrentTarget(var22), this::putDownItem, (var1, var2) -> this.stopTargetingCurrentTarget(var22));
                this.onStartTravelling(var22);
            }
        }
    }

    private void startQueuing(EntityCreature var0) {
        this.stopInPlace(var0);
        this.setTransportingState(c.QUEUING);
    }

    private void resumeTravelling(EntityCreature var0) {
        this.setTransportingState(c.TRAVELLING);
        this.walkTowardsTarget(var0);
    }

    private void walkTowardsTarget(EntityCreature var0) {
        if (this.target != null) {
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var0, this.target.pos, this.speedModifier, 0);
        }
    }

    private void startOnReachedTargetInteraction(d var0, EntityCreature var1) {
        this.doReachedTargetInteraction(var1, var0.container, this.onReachedInteraction(a.PICKUP_ITEM), this.onReachedInteraction(a.PICKUP_NO_ITEM), this.onReachedInteraction(a.PLACE_ITEM), this.onReachedInteraction(a.PLACE_NO_ITEM));
        this.setTransportingState(c.INTERACTING);
    }

    private void onStartTravelling(EntityCreature var0) {
        this.onStartTravelling.accept(var0);
        this.setTransportingState(c.TRAVELLING);
        this.interactionState = null;
        this.ticksSinceReachingTarget = 0;
    }

    private BiConsumer<EntityCreature, IInventory> onReachedInteraction(a var0) {
        return (var1, var2) -> this.setInteractionState(var0);
    }

    private void setTransportingState(c var0) {
        this.state = var0;
    }

    private void setInteractionState(a var0) {
        this.interactionState = var0;
    }

    private void onTargetInteraction(d var0, EntityCreature var1) {
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(var0.pos));
        this.stopInPlace(var1);
        if (this.interactionState != null) {
            Optional.ofNullable(this.onTargetInteractionActions.get((Object)this.interactionState)).ifPresent(var2 -> var2.accept(var1, var0, this.ticksSinceReachingTarget));
        }
    }

    private void doReachedTargetInteraction(EntityCreature var0, IInventory var1, BiConsumer<EntityCreature, IInventory> var2, BiConsumer<EntityCreature, IInventory> var3, BiConsumer<EntityCreature, IInventory> var4, BiConsumer<EntityCreature, IInventory> var5) {
        if (TransportItemsBetweenContainers.isPickingUpItems(var0)) {
            if (TransportItemsBetweenContainers.matchesGettingItemsRequirement(var1)) {
                var2.accept(var0, var1);
            } else {
                var3.accept(var0, var1);
            }
        } else if (TransportItemsBetweenContainers.matchesLeavingItemsRequirement(var0, var1)) {
            var4.accept(var0, var1);
        } else {
            var5.accept(var0, var1);
        }
    }

    private Optional<d> getTransportTarget(WorldServer var0, EntityCreature var1) {
        AxisAlignedBB var2 = this.getTargetSearchArea(var1);
        Set<GlobalPos> var3 = TransportItemsBetweenContainers.getVisitedPositions(var1);
        Set<GlobalPos> var4 = TransportItemsBetweenContainers.getUnreachablePositions(var1);
        List<ChunkCoordIntPair> var5 = ChunkCoordIntPair.rangeClosed(new ChunkCoordIntPair(var1.blockPosition()), Math.floorDiv(this.getHorizontalSearchDistance(var1), 16) + 1).toList();
        d var6 = null;
        double var7 = 3.4028234663852886E38;
        for (ChunkCoordIntPair var10 : var5) {
            Chunk var11 = var0.getChunkSource().getChunkNow(var10.x, var10.z);
            if (var11 == null) continue;
            for (TileEntity var13 : var11.getBlockEntities().values()) {
                d var17;
                TileEntityChest var14;
                double var15;
                if (!(var13 instanceof TileEntityChest) || !((var15 = (var14 = (TileEntityChest)var13).getBlockPos().distToCenterSqr(var1.position())) < var7) || (var17 = this.isTargetValidToPick(var1, var0, var14, var3, var4, var2)) == null) continue;
                var6 = var17;
                var7 = var15;
            }
        }
        return var6 == null ? Optional.empty() : Optional.of(var6);
    }

    @Nullable
    private d isTargetValidToPick(EntityCreature var0, World var1, TileEntity var2, Set<GlobalPos> var3, Set<GlobalPos> var4, AxisAlignedBB var5) {
        BlockPosition var6 = var2.getBlockPos();
        boolean var7 = var5.contains(var6.getX(), var6.getY(), var6.getZ());
        if (!var7) {
            return null;
        }
        d var8 = d.tryCreatePossibleTarget(var2, var1);
        if (var8 == null) {
            return null;
        }
        boolean var9 = this.isWantedBlock(var0, var8.state) && !this.isPositionAlreadyVisited(var3, var4, var8, var1) && !this.isContainerLocked(var8);
        return var9 ? var8 : null;
    }

    private boolean isContainerLocked(d var0) {
        TileEntityContainer var1;
        TileEntity tileEntity = var0.blockEntity;
        return tileEntity instanceof TileEntityContainer && (var1 = (TileEntityContainer)tileEntity).isLocked();
    }

    private boolean hasValidTarget(World var0, EntityCreature var1) {
        boolean var2;
        boolean bl = var2 = this.target != null && this.isWantedBlock(var1, this.target.state) && this.targetHasNotChanged(var0, this.target);
        if (var2 && !this.isTargetBlocked(var0, this.target)) {
            if (!this.state.equals((Object)c.TRAVELLING)) {
                return true;
            }
            if (this.hasValidTravellingPath(var0, this.target, var1)) {
                return true;
            }
            this.markVisitedBlockPosAsUnreachable(var1, var0, this.target.pos);
        }
        return false;
    }

    private boolean hasValidTravellingPath(World var0, d var1, EntityCreature var2) {
        PathEntity var3 = var2.getNavigation().getPath() == null ? var2.getNavigation().createPath(var1.pos, 0) : var2.getNavigation().getPath();
        Vec3D var4 = this.getPositionToReachTargetFrom(var3, var2);
        boolean var5 = this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(var2), var1, var0, var2, var4);
        boolean var6 = var3 == null && !var5;
        return var6 || this.targetIsReachableFromPosition(var0, var5, var4, var1, var2);
    }

    private Vec3D getPositionToReachTargetFrom(@Nullable PathEntity var0, EntityCreature var1) {
        boolean var2 = var0 == null || var0.getEndNode() == null;
        Vec3D var3 = var2 ? var1.position() : var0.getEndNode().asBlockPos().getBottomCenter();
        return this.setMiddleYPosition(var1, var3);
    }

    private Vec3D setMiddleYPosition(EntityCreature var0, Vec3D var1) {
        return var1.add(0.0, var0.getBoundingBox().getYsize() / 2.0, 0.0);
    }

    private boolean isTargetBlocked(World var0, d var1) {
        return BlockChest.isChestBlockedAt(var0, var1.pos);
    }

    private boolean targetHasNotChanged(World var0, d var1) {
        return var1.blockEntity.equals(var0.getBlockEntity(var1.pos));
    }

    private Stream<d> getConnectedTargets(d var0, World var1) {
        if (var0.state.getValueOrElse(BlockChest.TYPE, BlockPropertyChestType.SINGLE) != BlockPropertyChestType.SINGLE) {
            d var2 = d.tryCreatePossibleTarget(BlockChest.getConnectedBlockPos(var0.pos, var0.state), var1);
            return var2 != null ? Stream.of(var0, var2) : Stream.of(var0);
        }
        return Stream.of(var0);
    }

    private AxisAlignedBB getTargetSearchArea(EntityCreature var0) {
        int var1 = this.getHorizontalSearchDistance(var0);
        return new AxisAlignedBB(var0.blockPosition()).inflate(var1, this.getVerticalSearchDistance(var0), var1);
    }

    private int getHorizontalSearchDistance(EntityCreature var0) {
        return var0.isPassenger() ? 1 : this.horizontalSearchDistance;
    }

    private int getVerticalSearchDistance(EntityCreature var0) {
        return var0.isPassenger() ? 1 : this.verticalSearchDistance;
    }

    private static Set<GlobalPos> getVisitedPositions(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS).orElse(Set.of());
    }

    private static Set<GlobalPos> getUnreachablePositions(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS).orElse(Set.of());
    }

    private boolean isPositionAlreadyVisited(Set<GlobalPos> var0, Set<GlobalPos> var12, d var22, World var3) {
        return this.getConnectedTargets(var22, var3).map(var1 -> new GlobalPos(var3.dimension(), var1.pos)).anyMatch(var2 -> var0.contains(var2) || var12.contains(var2));
    }

    private static boolean hasFinishedPath(EntityCreature var0) {
        return var0.getNavigation().getPath() != null && var0.getNavigation().getPath().isDone();
    }

    protected void setVisitedBlockPos(EntityCreature var0, World var1, BlockPosition var2) {
        HashSet<GlobalPos> var3 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(var0));
        var3.add(new GlobalPos(var1.dimension(), var2));
        if (var3.size() > 10) {
            this.enterCooldownAfterNoMatchingTargetFound(var0);
        } else {
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, var3, 6000L);
        }
    }

    protected void markVisitedBlockPosAsUnreachable(EntityCreature var0, World var1, BlockPosition var2) {
        HashSet<GlobalPos> var3 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(var0));
        var3.remove(new GlobalPos(var1.dimension(), var2));
        HashSet<GlobalPos> var4 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getUnreachablePositions(var0));
        var4.add(new GlobalPos(var1.dimension(), var2));
        if (var4.size() > 50) {
            this.enterCooldownAfterNoMatchingTargetFound(var0);
        } else {
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, var3, 6000L);
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, var4, 6000L);
        }
    }

    private boolean isWantedBlock(EntityCreature var0, IBlockData var1) {
        return TransportItemsBetweenContainers.isPickingUpItems(var0) ? this.sourceBlockType.test(var1) : this.destinationBlockType.test(var1);
    }

    private static double getInteractionRange(EntityCreature var0) {
        return TransportItemsBetweenContainers.hasFinishedPath(var0) ? 1.0 : 0.5;
    }

    private boolean isWithinTargetDistance(double var0, d var2, World var3, EntityCreature var4, Vec3D var5) {
        AxisAlignedBB var6 = var4.getBoundingBox();
        AxisAlignedBB var7 = AxisAlignedBB.ofSize(var5, var6.getXsize(), var6.getYsize(), var6.getZsize());
        return var2.state.getCollisionShape(var3, var2.pos).bounds().inflate(var0, 0.5, var0).move(var2.pos).intersects(var7);
    }

    private boolean targetIsReachableFromPosition(World var0, boolean var1, Vec3D var2, d var3, EntityCreature var4) {
        return var1 && this.canSeeAnyTargetSide(var3, var0, var4, var2);
    }

    private boolean canSeeAnyTargetSide(d var0, World var12, EntityCreature var2, Vec3D var32) {
        Vec3D var4 = var0.pos.getCenter();
        return EnumDirection.stream().map(var1 -> var4.add(0.5 * (double)var1.getStepX(), 0.5 * (double)var1.getStepY(), 0.5 * (double)var1.getStepZ())).map(var3 -> var12.clip(new RayTrace(var32, (Vec3D)var3, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var2))).anyMatch(var1 -> var1.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK && var1.getBlockPos().equals(var0.pos));
    }

    private boolean isAnotherMobInteractingWithTarget(d var0, World var1) {
        return this.getConnectedTargets(var0, var1).anyMatch(this.shouldQueueForTarget);
    }

    private static boolean isPickingUpItems(EntityCreature var0) {
        return var0.getMainHandItem().isEmpty();
    }

    private static boolean matchesGettingItemsRequirement(IInventory var0) {
        return !var0.isEmpty();
    }

    private static boolean matchesLeavingItemsRequirement(EntityCreature var0, IInventory var1) {
        return var1.isEmpty() || TransportItemsBetweenContainers.hasItemMatchingHandItem(var0, var1);
    }

    private static boolean hasItemMatchingHandItem(EntityCreature var0, IInventory var1) {
        ItemStack var2 = var0.getMainHandItem();
        for (ItemStack var4 : var1) {
            if (!ItemStack.isSameItem(var4, var2)) continue;
            return true;
        }
        return false;
    }

    private void pickUpItems(EntityCreature var0, IInventory var1) {
        var0.setItemSlot(EnumItemSlot.MAINHAND, TransportItemsBetweenContainers.pickupItemFromContainer(var1));
        var0.setGuaranteedDrop(EnumItemSlot.MAINHAND);
        var1.setChanged();
        this.clearMemoriesAfterMatchingTargetFound(var0);
    }

    private void putDownItem(EntityCreature var0, IInventory var1) {
        ItemStack var2 = TransportItemsBetweenContainers.addItemsToContainer(var0, var1);
        var1.setChanged();
        var0.setItemSlot(EnumItemSlot.MAINHAND, var2);
        if (var2.isEmpty()) {
            this.clearMemoriesAfterMatchingTargetFound(var0);
        } else {
            this.stopTargetingCurrentTarget(var0);
        }
    }

    private static ItemStack pickupItemFromContainer(IInventory var0) {
        int var1 = 0;
        for (ItemStack var3 : var0) {
            if (!var3.isEmpty()) {
                int var4 = Math.min(var3.getCount(), 16);
                return var0.removeItem(var1, var4);
            }
            ++var1;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack addItemsToContainer(EntityCreature var0, IInventory var1) {
        int var2 = 0;
        ItemStack var3 = var0.getMainHandItem();
        for (ItemStack var5 : var1) {
            if (var5.isEmpty()) {
                var1.setItem(var2, var3);
                return ItemStack.EMPTY;
            }
            if (ItemStack.isSameItemSameComponents(var5, var3) && var5.getCount() < var5.getMaxStackSize()) {
                int var6 = var5.getMaxStackSize() - var5.getCount();
                int var7 = Math.min(var6, var3.getCount());
                var5.setCount(var5.getCount() + var7);
                var3.setCount(var3.getCount() - var6);
                var1.setItem(var2, var5);
                if (var3.isEmpty()) {
                    return ItemStack.EMPTY;
                }
            }
            ++var2;
        }
        return var3;
    }

    protected void stopTargetingCurrentTarget(EntityCreature var0) {
        this.ticksSinceReachingTarget = 0;
        this.target = null;
        var0.getNavigation().stop();
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    protected void clearMemoriesAfterMatchingTargetFound(EntityCreature var0) {
        this.stopTargetingCurrentTarget(var0);
        var0.getBrain().eraseMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS);
        var0.getBrain().eraseMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS);
    }

    private void enterCooldownAfterNoMatchingTargetFound(EntityCreature var0) {
        this.stopTargetingCurrentTarget(var0);
        var0.getBrain().setMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, 140);
        var0.getBrain().eraseMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS);
        var0.getBrain().eraseMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS);
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        this.onStartTravelling(var1);
        NavigationAbstract navigationAbstract = var1.getNavigation();
        if (navigationAbstract instanceof Navigation) {
            Navigation var4 = (Navigation)navigationAbstract;
            var4.setCanPathToTargetsBelowSurface(false);
        }
    }

    private void stopInPlace(EntityCreature var0) {
        var0.getNavigation().stop();
        var0.setXxa(0.0f);
        var0.setYya(0.0f);
        var0.setSpeed(0.0f);
        var0.setDeltaMovement(0.0, var0.getDeltaMovement().y, 0.0);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }

    public static final class d
    extends Record {
        final BlockPosition pos;
        final IInventory container;
        final TileEntity blockEntity;
        final IBlockData state;

        public d(BlockPosition var0, IInventory var1, TileEntity var2, IBlockData var3) {
            this.pos = var0;
            this.container = var1;
            this.blockEntity = var2;
            this.state = var3;
        }

        @Nullable
        public static d tryCreatePossibleTarget(TileEntity var0, World var1) {
            BlockPosition var2 = var0.getBlockPos();
            IBlockData var3 = var0.getBlockState();
            IInventory var4 = d.getBlockEntityContainer(var0, var3, var1, var2);
            if (var4 != null) {
                return new d(var2, var4, var0, var3);
            }
            return null;
        }

        @Nullable
        public static d tryCreatePossibleTarget(BlockPosition var0, World var1) {
            TileEntity var2 = var1.getBlockEntity(var0);
            return var2 == null ? null : d.tryCreatePossibleTarget(var2, var1);
        }

        @Nullable
        private static IInventory getBlockEntityContainer(TileEntity var0, IBlockData var1, World var2, BlockPosition var3) {
            Block block = var1.getBlock();
            if (block instanceof BlockChest) {
                BlockChest var4 = (BlockChest)block;
                return BlockChest.getContainer(var4, var1, var2, var3, false);
            }
            if (var0 instanceof IInventory) {
                IInventory var5 = (IInventory)((Object)var0);
                return var5;
            }
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "pos;container;blockEntity;state", "pos", "container", "blockEntity", "state"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "pos;container;blockEntity;state", "pos", "container", "blockEntity", "state"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "pos;container;blockEntity;state", "pos", "container", "blockEntity", "state"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public IInventory container() {
            return this.container;
        }

        public TileEntity blockEntity() {
            return this.blockEntity;
        }

        public IBlockData state() {
            return this.state;
        }
    }

    public static final class c
    extends Enum<c> {
        public static final /* enum */ c TRAVELLING = new c();
        public static final /* enum */ c QUEUING = new c();
        public static final /* enum */ c INTERACTING = new c();
        private static final /* synthetic */ c[] d;

        public static c[] values() {
            return (c[])d.clone();
        }

        public static c valueOf(String var0) {
            return Enum.valueOf(c.class, var0);
        }

        private static /* synthetic */ c[] a() {
            return new c[]{TRAVELLING, QUEUING, INTERACTING};
        }

        static {
            d = c.a();
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a PICKUP_ITEM = new a();
        public static final /* enum */ a PICKUP_NO_ITEM = new a();
        public static final /* enum */ a PLACE_ITEM = new a();
        public static final /* enum */ a PLACE_NO_ITEM = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{PICKUP_ITEM, PICKUP_NO_ITEM, PLACE_ITEM, PLACE_NO_ITEM};
        }

        static {
            e = a.a();
        }
    }

    @FunctionalInterface
    public static interface b
    extends TriConsumer<EntityCreature, d, Integer> {
    }
}

