/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalLlamaFollow
extends PathfinderGoal {
    public final EntityLlama llama;
    private double speedModifier;
    private static final int CARAVAN_LIMIT = 8;
    private int distCheckCounter;

    public PathfinderGoalLlamaFollow(EntityLlama var0, double var1) {
        this.llama = var0;
        this.speedModifier = var1;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        double var7;
        EntityLlama var6;
        if (this.llama.isLeashed() || this.llama.inCaravan()) {
            return false;
        }
        List<Entity> var02 = this.llama.level().getEntities(this.llama, this.llama.getBoundingBox().inflate(9.0, 4.0, 9.0), var0 -> {
            EntityTypes<?> var1 = var0.getType();
            return var1 == EntityTypes.LLAMA || var1 == EntityTypes.TRADER_LLAMA;
        });
        Leashable var1 = null;
        double var2 = Double.MAX_VALUE;
        for (Entity var5 : var02) {
            var6 = (EntityLlama)var5;
            if (!var6.inCaravan() || var6.hasCaravanTail() || (var7 = this.llama.distanceToSqr(var6)) > var2) continue;
            var2 = var7;
            var1 = var6;
        }
        if (var1 == null) {
            for (Entity var5 : var02) {
                var6 = (EntityLlama)var5;
                if (!var6.isLeashed() || var6.hasCaravanTail() || (var7 = this.llama.distanceToSqr(var6)) > var2) continue;
                var2 = var7;
                var1 = var6;
            }
        }
        if (var1 == null) {
            return false;
        }
        if (var2 < 4.0) {
            return false;
        }
        if (!var1.isLeashed() && !this.firstIsLeashed((EntityLlama)var1, 1)) {
            return false;
        }
        this.llama.joinCaravan((EntityLlama)var1);
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        if (!(this.llama.inCaravan() && this.llama.getCaravanHead().isAlive() && this.firstIsLeashed(this.llama, 0))) {
            return false;
        }
        double var0 = this.llama.distanceToSqr(this.llama.getCaravanHead());
        if (var0 > 676.0) {
            if (this.speedModifier <= 3.0) {
                this.speedModifier *= 1.2;
                this.distCheckCounter = PathfinderGoalLlamaFollow.reducedTickDelay(40);
                return true;
            }
            if (this.distCheckCounter == 0) {
                return false;
            }
        }
        if (this.distCheckCounter > 0) {
            --this.distCheckCounter;
        }
        return true;
    }

    @Override
    public void stop() {
        this.llama.leaveCaravan();
        this.speedModifier = 2.1;
    }

    @Override
    public void tick() {
        if (!this.llama.inCaravan()) {
            return;
        }
        if (this.llama.getLeashHolder() instanceof EntityLeash) {
            return;
        }
        EntityLlama var0 = this.llama.getCaravanHead();
        double var1 = this.llama.distanceTo(var0);
        float var3 = 2.0f;
        Vec3D var4 = new Vec3D(var0.getX() - this.llama.getX(), var0.getY() - this.llama.getY(), var0.getZ() - this.llama.getZ()).normalize().scale(Math.max(var1 - 2.0, 0.0));
        this.llama.getNavigation().moveTo(this.llama.getX() + var4.x, this.llama.getY() + var4.y, this.llama.getZ() + var4.z, this.speedModifier);
    }

    private boolean firstIsLeashed(EntityLlama var0, int var1) {
        if (var1 > 8) {
            return false;
        }
        if (var0.inCaravan()) {
            if (var0.getCaravanHead().isLeashed()) {
                return true;
            }
            return this.firstIsLeashed(var0.getCaravanHead(), ++var1);
        }
        return false;
    }
}

